/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.utils;

import java.awt.Dimension;
import java.awt.Graphics2D;
import org.antlr.xjlib.appkit.gview.base.Vector2D;

public class GMagnetic {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int kind = 0;
    private double factor = 0.0;
    private boolean visible = false;

    public static GMagnetic createHorizontal(double factor) {
        GMagnetic m = new GMagnetic();
        m.kind = 0;
        m.factor = factor;
        return m;
    }

    public static GMagnetic createVertical(double factor) {
        GMagnetic m = new GMagnetic();
        m.kind = 1;
        m.factor = factor;
        return m;
    }

    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void showAndAjust(Vector2D position, Dimension realSize) {
        this.setVisible(false);
        if (this.kind == 0) {
            if (Math.abs(position.y - (double)realSize.height * this.factor) < 5.0) {
                position.y = (double)realSize.height * this.factor;
                this.setVisible(true);
            }
        } else if (Math.abs(position.x - (double)realSize.width * this.factor) < 5.0) {
            position.x = (double)realSize.width * this.factor;
            this.setVisible(true);
        }
    }

    public void draw(Graphics2D g2d, Dimension realSize) {
        int middleV = (int)((double)realSize.height * this.factor);
        int middleH = (int)((double)realSize.width * this.factor);
        if (this.kind == 0) {
            g2d.drawLine(0, middleV, realSize.width, middleV);
        } else {
            g2d.drawLine(middleH, 0, middleH, realSize.height);
        }
    }
}

