/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.update;

import java.awt.Container;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.update.XJUpdateManagerDelegate;
import org.antlr.xjlib.appkit.update.XJUpdateManagerDialogUpdateAvailable;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJUtils;

public class XJUpdateManager {
    public static final String KEY_VERSION = "KEY_VERSION";
    public static final String KEY_APP_NAME = "KEY_APP_NAME";
    public static final String KEY_DESCRIPTION = "KEY_DESCRIPTION";
    public static final String KEY_DOWNLOAD_FILE_URL = "KEY_DOWNLOAD_FILE_URL";
    public static final String KEY_DOWNLOAD_FILE_NAME = "KEY_DOWNLOAD_FILE_NAME";
    public static final String KEY_DOWNLOAD_SIZE = "KEY_DOWNLOAD_SIZE";
    protected Container parent;
    protected XJUpdateManagerDelegate delegate;
    protected Map updateInfoMap;
    protected boolean cancelDownload = false;

    public XJUpdateManager(Container parent, XJUpdateManagerDelegate delegate) {
        this.parent = parent == null ? XJApplication.getActiveContainer() : parent;
        this.delegate = delegate == null ? new DefaultDownloadUpdateDelegate() : delegate;
    }

    public Container getParentContainer() {
        return this.parent;
    }

    public String getApplicationName() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_APP_NAME);
    }

    public String getDownloadVersion() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_VERSION);
    }

    public String getDownloadFileName() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_DOWNLOAD_FILE_NAME);
    }

    public String getDownloadFileURL() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_DOWNLOAD_FILE_URL);
    }

    public long getDownloadSize() {
        if (this.updateInfoMap == null) {
            return 0L;
        }
        return (Long)this.updateInfoMap.get(KEY_DOWNLOAD_SIZE);
    }

    public String getDescription() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_DESCRIPTION);
    }

    public boolean writeUpdateXMLFile(String version, String appName, String description, String downloadFileName, String downloadFileURL, long downloadFileSize, String outputFile) {
        XMLEncoder encoder;
        try {
            encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(outputFile)));
        }
        catch (FileNotFoundException e) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot write the update xml file because:\n" + e);
            return false;
        }
        HashMap<String, Object> update = new HashMap<String, Object>();
        update.put(KEY_VERSION, version);
        update.put(KEY_APP_NAME, appName);
        update.put(KEY_DESCRIPTION, description);
        update.put(KEY_DOWNLOAD_FILE_NAME, downloadFileName);
        update.put(KEY_DOWNLOAD_FILE_URL, downloadFileURL);
        update.put(KEY_DOWNLOAD_SIZE, downloadFileSize);
        encoder.writeObject(update);
        encoder.close();
        return true;
    }

    public void downloadUpdateToLocalDisk(String localFile) {
        this.downloadUpdateToLocalDisk(this.getDownloadFileURL(), localFile);
    }

    public void downloadUpdateToLocalDisk(String urlString, String localFile) {
        InputStream is;
        URL url;
        BufferedOutputStream localOutputStream;
        new File(localFile).delete();
        try {
            localOutputStream = new BufferedOutputStream(new FileOutputStream(localFile));
        }
        catch (FileNotFoundException e) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot download the update because:\n" + e);
            return;
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot download the update because:\n" + e);
            return;
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot download the update because:\n" + e);
            return;
        }
        this.delegate.umDownloadBegin();
        new Thread(new BackgroundDownloader(is, localOutputStream, localFile)).start();
    }

    public void fetchRemoteUpdateInformation(String urlString, boolean silent) {
        InputStream is;
        URL url;
        this.updateInfoMap = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            if (!silent) {
                XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot check the update because:\n" + e);
            }
            return;
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            if (!silent) {
                XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot check the update because:\n" + e);
            }
            return;
        }
        XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(is));
        try {
            this.updateInfoMap = (Map)decoder.readObject();
        }
        catch (Exception e) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot check the update because:\n" + e);
            return;
        }
        decoder.close();
    }

    public boolean isUpdateAvailable(String version) {
        if (this.updateInfoMap == null) {
            return false;
        }
        return XJUtils.isVersionGreaterThan(this.getDownloadVersion(), version);
    }

    public void cancelDownload() {
        this.setCancelDownload(true);
    }

    public synchronized void setCancelDownload(boolean flag) {
        this.cancelDownload = flag;
    }

    public boolean isCancelDownload() {
        return this.cancelDownload;
    }

    public void checkForUpdates(String version, String remoteUpdateFile, String localDownloadPath, boolean silent) {
        this.fetchRemoteUpdateInformation(remoteUpdateFile, silent);
        if (this.isUpdateAvailable(version)) {
            if (new XJUpdateManagerDialogUpdateAvailable(this).runModal() == 1) {
                this.downloadUpdateToLocalDisk(XJUtils.concatPath(localDownloadPath, this.getDownloadFileName()));
            }
        } else if (this.updateInfoMap != null && !silent) {
            XJAlert.display(this.getParentContainer(), "Check for Updates", "You already have the latest version.\nCheck again later.");
        }
    }

    protected class BackgroundDownloader
    implements Runnable {
        protected InputStream is;
        protected OutputStream os;
        protected String localDownloadFile;

        public BackgroundDownloader(InputStream is, OutputStream os, String localDownloadFile) {
            this.is = is;
            this.os = os;
            this.localDownloadFile = localDownloadFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] b = new byte[8192];
            long current = 0L;
            long total = XJUpdateManager.this.getDownloadSize();
            try {
                int r;
                while ((r = this.is.read(b)) > 0 && !XJUpdateManager.this.isCancelDownload()) {
                    XJUpdateManager.this.delegate.umDownloadProgress(current += (long)r, total);
                    this.os.write(b, 0, r);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.is.close();
                }
                catch (IOException e) {}
                try {
                    this.os.close();
                }
                catch (IOException e) {}
                if (XJUpdateManager.this.isCancelDownload()) {
                    XJUpdateManager.this.delegate.umDownloadCancelled();
                } else {
                    XJUpdateManager.this.delegate.umDownloadCompleted(this.localDownloadFile);
                }
            }
        }
    }

    protected class DefaultDownloadUpdateDelegate
    extends XJUpdateManagerDelegate
    implements XJDialogProgressDelegate {
        protected XJDialogProgress progress;

        protected DefaultDownloadUpdateDelegate() {
        }

        public void umDownloadBegin() {
            this.progress = new XJDialogProgress(XJUpdateManager.this.parent);
            this.progress.setInfo("Downloading...");
            this.progress.setProgress(0);
            this.progress.setProgressMax(100);
            this.progress.setDelegate(this);
            this.progress.display();
        }

        public void umDownloadProgress(long current, long total) {
            this.progress.setProgress((float)current / (float)total * 100.0f);
        }

        public void umDownloadCancelled() {
            this.progress.close();
            XJAlert.display(XJUpdateManager.this.getParentContainer(), "Check for Updates", "The download has been cancelled.");
        }

        public void umDownloadCompleted(String localDownloadFile) {
            this.progress.close();
            XJAlert.display(XJUpdateManager.this.getParentContainer(), "Check for Updates", "The new version has been downloaded and is available here:\n" + localDownloadFile);
        }

        public void dialogDidCancel() {
            XJUpdateManager.this.cancelDownload();
        }
    }
}

