/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.util.ThreadManager;

public class CompoundPhotonSource
implements PhotonSource {
    private PhotonSource[] source;
    private double[] sourceIntensity;
    private double totalSourceIntensity;

    public CompoundPhotonSource(PhotonSource[] source) {
        this.source = source;
        this.sourceIntensity = new double[source.length];
        this.totalSourceIntensity = 0.0;
        for (int i = 0; i < source.length; ++i) {
            this.sourceIntensity[i] = source[i].getTotalIntensity();
            this.totalSourceIntensity += this.sourceIntensity[i];
        }
    }

    public double getTotalIntensity() {
        return this.totalSourceIntensity;
    }

    public void generatePhotons(final PhotonMap map, final double intensity, ThreadManager threads) {
        final Thread currentThread = Thread.currentThread();
        threads.setNumIndices(this.source.length);
        threads.setTask(new ThreadManager.Task(){

            public void execute(int index) {
                if (map.getRaytracer().renderThread != currentThread) {
                    return;
                }
                CompoundPhotonSource.this.source[index].generatePhotons(map, intensity * CompoundPhotonSource.this.sourceIntensity[index] / CompoundPhotonSource.this.totalSourceIntensity, null);
            }

            public void cleanup() {
                map.getContext().cleanup();
            }
        });
        threads.run();
    }
}

