/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

public class NoiseReductionFilter {
    private int width;
    private int height;
    private float[][] cu;
    private float[][] cv;

    public static void filter(int iterations, final int width, int height, float[] red, float[] green, float[] blue, float[] error, final Object[] object) {
        NoiseReductionFilter filter = new NoiseReductionFilter(iterations, width, height);
        float[] origRed = red;
        float[] origGreen = green;
        float[] origBlue = blue;
        float[] origVariance = error;
        for (int i = 0; i < iterations; ++i) {
            final float[] r = red;
            final float[] g = green;
            final float[] b = blue;
            final float[] e = error;
            ConductivityFunction fn = new ConductivityFunction(){

                public float evaluate(int x1, int y1, int x2, int y2) {
                    int index1 = x1 + y1 * width;
                    int index2 = x2 + y2 * width;
                    if (object[index1] != object[index2] || object[index1] == null) {
                        return 0.0f;
                    }
                    float err = e[index1] + e[index2];
                    if ((double)err < 1.0E-6) {
                        return 0.0f;
                    }
                    float dred = r[index1] - r[index2];
                    float dgreen = g[index1] - g[index2];
                    float dblue = b[index1] - b[index2];
                    float d = (dred * dred + dgreen * dgreen + dblue * dblue) / err;
                    return (float)Math.exp((double)(-d) * 0.2);
                }
            };
            filter.calcConductivity(fn);
            red = filter.filterImageComponent(red);
            green = filter.filterImageComponent(green);
            blue = filter.filterImageComponent(blue);
            error = filter.filterImageComponent(error);
        }
        System.arraycopy(red, 0, origRed, 0, red.length);
        System.arraycopy(green, 0, origGreen, 0, green.length);
        System.arraycopy(blue, 0, origBlue, 0, blue.length);
    }

    private NoiseReductionFilter(int iterations, int width, int height) {
        this.width = width;
        this.height = height;
        this.cu = new float[width - 1][height];
        this.cv = new float[width][height - 1];
    }

    private void calcConductivity(ConductivityFunction fn) {
        int j;
        int i;
        for (i = 0; i < this.width - 1; ++i) {
            for (j = 0; j < this.height; ++j) {
                this.cu[i][j] = fn.evaluate(i, j, i + 1, j);
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height - 1; ++j) {
                this.cv[i][j] = fn.evaluate(i, j, i, j + 1);
            }
        }
    }

    private float[] filterImageComponent(float[] original) {
        float diff;
        int index2;
        int index1;
        int j;
        int i;
        float[] filtered = new float[this.width * this.height];
        for (i = 0; i < this.width - 1; ++i) {
            for (j = 0; j < this.height; ++j) {
                index1 = i + j * this.width;
                index2 = i + 1 + j * this.width;
                diff = this.cu[i][j] * (original[index2] - original[index1]);
                int n = index1;
                filtered[n] = filtered[n] + diff;
                int n2 = index2;
                filtered[n2] = filtered[n2] - diff;
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height - 1; ++j) {
                index1 = i + j * this.width;
                index2 = i + (j + 1) * this.width;
                diff = this.cv[i][j] * (original[index2] - original[index1]);
                int n = index1;
                filtered[n] = filtered[n] + diff;
                int n3 = index2;
                filtered[n3] = filtered[n3] - diff;
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                int index = i + j * this.width;
                filtered[index] = 0.1f * filtered[index] + original[index];
            }
        }
        return filtered;
    }

    private static interface ConductivityFunction {
        public float evaluate(int var1, int var2, int var3, int var4);
    }
}

