/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import java.util.ArrayList;

public class OctreeNode
extends BoundingBox {
    OctreeNode parent;
    OctreeNode child0;
    OctreeNode child1;
    OctreeNode child2;
    OctreeNode child3;
    OctreeNode child4;
    OctreeNode child5;
    OctreeNode child6;
    OctreeNode child7;
    RTObject[] obj;
    double midx;
    double midy;
    double midz;
    private static final int CELLS = 64;
    private static final RTObject[] EMPTY_OBJECT_LIST = new RTObject[0];
    private static int[] leftCount = new int[66];
    private static int[] rightCount = new int[66];

    public OctreeNode(double minx, double maxx, double miny, double maxy, double minz, double maxz, RTObject[] tri, BoundingBox[] bb, OctreeNode parentNode) {
        super(minx, maxx, miny, maxy, minz, maxz);
        int i;
        boolean[] inside = new boolean[tri.length];
        this.parent = parentNode;
        int count = 0;
        for (i = 0; i < tri.length; ++i) {
            if (!bb[i].intersects((BoundingBox)this) || !tri[i].intersectsBox(this)) continue;
            inside[i] = true;
            ++count;
        }
        if (count == 0) {
            this.obj = EMPTY_OBJECT_LIST;
            return;
        }
        this.obj = new RTObject[count];
        BoundingBox[] objBounds = new BoundingBox[count];
        count = 0;
        for (i = 0; i < tri.length; ++i) {
            if (!inside[i]) continue;
            this.obj[count] = tri[i];
            objBounds[count++] = bb[i];
        }
        this.subdivide(objBounds);
    }

    private void subdivide(BoundingBox[] objBounds) {
        if (this.obj.length > 9) {
            boolean splitz;
            this.findMidpoints(objBounds);
            boolean splitx = this.midx != this.maxx;
            boolean splity = this.midy != this.maxy;
            boolean bl = splitz = this.midz != this.maxz;
            if (!(splitx || splity || splitz)) {
                return;
            }
            this.child0 = new OctreeNode(this.minx, this.midx, this.miny, this.midy, this.minz, this.midz, this.obj, objBounds, this);
            if (splitz) {
                this.child1 = new OctreeNode(this.minx, this.midx, this.miny, this.midy, this.maxz, this.midz, this.obj, objBounds, this);
            }
            if (splity) {
                this.child2 = new OctreeNode(this.minx, this.midx, this.maxy, this.midy, this.minz, this.midz, this.obj, objBounds, this);
                if (splitz) {
                    this.child3 = new OctreeNode(this.minx, this.midx, this.maxy, this.midy, this.maxz, this.midz, this.obj, objBounds, this);
                }
            }
            if (splitx) {
                this.child4 = new OctreeNode(this.maxx, this.midx, this.miny, this.midy, this.minz, this.midz, this.obj, objBounds, this);
                if (splitz) {
                    this.child5 = new OctreeNode(this.maxx, this.midx, this.miny, this.midy, this.maxz, this.midz, this.obj, objBounds, this);
                }
                if (splity) {
                    this.child6 = new OctreeNode(this.maxx, this.midx, this.maxy, this.midy, this.minz, this.midz, this.obj, objBounds, this);
                    if (splitz) {
                        this.child7 = new OctreeNode(this.maxx, this.midx, this.maxy, this.midy, this.maxz, this.midz, this.obj, objBounds, this);
                    }
                }
            }
            this.obj = null;
        }
    }

    public OctreeNode[] findChildNodes() {
        ArrayList<OctreeNode> nodes = new ArrayList<OctreeNode>();
        if (this.child0 != null) {
            nodes.add(this.child0);
        }
        if (this.child1 != null) {
            nodes.add(this.child1);
        }
        if (this.child2 != null) {
            nodes.add(this.child2);
        }
        if (this.child3 != null) {
            nodes.add(this.child3);
        }
        if (this.child4 != null) {
            nodes.add(this.child4);
        }
        if (this.child5 != null) {
            nodes.add(this.child5);
        }
        if (this.child6 != null) {
            nodes.add(this.child6);
        }
        if (this.child7 != null) {
            nodes.add(this.child7);
        }
        return nodes.toArray(new OctreeNode[nodes.size()]);
    }

    public RTObject[] getObjects() {
        return this.obj;
    }

    public OctreeNode findNode(Vec3 pos) {
        if (!this.contains(pos)) {
            return null;
        }
        OctreeNode current = this;
        while (current.obj == null) {
            if (pos.x > current.midx) {
                if (pos.y > current.midy) {
                    if (pos.z > current.midz) {
                        current = current.child7;
                        continue;
                    }
                    current = current.child6;
                    continue;
                }
                if (pos.z > current.midz) {
                    current = current.child5;
                    continue;
                }
                current = current.child4;
                continue;
            }
            if (pos.y > current.midy) {
                if (pos.z > current.midz) {
                    current = current.child3;
                    continue;
                }
                current = current.child2;
                continue;
            }
            if (pos.z > current.midz) {
                current = current.child1;
                continue;
            }
            current = current.child0;
        }
        return current;
    }

    public OctreeNode findNextNode(Ray r) {
        double t;
        double maxt = Double.MAX_VALUE;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        if (this.parent == null) {
            return null;
        }
        if (dir.x > 1.0E-12) {
            dx = 1.0E-12;
            t = (this.maxx - orig.x) / dir.x;
            if (t < maxt) {
                maxt = t;
            }
        } else if (dir.x < -1.0E-12) {
            dx = -1.0E-12;
            t = (this.minx - orig.x) / dir.x;
            if (t < maxt) {
                maxt = t;
            }
        }
        if (dir.y > 1.0E-12) {
            dy = 1.0E-12;
            t = (this.maxy - orig.y) / dir.y;
            if (t < maxt) {
                maxt = t;
            }
        } else if (dir.y < -1.0E-12) {
            dy = -1.0E-12;
            t = (this.miny - orig.y) / dir.y;
            if (t < maxt) {
                maxt = t;
            }
        }
        if (dir.z > 1.0E-12) {
            dz = 1.0E-12;
            t = (this.maxz - orig.z) / dir.z;
            if (t < maxt) {
                maxt = t;
            }
        } else if (dir.z < -1.0E-12) {
            dz = -1.0E-12;
            t = (this.minz - orig.z) / dir.z;
            if (t < maxt) {
                maxt = t;
            }
        }
        Vec3 nextPos = r.tempVec1;
        nextPos.set(orig.x + dir.x * maxt + dx, orig.y + dir.y * maxt + dy, orig.z + dir.z * maxt + dz);
        OctreeNode current = this.parent;
        while (!current.contains(nextPos)) {
            current = current.parent;
            if (current != null) continue;
            return null;
        }
        while (current.obj == null) {
            if (nextPos.x > current.midx) {
                if (nextPos.y > current.midy) {
                    if (nextPos.z > current.midz) {
                        current = current.child7;
                        continue;
                    }
                    current = current.child6;
                    continue;
                }
                if (nextPos.z > current.midz) {
                    current = current.child5;
                    continue;
                }
                current = current.child4;
                continue;
            }
            if (nextPos.y > current.midy) {
                if (nextPos.z > current.midz) {
                    current = current.child3;
                    continue;
                }
                current = current.child2;
                continue;
            }
            if (nextPos.z > current.midz) {
                current = current.child1;
                continue;
            }
            current = current.child0;
        }
        return current;
    }

    public OctreeNode findFirstNode(Ray r) {
        double t2;
        double t1;
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        if (dir.x == 0.0) {
            if (orig.x < this.minx || orig.x > this.maxx) {
                return null;
            }
        } else {
            t1 = (this.minx - orig.x) / dir.x;
            t2 = (this.maxx - orig.x) / dir.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return null;
            }
        }
        if (dir.y == 0.0) {
            if (orig.y < this.miny || orig.y > this.maxy) {
                return null;
            }
        } else {
            t1 = (this.miny - orig.y) / dir.y;
            t2 = (this.maxy - orig.y) / dir.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return null;
            }
        }
        if (dir.z == 0.0) {
            if (orig.z < this.minz || orig.z > this.maxz) {
                return null;
            }
        } else {
            t1 = (this.minz - orig.z) / dir.z;
            t2 = (this.maxz - orig.z) / dir.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return null;
            }
        }
        Vec3 nextPos = r.tempVec1;
        nextPos.set(orig.x + dir.x * (mint += 1.0E-12), orig.y + dir.y * mint, orig.z + dir.z * mint);
        return this.findNode(nextPos);
    }

    private void findMidpoints(BoundingBox[] objBounds) {
        double cutoff;
        Vec3 size = this.getSize();
        double d = cutoff = size.x > size.y ? size.x : size.y;
        if (size.z > cutoff) {
            cutoff = size.z;
        }
        if ((cutoff *= 0.1) < 0.01) {
            cutoff = 0.01;
        }
        this.midx = size.x > cutoff ? this.findAxisMidpoint(objBounds, 0) : this.maxx;
        this.midy = size.y > cutoff ? this.findAxisMidpoint(objBounds, 1) : this.maxy;
        this.midz = size.z > cutoff ? this.findAxisMidpoint(objBounds, 2) : this.maxz;
    }

    private double findAxisMidpoint(BoundingBox[] objBounds, int axis) {
        int i;
        for (int i2 = 0; i2 < 66; ++i2) {
            OctreeNode.rightCount[i2] = 0;
            OctreeNode.leftCount[i2] = 0;
        }
        double min = OctreeNode.findMinimum(this, axis);
        double max = OctreeNode.findMaximum(this, axis);
        double invwidth = 64.0 / (max - min);
        for (int i3 = 0; i3 < objBounds.length; ++i3) {
            double objmin = OctreeNode.findMinimum(objBounds[i3], axis);
            double objmax = OctreeNode.findMaximum(objBounds[i3], axis);
            if (objmin <= min) {
                leftCount[0] = leftCount[0] + 1;
            } else {
                int n = (int)((objmin - min) * invwidth) + 1;
                leftCount[n] = leftCount[n] + 1;
            }
            if (!(objmax < max)) continue;
            int n = (int)((objmax - min) * invwidth) + 1;
            rightCount[n] = rightCount[n] + 1;
        }
        int numToLeft = 0;
        int numToRight = objBounds.length;
        int minCost = numToRight * 48;
        int j = -1;
        for (int i4 = 0; i4 < 64; ++i4) {
            int cost = (numToLeft += leftCount[i4]) * i4 + (numToRight -= rightCount[i4]) * (64 - i4);
            if (cost >= minCost) continue;
            minCost = cost;
            j = i4;
        }
        if (j == -1) {
            return max;
        }
        double mid = min + (double)j / invwidth;
        double limit = mid + 1.0 / invwidth;
        boolean found = false;
        for (i = 0; i < objBounds.length; ++i) {
            double objmin = OctreeNode.findMinimum(objBounds[i], axis);
            if (!(objmin > mid) || !(objmin < limit)) continue;
            limit = objmin;
            found = true;
        }
        if (found) {
            return limit - 1.0E-12;
        }
        limit = mid - 1.0 / invwidth;
        found = false;
        for (i = 0; i < objBounds.length; ++i) {
            double objmax = OctreeNode.findMaximum(objBounds[i], axis);
            if (!(objmax < mid) || !(objmax > limit)) continue;
            limit = objmax;
            found = true;
        }
        if (found) {
            return limit + 1.0E-12;
        }
        return mid;
    }

    private static double findMinimum(BoundingBox box, int axis) {
        switch (axis) {
            case 0: {
                return box.minx;
            }
            case 1: {
                return box.miny;
            }
        }
        return box.minz;
    }

    private static double findMaximum(BoundingBox box, int axis) {
        switch (axis) {
            case 0: {
                return box.maxx;
            }
            case 1: {
                return box.maxy;
            }
        }
        return box.maxz;
    }
}

