/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.PointLight;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.Ray;
import artofillusion.util.ThreadManager;

public class PointPhotonSource
implements PhotonSource {
    private PointLight light;
    private Vec3 pos;
    private RGBColor color;
    private float lightIntensity;

    public PointPhotonSource(PointLight light, CoordinateSystem coords, BoundingBox sceneBounds) {
        this.light = light;
        this.pos = coords.getOrigin();
        Vec3[] corner = sceneBounds.getCorners();
        double maxDist2 = 0.0;
        for (int i = 0; i < corner.length; ++i) {
            double dist2 = this.pos.distance2(corner[i]);
            if (!(dist2 > maxDist2)) continue;
            maxDist2 = dist2;
        }
        this.color = new RGBColor();
        double radius = Math.sqrt(maxDist2) * 0.5;
        light.getLight(this.color, (float)radius);
        this.lightIntensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if (this.lightIntensity == 0.0f) {
            return;
        }
        this.color.scale(1.0f / this.lightIntensity);
        this.lightIntensity *= (float)(Math.PI * 4 * radius * radius);
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(final PhotonMap map, double intensity, ThreadManager threads) {
        int n;
        final Thread currentThread = Thread.currentThread();
        final boolean randomizeOrigin = map.getRaytracer().penumbra;
        for (int num = (int)intensity; num > 0; num -= n * n) {
            n = (int)Math.sqrt(num);
            final double du = 2.0 / (double)n;
            final double dphi = Math.PI * 2 / (double)n;
            threads.setNumIndices(n * n);
            threads.setTask(new ThreadManager.Task(){

                public void execute(int index) {
                    if (map.getRaytracer().renderThread != currentThread) {
                        return;
                    }
                    int i = index / n;
                    int j = index - i * n;
                    double baseu = -1.0 + (double)i * du;
                    double basephi = (double)j * dphi;
                    Ray r = new Ray(map.getContext());
                    Vec3 orig = r.getOrigin();
                    Vec3 dir = r.getDirection();
                    orig.set(PointPhotonSource.this.pos);
                    if (randomizeOrigin) {
                        map.randomizePoint(orig, PointPhotonSource.this.light.getRadius());
                    }
                    double ctheta = baseu + map.random.nextDouble() * du;
                    double phi = basephi + map.random.nextDouble() * dphi;
                    double stheta = Math.sqrt(1.0 - ctheta * ctheta);
                    double cphi = Math.cos(phi);
                    double sphi = Math.sin(phi);
                    dir.set(stheta * sphi, stheta * cphi, ctheta);
                    r.newID();
                    map.spawnPhoton(r, PointPhotonSource.this.color, false);
                }

                public void cleanup() {
                    map.getContext().cleanup();
                }
            });
            threads.run();
        }
    }
}

