/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialSpec;
import artofillusion.math.FastRandom;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.PhotonMapContext;
import artofillusion.raytracer.PixelInfo;
import artofillusion.raytracer.RTDisplacedTriangle;
import artofillusion.raytracer.RTImplicitObject;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.RTTriangle;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.Raytracer;
import artofillusion.raytracer.ResourcePool;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.texture.TextureSpec;
import java.util.Random;

public class RaytracerContext {
    public Raytracer rt;
    public RTObject firstObjectHit;
    public RTObject materialAtCamera;
    public boolean materialAtCameraIsFixed;
    public Ray[] ray;
    public RGBColor[] color;
    public RGBColor[] rayIntensity;
    public RGBColor tempColor;
    public RGBColor tempColor2;
    public Vec3[] pos;
    public Vec3[] normal;
    public Vec3[] trueNormal;
    public double[] transparency;
    public Raytracer.RayIntersection intersect;
    public Raytracer.MaterialIntersection[] matChange;
    public TextureSpec[] surfSpec;
    public MaterialSpec matSpec;
    public int[] lastRayID;
    public SurfaceIntersection[] lastRayResult;
    public ResourcePool rtTriPool;
    public ResourcePool rtDispTriPool;
    public ResourcePool rtImplicitPool;
    public Random random;
    public PixelInfo tempPixel;
    public PhotonMapContext globalMap;
    public PhotonMapContext causticsMap;
    public PhotonMapContext volumeMap;

    public RaytracerContext(Raytracer rt) {
        int i;
        this.rt = rt;
        int maxRayDepth = rt.maxRayDepth;
        this.ray = new Ray[maxRayDepth + 1];
        this.color = new RGBColor[maxRayDepth + 1];
        this.transparency = new double[maxRayDepth + 1];
        this.rayIntensity = new RGBColor[maxRayDepth + 1];
        this.surfSpec = new TextureSpec[maxRayDepth + 1];
        this.pos = new Vec3[maxRayDepth + 1];
        this.normal = new Vec3[maxRayDepth + 1];
        this.trueNormal = new Vec3[maxRayDepth + 1];
        for (i = 0; i < maxRayDepth + 1; ++i) {
            this.ray[i] = new Ray(this);
            this.color[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            this.rayIntensity[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            this.surfSpec[i] = new TextureSpec();
            this.pos[i] = new Vec3();
            this.normal[i] = new Vec3();
            this.trueNormal[i] = new Vec3();
        }
        this.matSpec = new MaterialSpec();
        this.intersect = new Raytracer.RayIntersection();
        this.tempColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempColor2 = new RGBColor(0.0f, 0.0f, 0.0f);
        this.matChange = new Raytracer.MaterialIntersection[16];
        for (i = 0; i < this.matChange.length; ++i) {
            this.matChange[i] = new Raytracer.MaterialIntersection();
        }
        this.random = new FastRandom(0L);
        this.rtTriPool = new ResourcePool(RTTriangle.TriangleIntersection.class);
        this.rtDispTriPool = new ResourcePool(RTDisplacedTriangle.DisplacedTriangleIntersection.class);
        this.rtImplicitPool = new ResourcePool(RTImplicitObject.ImplicitIntersection.class);
        this.lastRayID = new int[rt.sceneObject.length];
        this.lastRayResult = new SurfaceIntersection[rt.sceneObject.length];
        this.tempPixel = new PixelInfo();
        if (rt.globalMap != null) {
            this.globalMap = new PhotonMapContext(rt.globalMap);
        }
        if (rt.causticsMap != null) {
            this.causticsMap = new PhotonMapContext(rt.causticsMap);
        }
        if (rt.volumeMap != null) {
            this.volumeMap = new PhotonMapContext(rt.volumeMap);
        }
    }

    public void increaseMaterialChangeLength() {
        Raytracer.MaterialIntersection[] newMatChange = new Raytracer.MaterialIntersection[this.matChange.length * 2];
        System.arraycopy(this.matChange, 0, newMatChange, 0, this.matChange.length);
        for (int i = this.matChange.length; i < newMatChange.length; ++i) {
            newMatChange[i] = new Raytracer.MaterialIntersection();
        }
        this.matChange = newMatChange;
    }

    public void cleanup() {
        this.intersect = null;
        this.matChange = null;
        this.lastRayID = null;
        this.lastRayResult = null;
        this.rtTriPool = null;
        this.rtDispTriPool = null;
        this.rtImplicitPool = null;
        this.tempPixel = null;
        this.globalMap = null;
        this.causticsMap = null;
        this.volumeMap = null;
    }
}

