/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.spmanager.HttpSPMFileSystem;
import artofillusion.spmanager.InstallSplitPane;
import artofillusion.spmanager.ManageSplitPane;
import artofillusion.spmanager.SPMParameters;
import artofillusion.spmanager.SPMSetupFrame;
import artofillusion.spmanager.SPMSplitPane;
import artofillusion.spmanager.SPMTranslate;
import buoy.event.SelectionChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BTabbedPane;
import buoy.widget.ColumnContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class SPManagerFrame
extends BFrame {
    private static SPManagerFrame spmFrame;
    private static SPMParameters parameters;
    private BTabbedPane tabbedPane;
    private SPMSplitPane manageSplitPane;
    private SPMSplitPane updateSplitPane;
    private SPMSplitPane installSplitPane;
    private BLabel statusLabel;
    private String statusText;
    private Timer timer;
    private Action statusTextClearAction;
    BButton setupButton;
    BButton quitButton;
    BButton scanButton;

    public static SPManagerFrame getInstance() {
        return spmFrame;
    }

    public static SPMParameters getParameters() {
        return parameters;
    }

    public SPManagerFrame() {
        super(SPMTranslate.text("SPManager"));
        spmFrame = this;
        parameters = new SPMParameters();
        this.statusLabel = new BLabel(" ");
        this.statusTextClearAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SPManagerFrame.this.statusLabel.setText(" ");
            }
        };
        this.manageSplitPane = new ManageSplitPane();
        this.updateSplitPane = new InstallSplitPane(1, (URL)null);
        this.installSplitPane = new InstallSplitPane(2, this.updateSplitPane.getFileSystem());
        ((HttpSPMFileSystem)this.updateSplitPane.getFileSystem()).setRepository(parameters.getCurrentRepository());
        RowContainer rc = new RowContainer();
        LayoutInfo layout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(5, 3, 3, 3), new Dimension(0, 0));
        ColumnContainer cc = new ColumnContainer();
        LayoutInfo headLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(3, 5, 5, 3), new Dimension(0, 0));
        rc.add((Widget)new BLabel((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/artofillusion/spmanager/icons/gear.png"))), headLayout);
        rc.add((Widget)SPMTranslate.bLabel("Version", new Object[]{"1.5"}), headLayout);
        LayoutInfo cclayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(3, 3, 5, 3), new Dimension(0, 0));
        cc.add((Widget)rc, cclayout);
        this.tabbedPane = new BTabbedPane();
        this.tabbedPane.add((Widget)this.manageSplitPane, SPMTranslate.text("manage"));
        this.tabbedPane.add((Widget)this.updateSplitPane, SPMTranslate.text("update"));
        this.tabbedPane.add((Widget)this.installSplitPane, SPMTranslate.text("install"));
        this.tabbedPane.addEventLink(SelectionChangedEvent.class, (Object)this, "doTabbedPaneSelection");
        LayoutInfo tabbedPaneLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(0, 0, 0, 0), new Dimension(0, 0));
        cc.add((Widget)this.tabbedPane, tabbedPaneLayout);
        RowContainer buttons = new RowContainer();
        this.setupButton = SPMTranslate.bButton("setup", (Object)this, "doSetup");
        buttons.add((Widget)this.setupButton);
        this.scanButton = SPMTranslate.bButton("rescan", (Object)this, "doRescan");
        buttons.add((Widget)this.scanButton);
        this.quitButton = SPMTranslate.bButton("close", (Object)this, "hideSPManager");
        buttons.add((Widget)this.quitButton);
        cc.add((Widget)buttons, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(3, 0, 0, 0), null));
        cc.add((Widget)new BOutline((Widget)this.statusLabel, (Border)BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), SPMTranslate.text("remoteStatus"))), new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(1, 1, 1, 1), new Dimension(0, 0)));
        this.setContent((Widget)cc);
        this.pack();
        this.centerAndSizeWindow();
        this.setVisible(true);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "hideSPManager");
        this.manageSplitPane.setDividerLocation(this.manageSplitPane.getChild((int)0).getPreferredSize().width);
        this.updateSplitPane.setDividerLocation(this.updateSplitPane.getChild((int)0).getPreferredSize().width);
        this.installSplitPane.setDividerLocation(this.installSplitPane.getChild((int)0).getPreferredSize().width);
    }

    public void printBounds(WidgetContainer wc) {
        Iterator childEnum = wc.getChildren().iterator();
        while (childEnum.hasNext()) {
            Widget w = (Widget)childEnum.next();
            System.out.println("Widget: " + w);
            System.out.println("Bounds: " + w.getBounds());
            System.out.println("Min size: " + w.getMinimumSize());
            System.out.println("Pref size: " + w.getPreferredSize());
            if (!(w instanceof WidgetContainer)) continue;
            this.printBounds((WidgetContainer)w);
        }
    }

    protected void hideSPManager() {
        if (this.manageSplitPane.isModified() || this.updateSplitPane.isModified() || this.installSplitPane.isModified()) {
            JOptionPane.showMessageDialog(null, SPMTranslate.text("modified"), SPMTranslate.text("alert"), 0);
        }
        this.getComponent().setVisible(false);
    }

    private void doTabbedPaneSelection() {
        switch (this.tabbedPane.getSelectedTab()) {
            default: {
                this.manageSplitPane.doSetup();
                break;
            }
            case 1: {
                this.updateSplitPane.doSetup();
                break;
            }
            case 2: {
                this.installSplitPane.doSetup();
            }
        }
    }

    private void doManage() {
        this.tabbedPane.setSelectedTab(0);
        this.doTabbedPaneSelection();
    }

    private void doUpdate() {
        this.tabbedPane.setSelectedTab(1);
        this.doTabbedPaneSelection();
    }

    private void doInstall() {
        this.tabbedPane.setSelectedTab(2);
        this.doTabbedPaneSelection();
    }

    private void doSetup() {
        new SPMSetupFrame(this);
        if (parameters.hasChanged()) {
            ((HttpSPMFileSystem)this.updateSplitPane.getFileSystem()).setRepository(parameters.getCurrentRepository());
            this.doRescan();
        }
    }

    private void doRescan() {
        parameters.getRepositoriesList(true);
    }

    public void updatePanes() {
        this.manageSplitPane.doUpdate();
        ((HttpSPMFileSystem)this.updateSplitPane.getFileSystem()).setRepository(parameters.getCurrentRepository());
        this.updateSplitPane.doUpdate();
        this.installSplitPane.doUpdate();
    }

    private void centerAndSizeWindow() {
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = this.getComponent().getSize();
        int x = (d1.width - d2.width) / 2;
        int y = (d1.height - d2.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setBounds(new Rectangle(x, y, d2.width, d2.height + 2));
    }

    public void setRemoteStatusText(String text, int time) {
        this.statusText = text;
        this.setRemoteStatusTextDuration(time);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SPManagerFrame.this.statusLabel.setText(SPManagerFrame.this.statusText);
            }
        });
    }

    public void setRemoteStatusTextDuration(int time) {
        if (time > 0) {
            if (this.timer != null) {
                this.timer.setDelay(time);
                this.timer.restart();
            } else {
                this.timer = new Timer(time, this.statusTextClearAction);
                this.timer.start();
            }
        } else if (this.timer != null) {
            this.timer.stop();
        }
    }
}

