/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.WidgetMouseEvent;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class CreateCurveTool
extends EditingTool {
    static int counter = 1;
    private Vector clickPoint;
    private Vector smoothness;
    private int smoothing;
    private Curve theCurve;
    private CoordinateSystem coords;
    public static final int HANDLE_SIZE = 3;

    public CreateCurveTool(EditingWindow fr, int smoothingMethod) {
        super(fr);
        if (smoothingMethod == 2) {
            this.initButton("interpCurve");
        } else {
            this.initButton("approxCurve");
        }
        this.smoothing = smoothingMethod;
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("createCurveTool.helpText"));
    }

    public void deactivate() {
        super.deactivate();
        this.addToScene();
    }

    public int whichClicks() {
        return 1;
    }

    public String getToolTipText() {
        if (this.smoothing == 2) {
            return Translate.text("createCurveTool.tipText.interpolating");
        }
        return Translate.text("createCurveTool.tipText.approximating");
    }

    public boolean hilightSelection() {
        return this.clickPoint == null;
    }

    public void drawOverlay(ViewerCanvas view) {
        Camera cam = view.getCamera();
        if (this.clickPoint == null) {
            return;
        }
        if (this.theCurve != null) {
            int i;
            Mat4 trans = cam.getWorldToScreen().times(this.coords.fromLocal());
            WireframeMesh mesh = this.theCurve.getWireframeMesh();
            Point[] p = new Point[mesh.vert.length];
            for (i = 0; i < p.length; ++i) {
                Vec2 v = trans.timesXY(mesh.vert[i]);
                p[i] = new Point((int)v.x, (int)v.y);
            }
            for (i = 0; i < mesh.from.length; ++i) {
                view.drawLine(p[mesh.from[i]], p[mesh.to[i]], ViewerCanvas.lineColor);
            }
        }
        for (int i = 0; i < this.clickPoint.size(); ++i) {
            Vec3 pos = (Vec3)this.clickPoint.lastElement();
            Vec2 screenPos = view.getCamera().getWorldToScreen().timesXY(pos);
            view.drawBox((int)screenPos.x - 1, (int)screenPos.y - 1, 3, 3, ViewerCanvas.handleColor);
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.clickPoint == null) {
            this.clickPoint = new Vector();
            this.smoothness = new Vector();
            view.repaint();
        } else {
            Vec3 pos = (Vec3)this.clickPoint.lastElement();
            Vec2 screenPos = view.getCamera().getWorldToScreen().timesXY(pos);
            view.drawDraggedShape(new Line2D.Float(new Point2D.Double(screenPos.x, screenPos.y), e.getPoint()));
        }
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.clickPoint.size() == 0) {
            return;
        }
        Point dragPoint = e.getPoint();
        Vec3 pos = (Vec3)this.clickPoint.lastElement();
        Vec2 screenPos = view.getCamera().getWorldToScreen().timesXY(pos);
        view.drawDraggedShape(new Line2D.Float(new Point2D.Double(screenPos.x, screenPos.y), dragPoint));
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (e.getClickCount() != 2) {
            this.clickPoint.addElement(cam.convertScreenToWorld(dragPoint, 20.0));
            this.smoothness.addElement(new Float(e.isShiftDown() ? 0.0f : 1.0f));
        }
        if (this.clickPoint.size() > 1) {
            int i;
            Vec3[] vertex = new Vec3[this.clickPoint.size()];
            float[] s = new float[this.clickPoint.size()];
            Vec3 orig = new Vec3();
            for (i = 0; i < vertex.length; ++i) {
                vertex[i] = (Vec3)this.clickPoint.elementAt(i);
                s[i] = ((Float)this.smoothness.elementAt(i)).floatValue();
                orig = orig.plus(vertex[i]);
            }
            orig = orig.times(1.0 / (double)vertex.length);
            Vec3 ydir = cam.getViewToWorld().timesDirection(Vec3.vy());
            Vec3 zdir = cam.getViewToWorld().timesDirection(new Vec3(0.0, 0.0, -1.0));
            this.coords = new CoordinateSystem(orig, zdir, ydir);
            for (i = 0; i < vertex.length; ++i) {
                vertex[i] = this.coords.toLocal().times(vertex[i]);
            }
            this.theCurve = new Curve(vertex, s, this.smoothing, false);
            if (e.getClickCount() == 2) {
                this.theCurve.setClosed(e.isControlDown());
                this.addToScene();
                return;
            }
            cam.setObjectTransform(this.coords.fromLocal());
        }
        this.theWindow.updateImage();
    }

    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
        if (e.getKeyCode() == 10 && this.theCurve != null) {
            this.theCurve.setClosed(e.isControlDown());
            this.addToScene();
            e.consume();
        }
    }

    private void addToScene() {
        boolean addCurve;
        boolean bl = addCurve = this.theCurve != null;
        if (addCurve) {
            ObjectInfo info = new ObjectInfo(this.theCurve, this.coords, "Curve " + counter++);
            info.addTrack(new PositionTrack(info), 0);
            info.addTrack(new RotationTrack(info), 1);
            UndoRecord undo = new UndoRecord(this.theWindow, false);
            int[] sel = this.theWindow.getScene().getSelection();
            ((LayoutWindow)this.theWindow).addObject(info, undo);
            undo.addCommand(16, new Object[]{sel});
            this.theWindow.setUndoRecord(undo);
            ((LayoutWindow)this.theWindow).setSelection(this.theWindow.getScene().getNumObjects() - 1);
        }
        this.clickPoint = null;
        this.smoothness = null;
        this.theCurve = null;
        this.coords = null;
        if (addCurve) {
            this.theWindow.updateImage();
        }
    }
}

