/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CurveViewer;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ModellingApp;
import artofillusion.MoveScaleRotateMeshTool;
import artofillusion.MoveViewTool;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.UndoRecord;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueSlider;
import buoy.event.CommandEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class CurveEditorWindow
extends MeshEditorWindow
implements EditingWindow {
    protected BMenu editMenu;
    protected BMenu meshMenu;
    protected BMenu smoothMenu;
    protected BMenuItem[] editMenuItem;
    protected BMenuItem[] meshMenuItem;
    protected BCheckBoxMenuItem[] smoothItem;
    protected Runnable onClose;
    private int[] selectionDistance;
    private int maxDistance;
    boolean[] selected;

    public CurveEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose) {
        super(parent, title, obj);
        this.onClose = onClose;
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{1.0, 0.0, 0.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.helpText = new BLabel();
        content.add(this.helpText, 0, 1, 2, 1);
        content.add(this.viewsContainer, 1, 0);
        RowContainer buttons = new RowContainer();
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "doCancel"));
        content.add(buttons, 0, 2, 2, 1, new LayoutInfo());
        this.tools = new ToolPalette(1, 7);
        content.add(this.tools, 0, 0, new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.NONE, null, null));
        this.defaultTool = new ReshapeMeshTool(this, this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this, this));
        this.tools.addTool(new RotateMeshTool(this, this, false));
        this.tools.addTool(new SkewMeshTool(this, this));
        this.tools.addTool(new TaperMeshTool(this, this));
        MoveScaleRotateMeshTool compoundTool = new MoveScaleRotateMeshTool(this, this);
        this.tools.addTool(compoundTool);
        if (ModellingApp.getPreferences().getUseCompoundMeshTool()) {
            this.defaultTool = compoundTool;
        }
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.setDefaultTool(this.defaultTool);
        this.tools.selectTool(this.defaultTool);
        for (int i = 0; i < this.theView.length; ++i) {
            MeshViewer view = (MeshViewer)this.theView[i];
            view.setMetaTool(metaTool);
            view.setAltTool(altTool);
            view.setMeshVisible(true);
            view.setScene(parent.getScene(), obj);
        }
        this.createEditMenu();
        this.createMeshMenu((Curve)obj.object);
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        UIUtilities.applyDefaultFont(content);
        UIUtilities.applyDefaultBackground(content);
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 3 / 4, d1.height * 3 / 4);
        this.setBounds(new Rectangle((d1.width - d2.width) / 2, (d1.height - d2.height) / 2, d2.width, d2.height));
        this.tools.requestFocus();
        this.selected = new boolean[((Curve)obj.object).getVertices().length];
        this.findSelectionDistance();
        this.updateMenus();
    }

    protected CurveEditorWindow(EditingWindow parent, String title, ObjectInfo obj) {
        super(parent, title, obj);
    }

    void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.editMenuItem = new BMenuItem[3];
        this.undoItem = Translate.menuItem("undo", this, "undoCommand");
        this.editMenu.add(this.undoItem);
        this.redoItem = Translate.menuItem("redo", this, "redoCommand");
        this.editMenu.add(this.redoItem);
        this.editMenu.add(Translate.menuItem("selectAll", this, "selectAllCommand"));
        this.editMenuItem[0] = Translate.menuItem("extendSelection", this, "extendSelectionCommand");
        this.editMenu.add(this.editMenuItem[0]);
        this.editMenuItem[1] = Translate.menuItem("invertSelection", this, "invertSelectionCommand");
        this.editMenu.add(this.editMenuItem[1]);
        this.editMenuItem[2] = Translate.checkboxMenuItem("freehandSelection", this, "freehandModeChanged", false);
        this.editMenu.add(this.editMenuItem[2]);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("curveTension", this, "setTensionCommand"));
    }

    void createMeshMenu(Curve obj) {
        this.meshMenu = Translate.menu("curve");
        this.menubar.add(this.meshMenu);
        this.meshMenuItem = new BMenuItem[7];
        this.meshMenuItem[0] = Translate.menuItem("deletePoints", this, "deleteCommand");
        this.meshMenu.add(this.meshMenuItem[0]);
        this.meshMenuItem[1] = Translate.menuItem("subdivide", this, "subdivideCommand");
        this.meshMenu.add(this.meshMenuItem[1]);
        this.meshMenuItem[2] = Translate.menuItem("editPoints", this, "setPointsCommand");
        this.meshMenu.add(this.meshMenuItem[2]);
        this.meshMenuItem[3] = Translate.menuItem("transformPoints", this, "transformPointsCommand");
        this.meshMenu.add(this.meshMenuItem[3]);
        this.meshMenuItem[4] = Translate.menuItem("randomize", this, "randomizeCommand");
        this.meshMenu.add(this.meshMenuItem[4]);
        this.meshMenu.add(Translate.menuItem("centerCurve", this, "centerCommand"));
        this.meshMenu.addSeparator();
        this.meshMenuItem[5] = Translate.menuItem("smoothness", this, "setSmoothnessCommand");
        this.meshMenu.add(this.meshMenuItem[5]);
        this.smoothMenu = Translate.menu("smoothingMethod");
        this.meshMenu.add(this.smoothMenu);
        this.smoothItem = new BCheckBoxMenuItem[3];
        this.smoothItem[0] = Translate.checkboxMenuItem("none", this, "smoothingChanged", obj.getSmoothingMethod() == 0);
        this.smoothMenu.add(this.smoothItem[0]);
        this.smoothItem[1] = Translate.checkboxMenuItem("interpolating", this, "smoothingChanged", obj.getSmoothingMethod() == 2);
        this.smoothMenu.add(this.smoothItem[1]);
        this.smoothItem[2] = Translate.checkboxMenuItem("approximating", this, "smoothingChanged", obj.getSmoothingMethod() == 3);
        this.smoothMenu.add(this.smoothItem[2]);
        this.meshMenuItem[6] = Translate.menuItem("closedEnds", this, "toggleClosedCommand");
        this.meshMenu.add(this.meshMenuItem[6]);
        if (obj.isClosed()) {
            this.meshMenuItem[6].setText(Translate.text("menu.openEnds"));
        }
    }

    protected BMenu createShowMenu() {
        BMenu menu = Translate.menu("show");
        this.showItem = new BCheckBoxMenuItem[4];
        this.showItem[0] = Translate.checkboxMenuItem("curve", this, "shownItemChanged", true);
        menu.add(this.showItem[0]);
        this.showItem[3] = Translate.checkboxMenuItem("entireScene", this, "shownItemChanged", ((MeshViewer)this.theView[this.currentView]).getSceneVisible());
        menu.add(this.showItem[3]);
        return menu;
    }

    public ObjectInfo getObject() {
        return this.objInfo;
    }

    public void setObject(Object3D obj) {
        this.objInfo.object = obj;
        this.objInfo.clearCachedMeshes();
    }

    public void setMesh(Mesh mesh) {
        Curve obj = (Curve)mesh;
        this.setObject(obj);
        if (this.selected.length != obj.getVertices().length) {
            this.selected = new boolean[obj.getVertices().length];
        }
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
    }

    public boolean[] getSelection() {
        return this.selected;
    }

    public void setSelection(boolean[] sel) {
        this.selected = sel;
        this.findSelectionDistance();
        this.updateMenus();
        this.updateImage();
    }

    public int[] getSelectionDistance() {
        if (this.maxDistance != this.getTensionDistance()) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    public int getSelectionMode() {
        return 0;
    }

    public void setSelectionMode(int mode) {
    }

    void findSelectionDistance() {
        int i;
        Curve theCurve = (Curve)this.getObject().object;
        int[] dist = new int[theCurve.getVertices().length];
        this.maxDistance = this.getTensionDistance();
        for (i = 0; i < dist.length; ++i) {
            dist[i] = this.selected[i] ? 0 : -1;
        }
        for (i = 0; i < this.maxDistance; ++i) {
            int j;
            for (j = 0; j < dist.length - 1; ++j) {
                if (dist[j] != -1 || dist[j + 1] != i) continue;
                dist[j] = i + 1;
            }
            for (j = 1; j < dist.length; ++j) {
                if (dist[j] != -1 || dist[j - 1] != i) continue;
                dist[j] = i + 1;
            }
            if (!theCurve.isClosed()) continue;
            if (dist[0] == -1 && dist[dist.length - 1] == i) {
                dist[0] = i + 1;
            }
            if (dist[0] != i || dist[dist.length - 1] != -1) continue;
            dist[dist.length - 1] = i + 1;
        }
        this.selectionDistance = dist;
    }

    public void updateMenus() {
        int i;
        super.updateMenus();
        for (i = 0; i < this.selected.length && !this.selected[i]; ++i) {
        }
        if (i < this.selected.length) {
            this.editMenuItem[0].setEnabled(true);
            for (i = 0; i < 6; ++i) {
                this.meshMenuItem[i].setEnabled(true);
            }
        } else {
            this.editMenuItem[0].setEnabled(false);
            for (i = 0; i < 6; ++i) {
                this.meshMenuItem[i].setEnabled(false);
            }
        }
    }

    protected void doOk() {
        Curve theMesh = (Curve)this.objInfo.object;
        this.oldMesh.copyObject(theMesh);
        this.oldMesh = null;
        this.dispose();
        this.onClose.run();
    }

    protected void doCancel() {
        this.oldMesh = null;
        this.dispose();
    }

    protected void freehandModeChanged() {
        for (int i = 0; i < this.theView.length; ++i) {
            ((CurveViewer)this.theView[i]).setFreehandSelection(((BCheckBoxMenuItem)this.editMenuItem[2]).getState());
        }
    }

    private void smoothingChanged(CommandEvent ev) {
        Widget source = ev.getWidget();
        if (source == this.smoothItem[0]) {
            this.setSmoothingMethod(0);
        } else if (source == this.smoothItem[1]) {
            this.setSmoothingMethod(2);
        } else if (source == this.smoothItem[2]) {
            this.setSmoothingMethod(3);
        }
    }

    public void selectAllCommand() {
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(0), this.selected.clone()}));
        for (int i = 0; i < this.selected.length; ++i) {
            this.selected[i] = true;
        }
        this.setSelection(this.selected);
    }

    public void extendSelectionCommand() {
        int oldDist = this.tensionDistance;
        this.tensionDistance = 1;
        int[] dist = this.getSelectionDistance();
        boolean[] newSel = new boolean[dist.length];
        this.tensionDistance = oldDist;
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(0), this.selected.clone()}));
        for (int i = 0; i < dist.length; ++i) {
            newSel[i] = dist[i] == 0 || dist[i] == 1;
        }
        this.setSelection(newSel);
    }

    public void invertSelectionCommand() {
        boolean[] newSel = new boolean[this.selected.length];
        for (int i = 0; i < newSel.length; ++i) {
            newSel[i] = !this.selected[i];
        }
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(0), this.selected}));
        this.setSelection(newSel);
    }

    public void deleteCommand() {
        int i;
        int num = 0;
        Curve theCurve = (Curve)this.objInfo.object;
        MeshVertex[] vt = theCurve.getVertices();
        float[] s = theCurve.getSmoothness();
        for (i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++num;
        }
        if (num == 0) {
            return;
        }
        if (!theCurve.isClosed() && this.selected.length - num < 2) {
            new BStandardDialog("", Translate.text("curveNeeds2Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        if (theCurve.isClosed() && this.selected.length - num < 3) {
            new BStandardDialog("", Translate.text("curveNeeds3Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        Vec3[] v = new Vec3[vt.length - num];
        float[] news = new float[vt.length - num];
        boolean[] newsel = new boolean[vt.length - num];
        int j = 0;
        for (i = 0; i < vt.length; ++i) {
            if (this.selected[i]) continue;
            newsel[j] = this.selected[i];
            news[j] = s[i];
            v[j++] = vt[i].r;
        }
        theCurve.setShape(v, news);
        this.setSelection(newsel);
    }

    public void subdivideCommand() {
        int i;
        Curve theCurve = (Curve)this.objInfo.object;
        MeshVertex[] vt = theCurve.getVertices();
        float[] s = theCurve.getSmoothness();
        int splitcount = 0;
        int method = theCurve.getSmoothingMethod();
        Vec3[] v = new Vec3[vt.length];
        for (i = 0; i < vt.length; ++i) {
            v[i] = vt[i].r;
        }
        boolean[] split = theCurve.isClosed() ? new boolean[vt.length] : new boolean[vt.length - 1];
        for (i = 0; i < split.length; ++i) {
            if (!this.selected[i] || !this.selected[(i + 1) % this.selected.length]) continue;
            split[i] = true;
            ++splitcount;
        }
        Vec3[] newpos = new Vec3[vt.length + splitcount];
        float[] news = new float[vt.length + splitcount];
        boolean[] newsel = new boolean[vt.length + splitcount];
        int j = 0;
        for (i = 0; i < split.length; ++i) {
            newsel[j] = this.selected[i];
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = theCurve.isClosed() ? v.length - 1 : 0;
            }
            int p3 = i < v.length - 1 ? i + 1 : (theCurve.isClosed() ? 0 : v.length - 1);
            newpos[j] = this.selected[i] && method == 3 ? Curve.calcApproxPoint(v, s, p1, i, p3) : vt[i].r;
            news[j] = this.selected[i] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
                continue;
            }
            if (method == 0) {
                newpos[j + 1] = v[i].plus(v[p3]).times(0.5);
            } else if (method == 2) {
                int p4 = i < v.length - 2 ? i + 2 : (theCurve.isClosed() ? (i + 2) % v.length : v.length - 1);
                newpos[j + 1] = Curve.calcInterpPoint(v, s, p1, i, p3, p4);
            } else {
                newpos[j + 1] = v[i].plus(v[p3]).times(0.5);
            }
            news[j + 1] = 1.0f;
            newsel[j + 1] = true;
            j += 2;
        }
        if (!theCurve.isClosed()) {
            newpos[0] = v[0];
            newpos[j] = v[i];
            news[j] = s[i];
            newsel[j] = this.selected[i];
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        theCurve.setShape(newpos, news);
        this.setSelection(newsel);
    }

    public void setSmoothnessCommand() {
        int i;
        final Curve theCurve = (Curve)this.objInfo.object;
        Curve oldCurve = (Curve)theCurve.duplicate();
        final MeshVertex[] vt = theCurve.getVertices();
        final float[] s = theCurve.getSmoothness();
        for (i = 0; i < this.selected.length && !this.selected[i]; ++i) {
        }
        if (i == this.selected.length) {
            return;
        }
        float value = 0.001f * (float)Math.round(s[i] * 1000.0f);
        final ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value);
        smoothness.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                int i;
                float sm = (float)smoothness.getValue();
                float[] news = new float[vt.length];
                for (i = 0; i < CurveEditorWindow.this.selected.length; ++i) {
                    news[i] = CurveEditorWindow.this.selected[i] ? sm : s[i];
                }
                theCurve.setSmoothness(news);
                CurveEditorWindow.this.objectChanged();
                for (i = 0; i < CurveEditorWindow.this.theView.length; ++i) {
                    CurveEditorWindow.this.theView[i].repaint();
                }
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("setPointSmoothness"), new Widget[]{smoothness}, new String[]{Translate.text("Smoothness")});
        if (dlg.clickedOk()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, oldCurve}));
        } else {
            theCurve.copyObject(oldCurve);
            this.objectChanged();
            for (int j = 0; j < this.theView.length; ++j) {
                this.theView[j].repaint();
            }
        }
    }

    void setSmoothingMethod(int method) {
        int i;
        Curve theCurve = (Curve)this.objInfo.object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        for (i = 0; i < this.smoothItem.length; ++i) {
            this.smoothItem[i].setState(false);
        }
        if (method == 0) {
            this.smoothItem[0].setState(true);
        } else if (method == 2) {
            this.smoothItem[1].setState(true);
        } else {
            this.smoothItem[2].setState(true);
        }
        theCurve.setSmoothingMethod(method);
        this.objectChanged();
        for (i = 0; i < this.theView.length; ++i) {
            this.theView[i].repaint();
        }
    }

    public void toggleClosedCommand() {
        Curve theCurve = (Curve)this.objInfo.object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        if (theCurve.isClosed()) {
            theCurve.setClosed(false);
            this.meshMenuItem[6].setText(Translate.text("menu.closedEnds"));
        } else {
            theCurve.setClosed(true);
            this.meshMenuItem[6].setText(Translate.text("menu.openEnds"));
        }
        this.setMesh(theCurve);
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].repaint();
        }
    }

    public void adjustDeltas(Vec3[] delta) {
        int i;
        int[] dist = this.getSelectionDistance();
        int[] count = new int[delta.length];
        Curve theCurve = (Curve)this.objInfo.object;
        int maxDistance = this.getTensionDistance();
        double tension = this.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] == 0) continue;
            delta[i].set(0.0, 0.0, 0.0);
        }
        for (i = 0; i < maxDistance; ++i) {
            int j;
            for (j = 0; j < count.length; ++j) {
                count[j] = 0;
            }
            for (j = 0; j < dist.length - 1; ++j) {
                if (dist[j] == i && dist[j + 1] == i + 1) {
                    int n = j + 1;
                    count[n] = count[n] + 1;
                    delta[j + 1].add(delta[j]);
                    continue;
                }
                if (dist[j + 1] != i || dist[j] != i + 1) continue;
                int n = j;
                count[n] = count[n] + 1;
                delta[j].add(delta[j + 1]);
            }
            if (theCurve.isClosed()) {
                if (dist[0] == i && dist[dist.length - 1] == i + 1) {
                    int n = dist.length - 1;
                    count[n] = count[n] + 1;
                    delta[dist.length - 1].add(delta[0]);
                } else if (dist[dist.length - 1] == i && dist[0] == i + 1) {
                    count[0] = count[0] + 1;
                    delta[0].add(delta[dist.length - 1]);
                }
            }
            for (j = 0; j < count.length; ++j) {
                if (count[j] <= 1) continue;
                delta[j].scale(1.0 / (double)count[j]);
            }
        }
        for (i = 0; i < scale.length; ++i) {
            scale[i] = Math.pow(((double)(maxDistance - i) + 1.0) / ((double)maxDistance + 1.0), tension);
        }
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] <= 0) continue;
            delta[i].scale(scale[dist[i]]);
        }
    }
}

