/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CreateCameraTool;
import artofillusion.CreateCubeTool;
import artofillusion.CreateCurveTool;
import artofillusion.CreateCylinderTool;
import artofillusion.CreateLightTool;
import artofillusion.CreatePolygonTool;
import artofillusion.CreateSphereTool;
import artofillusion.CreateSplineMeshTool;
import artofillusion.ModellingApp;
import artofillusion.ModellingTool;
import artofillusion.MoveObjectTool;
import artofillusion.MoveViewTool;
import artofillusion.ObjectMaterialDialog;
import artofillusion.ObjectPropertiesPanel;
import artofillusion.ObjectTextureDialog;
import artofillusion.PreferencesWindow;
import artofillusion.RecentFiles;
import artofillusion.RenderSetupDialog;
import artofillusion.RotateObjectTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleObjectTool;
import artofillusion.Scene;
import artofillusion.SceneChangedEvent;
import artofillusion.SceneViewer;
import artofillusion.TransformDialog;
import artofillusion.Translator;
import artofillusion.UndoRecord;
import artofillusion.UndoStack;
import artofillusion.ViewerCanvas;
import artofillusion.animation.AnimationPreviewer;
import artofillusion.animation.ConstraintTrack;
import artofillusion.animation.EditKeyframesDialog;
import artofillusion.animation.IKTrack;
import artofillusion.animation.Joint;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.PathFromCurveDialog;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.ProceduralPositionTrack;
import artofillusion.animation.ProceduralRotationTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Score;
import artofillusion.animation.Skeleton;
import artofillusion.animation.TextureTrack;
import artofillusion.animation.Track;
import artofillusion.animation.VisibilityTrack;
import artofillusion.animation.distortion.BendTrack;
import artofillusion.animation.distortion.CustomDistortionTrack;
import artofillusion.animation.distortion.ScaleTrack;
import artofillusion.animation.distortion.ShatterTrack;
import artofillusion.animation.distortion.SkeletonShapeTrack;
import artofillusion.animation.distortion.TwistTrack;
import artofillusion.image.ImagesDialog;
import artofillusion.keystroke.KeystrokeManager;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Curve;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.ExternalObject;
import artofillusion.object.NullObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.object.ReferenceImage;
import artofillusion.object.SceneCamera;
import artofillusion.object.Sphere;
import artofillusion.object.SpotLight;
import artofillusion.script.ExecuteScriptWindow;
import artofillusion.script.ScriptRunner;
import artofillusion.script.ScriptedObject;
import artofillusion.script.ToolScript;
import artofillusion.texture.Texture;
import artofillusion.ui.AutoScroller;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.DefaultDockableWidget;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ImageFileChooser;
import artofillusion.ui.ObjectTreeElement;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowActivatedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BComboBox;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BPopupMenu;
import buoy.widget.BScrollPane;
import buoy.widget.BSplitPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTabbedPane;
import buoy.widget.BTextField;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.MenuWidget;
import buoy.widget.OverlayContainer;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoyx.docking.DockableWidget;
import buoyx.docking.DockingContainer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;

public class LayoutWindow
extends BFrame
implements EditingWindow,
PopupMenuManager {
    SceneViewer[] theView;
    BorderContainer[] viewPanel;
    FormContainer viewsContainer;
    FormContainer centerContainer;
    private DockingContainer[] dock;
    BSplitPane div1;
    BSplitPane div2;
    BScrollPane itemTreeScroller;
    Score theScore;
    ToolPalette tools;
    BLabel helpText;
    BLabel timeFrameLabel;
    TreeList itemTree;
    Scene theScene;
    BMenuBar menubar;
    BMenu fileMenu;
    BMenu recentFilesMenu;
    BMenu editMenu;
    BMenu objectMenu;
    BMenu createMenu;
    BMenu toolsMenu;
    BMenu scriptMenu;
    BMenu animationMenu;
    BMenu editKeyframeMenu;
    BMenu sceneMenu;
    BMenu addTrackMenu;
    BMenu positionTrackMenu;
    BMenu rotationTrackMenu;
    BMenu distortionMenu;
    BMenuItem[] fileMenuItem;
    BMenuItem[] editMenuItem;
    BMenuItem[] objectMenuItem;
    BMenuItem[] toolsMenuItem;
    BMenuItem[] animationMenuItem;
    BMenuItem[] sceneMenuItem;
    BMenuItem[] popupMenuItem;
    BCheckBoxMenuItem[] displayItem;
    BPopupMenu popupMenu;
    UndoStack undoStack;
    int numViewsShown;
    int currentView;
    private boolean modified;
    private boolean sceneChangePending;
    private KeyEventPostProcessor keyEventHandler;
    private SceneChangedEvent sceneChangedEvent;
    private ModellingTool[] modellingTools;
    static /* synthetic */ Class class$buoy$event$MousePressedEvent;
    static /* synthetic */ Class class$buoy$event$KeyPressedEvent;
    static /* synthetic */ Class class$buoyx$docking$DockingEvent;

    public LayoutWindow(Scene s) {
        super(s.getName() == null ? "Untitled" : s.getName());
        int i;
        this.theScene = s;
        this.helpText = new BLabel();
        this.theScore = new Score(this);
        this.undoStack = new UndoStack();
        this.sceneChangedEvent = new SceneChangedEvent(this);
        this.createItemList();
        this.theView = new SceneViewer[4];
        this.viewPanel = new BorderContainer[4];
        Object listen = new Object(){

            void processEvent(MousePressedEvent ev) {
                for (int i = 0; i < LayoutWindow.this.theView.length; ++i) {
                    if (LayoutWindow.this.currentView == i || ev.getWidget() != LayoutWindow.this.theView[i]) continue;
                    LayoutWindow.this.theView[LayoutWindow.this.currentView].setDrawFocus(false);
                    LayoutWindow.this.theView[i].setDrawFocus(true);
                    LayoutWindow.this.displayItem[0].setState(LayoutWindow.this.theView[i].getRenderMode() == 0);
                    LayoutWindow.this.displayItem[1].setState(LayoutWindow.this.theView[i].getRenderMode() == 1);
                    LayoutWindow.this.displayItem[2].setState(LayoutWindow.this.theView[i].getRenderMode() == 2);
                    LayoutWindow.this.displayItem[3].setState(LayoutWindow.this.theView[i].getRenderMode() == 3);
                    LayoutWindow.this.currentView = i;
                    LayoutWindow.this.updateImage();
                }
            }
        };
        Object keyListener = new Object(){

            public void processEvent(KeyPressedEvent ev) {
                LayoutWindow.this.handleKeyEvent(ev);
            }
        };
        for (i = 0; i < 4; ++i) {
            this.viewPanel[i] = new BorderContainer(){

                public Dimension getPreferredSize() {
                    return new Dimension(0, 0);
                }

                public Dimension getMinimumSize() {
                    return new Dimension(0, 0);
                }
            };
            RowContainer row = new RowContainer();
            this.viewPanel[i].add(row, BorderContainer.NORTH);
            this.theView[i] = new SceneViewer(this.theScene, row, this);
            this.viewPanel[i].add(this.theView[i], BorderContainer.CENTER);
            this.theView[i].setGrid(this.theScene.getGridSpacing(), this.theScene.getGridSubdivisions(), this.theScene.getShowGrid(), this.theScene.getSnapToGrid());
            this.theView[i].addEventLink(class$buoy$event$MousePressedEvent == null ? LayoutWindow.class$("buoy.event.MousePressedEvent") : class$buoy$event$MousePressedEvent, listen);
            this.theView[i].addEventLink(class$buoy$event$KeyPressedEvent == null ? LayoutWindow.class$("buoy.event.KeyPressedEvent") : class$buoy$event$KeyPressedEvent, keyListener);
            this.theView[i].setPopupMenuManager(this);
        }
        this.theView[1].setOrientation(2);
        this.theView[2].setOrientation(4);
        this.theView[3].setOrientation(6);
        this.theView[3].setPerspective(true);
        this.theView[this.currentView].setDrawFocus(true);
        this.viewsContainer = new FormContainer(new double[]{1.0, 1.0}, new double[]{1.0, 1.0});
        this.viewsContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.viewsContainer.add(this.viewPanel[0], 0, 0);
        this.viewsContainer.add(this.viewPanel[1], 1, 0);
        this.viewsContainer.add(this.viewPanel[2], 0, 1);
        this.viewsContainer.add(this.viewPanel[3], 1, 1);
        this.centerContainer = new FormContainer(new double[]{0.0, 1.0}, new double[]{0.0, 1.0, 0.0, 0.0});
        this.centerContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.centerContainer.add(this.viewsContainer, 1, 0, 1, 3);
        this.centerContainer.add(this.helpText, 0, 3, 2, 1);
        this.dock = new DockingContainer[4];
        this.dock[0] = new DockingContainer(this.centerContainer, BTabbedPane.LEFT);
        this.dock[1] = new DockingContainer(this.dock[0], BTabbedPane.RIGHT);
        this.dock[2] = new DockingContainer(this.dock[1], BTabbedPane.BOTTOM);
        this.dock[3] = new DockingContainer(this.dock[2], BTabbedPane.TOP);
        this.setContent(this.dock[3]);
        for (i = 0; i < this.dock.length; ++i) {
            this.dock[i].setHideSingleTab(true);
            this.dock[i].addEventLink(class$buoyx$docking$DockingEvent == null ? LayoutWindow.class$("buoyx.docking.DockingEvent") : class$buoyx$docking$DockingEvent, (Object)this, "dockableWidgetMoved");
            BSplitPane split = this.dock[i].getSplitPane();
            split.setContinuousLayout(true);
            split.setOneTouchExpandable(true);
            BTabbedPane.TabPosition pos = this.dock[i].getTabPosition();
            split.setResizeWeight(pos == BTabbedPane.TOP || pos == BTabbedPane.LEFT ? 1.0 : 0.0);
            split.addEventLink(class$buoy$event$ValueChangedEvent == null ? LayoutWindow.class$("buoy.event.ValueChangedEvent") : class$buoy$event$ValueChangedEvent, (Object)this, "updateMenus");
            split.addEventLink(class$buoy$event$ValueChangedEvent == null ? LayoutWindow.class$("buoy.event.ValueChangedEvent") : class$buoy$event$ValueChangedEvent, (Object)this, "updateMenus");
        }
        ObjectPropertiesPanel propertiesPanel = new ObjectPropertiesPanel(this);
        BScrollPane propertiesScroller = new BScrollPane(propertiesPanel, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
        propertiesScroller.getVerticalScrollBar().setUnitIncrement(10);
        propertiesScroller.setBackground(ThemeManager.getAppBackgroundColor());
        this.getDockingContainer(BTabbedPane.RIGHT).addDockableWidget(new DefaultDockableWidget(this.itemTreeScroller, Translate.text("Objects")));
        this.getDockingContainer(BTabbedPane.RIGHT).addDockableWidget(new DefaultDockableWidget(propertiesScroller, Translate.text("Properties")), 0, 1);
        this.getDockingContainer(BTabbedPane.BOTTOM).addDockableWidget(new DefaultDockableWidget(this.theScore, Translate.text("Score")));
        this.numViewsShown = 1;
        this.tools = new ToolPalette(2, 7);
        MoveObjectTool defaultTool = new MoveObjectTool(this);
        this.tools.addTool(defaultTool);
        this.tools.addTool(new RotateObjectTool(this));
        this.tools.addTool(new ScaleObjectTool(this));
        this.tools.addTool(new CreateCubeTool(this));
        this.tools.addTool(new CreateSphereTool(this));
        this.tools.addTool(new CreateCylinderTool(this));
        this.tools.addTool(new CreateSplineMeshTool(this));
        this.tools.addTool(new CreatePolygonTool(this));
        this.tools.addTool(new CreateCameraTool(this));
        this.tools.addTool(new CreateLightTool(this));
        this.tools.addTool(new CreateCurveTool(this, 2));
        this.tools.addTool(new CreateCurveTool(this, 3));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(defaultTool);
        for (int i2 = 0; i2 < this.theView.length; ++i2) {
            this.theView[i2].setMetaTool(metaTool);
            this.theView[i2].setAltTool(altTool);
        }
        altTool.setUseSelectionCenter(true);
        this.centerContainer.add(this.tools, 0, 0);
        this.timeFrameLabel = new BLabel(Translate.text("timeFrameLabel", "0.0", "0"), BLabel.CENTER);
        this.centerContainer.add(this.timeFrameLabel, 0, 2, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.menubar = new BMenuBar();
        this.setMenuBar(this.menubar);
        this.createFileMenu();
        this.createEditMenu();
        this.createObjectMenu();
        this.createToolsMenu();
        this.createAnimationMenu();
        this.createSceneMenu();
        this.createPopupMenu();
        this.toggleViewsCommand();
        this.keyEventHandler = new KeyEventPostProcessor(){

            public boolean postProcessKeyEvent(KeyEvent e) {
                if (e.getID() != 401 || e.isConsumed()) {
                    return false;
                }
                KeyPressedEvent press = new KeyPressedEvent(LayoutWindow.this, e.getWhen(), e.getModifiersEx(), e.getKeyCode());
                LayoutWindow.this.handleKeyEvent(press);
                return press.isConsumed();
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.keyEventHandler);
        this.addEventLink(WindowActivatedEvent.class, (Object)this, "updateMenus");
        this.addEventLink(WindowClosingEvent.class, new Object(){

            void processEvent() {
                ModellingApp.closeWindow(LayoutWindow.this);
            }
        });
        this.itemTree.setPopupMenuManager(this);
        UIUtilities.applyDefaultFont(this.getContent());
        UIUtilities.applyDefaultBackground(this.centerContainer);
        this.itemTreeScroller.setBackground(Color.white);
        if (ModellingApp.APP_ICON != null) {
            this.setIcon(ModellingApp.APP_ICON);
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getComponent().getGraphicsConfiguration());
        this.setBounds(new Rectangle(screenInsets.left, screenInsets.top, screenDim.width - screenInsets.left - screenInsets.right, screenDim.height - screenInsets.top - screenInsets.bottom));
        this.tools.requestFocus();
    }

    private void handleKeyEvent(KeyPressedEvent e) {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (manager.getFocusedWindow() != this.getComponent() || manager.getFocusOwner() instanceof JTextComponent) {
            return;
        }
        this.tools.getSelectedTool().keyPressed(e, this.theView[this.currentView]);
        if (!e.isConsumed()) {
            KeystrokeManager.executeKeystrokes(e, this);
        }
    }

    private void createItemList() {
        this.itemTree = new TreeList(this);
        this.itemTree.setPreferredSize(new Dimension(130, 300));
        this.itemTree.addEventLink(TreeList.ElementMovedEvent.class, (Object)this.theScore, "rebuildList");
        this.itemTree.addEventLink(TreeList.ElementDoubleClickedEvent.class, (Object)this, "editObjectCommand");
        this.itemTree.setUpdateEnabled(false);
        for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo info = this.theScene.getObject(i);
            if (info.parent != null) continue;
            this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
        }
        this.itemTree.setUpdateEnabled(true);
        this.itemTreeScroller = new BScrollPane(this.itemTree){

            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        this.itemTreeScroller.setForceWidth(true);
        this.itemTreeScroller.setForceHeight(true);
        this.itemTreeScroller.getVerticalScrollBar().setUnitIncrement(10);
        this.itemTree.addEventLink(SelectionChangedEvent.class, (Object)this, "treeSelectionChanged");
        new AutoScroller(this.itemTreeScroller, 0, 10);
    }

    public void rebuildItemList() {
        TreeElement el;
        ObjectInfo info;
        int i;
        boolean[] expanded = new boolean[this.theScene.getNumObjects()];
        boolean[] selected = new boolean[this.theScene.getNumObjects()];
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            info = this.theScene.getObject(i);
            el = this.itemTree.findElement(info);
            if (el == null) continue;
            expanded[i] = el.isExpanded();
            selected[i] = el.isSelected();
        }
        this.itemTree.setUpdateEnabled(false);
        this.itemTree.removeAllElements();
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            info = this.theScene.getObject(i);
            if (info.parent != null) continue;
            this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
        }
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            info = this.theScene.getObject(i);
            el = this.itemTree.findElement(info);
            if (el == null) continue;
            el.setExpanded(expanded[i]);
            el.setSelected(selected[i]);
        }
        this.itemTree.setUpdateEnabled(true);
        this.theScore.rebuildList();
    }

    private void dockableWidgetMoved() {
        StringBuffer config = new StringBuffer();
        for (int i = 0; i < this.dock.length; ++i) {
            for (int j = 0; j < this.dock[i].getTabCount(); ++j) {
                for (int k = 0; k < this.dock[i].getTabChildCount(j); ++k) {
                    DockableWidget w = this.dock[i].getChild(j, k);
                    config.append(w.getContent().getClass().getName());
                    config.append('\t');
                    config.append(w.getLabel());
                    config.append('\n');
                }
                config.append('\n');
            }
            config.append("-\n");
        }
        Preferences prefs = Preferences.userNodeForPackage(this.getClass()).node("LayoutWindow");
        prefs.put("dockingConfiguration", config.toString());
    }

    void arrangeDockableWidgets() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass()).node("LayoutWindow");
        String config = prefs.get("dockingConfiguration", null);
        if (config == null) {
            return;
        }
        HashMap widgets = new HashMap();
        for (int i = 0; i < this.dock.length; ++i) {
            Iterator children = this.dock[i].getChildren().iterator();
            while (children.hasNext()) {
                Object next = children.next();
                if (!(next instanceof DockableWidget)) continue;
                DockableWidget w = (DockableWidget)next;
                widgets.put(w.getContent().getClass().getName() + '\t' + w.getLabel(), next);
            }
        }
        String[] lines = config.split("\n");
        int container = 0;
        int tab = 0;
        int index = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() == 0) {
                ++tab;
                index = 0;
                continue;
            }
            if ("-".equals(lines[i])) {
                ++container;
                tab = 0;
                index = 0;
                continue;
            }
            DockableWidget w = (DockableWidget)widgets.get(lines[i]);
            if (w == null) continue;
            this.dock[container].addDockableWidget(w, tab, index++);
            widgets.remove(lines[i]);
        }
        this.setScoreVisible(false);
    }

    private void createFileMenu() {
        Translator[] trans = ModellingApp.getTranslators();
        this.fileMenu = Translate.menu("file");
        this.menubar.add(this.fileMenu);
        BMenu importMenu = Translate.menu("import");
        BMenu exportMenu = Translate.menu("export");
        this.fileMenuItem = new BMenuItem[1];
        this.fileMenu.add(Translate.menuItem("new", this, "actionPerformed"));
        this.fileMenu.add(Translate.menuItem("open", this, "actionPerformed"));
        this.recentFilesMenu = Translate.menu("openRecent");
        this.fileMenu.add(this.recentFilesMenu);
        RecentFiles.createMenu(this.recentFilesMenu);
        this.fileMenu.add(Translate.menuItem("close", this, "actionPerformed"));
        this.fileMenu.addSeparator();
        for (int i = 0; i < trans.length; ++i) {
            BMenuItem item;
            if (trans[i].canImport()) {
                item = new BMenuItem(trans[i].getName());
                importMenu.add(item);
                item.setActionCommand("import");
                item.addEventLink(class$buoy$event$CommandEvent == null ? LayoutWindow.class$("buoy.event.CommandEvent") : class$buoy$event$CommandEvent, (Object)this, "actionPerformed");
            }
            if (!trans[i].canExport()) continue;
            item = new BMenuItem(trans[i].getName());
            exportMenu.add(item);
            item.setActionCommand("export");
            item.addEventLink(class$buoy$event$CommandEvent == null ? LayoutWindow.class$("buoy.event.CommandEvent") : class$buoy$event$CommandEvent, (Object)this, "actionPerformed");
        }
        if (importMenu.getChildCount() > 0) {
            this.fileMenu.add(importMenu);
        }
        if (exportMenu.getChildCount() > 0) {
            this.fileMenu.add(exportMenu);
        }
        this.fileMenu.add(Translate.menuItem("linkExternal", this, "linkExternalCommand"));
        this.fileMenu.addSeparator();
        this.fileMenuItem[0] = Translate.menuItem("save", this, "saveCommand");
        this.fileMenu.add(this.fileMenuItem[0]);
        this.fileMenu.add(Translate.menuItem("saveas", this, "saveAsCommand"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(Translate.menuItem("quit", this, "actionPerformed"));
    }

    private void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.editMenuItem = new BMenuItem[9];
        this.editMenuItem[0] = Translate.menuItem("undo", this, "undoCommand");
        this.editMenu.add(this.editMenuItem[0]);
        this.editMenuItem[1] = Translate.menuItem("redo", this, "redoCommand");
        this.editMenu.add(this.editMenuItem[1]);
        this.editMenu.addSeparator();
        this.editMenuItem[2] = Translate.menuItem("cut", this, "cutCommand");
        this.editMenu.add(this.editMenuItem[2]);
        this.editMenuItem[3] = Translate.menuItem("copy", this, "copyCommand");
        this.editMenu.add(this.editMenuItem[3]);
        this.editMenuItem[4] = Translate.menuItem("paste", this, "pasteCommand");
        this.editMenu.add(this.editMenuItem[4]);
        this.editMenuItem[5] = Translate.menuItem("clear", this, "clearCommand");
        this.editMenu.add(this.editMenuItem[5]);
        this.editMenuItem[6] = Translate.menuItem("selectChildren", this, "actionPerformed");
        this.editMenu.add(this.editMenuItem[6]);
        this.editMenu.add(Translate.menuItem("selectAll", this, "selectAllCommand"));
        this.editMenu.addSeparator();
        this.editMenuItem[7] = Translate.menuItem("duplicate", this, "duplicateCommand");
        this.editMenu.add(this.editMenuItem[7]);
        this.editMenuItem[8] = Translate.menuItem("sever", this, "severCommand");
        this.editMenu.add(this.editMenuItem[8]);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("preferences", this, "actionPerformed"));
    }

    private void createObjectMenu() {
        this.objectMenu = Translate.menu("object");
        this.menubar.add(this.objectMenu);
        this.objectMenuItem = new BMenuItem[11];
        this.objectMenuItem[0] = Translate.menuItem("editObject", this, "editObjectCommand");
        this.objectMenu.add(this.objectMenuItem[0]);
        this.objectMenuItem[1] = Translate.menuItem("objectLayout", this, "objectLayoutCommand");
        this.objectMenu.add(this.objectMenuItem[1]);
        this.objectMenuItem[2] = Translate.menuItem("transformObject", this, "transformObjectCommand");
        this.objectMenu.add(this.objectMenuItem[2]);
        this.objectMenuItem[3] = Translate.menuItem("alignObjects", this, "alignObjectsCommand");
        this.objectMenu.add(this.objectMenuItem[3]);
        this.objectMenuItem[4] = Translate.menuItem("setTexture", this, "setTextureCommand");
        this.objectMenu.add(this.objectMenuItem[4]);
        this.objectMenuItem[5] = Translate.menuItem("setMaterial", this, "setMaterialCommand");
        this.objectMenu.add(this.objectMenuItem[5]);
        this.objectMenuItem[6] = Translate.menuItem("renameObject", this, "renameObjectCommand");
        this.objectMenu.add(this.objectMenuItem[6]);
        this.objectMenuItem[7] = Translate.menuItem("convertToTriangle", this, "convertToTriangleCommand");
        this.objectMenu.add(this.objectMenuItem[7]);
        this.objectMenuItem[8] = Translate.menuItem("convertToActor", this, "convertToActorCommand");
        this.objectMenu.add(this.objectMenuItem[8]);
        this.objectMenu.addSeparator();
        this.objectMenuItem[9] = Translate.menuItem("hideSelection", this, "actionPerformed");
        this.objectMenu.add(this.objectMenuItem[9]);
        this.objectMenuItem[10] = Translate.menuItem("showSelection", this, "actionPerformed");
        this.objectMenu.add(this.objectMenuItem[10]);
        this.objectMenu.add(Translate.menuItem("showAll", this, "actionPerformed"));
        this.objectMenu.addSeparator();
        this.createMenu = Translate.menu("createPrimitive");
        this.objectMenu.add(this.createMenu);
        this.createMenu.add(Translate.menuItem("cube", this, "createObjectCommand"));
        this.createMenu.add(Translate.menuItem("sphere", this, "createObjectCommand"));
        this.createMenu.add(Translate.menuItem("cylinder", this, "createObjectCommand"));
        this.createMenu.add(Translate.menuItem("cone", this, "createObjectCommand"));
        this.createMenu.add(Translate.menuItem("pointLight", this, "createObjectCommand"));
        this.createMenu.add(Translate.menuItem("directionalLight", this, "createObjectCommand"));
        this.createMenu.add(Translate.menuItem("spotLight", this, "createObjectCommand"));
        this.createMenu.add(Translate.menuItem("camera", this, "createObjectCommand"));
        this.createMenu.add(Translate.menuItem("referenceImage", this, "createObjectCommand"));
        this.createMenu.add(Translate.menuItem("null", this, "createObjectCommand"));
    }

    private void createToolsMenu() {
        this.modellingTools = ModellingApp.getModellingTools();
        Arrays.sort(this.modellingTools, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ModellingTool)o1).getName().compareTo(((ModellingTool)o2).getName());
            }
        });
        this.toolsMenu = Translate.menu("tools");
        this.menubar.add(this.toolsMenu);
        this.toolsMenuItem = new BMenuItem[this.modellingTools.length];
        for (int i = 0; i < this.modellingTools.length; ++i) {
            BMenuItem item = new BMenuItem(this.modellingTools[i].getName());
            this.toolsMenu.add(item);
            item.setActionCommand("modellingTool");
            item.addEventLink(class$buoy$event$CommandEvent == null ? LayoutWindow.class$("buoy.event.CommandEvent") : class$buoy$event$CommandEvent, (Object)this, "modellingToolCommand");
            this.toolsMenuItem[i] = item;
        }
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(Translate.menuItem("createScriptObject", this, "createScriptObjectCommand"));
        this.toolsMenu.add(Translate.menuItem("editScript", this, "actionPerformed"));
        this.scriptMenu = Translate.menu("scripts");
        this.toolsMenu.add(this.scriptMenu);
        this.rebuildScriptsMenu();
    }

    public void rebuildScriptsMenu() {
        this.scriptMenu.removeAll();
        this.addScriptsToMenu(this.scriptMenu, new File(ModellingApp.TOOL_SCRIPT_DIRECTORY));
    }

    private void addScriptsToMenu(BMenu menu, File dir2) {
        String[] files = dir2.list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir2, files[i]);
            if (f.isDirectory()) {
                BMenu m = new BMenu(files[i]);
                menu.add(m);
                this.addScriptsToMenu(m, f);
                continue;
            }
            if (!files[i].endsWith(".bsh") || files[i].length() <= 4) continue;
            BMenuItem item = new BMenuItem(files[i].substring(0, files[i].length() - 4));
            item.setActionCommand(f.getAbsolutePath());
            item.addEventLink(class$buoy$event$CommandEvent == null ? LayoutWindow.class$("buoy.event.CommandEvent") : class$buoy$event$CommandEvent, (Object)this, "executeScriptCommand");
            menu.add(item);
        }
    }

    private void createAnimationMenu() {
        this.animationMenu = Translate.menu("animation");
        this.menubar.add(this.animationMenu);
        this.animationMenuItem = new BMenuItem[13];
        this.animationMenuItem[0] = Translate.menuItem("showScore", this, "actionPerformed");
        this.animationMenu.add(this.animationMenuItem[0]);
        this.animationMenu.add(Translate.menuItem("previewAnimation", this, "actionPerformed"));
        this.animationMenu.addSeparator();
        this.animationMenu.add(Translate.menuItem("forwardFrame", this, "actionPerformed"));
        this.animationMenu.add(Translate.menuItem("backFrame", this, "actionPerformed"));
        this.animationMenu.add(Translate.menuItem("jumpToTime", this, "jumpToTimeCommand"));
        this.animationMenu.addSeparator();
        this.animationMenuItem[1] = Translate.menuItem("editKeyframe", this.theScore, "editSelectedKeyframe");
        this.animationMenu.add(this.animationMenuItem[1]);
        this.animationMenuItem[2] = Translate.menuItem("deleteSelectedKeyframes", this.theScore, "deleteSelectedKeyframes");
        this.animationMenu.add(this.animationMenuItem[2]);
        this.editKeyframeMenu = Translate.menu("bulkEditKeyframes");
        this.animationMenu.add(this.editKeyframeMenu);
        this.editKeyframeMenu.add(Translate.menuItem("moveKeyframes", this, "actionPerformed"));
        this.editKeyframeMenu.add(Translate.menuItem("copyKeyframes", this, "actionPerformed"));
        this.editKeyframeMenu.add(Translate.menuItem("rescaleKeyframes", this, "actionPerformed"));
        this.editKeyframeMenu.add(Translate.menuItem("loopKeyframes", this, "actionPerformed"));
        this.editKeyframeMenu.add(Translate.menuItem("deleteKeyframes", this, "actionPerformed"));
        this.animationMenuItem[3] = Translate.menuItem("keyframe", this.theScore, "keyframeSelectedTracks");
        this.animationMenu.add(this.animationMenuItem[3]);
        this.animationMenuItem[4] = Translate.menuItem("keyframeModified", this.theScore, "keyframeModifiedTracks");
        this.animationMenu.add(this.animationMenuItem[4]);
        this.animationMenu.addSeparator();
        this.animationMenuItem[5] = Translate.menuItem("editTrack", this.theScore, "editSelectedTrack");
        this.animationMenu.add(this.animationMenuItem[5]);
        this.addTrackMenu = Translate.menu("addTrack");
        this.animationMenu.add(this.addTrackMenu);
        this.positionTrackMenu = Translate.menu("positionTrack");
        this.addTrackMenu.add(this.positionTrackMenu);
        this.positionTrackMenu.add(Translate.menuItem("xyzOneTrack", this, "actionPerformed"));
        this.positionTrackMenu.add(Translate.menuItem("xyzThreeTracks", this, "actionPerformed"));
        this.positionTrackMenu.add(Translate.menuItem("proceduralTrack", this, "actionPerformed"));
        this.rotationTrackMenu = Translate.menu("rotationTrack");
        this.addTrackMenu.add(this.rotationTrackMenu);
        this.rotationTrackMenu.add(Translate.menuItem("xyzOneTrack", this, "actionPerformed"));
        this.rotationTrackMenu.add(Translate.menuItem("xyzThreeTracks", this, "actionPerformed"));
        this.rotationTrackMenu.add(Translate.menuItem("quaternionTrack", this, "actionPerformed"));
        this.rotationTrackMenu.add(Translate.menuItem("proceduralTrack", this, "actionPerformed"));
        this.addTrackMenu.add(Translate.menuItem("poseTrack", this, "actionPerformed"));
        this.distortionMenu = Translate.menu("distortionTrack");
        this.addTrackMenu.add(this.distortionMenu);
        this.distortionMenu.add(Translate.menuItem("bendDistortion", this, "actionPerformed"));
        this.distortionMenu.add(Translate.menuItem("customDistortion", this, "actionPerformed"));
        this.distortionMenu.add(Translate.menuItem("scaleDistortion", this, "actionPerformed"));
        this.distortionMenu.add(Translate.menuItem("shatterDistortion", this, "actionPerformed"));
        this.distortionMenu.add(Translate.menuItem("twistDistortion", this, "actionPerformed"));
        this.distortionMenu.addSeparator();
        this.distortionMenu.add(Translate.menuItem("IKTrack", this, "actionPerformed"));
        this.distortionMenu.add(Translate.menuItem("skeletonShapeTrack", this, "actionPerformed"));
        this.addTrackMenu.add(Translate.menuItem("constraintTrack", this, "actionPerformed"));
        this.addTrackMenu.add(Translate.menuItem("visibilityTrack", this, "actionPerformed"));
        this.addTrackMenu.add(Translate.menuItem("textureTrack", this, "actionPerformed"));
        this.animationMenuItem[6] = Translate.menuItem("duplicateTracks", this.theScore, "duplicateSelectedTracks");
        this.animationMenu.add(this.animationMenuItem[6]);
        this.animationMenuItem[7] = Translate.menuItem("deleteTracks", this.theScore, "deleteSelectedTracks");
        this.animationMenu.add(this.animationMenuItem[7]);
        this.animationMenuItem[8] = Translate.menuItem("selectAllTracks", this.theScore, "selectAllTracks");
        this.animationMenu.add(this.animationMenuItem[8]);
        this.animationMenuItem[9] = Translate.menuItem("enableTracks", this, "actionPerformed");
        this.animationMenu.add(this.animationMenuItem[9]);
        this.animationMenuItem[10] = Translate.menuItem("disableTracks", this, "actionPerformed");
        this.animationMenu.add(this.animationMenuItem[10]);
        this.animationMenuItem[11] = Translate.menuItem("pathFromCurve", this, "actionPerformed");
        this.animationMenu.add(this.animationMenuItem[11]);
        this.animationMenuItem[12] = Translate.menuItem("bindToParent", this, "bindToParentCommand");
        this.animationMenu.add(this.animationMenuItem[12]);
    }

    private void createSceneMenu() {
        this.sceneMenu = Translate.menu("scene");
        this.menubar.add(this.sceneMenu);
        this.sceneMenuItem = new BMenuItem[5];
        this.sceneMenu.add(Translate.menuItem("renderScene", this, "renderCommand"));
        this.sceneMenu.add(Translate.menuItem("renderImmediately", this, "actionPerformed"));
        this.sceneMenu.addSeparator();
        BMenu displayMenu = Translate.menu("displayMode");
        this.sceneMenu.add(displayMenu);
        this.displayItem = new BCheckBoxMenuItem[5];
        this.displayItem[0] = Translate.checkboxMenuItem("wireframeDisplay", this, "displayModeCommand", this.theView[0].getRenderMode() == 0);
        displayMenu.add(this.displayItem[0]);
        this.displayItem[1] = Translate.checkboxMenuItem("shadedDisplay", this, "displayModeCommand", this.theView[0].getRenderMode() == 1);
        displayMenu.add(this.displayItem[1]);
        this.displayItem[2] = Translate.checkboxMenuItem("smoothDisplay", this, "displayModeCommand", this.theView[0].getRenderMode() == 2);
        displayMenu.add(this.displayItem[2]);
        this.displayItem[3] = Translate.checkboxMenuItem("texturedDisplay", this, "displayModeCommand", this.theView[0].getRenderMode() == 3);
        displayMenu.add(this.displayItem[3]);
        this.displayItem[4] = Translate.checkboxMenuItem("transparentDisplay", this, "displayModeCommand", this.theView[0].getRenderMode() == 3);
        displayMenu.add(this.displayItem[4]);
        this.sceneMenuItem[0] = Translate.menuItem("fourViews", this, "toggleViewsCommand");
        this.sceneMenu.add(this.sceneMenuItem[0]);
        this.sceneMenuItem[1] = Translate.menuItem("hideObjectList", this, "actionPerformed");
        this.sceneMenu.add(this.sceneMenuItem[1]);
        this.sceneMenu.add(Translate.menuItem("grid", this, "setGridCommand"));
        this.sceneMenuItem[2] = Translate.menuItem("showCoordinateAxes", this, "actionPerformed");
        this.sceneMenu.add(this.sceneMenuItem[2]);
        this.sceneMenuItem[3] = Translate.menuItem("showTemplate", this, "actionPerformed");
        this.sceneMenu.add(this.sceneMenuItem[3]);
        this.sceneMenu.add(Translate.menuItem("setTemplate", this, "setTemplateCommand"));
        this.sceneMenu.addSeparator();
        this.sceneMenuItem[4] = Translate.menuItem("frameSelection", this, "actionPerformed");
        this.sceneMenu.add(this.sceneMenuItem[4]);
        this.sceneMenu.add(Translate.menuItem("frameScene", this, "actionPerformed"));
        this.sceneMenu.addSeparator();
        this.sceneMenu.add(Translate.menuItem("textures", this, "texturesCommand"));
        this.sceneMenu.add(Translate.menuItem("materials", this, "materialsCommand"));
        this.sceneMenu.add(Translate.menuItem("images", this, "actionPerformed"));
        this.sceneMenu.add(Translate.menuItem("environment", this, "environmentCommand"));
    }

    private void createPopupMenu() {
        this.popupMenu = new BPopupMenu();
        this.popupMenuItem = new BMenuItem[12];
        this.popupMenuItem[0] = Translate.menuItem("editObject", this, "editObjectCommand", null);
        this.popupMenu.add(this.popupMenuItem[0]);
        this.popupMenuItem[1] = Translate.menuItem("objectLayout", this, "objectLayoutCommand", null);
        this.popupMenu.add(this.popupMenuItem[1]);
        this.popupMenuItem[2] = Translate.menuItem("setTexture", this, "setTextureCommand", null);
        this.popupMenu.add(this.popupMenuItem[2]);
        this.popupMenuItem[3] = Translate.menuItem("setMaterial", this, "setMaterialCommand", null);
        this.popupMenu.add(this.popupMenuItem[3]);
        this.popupMenuItem[4] = Translate.menuItem("renameObject", this, "renameObjectCommand", null);
        this.popupMenu.add(this.popupMenuItem[4]);
        this.popupMenuItem[5] = Translate.menuItem("convertToTriangle", this, "convertToTriangleCommand", null);
        this.popupMenu.add(this.popupMenuItem[5]);
        this.popupMenuItem[6] = Translate.menuItem("selectChildren", this, "actionPerformed", null);
        this.popupMenu.add(this.popupMenuItem[6]);
        this.popupMenu.addSeparator();
        this.popupMenuItem[7] = Translate.menuItem("hideSelection", this, "actionPerformed", null);
        this.popupMenu.add(this.popupMenuItem[7]);
        this.popupMenuItem[8] = Translate.menuItem("showSelection", this, "actionPerformed", null);
        this.popupMenu.add(this.popupMenuItem[8]);
        this.popupMenu.addSeparator();
        this.popupMenuItem[9] = Translate.menuItem("cut", this, "cutCommand", null);
        this.popupMenu.add(this.popupMenuItem[9]);
        this.popupMenuItem[10] = Translate.menuItem("copy", this, "copyCommand", null);
        this.popupMenu.add(this.popupMenuItem[10]);
        this.popupMenuItem[11] = Translate.menuItem("clear", this, "clearCommand", null);
        this.popupMenu.add(this.popupMenuItem[11]);
    }

    public void showPopupMenu(Widget w, int x, int y) {
        Object3D obj;
        int i;
        Object[] sel = this.itemTree.getSelectedObjects();
        boolean canSetTexture = sel.length > 0;
        boolean canSetMaterial = canSetTexture;
        boolean canConvert = canSetTexture;
        boolean hasChildren = false;
        boolean canShow = false;
        boolean canHide = false;
        for (i = 0; i < sel.length; ++i) {
            ObjectInfo info = (ObjectInfo)sel[i];
            obj = info.object;
            if (obj.canConvertToTriangleMesh() == 0) {
                canConvert = false;
            }
            if (!obj.canSetTexture()) {
                canSetTexture = false;
            }
            if (!obj.canSetMaterial()) {
                canSetMaterial = false;
            }
            if (info.children.length > 0) {
                hasChildren = true;
            }
            if (info.visible) {
                canHide = true;
                continue;
            }
            canShow = true;
        }
        if (sel.length == 0) {
            for (i = 0; i < this.popupMenuItem.length; ++i) {
                this.popupMenuItem[i].setEnabled(false);
            }
        } else {
            obj = ((ObjectInfo)sel[0]).object;
            this.popupMenuItem[0].setEnabled(sel.length == 1 && obj.isEditable());
            this.popupMenuItem[1].setEnabled(true);
            this.popupMenuItem[2].setEnabled(canSetTexture);
            this.popupMenuItem[3].setEnabled(canSetMaterial);
            this.popupMenuItem[4].setEnabled(sel.length == 1);
            this.popupMenuItem[5].setEnabled(canConvert);
            this.popupMenuItem[6].setEnabled(sel.length == 1 && hasChildren);
            this.popupMenuItem[7].setEnabled(canHide);
            this.popupMenuItem[8].setEnabled(canShow);
            this.popupMenuItem[9].setEnabled(sel.length > 0);
            this.popupMenuItem[10].setEnabled(sel.length > 0);
            this.popupMenuItem[11].setEnabled(sel.length > 0);
        }
        this.popupMenu.show(w, x, y);
    }

    public DockingContainer getDockingContainer(BTabbedPane.TabPosition position) {
        for (int i = 0; i < this.dock.length; ++i) {
            if (this.dock[i].getTabPosition() != position) continue;
            return this.dock[i];
        }
        return null;
    }

    public void setWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void clearWaitCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public boolean confirmClose() {
        if (this.modified) {
            String name = this.theScene.getName();
            if (name == null) {
                name = "Untitled";
            }
            BStandardDialog dlg = new BStandardDialog("", Translate.text("checkSaveChanges", name), BStandardDialog.QUESTION);
            String[] options = new String[]{Translate.text("button.save"), Translate.text("button.dontSave"), Translate.text("button.cancel")};
            int choice = dlg.showOptionDialog(this, options, options[0]);
            if (choice == 0) {
                this.saveCommand();
                if (this.modified) {
                    return false;
                }
            }
            if (choice == 2) {
                return false;
            }
        }
        this.dispose();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.keyEventHandler);
        return true;
    }

    public void setTool(EditingTool tool) {
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setTool(tool);
        }
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public BFrame getFrame() {
        return this;
    }

    public void updateImage() {
        if (this.numViewsShown == 1) {
            this.theView[this.currentView].copyOrientationFromCamera();
            this.theView[this.currentView].repaint();
        } else {
            for (int i = 0; i < this.numViewsShown; ++i) {
                this.theView[i].copyOrientationFromCamera();
                this.theView[i].repaint();
            }
        }
    }

    public void updateMenus() {
        Object3D obj;
        int i;
        Object[] sel = this.itemTree.getSelectedObjects();
        int numSelObjects = sel.length;
        Track[] selTrack = this.theScore.getSelectedTracks();
        int numSelTracks = selTrack.length;
        int numSelKeyframes = this.theScore.getSelectedKeyframes().length;
        SceneViewer view = this.theView[this.currentView];
        boolean canSetTexture = numSelObjects > 0;
        boolean canSetMaterial = canSetTexture;
        boolean canConvert = canSetTexture;
        boolean hasParent = false;
        boolean hasChildren = false;
        boolean disable = false;
        boolean enable = false;
        boolean noncurve = false;
        boolean curve = false;
        for (i = 0; i < numSelObjects; ++i) {
            ObjectInfo info = (ObjectInfo)sel[i];
            obj = info.object;
            if (obj instanceof Curve) {
                curve = true;
            } else {
                noncurve = true;
            }
            if (obj.canConvertToTriangleMesh() == 0) {
                canConvert = false;
            }
            if (!obj.canSetTexture()) {
                canSetTexture = false;
            }
            if (!obj.canSetMaterial()) {
                canSetMaterial = false;
            }
            if (info.children.length > 0) {
                hasChildren = true;
            }
            if (info.parent == null) continue;
            hasParent = true;
        }
        for (i = 0; i < numSelTracks; ++i) {
            if (selTrack[i].isEnabled()) {
                disable = true;
                continue;
            }
            enable = true;
        }
        this.fileMenuItem[0].setEnabled(this.modified);
        this.editMenuItem[0].setEnabled(this.undoStack.canUndo());
        this.editMenuItem[1].setEnabled(this.undoStack.canRedo());
        this.editMenuItem[2].setEnabled(numSelObjects > 0);
        this.editMenuItem[3].setEnabled(numSelObjects > 0);
        this.editMenuItem[4].setEnabled(ModellingApp.getClipboardSize() > 0);
        this.editMenuItem[5].setEnabled(numSelObjects > 0);
        this.editMenuItem[6].setEnabled(hasChildren);
        this.editMenuItem[7].setEnabled(numSelObjects > 0);
        this.editMenuItem[8].setEnabled(numSelObjects > 0);
        if (numSelObjects == 0) {
            for (i = 0; i < this.objectMenuItem.length; ++i) {
                this.objectMenuItem[i].setEnabled(false);
            }
        } else {
            obj = ((ObjectInfo)sel[0]).object;
            this.objectMenuItem[0].setEnabled(numSelObjects == 1 && obj.isEditable());
            this.objectMenuItem[1].setEnabled(true);
            this.objectMenuItem[2].setEnabled(true);
            this.objectMenuItem[3].setEnabled(numSelObjects > 0);
            this.objectMenuItem[4].setEnabled(canSetTexture);
            this.objectMenuItem[5].setEnabled(canSetMaterial);
            this.objectMenuItem[6].setEnabled(sel.length == 1);
            this.objectMenuItem[7].setEnabled(canConvert && sel.length == 1);
            this.objectMenuItem[8].setEnabled(sel.length == 1 && ((ObjectInfo)sel[0]).object.canConvertToActor());
            this.objectMenuItem[9].setEnabled(true);
            this.objectMenuItem[10].setEnabled(true);
        }
        this.animationMenuItem[0].setText(Translate.text(this.theScore.getBounds().height == 0 || this.theScore.getBounds().width == 0 ? "menu.showScore" : "menu.hideScore"));
        this.animationMenuItem[1].setEnabled(numSelKeyframes == 1);
        this.animationMenuItem[2].setEnabled(numSelKeyframes > 0);
        this.animationMenuItem[3].setEnabled(numSelTracks > 0);
        this.animationMenuItem[4].setEnabled(numSelObjects > 0);
        this.animationMenuItem[5].setEnabled(numSelTracks == 1);
        this.animationMenuItem[6].setEnabled(numSelTracks > 0);
        this.animationMenuItem[7].setEnabled(numSelTracks > 0);
        this.animationMenuItem[8].setEnabled(numSelObjects > 0);
        this.animationMenuItem[9].setEnabled(enable);
        this.animationMenuItem[10].setEnabled(disable);
        this.animationMenuItem[11].setEnabled(curve && noncurve);
        this.animationMenuItem[12].setEnabled(hasParent);
        this.addTrackMenu.setEnabled(numSelObjects > 0);
        this.distortionMenu.setEnabled(sel.length > 0);
        this.sceneMenuItem[1].setText(Translate.text(this.itemTreeScroller.getBounds().width == 0 || this.itemTreeScroller.getBounds().height == 0 ? "menu.showObjectList" : "menu.hideObjectList"));
        this.sceneMenuItem[2].setText(Translate.text(view.getShowAxes() ? "menu.hideCoordinateAxes" : "menu.showCoordinateAxes"));
        this.sceneMenuItem[3].setEnabled(view.getTemplateImage() != null);
        this.sceneMenuItem[3].setText(Translate.text(view.getTemplateShown() ? "menu.hideTemplate" : "menu.showTemplate"));
        this.sceneMenuItem[4].setEnabled(sel.length > 0);
        this.displayItem[0].setState(view.getRenderMode() == 0);
        this.displayItem[1].setState(view.getRenderMode() == 1);
        this.displayItem[2].setState(view.getRenderMode() == 2);
        this.displayItem[3].setState(view.getRenderMode() == 3);
    }

    public void setUndoRecord(UndoRecord command) {
        this.undoStack.addRecord(command);
        this.setModified();
        this.updateMenus();
    }

    public void setModified() {
        this.modified = true;
        this.dispatchSceneChangedEvent();
    }

    public boolean isModified() {
        return this.modified;
    }

    private void dispatchSceneChangedEvent() {
        if (this.sceneChangePending) {
            return;
        }
        this.sceneChangePending = true;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LayoutWindow.this.sceneChangePending = false;
                LayoutWindow.this.dispatchEvent(LayoutWindow.this.sceneChangedEvent);
            }
        });
    }

    public void addObject(Object3D obj, CoordinateSystem coords, String name, UndoRecord undo) {
        this.addObject(new ObjectInfo(obj, coords, name), undo);
    }

    public void addObject(ObjectInfo info, UndoRecord undo) {
        this.theScene.addObject(info, undo);
        this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].rebuildCameraList();
        }
        this.theScore.rebuildList();
    }

    public void addObject(ObjectInfo info, int index, UndoRecord undo) {
        this.theScene.addObject(info, index, undo);
        this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree), index);
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].rebuildCameraList();
        }
        this.theScore.rebuildList();
    }

    public void removeObject(int which, UndoRecord undo) {
        int i;
        ObjectInfo info = this.theScene.getObject(which);
        ObjectInfo parent = info.parent;
        int childIndex = -1;
        if (parent != null) {
            for (i = 0; i < parent.children.length; ++i) {
                if (parent.children[i] != info) continue;
                childIndex = i;
            }
        }
        this.itemTree.removeObject(info);
        if (childIndex > -1 && info.parent == null) {
            undo.addCommandAtBeginning(7, new Object[]{parent, info, new Integer(childIndex)});
        }
        this.theScene.removeObject(which, undo);
        for (i = 0; i < this.theView.length; ++i) {
            this.theView[i].rebuildCameraList();
        }
        this.theScore.rebuildList();
    }

    public void setObjectName(int which, String name) {
        this.theScene.getObject((int)which).name = name;
        this.itemTree.repaint();
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].rebuildCameraList();
        }
        this.theScore.rebuildList();
    }

    public void setTime(double time) {
        this.theScene.setTime(time);
        this.theScore.setTime(time);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        this.timeFrameLabel.setText(Translate.text("timeFrameLabel", nf.format(time), Integer.toString((int)Math.round(time * (double)this.theScene.getFramesPerSecond()))));
        this.theScore.repaint();
        this.itemTree.repaint();
        this.updateImage();
        this.dispatchSceneChangedEvent();
    }

    public Scene getScene() {
        return this.theScene;
    }

    public ViewerCanvas getView() {
        return this.theView[this.currentView];
    }

    public ViewerCanvas[] getAllViews() {
        return (ViewerCanvas[])this.theView.clone();
    }

    public Score getScore() {
        return this.theScore;
    }

    public ToolPalette getToolPalette() {
        return this.tools;
    }

    private void setDockableWidgetVisible(DockableWidget widget, boolean visible) {
        DockingContainer parent = (DockingContainer)widget.getParent();
        BTabbedPane.TabPosition pos = parent.getTabPosition();
        BSplitPane split = parent.getSplitPane();
        if (visible) {
            split.resetToPreferredSizes();
        } else {
            split.setDividerLocation(pos == BTabbedPane.TOP || pos == BTabbedPane.LEFT ? 0.0 : 1.0);
        }
        this.updateMenus();
    }

    public void setObjectListVisible(boolean visible) {
        this.setDockableWidgetVisible((DockableWidget)this.itemTreeScroller.getParent(), visible);
    }

    public void setScoreVisible(boolean visible) {
        this.setDockableWidgetVisible((DockableWidget)this.theScore.getParent(), visible);
    }

    public void setSplitView(boolean split) {
        if (this.numViewsShown == 1 == split) {
            this.toggleViewsCommand();
        }
    }

    private void treeSelectionChanged() {
        Object[] sel = this.itemTree.getSelectedObjects();
        int[] which = new int[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            which[i] = this.theScene.indexOf((ObjectInfo)sel[i]);
        }
        this.setUndoRecord(new UndoRecord(this, false, 16, new Object[]{this.theScene.getSelection()}));
        this.setSelection(which);
        this.updateImage();
    }

    private void displayModeCommand(CommandEvent ev) {
        Widget source = ev.getWidget();
        if (source == this.displayItem[0]) {
            this.theView[this.currentView].setRenderMode(0);
        } else if (source == this.displayItem[1]) {
            this.theView[this.currentView].setRenderMode(1);
        } else if (source == this.displayItem[2]) {
            this.theView[this.currentView].setRenderMode(2);
        } else if (source == this.displayItem[3]) {
            this.theView[this.currentView].setRenderMode(3);
        } else if (source == this.displayItem[4]) {
            this.theView[this.currentView].setRenderMode(4);
        }
        for (int i = 0; i < this.displayItem.length; ++i) {
            this.displayItem[i].setState(source == this.displayItem[i]);
        }
    }

    public void setSelection(int which) {
        this.itemTree.setUpdateEnabled(false);
        this.clearSelection();
        this.theScene.setSelection(which);
        this.itemTree.setSelected(this.theScene.getObject(which), true);
        this.itemTree.setUpdateEnabled(true);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void setSelection(int[] which) {
        this.itemTree.setUpdateEnabled(false);
        this.clearSelection();
        this.theScene.setSelection(which);
        for (int i = 0; i < which.length; ++i) {
            this.itemTree.setSelected(this.theScene.getObject(which[i]), true);
        }
        this.itemTree.setUpdateEnabled(true);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void addToSelection(int which) {
        this.theScene.addToSelection(which);
        this.itemTree.setSelected(this.theScene.getObject(which), true);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void clearSelection() {
        this.theScene.clearSelection();
        this.itemTree.deselectAll();
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void removeFromSelection(int which) {
        this.theScene.removeFromSelection(which);
        this.itemTree.setSelected(this.theScene.getObject(which), false);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    private void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        Widget src = e.getWidget();
        WidgetContainer menu = src instanceof MenuWidget ? src.getParent() : null;
        this.setWaitCursor();
        if (menu == this.fileMenu) {
            if (command.equals("new")) {
                ModellingApp.newWindow();
            } else if (command.equals("open")) {
                ModellingApp.openScene(this);
            } else if (command.equals("close")) {
                ModellingApp.closeWindow(this);
            } else if (command.equals("quit")) {
                ModellingApp.quit();
            }
        } else if (command.equals("import")) {
            this.importCommand(((BMenuItem)e.getWidget()).getText());
        } else if (command.equals("export")) {
            this.exportCommand(((BMenuItem)e.getWidget()).getText());
        } else if (menu == this.editMenu) {
            if (command.equals("selectChildren")) {
                this.setUndoRecord(new UndoRecord(this, false, 16, new Object[]{this.theScene.getSelection()}));
                this.setSelection(this.theScene.getSelectionWithChildren());
                this.updateImage();
            } else if (command.equals("preferences")) {
                new PreferencesWindow(this);
            }
        } else if (menu == this.objectMenu) {
            if (command.equals("hideSelection")) {
                this.setObjectVisibility(false, true);
            } else if (command.equals("showSelection")) {
                this.setObjectVisibility(true, true);
            } else if (command.equals("showAll")) {
                this.setObjectVisibility(true, false);
            }
        } else if (menu == this.toolsMenu) {
            if (command.equals("editScript")) {
                new ExecuteScriptWindow(this);
            }
        } else if (menu == this.animationMenu || menu == this.theScore.getPopupMenu()) {
            if (command.equals("showScore")) {
                this.setScoreVisible(this.theScore.getBounds().height == 0 || this.theScore.getBounds().width == 0);
            } else if (command.equals("previewAnimation")) {
                new AnimationPreviewer(this);
            } else if (command.equals("forwardFrame")) {
                double t = this.theScene.getTime() + 1.0 / (double)this.theScene.getFramesPerSecond();
                this.setTime(t);
            } else if (command.equals("backFrame")) {
                double t = this.theScene.getTime() - 1.0 / (double)this.theScene.getFramesPerSecond();
                this.setTime(t);
            } else if (command.equals("enableTracks")) {
                this.theScore.setTracksEnabled(true);
            } else if (command.equals("disableTracks")) {
                this.theScore.setTracksEnabled(false);
            } else if (command.equals("pathFromCurve")) {
                new PathFromCurveDialog(this, this.itemTree.getSelectedObjects());
            } else if (command.equals("bindToParent")) {
                this.bindToParentCommand();
            }
        } else if (menu == this.editKeyframeMenu) {
            if (command.equals("moveKeyframes")) {
                new EditKeyframesDialog(this, 0);
            } else if (command.equals("copyKeyframes")) {
                new EditKeyframesDialog(this, 1);
            } else if (command.equals("rescaleKeyframes")) {
                new EditKeyframesDialog(this, 2);
            } else if (command.equals("loopKeyframes")) {
                new EditKeyframesDialog(this, 3);
            } else if (command.equals("deleteKeyframes")) {
                new EditKeyframesDialog(this, 4);
            }
        } else if (menu == this.addTrackMenu) {
            if (command.equals("poseTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), PoseTrack.class, null, true);
            } else if (command.equals("constraintTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), ConstraintTrack.class, null, true);
            } else if (command.equals("visibilityTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), VisibilityTrack.class, null, true);
            } else if (command.equals("textureTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), TextureTrack.class, null, true);
            }
        } else if (menu == this.positionTrackMenu) {
            if (command.equals("xyzOneTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), PositionTrack.class, null, true);
            } else if (command.equals("xyzThreeTracks")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), PositionTrack.class, new Object[]{"Z Position", Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}, true);
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), PositionTrack.class, new Object[]{"Y Position", Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}, false);
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), PositionTrack.class, new Object[]{"X Position", Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}, false);
            } else if (command.equals("proceduralTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), ProceduralPositionTrack.class, null, true);
            }
        } else if (menu == this.rotationTrackMenu) {
            if (command.equals("xyzOneTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"Rotation", Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}, true);
            } else if (command.equals("xyzThreeTracks")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"Z Rotation", Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}, true);
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"Y Rotation", Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}, false);
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"X Rotation", Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}, false);
            } else if (command.equals("quaternionTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"Rotation", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}, true);
            } else if (command.equals("proceduralTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), ProceduralRotationTrack.class, null, true);
            }
        } else if (menu == this.distortionMenu) {
            if (command.equals("bendDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), BendTrack.class, null, true);
            } else if (command.equals("customDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), CustomDistortionTrack.class, null, true);
            } else if (command.equals("scaleDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), ScaleTrack.class, null, true);
            } else if (command.equals("shatterDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), ShatterTrack.class, null, true);
            } else if (command.equals("twistDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), TwistTrack.class, null, true);
            } else if (command.equals("IKTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), IKTrack.class, null, true);
            } else if (command.equals("skeletonShapeTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), SkeletonShapeTrack.class, null, true);
            }
        } else if (menu == this.sceneMenu) {
            if (command.equals("renderScene")) {
                new RenderSetupDialog(this, this.theScene);
            } else if (command.equals("renderImmediately")) {
                RenderSetupDialog.renderImmediately(this, this.theScene);
            } else if (command.equals("hideObjectList")) {
                this.setObjectListVisible(this.itemTreeScroller.getBounds().width == 0 || this.itemTreeScroller.getBounds().height == 0);
            } else if (command.equals("showCoordinateAxes")) {
                boolean wasShown = this.theView[this.currentView].getShowAxes();
                for (int i = 0; i < this.theView.length; ++i) {
                    this.theView[i].setShowAxes(!wasShown);
                }
                this.updateImage();
                this.updateMenus();
            } else if (command.equals("showTemplate")) {
                boolean wasShown = this.theView[this.currentView].getTemplateShown();
                this.theView[this.currentView].setShowTemplate(!wasShown);
                this.updateImage();
                this.updateMenus();
            } else if (command.equals("frameSelection")) {
                this.frameWithCameraCommand(true);
            } else if (command.equals("frameScene")) {
                this.frameWithCameraCommand(false);
            } else if (command.equals("images")) {
                new ImagesDialog(this, this.theScene, null);
            }
        } else if (menu == this.popupMenu) {
            if (command.equals("selectChildren")) {
                this.setUndoRecord(new UndoRecord(this, false, 16, new Object[]{this.theScene.getSelection()}));
                this.setSelection(this.theScene.getSelectionWithChildren());
                this.updateImage();
            } else if (command.equals("hideSelection")) {
                this.setObjectVisibility(false, true);
            } else if (command.equals("showSelection")) {
                this.setObjectVisibility(true, true);
            }
        }
        this.clearWaitCursor();
    }

    void importCommand(String format) {
        Translator[] trans = ModellingApp.getTranslators();
        for (int i = 0; i < trans.length; ++i) {
            if (!trans[i].canImport() || !format.equals(trans[i].getName())) continue;
            trans[i].importFile(this);
            return;
        }
    }

    void exportCommand(String format) {
        Translator[] trans = ModellingApp.getTranslators();
        for (int i = 0; i < trans.length; ++i) {
            if (!trans[i].canExport() || !format.equals(trans[i].getName())) continue;
            trans[i].exportFile(this, this.theScene);
            return;
        }
    }

    public void linkExternalCommand() {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("externalObject.selectScene"));
        if (!fc.showDialog(this)) {
            return;
        }
        ExternalObject obj = new ExternalObject(fc.getSelectedFile(), "");
        ObjectInfo info = new ObjectInfo(obj, new CoordinateSystem(), "External Object");
        UndoRecord undo = new UndoRecord(this, false);
        int[] sel = this.theScene.getSelection();
        this.addObject(info, undo);
        undo.addCommand(16, new Object[]{sel});
        this.setUndoRecord(undo);
        this.setSelection(this.theScene.getNumObjects() - 1);
        this.editObjectCommand();
    }

    void modellingToolCommand(CommandEvent ev) {
        Widget item = ev.getWidget();
        for (int i = 0; i < this.toolsMenuItem.length; ++i) {
            if (this.toolsMenuItem[i] != item) continue;
            this.modellingTools[i].commandSelected(this);
        }
    }

    public void saveCommand() {
        if (this.theScene.getName() == null) {
            this.saveAsCommand();
        } else {
            this.modified = !ModellingApp.saveScene(this.theScene, this);
        }
    }

    public void saveAsCommand() {
        File file;
        BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text("saveScene"));
        if (this.theScene.getName() == null) {
            fc.setSelectedFile(new File("Untitled.aoi"));
        } else {
            fc.setSelectedFile(new File(this.theScene.getName()));
        }
        if (this.theScene.getDirectory() != null) {
            fc.setDirectory(new File(this.theScene.getDirectory()));
        } else if (ModellingApp.currentDirectory != null) {
            fc.setDirectory(new File(ModellingApp.currentDirectory));
        }
        if (!fc.showDialog(this)) {
            return;
        }
        String name = fc.getSelectedFile().getName();
        if (!name.toLowerCase().endsWith(".aoi")) {
            name = name + ".aoi";
        }
        if ((file = new File(fc.getDirectory(), name)).isFile()) {
            String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
            int choice = new BStandardDialog("", Translate.text("overwriteFile", name), BStandardDialog.QUESTION).showOptionDialog(this, options, options[1]);
            if (choice == 1) {
                return;
            }
        }
        this.theScene.setName(name);
        this.theScene.setDirectory(fc.getDirectory().getAbsolutePath());
        this.setTitle(name);
        this.modified = !ModellingApp.saveScene(this.theScene, this);
    }

    public void undoCommand() {
        this.undoStack.executeUndo();
        this.rebuildItemList();
        this.updateImage();
        this.updateMenus();
    }

    public void redoCommand() {
        this.undoStack.executeRedo();
        this.rebuildItemList();
        this.updateImage();
        this.updateMenus();
    }

    public void cutCommand() {
        this.copyCommand();
        this.clearCommand();
    }

    public void copyCommand() {
        int[] sel = this.theScene.getSelectionWithChildren();
        if (sel.length == 0) {
            return;
        }
        ObjectInfo[] copy = new ObjectInfo[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            copy[i] = this.theScene.getObject(sel[i]);
        }
        copy = ObjectInfo.duplicateAll(copy);
        ModellingApp.copyToClipboard(copy, this.theScene);
        this.updateMenus();
    }

    public void pasteCommand() {
        int[] which = new int[ModellingApp.getClipboardSize()];
        int num = this.theScene.getNumObjects();
        for (int i = 0; i < which.length; ++i) {
            which[i] = num + i;
        }
        ModellingApp.pasteClipboard(this);
        this.setSelection(which);
        this.rebuildItemList();
        this.updateImage();
    }

    public void clearCommand() {
        boolean any;
        ObjectInfo info;
        int i;
        Object[] sel = this.itemTree.getSelectedObjects();
        int[] selIndex = this.theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        this.theScene.clearSelection();
        UndoRecord undo = new UndoRecord(this, false);
        for (i = sel.length - 1; i >= 0; --i) {
            info = (ObjectInfo)sel[i];
            int index = this.theScene.indexOf(info);
            this.removeObject(index, undo);
        }
        do {
            any = false;
            for (i = 0; i < this.theScene.getNumObjects(); ++i) {
                info = this.theScene.getObject(i);
                if (info.parent == null || this.theScene.indexOf(info.parent) != -1) continue;
                this.removeObject(i, undo);
                --i;
                any = true;
            }
        } while (any);
        undo.addCommand(16, new Object[]{selIndex});
        this.setUndoRecord(undo);
        this.updateMenus();
        this.updateImage();
    }

    public void selectAllCommand() {
        int[] which = new int[this.theScene.getNumObjects()];
        for (int i = 0; i < which.length; ++i) {
            which[i] = i;
        }
        this.setUndoRecord(new UndoRecord(this, false, 16, new Object[]{this.theScene.getSelection()}));
        this.setSelection(which);
        this.updateImage();
    }

    public void duplicateCommand() {
        Object[] sel = this.itemTree.getSelectedObjects();
        int[] which = new int[sel.length];
        int num = this.theScene.getNumObjects();
        UndoRecord undo = new UndoRecord(this, false);
        int[] selected = this.theScene.getSelection();
        for (int i = 0; i < sel.length; ++i) {
            this.addObject(((ObjectInfo)sel[i]).duplicate(), undo);
            which[i] = num + i;
        }
        undo.addCommand(16, new Object[]{selected});
        this.setSelection(which);
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void severCommand() {
        Object[] sel = this.itemTree.getSelectedObjects();
        UndoRecord undo = new UndoRecord(this, false);
        for (int i = 0; i < sel.length; ++i) {
            ObjectInfo info = (ObjectInfo)sel[i];
            undo.addCommand(2, new Object[]{info, info.duplicate()});
            info.object = info.object.duplicate();
        }
        this.setUndoRecord(undo);
    }

    public void editObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        final Object3D obj = this.theScene.getObject((int)sel[0]).object;
        if (obj.isEditable()) {
            final UndoRecord undo = new UndoRecord(this, false, 0, new Object[]{obj, obj.duplicate()});
            obj.edit(this, this.theScene.getObject(sel[0]), new Runnable(){

                public void run() {
                    LayoutWindow.this.setUndoRecord(undo);
                    LayoutWindow.this.theScene.objectModified(obj);
                    LayoutWindow.this.updateImage();
                    LayoutWindow.this.updateMenus();
                }
            });
        }
    }

    public void objectLayoutCommand() {
        int i;
        int[] sel = this.theScene.getSelection();
        ObjectInfo[] obj = new ObjectInfo[sel.length];
        if (sel.length == 0) {
            return;
        }
        UndoRecord undo = new UndoRecord(this, false);
        for (i = 0; i < sel.length; ++i) {
            obj[i] = this.theScene.getObject(sel[i]);
            undo.addCommand(0, new Object[]{obj[i].object, obj[i].object.duplicate()});
            undo.addCommand(1, new Object[]{obj[i].coords, obj[i].coords.duplicate()});
        }
        if (sel.length == 1) {
            Vec3 orig = obj[0].coords.getOrigin();
            double[] angles = obj[0].coords.getRotationAngles();
            Vec3 size = obj[0].object.getBounds().getSize();
            TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitle", this.theScene.getObject((int)sel[0]).name), new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
            if (!dlg.clickedOk()) {
                return;
            }
            double[] values = dlg.getValues();
            if (!Double.isNaN(values[0])) {
                orig.x = values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y = values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z = values[2];
            }
            if (!Double.isNaN(values[3])) {
                angles[0] = values[3];
            }
            if (!Double.isNaN(values[4])) {
                angles[1] = values[4];
            }
            if (!Double.isNaN(values[5])) {
                angles[2] = values[5];
            }
            if (!Double.isNaN(values[6])) {
                size.x = values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y = values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z = values[8];
            }
            obj[0].coords.setOrigin(orig);
            obj[0].coords.setOrientation(angles[0], angles[1], angles[2]);
            obj[0].object.setSize(size.x, size.y, size.z);
            this.theScene.objectModified(obj[0].object);
            obj[0].object.sceneChanged(obj[0], this.theScene);
        } else {
            TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitleMultiple"), false, false);
            if (!dlg.clickedOk()) {
                return;
            }
            double[] values = dlg.getValues();
            for (i = 0; i < sel.length; ++i) {
                Vec3 orig = obj[i].coords.getOrigin();
                double[] angles = obj[i].coords.getRotationAngles();
                Vec3 size = obj[i].object.getBounds().getSize();
                if (!Double.isNaN(values[0])) {
                    orig.x = values[0];
                }
                if (!Double.isNaN(values[1])) {
                    orig.y = values[1];
                }
                if (!Double.isNaN(values[2])) {
                    orig.z = values[2];
                }
                if (!Double.isNaN(values[3])) {
                    angles[0] = values[3];
                }
                if (!Double.isNaN(values[4])) {
                    angles[1] = values[4];
                }
                if (!Double.isNaN(values[5])) {
                    angles[2] = values[5];
                }
                if (!Double.isNaN(values[6])) {
                    size.x = values[6];
                }
                if (!Double.isNaN(values[7])) {
                    size.y = values[7];
                }
                if (!Double.isNaN(values[8])) {
                    size.z = values[8];
                }
                obj[i].coords.setOrigin(orig);
                obj[i].coords.setOrientation(angles[0], angles[1], angles[2]);
                obj[i].object.setSize(size.x, size.y, size.z);
            }
            for (i = 0; i < sel.length; ++i) {
                this.theScene.objectModified(obj[i].object);
                obj[i].object.sceneChanged(obj[i], this.theScene);
            }
        }
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void transformObjectCommand() {
        ObjectInfo info;
        int i;
        int[] sel = this.theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        TransformDialog dlg = sel.length == 1 ? new TransformDialog(this, Translate.text("transformObjectTitle", this.theScene.getObject((int)sel[0]).name), new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true) : new TransformDialog(this, Translate.text("transformObjectTitleMultiple"), new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true);
        if (!dlg.clickedOk()) {
            return;
        }
        double[] values = dlg.getValues();
        BoundingBox bounds = null;
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            bounds = bounds == null ? info.getBounds().transformAndOutset(info.coords.fromLocal()) : bounds.merge(info.getBounds().transformAndOutset(info.coords.fromLocal()));
        }
        Vec3 center = bounds.getCenter();
        if (dlg.applyToChildren()) {
            sel = this.theScene.getSelectionWithChildren();
        }
        Mat4 m = Mat4.identity();
        if (!Double.isNaN(values[3])) {
            m = m.times(Mat4.xrotation(values[3] * Math.PI / 180.0));
        }
        if (!Double.isNaN(values[4])) {
            m = m.times(Mat4.yrotation(values[4] * Math.PI / 180.0));
        }
        if (!Double.isNaN(values[5])) {
            m = m.times(Mat4.zrotation(values[5] * Math.PI / 180.0));
        }
        UndoRecord undo = new UndoRecord(this, false);
        HashSet<Object3D> scaledObjects = new HashSet<Object3D>();
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            Object3D obj = info.object;
            CoordinateSystem coords = info.coords;
            if (!scaledObjects.contains(obj)) {
                undo.addCommand(0, new Object[]{obj, obj.duplicate()});
            }
            undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            Vec3 orig = coords.getOrigin();
            Vec3 size = obj.getBounds().getSize();
            if (!Double.isNaN(values[0])) {
                orig.x += values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y += values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z += values[2];
            }
            if (!Double.isNaN(values[6])) {
                size.x *= values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y *= values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z *= values[8];
            }
            if (dlg.useSelectionCenter()) {
                Vec3 neworig = orig.minus(center);
                if (!Double.isNaN(values[6])) {
                    neworig.x *= values[6];
                }
                if (!Double.isNaN(values[7])) {
                    neworig.y *= values[7];
                }
                if (!Double.isNaN(values[8])) {
                    neworig.z *= values[8];
                }
                coords.setOrigin(neworig);
                coords.transformCoordinates(m);
                coords.setOrigin(coords.getOrigin().plus(center));
            } else {
                coords.setOrigin(orig);
                coords.transformAxes(m);
            }
            if (scaledObjects.contains(obj)) continue;
            obj.setSize(size.x, size.y, size.z);
            scaledObjects.add(obj);
        }
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            this.theScene.objectModified(info.object);
            info.object.sceneChanged(info, this.theScene);
        }
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void alignObjectsCommand() {
        Vec3 orig;
        Vec3 center;
        BoundingBox bounds;
        CoordinateSystem coords;
        ObjectInfo info;
        int i;
        int[] sel = this.theScene.getSelection();
        RowContainer px = new RowContainer();
        RowContainer py = new RowContainer();
        RowContainer pz = new RowContainer();
        if (sel.length == 0) {
            return;
        }
        BComboBox xchoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Right"), Translate.text("Center"), Translate.text("Left"), Translate.text("Origin")});
        px.add(xchoice);
        px.add(Translate.label("alignTo"));
        ValueField vfx = new ValueField(Double.NaN, 0, 5);
        px.add(vfx);
        BComboBox ychoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Top"), Translate.text("Center"), Translate.text("Bottom"), Translate.text("Origin")});
        py.add(ychoice);
        py.add(Translate.label("alignTo"));
        ValueField vfy = new ValueField(Double.NaN, 0, 5);
        py.add(vfy);
        BComboBox zchoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Front"), Translate.text("Center"), Translate.text("Back"), Translate.text("Origin")});
        pz.add(zchoice);
        pz.add(Translate.label("alignTo"));
        ValueField vfz = new ValueField(Double.NaN, 0, 5);
        pz.add(vfz);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("alignObjectsTitle"), new Widget[]{px, py, pz}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        UndoRecord undo = new UndoRecord(this, false);
        Vec3 alignTo = new Vec3();
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            coords = info.coords;
            bounds = info.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            if (!Double.isNaN(vfx.getValue())) {
                alignTo.x += vfx.getValue();
            } else if (xchoice.getSelectedIndex() == 1) {
                alignTo.x += bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                alignTo.x += center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                alignTo.x += bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                alignTo.x += orig.x;
            }
            if (!Double.isNaN(vfy.getValue())) {
                alignTo.y += vfy.getValue();
            } else if (ychoice.getSelectedIndex() == 1) {
                alignTo.y += bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                alignTo.y += center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                alignTo.y += bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                alignTo.y += orig.y;
            }
            if (!Double.isNaN(vfz.getValue())) {
                alignTo.z += vfz.getValue();
                continue;
            }
            if (zchoice.getSelectedIndex() == 1) {
                alignTo.z += bounds.maxz;
                continue;
            }
            if (zchoice.getSelectedIndex() == 2) {
                alignTo.z += center.z;
                continue;
            }
            if (zchoice.getSelectedIndex() == 3) {
                alignTo.z += bounds.minz;
                continue;
            }
            if (zchoice.getSelectedIndex() != 4) continue;
            alignTo.z += orig.z;
        }
        alignTo.scale(1.0 / (double)sel.length);
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            coords = info.coords;
            bounds = info.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            if (xchoice.getSelectedIndex() == 1) {
                orig.x += alignTo.x - bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                orig.x += alignTo.x - center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                orig.x += alignTo.x - bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                orig.x += alignTo.x - orig.x;
            }
            if (ychoice.getSelectedIndex() == 1) {
                orig.y += alignTo.y - bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                orig.y += alignTo.y - center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                orig.y += alignTo.y - bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                orig.y += alignTo.y - orig.y;
            }
            if (zchoice.getSelectedIndex() == 1) {
                orig.z += alignTo.z - bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                orig.z += alignTo.z - center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                orig.z += alignTo.z - bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                orig.z += alignTo.z - orig.z;
            }
            coords.setOrigin(orig);
        }
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            info.object.sceneChanged(info, this.theScene);
        }
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void setTextureCommand() {
        int i;
        int[] sel = this.theScene.getSelection();
        int count = 0;
        for (i = 0; i < sel.length; ++i) {
            if (!this.theScene.getObject((int)sel[i]).object.canSetTexture()) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        ObjectInfo[] obj = new ObjectInfo[count];
        for (i = 0; i < sel.length; ++i) {
            if (!this.theScene.getObject((int)sel[i]).object.canSetTexture()) continue;
            obj[i] = this.theScene.getObject(sel[i]);
        }
        new ObjectTextureDialog(this, obj);
        for (i = 0; i < sel.length; ++i) {
            this.theScene.objectModified(this.theScene.getObject((int)sel[i]).object);
        }
        this.modified = true;
        this.updateImage();
    }

    public void setMaterialCommand() {
        ObjectInfo info;
        int i;
        int[] sel = this.theScene.getSelection();
        int count = 0;
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            if (!info.object.canSetMaterial()) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        ObjectInfo[] obj = new ObjectInfo[count];
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            if (!info.object.canSetMaterial()) continue;
            obj[i] = info;
        }
        new ObjectMaterialDialog(this, obj);
        this.modified = true;
        this.updateImage();
    }

    public void renameObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        BStandardDialog dlg = new BStandardDialog("", Translate.text("renameObjectTitle"), BStandardDialog.PLAIN);
        String val = dlg.showInputDialog(this, null, info.name);
        if (val == null) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 6, new Object[]{new Integer(sel[0]), info.name}));
        this.setObjectName(sel[0], val);
    }

    public void convertToTriangleCommand() {
        Object3D mesh;
        String[] options;
        BStandardDialog dlg;
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        Object3D obj = info.object;
        if (obj.canConvertToTriangleMesh() == 0) {
            return;
        }
        boolean confirmed = false;
        boolean hasPose = false;
        for (int i = 0; i < info.tracks.length; ++i) {
            if (!(info.tracks[i] instanceof PoseTrack)) continue;
            hasPose = true;
            if (!confirmed && !info.tracks[i].isNullTrack()) {
                dlg = new BStandardDialog("", Translate.text("convertLosesPosesWarning", info.name), BStandardDialog.QUESTION);
                if (dlg.showOptionDialog(this, options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")}, options[0]) == 1) {
                    return;
                }
                confirmed = true;
            }
            if (info.tracks[i].getTimecourse() != null) {
                info.tracks[i].getTimecourse().removeAllTimepoints();
            }
            info.pose = null;
        }
        if (confirmed) {
            this.theScore.repaintAll();
        }
        UndoRecord undo = new UndoRecord(this, false, 2, new Object[]{info, info.duplicate()});
        if (obj.canConvertToTriangleMesh() == 1) {
            if (!confirmed && (dlg = new BStandardDialog("", Translate.text("confirmConvertToTriangle", info.name), BStandardDialog.QUESTION)).showOptionDialog(this, options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")}, options[0]) == 1) {
                return;
            }
            mesh = obj.convertToTriangleMesh(0.0);
        } else {
            ValueField errorField = new ValueField(0.1, 3);
            ComponentsDialog dlg2 = new ComponentsDialog(this, Translate.text("selectToleranceForMesh"), new Widget[]{errorField}, new String[]{Translate.text("maxError")});
            if (!dlg2.clickedOk()) {
                return;
            }
            mesh = obj.convertToTriangleMesh(errorField.getValue());
        }
        if (mesh == null) {
            new BStandardDialog("", Translate.text("cannotTriangulate"), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        if (hasPose) {
            mesh = mesh.getPosableObject();
        }
        if (mesh.getTexture() == null) {
            Texture tex = this.theScene.getDefaultTexture();
            mesh.setTexture(tex, tex.getDefaultMapping(mesh));
        }
        this.theScene.replaceObject(obj, mesh, undo);
        this.setUndoRecord(undo);
        this.updateImage();
        this.updateMenus();
    }

    public void convertToActorCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        Object3D obj = info.object;
        Object3D posable = obj.getPosableObject();
        if (posable == null) {
            return;
        }
        BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("confirmConvertToActor", info.name)), BStandardDialog.QUESTION);
        String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
        if (dlg.showOptionDialog(this, options, options[0]) == 1) {
            return;
        }
        UndoRecord undo = new UndoRecord(this, false, 2, new Object[]{info, info.duplicate()});
        this.theScene.replaceObject(obj, posable, undo);
        this.setUndoRecord(undo);
        this.updateImage();
        this.updateMenus();
    }

    void setObjectVisibility(boolean visible, boolean selectionOnly) {
        UndoRecord undo = new UndoRecord(this, false);
        if (selectionOnly) {
            int[] sel = this.theScene.getSelection();
            for (int i = 0; i < sel.length; ++i) {
                ObjectInfo info = this.theScene.getObject(sel[i]);
                undo.addCommand(2, new Object[]{info, info.duplicate()});
                info.visible = visible;
            }
        } else {
            for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
                ObjectInfo info = this.theScene.getObject(i);
                undo.addCommand(2, new Object[]{info, info.duplicate()});
                info.visible = visible;
            }
        }
        this.setUndoRecord(undo);
        this.updateImage();
        this.itemTree.repaint();
    }

    void createObjectCommand(CommandEvent ev) {
        String name;
        Object3D obj;
        String type = ev.getActionCommand();
        if ("cube".equals(type)) {
            obj = new Cube(1.0, 1.0, 1.0);
            name = "Cube " + CreateCubeTool.counter++;
        } else if ("sphere".equals(type)) {
            obj = new Sphere(0.5, 0.5, 0.5);
            name = "Sphere " + CreateSphereTool.counter++;
        } else if ("cylinder".equals(type)) {
            obj = new Cylinder(1.0, 0.5, 0.5, 1.0);
            name = "Cylinder " + CreateCylinderTool.counter++;
        } else if ("cone".equals(type)) {
            obj = new Cylinder(1.0, 0.5, 0.5, 0.0);
            name = "Cone " + CreateCylinderTool.counter++;
        } else if ("pointLight".equals(type)) {
            obj = new PointLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f, 0.1);
            name = "Light " + CreateLightTool.counter++;
        } else if ("directionalLight".equals(type)) {
            obj = new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f);
            name = "Light " + CreateLightTool.counter++;
        } else if ("spotLight".equals(type)) {
            obj = new SpotLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f, 20.0, 0.0, 0.1);
            name = "Light " + CreateLightTool.counter++;
        } else if ("camera".equals(type)) {
            obj = new SceneCamera();
            name = "Camera " + CreateCameraTool.counter++;
        } else if ("referenceImage".equals(type)) {
            ImageFileChooser fc = new ImageFileChooser(Translate.text("selectReferenceImage"));
            if (!fc.showDialog(this)) {
                return;
            }
            File f = fc.getSelectedFile();
            Image image = new ImageIcon(f.getAbsolutePath()).getImage();
            if (image == null || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
                new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingImage", f.getName())), BStandardDialog.ERROR).showMessageDialog(this);
                return;
            }
            obj = new ReferenceImage(image);
            name = f.getName();
            if (name.lastIndexOf(46) > -1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
        } else {
            obj = new NullObject();
            name = "Null";
        }
        CoordinateSystem coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        ObjectInfo info = new ObjectInfo(obj, coords, name);
        if (obj.canSetTexture()) {
            info.setTexture(this.theScene.getDefaultTexture(), this.theScene.getDefaultTexture().getDefaultMapping(obj));
        }
        Vec3 orig = coords.getOrigin();
        double[] angles = coords.getRotationAngles();
        Vec3 size = info.getBounds().getSize();
        TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitle", name), new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
        if (!dlg.clickedOk()) {
            return;
        }
        double[] values = dlg.getValues();
        if (!Double.isNaN(values[0])) {
            orig.x = values[0];
        }
        if (!Double.isNaN(values[1])) {
            orig.y = values[1];
        }
        if (!Double.isNaN(values[2])) {
            orig.z = values[2];
        }
        if (!Double.isNaN(values[3])) {
            angles[0] = values[3];
        }
        if (!Double.isNaN(values[4])) {
            angles[1] = values[4];
        }
        if (!Double.isNaN(values[5])) {
            angles[2] = values[5];
        }
        if (!Double.isNaN(values[6])) {
            size.x = values[6];
        }
        if (!Double.isNaN(values[7])) {
            size.y = values[7];
        }
        if (!Double.isNaN(values[8])) {
            size.z = values[8];
        }
        coords.setOrigin(orig);
        coords.setOrientation(angles[0], angles[1], angles[2]);
        obj.setSize(size.x, size.y, size.z);
        info.clearCachedMeshes();
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this, false);
        int[] sel = this.theScene.getSelection();
        this.addObject(info, undo);
        undo.addCommand(16, new Object[]{sel});
        this.setSelection(this.theScene.getNumObjects() - 1);
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void createScriptObjectCommand() {
        ComponentsDialog dlg;
        BTextField nameField = new BTextField(Translate.text("Script"));
        BComboBox scriptChoice = new BComboBox();
        scriptChoice.add(Translate.text("newScript"));
        String[] files = new File(ModellingApp.OBJECT_SCRIPT_DIRECTORY).list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".bsh") || files[i].length() <= 4) continue;
                scriptChoice.add(files[i].substring(0, files[i].length() - 4));
            }
        }
        if (!(dlg = new ComponentsDialog(this, Translate.text("newScriptedObject"), new Widget[]{nameField, scriptChoice}, new String[]{Translate.text("Name"), Translate.text("Script")})).clickedOk()) {
            return;
        }
        String scriptText = "";
        if (scriptChoice.getSelectedIndex() > 0) {
            try {
                String scriptName = scriptChoice.getSelectedValue() + ".bsh";
                File f = new File(ModellingApp.OBJECT_SCRIPT_DIRECTORY, scriptName);
                scriptText = ModellingApp.loadFile(f);
            }
            catch (IOException ex) {
                new BStandardDialog("", new String[]{Translate.text("errorReadingScript"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
                return;
            }
        }
        ScriptedObject obj = new ScriptedObject("");
        ObjectInfo info = new ObjectInfo(obj, new CoordinateSystem(), nameField.getText());
        UndoRecord undo = new UndoRecord(this, false);
        int[] sel = this.theScene.getSelection();
        this.addObject(info, undo);
        undo.addCommand(16, new Object[]{sel});
        this.setSelection(this.theScene.getNumObjects() - 1);
        this.setUndoRecord(undo);
        this.updateImage();
        obj.setScript(scriptText);
        this.editObjectCommand();
    }

    public void jumpToTimeCommand() {
        ValueField timeField = new ValueField(this.theScene.getTime(), 0);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("jumpToTimeTitle"), new Widget[]{timeField}, new String[]{Translate.text("Time")});
        if (!dlg.clickedOk()) {
            return;
        }
        double t = timeField.getValue();
        double fps = this.theScene.getFramesPerSecond();
        t = (double)Math.round(t * fps) / fps;
        this.setTime(t);
    }

    public void bindToParentCommand() {
        BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("confirmBindParent")), BStandardDialog.QUESTION);
        String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
        if (dlg.showOptionDialog(this, options, options[0]) == 1) {
            return;
        }
        int[] sel = this.theScene.getSelection();
        UndoRecord undo = new UndoRecord(this, false);
        for (int i = 0; i < sel.length; ++i) {
            ObjectInfo info = this.theScene.getObject(sel[i]);
            if (info.parent == null) continue;
            Skeleton s = info.parent.getSkeleton();
            ObjectRef relObj = new ObjectRef(info.parent);
            if (s != null) {
                double nearest = Double.MAX_VALUE;
                Joint[] jt = s.getJoints();
                Vec3 pos = info.coords.getOrigin();
                for (int j = 0; j < jt.length; ++j) {
                    ObjectRef r = new ObjectRef(info.parent, jt[j]);
                    double dist = r.getCoords().getOrigin().distance2(pos);
                    if (!(dist < nearest)) continue;
                    relObj = r;
                    nearest = dist;
                }
            }
            undo.addCommand(2, new Object[]{info, info.duplicate()});
            PositionTrack pt = new PositionTrack(info);
            pt.setCoordsObject(relObj);
            info.addTrack(pt, 0);
            pt.setKeyframe(this.theScene.getTime(), this.theScene);
            RotationTrack rt = new RotationTrack(info);
            rt.setCoordsObject(relObj);
            info.addTrack(rt, 1);
            rt.setKeyframe(this.theScene.getTime(), this.theScene);
        }
        this.setUndoRecord(undo);
        this.theScore.rebuildList();
        this.theScore.repaint();
    }

    public void renderCommand() {
        new RenderSetupDialog(this, this.theScene);
    }

    public void toggleViewsCommand() {
        if (this.numViewsShown == 4) {
            this.numViewsShown = 1;
            this.viewsContainer.setColumnWeight(0, this.currentView == 0 || this.currentView == 2 ? 1.0 : 0.0);
            this.viewsContainer.setColumnWeight(1, this.currentView == 1 || this.currentView == 3 ? 1.0 : 0.0);
            this.viewsContainer.setRowWeight(0, this.currentView == 0 || this.currentView == 1 ? 1.0 : 0.0);
            this.viewsContainer.setRowWeight(1, this.currentView == 2 || this.currentView == 3 ? 1.0 : 0.0);
            this.sceneMenuItem[0].setText(Translate.text("menu.fourViews"));
        } else {
            this.numViewsShown = 4;
            this.viewsContainer.setColumnWeight(0, 1.0);
            this.viewsContainer.setColumnWeight(1, 1.0);
            this.viewsContainer.setRowWeight(0, 1.0);
            this.viewsContainer.setRowWeight(1, 1.0);
            this.sceneMenuItem[0].setText(Translate.text("menu.oneView"));
        }
        this.viewsContainer.layoutChildren();
        this.updateImage();
        this.viewPanel[this.currentView].requestFocus();
    }

    public void setTemplateCommand() {
        ImageFileChooser fc = new ImageFileChooser(Translate.text("selectTemplateImage"));
        if (!fc.showDialog(this)) {
            return;
        }
        File f = fc.getSelectedFile();
        try {
            this.theView[this.currentView].setTemplateImage(f);
        }
        catch (InterruptedException ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingImage", f.getName())), BStandardDialog.ERROR).showMessageDialog(this);
        }
        this.theView[this.currentView].setShowTemplate(true);
        this.updateImage();
        this.updateMenus();
    }

    public void setGridCommand() {
        ValueField spaceField = new ValueField(this.theScene.getGridSpacing(), 3);
        ValueField divField = new ValueField(this.theScene.getGridSubdivisions(), 7);
        BCheckBox showBox = new BCheckBox(Translate.text("showGrid"), this.theScene.getShowGrid());
        BCheckBox snapBox = new BCheckBox(Translate.text("snapToGrid"), this.theScene.getSnapToGrid());
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("gridTitle"), new Widget[]{spaceField, divField, showBox, snapBox}, new String[]{Translate.text("gridSpacing"), Translate.text("snapToSubdivisions"), null, null});
        if (!dlg.clickedOk()) {
            return;
        }
        this.theScene.setGridSpacing(spaceField.getValue());
        this.theScene.setGridSubdivisions((int)divField.getValue());
        this.theScene.setShowGrid(showBox.getState());
        this.theScene.setSnapToGrid(snapBox.getState());
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setGrid(this.theScene.getGridSpacing(), this.theScene.getGridSubdivisions(), this.theScene.getShowGrid(), this.theScene.getSnapToGrid());
        }
        this.updateImage();
    }

    public void frameWithCameraCommand(boolean selectionOnly) {
        BoundingBox bounds;
        ObjectInfo info;
        int i;
        int[] sel = this.theScene.getSelectionWithChildren();
        BoundingBox bb = null;
        if (selectionOnly) {
            for (i = 0; i < sel.length; ++i) {
                info = this.theScene.getObject(sel[i]);
                bounds = info.getBounds().transformAndOutset(info.coords.fromLocal());
                bb = bb == null ? bounds : bb.merge(bounds);
            }
        } else {
            for (i = 0; i < this.theScene.getNumObjects(); ++i) {
                info = this.theScene.getObject(i);
                bounds = info.getBounds().transformAndOutset(info.coords.fromLocal());
                bb = bb == null ? bounds : bb.merge(bounds);
            }
        }
        if (bb == null) {
            return;
        }
        if (this.numViewsShown == 1) {
            this.theView[this.currentView].frameBox(bb);
        } else {
            for (i = 0; i < this.theView.length; ++i) {
                this.theView[i].frameBox(bb);
            }
        }
        this.updateImage();
    }

    public void texturesCommand() {
        this.theScene.showTexturesDialog(this);
    }

    public void materialsCommand() {
        this.theScene.showMaterialsDialog(this);
    }

    public void environmentCommand() {
        final RGBColor ambColor = this.theScene.getAmbientColor();
        final RGBColor envColor = this.theScene.getEnvironmentColor();
        final RGBColor fogColor = this.theScene.getFogColor();
        final RGBColor oldAmbColor = ambColor.duplicate();
        final RGBColor oldEnvColor = envColor.duplicate();
        final RGBColor oldFogColor = fogColor.duplicate();
        final Widget ambPatch = ambColor.getSample(50, 30);
        final Widget envPatch = envColor.getSample(50, 30);
        final Widget fogPatch = fogColor.getSample(50, 30);
        final BCheckBox fogBox = new BCheckBox("Environment Fog", this.theScene.getFogState());
        final ValueField fogField = new ValueField(this.theScene.getFogDistance(), 3);
        final OverlayContainer envPanel = new OverlayContainer();
        BButton envButton = new BButton(Translate.text("Choose") + ":");
        final BLabel envLabel = new BLabel();
        final Sphere envSphere = new Sphere(1.0, 1.0, 1.0);
        final ObjectInfo envInfo = new ObjectInfo(envSphere, new CoordinateSystem(), "Environment");
        final BComboBox envChoice = new BComboBox(new String[]{Translate.text("solidColor"), Translate.text("textureDiffuse"), Translate.text("textureEmissive")});
        envChoice.setSelectedIndex(this.theScene.getEnvironmentMode());
        RowContainer row = new RowContainer();
        row.add(envButton);
        row.add(envLabel);
        envPanel.add(envPatch, 0);
        envPanel.add(row, 1);
        if (this.theScene.getEnvironmentMode() == 0) {
            envPanel.setVisibleChild(0);
        } else {
            envPanel.setVisibleChild(1);
        }
        envInfo.setTexture(this.theScene.getEnvironmentTexture(), this.theScene.getEnvironmentMapping());
        envSphere.setParameterValues(this.theScene.getEnvironmentParameterValues());
        envLabel.setText(envSphere.getTexture().getName());
        envChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                if (envChoice.getSelectedIndex() == 0) {
                    envPanel.setVisibleChild(0);
                } else {
                    envPanel.setVisibleChild(1);
                }
                envPanel.getParent().layoutChildren();
            }
        });
        final Runnable envTextureCallback = new Runnable(){

            public void run() {
                envLabel.setText(envSphere.getTexture().getName());
                envPanel.getParent().layoutChildren();
            }
        };
        envButton.addEventLink(CommandEvent.class, new Object(){

            void processEvent() {
                envPanel.getParent().setCursor(Cursor.getPredefinedCursor(3));
                ObjectTextureDialog otd = new ObjectTextureDialog(LayoutWindow.this, new ObjectInfo[]{envInfo});
                otd.setCallback(envTextureCallback);
                envPanel.getParent().setCursor(Cursor.getDefaultCursor());
            }
        });
        ambPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(LayoutWindow.this, Translate.text("ambientColor"), ambColor);
                ambPatch.setBackground(ambColor.getColor());
                ambPatch.repaint();
            }
        });
        envPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(LayoutWindow.this, Translate.text("environmentColor"), envColor);
                envPatch.setBackground(envColor.getColor());
                envPatch.repaint();
            }
        });
        fogPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(LayoutWindow.this, Translate.text("fogColor"), fogColor);
                fogPatch.setBackground(fogColor.getColor());
                fogPatch.repaint();
            }
        });
        Runnable okCallback = new Runnable(){

            public void run() {
                LayoutWindow.this.theScene.setFog(fogBox.getState(), fogField.getValue());
                LayoutWindow.this.theScene.setEnvironmentMode(envChoice.getSelectedIndex());
                LayoutWindow.this.theScene.setEnvironmentTexture(envSphere.getTexture());
                LayoutWindow.this.theScene.setEnvironmentMapping(envSphere.getTextureMapping());
                LayoutWindow.this.theScene.setEnvironmentParameterValues(envSphere.getParameterValues());
                LayoutWindow.this.setModified();
            }
        };
        Runnable cancelCallback = new Runnable(){

            public void run() {
                ambColor.copy(oldAmbColor);
                envColor.copy(oldEnvColor);
                fogColor.copy(oldFogColor);
            }
        };
        new ComponentsDialog(this, Translate.text("environmentTitle"), new Widget[]{ambPatch, envChoice, envPanel, fogBox, fogPatch, fogField}, new String[]{Translate.text("ambientColor"), Translate.text("environment"), "", "", Translate.text("fogColor"), Translate.text("fogDistance")}, okCallback, cancelCallback);
    }

    private void executeScriptCommand(CommandEvent ev) {
        this.executeScript(new File(ev.getActionCommand()));
    }

    public void executeScript(File f) {
        String scriptText = null;
        try {
            scriptText = ModellingApp.loadFile(f);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorReadingScript"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        try {
            ToolScript script = ScriptRunner.parseToolScript(scriptText);
            script.execute(this);
        }
        catch (Exception e) {
            ScriptRunner.displayError(e, 1);
        }
        this.updateImage();
        this.dispatchSceneChangedEvent();
    }
}

