/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ApplicationPreferences;
import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.Plugin;
import artofillusion.PluginRegistry;
import artofillusion.RecentFiles;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.TitleWindow;
import artofillusion.Translator;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.image.ImageMap;
import artofillusion.image.filter.BlurFilter;
import artofillusion.image.filter.BrightnessFilter;
import artofillusion.image.filter.ExposureFilter;
import artofillusion.image.filter.GlowFilter;
import artofillusion.image.filter.ImageFilter;
import artofillusion.image.filter.OutlineFilter;
import artofillusion.image.filter.SaturationFilter;
import artofillusion.image.filter.TintFilter;
import artofillusion.keystroke.KeystrokeManager;
import artofillusion.material.LinearMaterialMapping;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.material.ProceduralMaterial3D;
import artofillusion.material.UniformMaterial;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.procedural.Module;
import artofillusion.script.ScriptRunner;
import artofillusion.texture.CylindricalMapping;
import artofillusion.texture.ImageMapTexture;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.LinearMapping3D;
import artofillusion.texture.ProceduralTexture2D;
import artofillusion.texture.ProceduralTexture3D;
import artofillusion.texture.ProjectionMapping;
import artofillusion.texture.SphericalMapping;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UVMapping;
import artofillusion.texture.UniformMapping;
import artofillusion.texture.UniformTexture;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.view.ViewerOrientationControl;
import artofillusion.view.ViewerPerspectiveControl;
import artofillusion.view.ViewerScaleControl;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextArea;
import buoy.xml.IconResource;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class ModellingApp {
    public static final String MAJOR_VERSION = "2.5";
    public static final String VERSION = "2.5.1";
    public static final double DIST_TO_SCREEN = 20.0;
    public static final String APP_DIRECTORY;
    public static final String PLUGIN_DIRECTORY;
    public static final String TOOL_SCRIPT_DIRECTORY;
    public static final String OBJECT_SCRIPT_DIRECTORY;
    public static final String STARTUP_SCRIPT_DIRECTORY;
    public static final ImageIcon APP_ICON;
    public static Font defaultFont;
    public static String currentDirectory;
    public static int standardDialogInsets;
    private static ApplicationPreferences preferences;
    private static ObjectInfo[] clipboardObject;
    private static Texture[] clipboardTexture;
    private static Material[] clipboardMaterial;
    private static ImageMap[] clipboardImage;
    private static Vector windows;
    private static Hashtable classTranslations;
    private static int numNewWindows;

    public static void main(String[] args) {
        int i;
        Translate.setLocale(Locale.getDefault());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        try {
            Class popup = PopupFactory.class;
            Field heavyweight = popup.getDeclaredField("HEAVY_WEIGHT_POPUP");
            Method setPopupType = popup.getDeclaredMethod("setPopupType", Integer.TYPE);
            heavyweight.setAccessible(true);
            setPopupType.setAccessible(true);
            setPopupType.invoke((Object)PopupFactory.getSharedInstance(), heavyweight.get(null));
        }
        catch (Exception ex) {
            // empty catch block
        }
        TitleWindow title = new TitleWindow();
        PluginRegistry.addCategory(Plugin.class);
        PluginRegistry.addCategory(Renderer.class);
        PluginRegistry.addCategory(Translator.class);
        PluginRegistry.addCategory(ModellingTool.class);
        PluginRegistry.addCategory(Texture.class);
        PluginRegistry.addCategory(Material.class);
        PluginRegistry.addCategory(TextureMapping.class);
        PluginRegistry.addCategory(MaterialMapping.class);
        PluginRegistry.addCategory(ImageFilter.class);
        PluginRegistry.addCategory(Module.class);
        PluginRegistry.registerPlugin(new UniformTexture());
        PluginRegistry.registerPlugin(new ImageMapTexture());
        PluginRegistry.registerPlugin(new ProceduralTexture2D());
        PluginRegistry.registerPlugin(new ProceduralTexture3D());
        PluginRegistry.registerPlugin(new UniformMaterial());
        PluginRegistry.registerPlugin(new ProceduralMaterial3D());
        PluginRegistry.registerPlugin(new UniformMapping(null, null));
        PluginRegistry.registerPlugin(new ProjectionMapping(null, null));
        PluginRegistry.registerPlugin(new CylindricalMapping(null, null));
        PluginRegistry.registerPlugin(new SphericalMapping(null, null));
        PluginRegistry.registerPlugin(new UVMapping(null, null));
        PluginRegistry.registerPlugin(new LinearMapping3D(null, null));
        PluginRegistry.registerPlugin(new LinearMaterialMapping(null, null));
        PluginRegistry.registerPlugin(new BrightnessFilter());
        PluginRegistry.registerPlugin(new SaturationFilter());
        PluginRegistry.registerPlugin(new ExposureFilter());
        PluginRegistry.registerPlugin(new TintFilter());
        PluginRegistry.registerPlugin(new BlurFilter());
        PluginRegistry.registerPlugin(new GlowFilter());
        PluginRegistry.registerPlugin(new OutlineFilter());
        PluginRegistry.registerResource("TranslateBundle", "artofillusion", ModellingApp.class.getClassLoader(), "artofillusion", null);
        PluginRegistry.registerResource("UITheme", "default", ModellingApp.class.getClassLoader(), "artofillusion/Icons/defaultTheme.xml", null);
        PluginRegistry.scanPlugins();
        ThemeManager.initThemes();
        preferences = new ApplicationPreferences();
        KeystrokeManager.loadRecords();
        ViewerCanvas.addViewerControl(new ViewerOrientationControl());
        ViewerCanvas.addViewerControl(new ViewerPerspectiveControl());
        ViewerCanvas.addViewerControl(new ViewerScaleControl());
        List plugins = PluginRegistry.getPlugins(Plugin.class);
        for (i = 0; i < plugins.size(); ++i) {
            try {
                ((Plugin)plugins.get(i)).processMessage(0, new Object[0]);
                continue;
            }
            catch (Throwable tx) {
                String name = plugins.get(i).getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginInitError", name)), BStandardDialog.ERROR).showMessageDialog(null);
            }
        }
        for (i = 0; i < args.length; ++i) {
            try {
                ModellingApp.newWindow(new Scene(new File(args[i]), true));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ModellingApp.runStartupScripts();
        if (numNewWindows == 0) {
            ModellingApp.newWindow();
        }
        title.dispose();
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getMajorVersion() {
        return MAJOR_VERSION;
    }

    public static ApplicationPreferences getPreferences() {
        return preferences;
    }

    public static Renderer[] getRenderers() {
        return PluginRegistry.getPlugins(Renderer.class).toArray(new Renderer[0]);
    }

    public static Plugin[] getPlugins() {
        return PluginRegistry.getPlugins(Plugin.class).toArray(new Plugin[0]);
    }

    public static Translator[] getTranslators() {
        return PluginRegistry.getPlugins(Translator.class).toArray(new Translator[0]);
    }

    public static ModellingTool[] getModellingTools() {
        return PluginRegistry.getPlugins(ModellingTool.class).toArray(new ModellingTool[0]);
    }

    public static Class[] getTextureTypes() {
        List instances = PluginRegistry.getPlugins(Texture.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getMaterialTypes() {
        List instances = PluginRegistry.getPlugins(Material.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getTextureMappings() {
        List instances = PluginRegistry.getPlugins(TextureMapping.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getMaterialMappings() {
        List instances = PluginRegistry.getPlugins(MaterialMapping.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getImageFilters() {
        List instances = PluginRegistry.getPlugins(ImageFilter.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getModules() {
        List instances = PluginRegistry.getPlugins(Module.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static void registerRenderer(Renderer o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerTranslator(Translator o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerModellingTool(ModellingTool o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerTexture(Texture o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerMaterial(Material o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerTextureMapping(TextureMapping o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerMaterialMapping(MaterialMapping o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerPlugin(Plugin o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerImageFilter(ImageFilter o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerModule(Module o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void newWindow() {
        Scene theScene = new Scene();
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        ObjectInfo info = new ObjectInfo(new SceneCamera(), coords, "Camera 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        info = new ObjectInfo(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords.duplicate(), "Light 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        ModellingApp.newWindow(theScene);
    }

    public static void newWindow(final Scene theScene) {
        ++numNewWindows;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i;
                LayoutWindow fr = new LayoutWindow(theScene);
                windows.addElement(fr);
                List plugins = PluginRegistry.getPlugins(class$artofillusion$Plugin == null ? (class$artofillusion$Plugin = ModellingApp.class$("artofillusion.Plugin")) : class$artofillusion$Plugin);
                for (i = 0; i < plugins.size(); ++i) {
                    try {
                        ((Plugin)plugins.get(i)).processMessage(2, new Object[]{fr});
                        continue;
                    }
                    catch (Throwable tx) {
                        String name = plugins.get(i).getClass().getName();
                        name = name.substring(name.lastIndexOf(46) + 1);
                        new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginNotifyError", name)), BStandardDialog.ERROR).showMessageDialog(null);
                    }
                }
                fr.setVisible(true);
                fr.arrangeDockableWidgets();
                for (i = windows.size() - 2; i >= 0; --i) {
                    LayoutWindow win;
                    if (!(windows.elementAt(i) instanceof LayoutWindow) || (win = (LayoutWindow)windows.elementAt(i)).getScene().getName() != null || win.isModified()) continue;
                    ModellingApp.closeWindow(win);
                }
            }
        });
    }

    public static void addWindow(EditingWindow win) {
        windows.addElement(win);
    }

    public static void closeWindow(EditingWindow win) {
        if (win.confirmClose()) {
            windows.removeElement(win);
            if (win instanceof LayoutWindow) {
                List plugins = PluginRegistry.getPlugins(Plugin.class);
                for (int i = 0; i < plugins.size(); ++i) {
                    try {
                        ((Plugin)plugins.get(i)).processMessage(3, new Object[]{win});
                        continue;
                    }
                    catch (Throwable tx) {
                        String name = plugins.get(i).getClass().getName();
                        name = name.substring(name.lastIndexOf(46) + 1);
                        new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginNotifyError", name)), BStandardDialog.ERROR).showMessageDialog(null);
                    }
                }
            }
        }
        if (windows.size() == 0) {
            ModellingApp.quit();
        }
    }

    public static EditingWindow[] getWindows() {
        Object[] w = new EditingWindow[windows.size()];
        windows.copyInto(w);
        return w;
    }

    public static void quit() {
        for (int i = windows.size() - 1; i >= 0; --i) {
            EditingWindow win = (EditingWindow)windows.elementAt(i);
            ModellingApp.closeWindow(win);
            if (!windows.contains(win)) continue;
            return;
        }
        List plugins = PluginRegistry.getPlugins(Plugin.class);
        for (int i = 0; i < plugins.size(); ++i) {
            try {
                ((Plugin)plugins.get(i)).processMessage(1, new Object[0]);
                continue;
            }
            catch (Throwable tx) {
                String name = plugins.get(i).getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginNotifyError", name)), BStandardDialog.ERROR).showMessageDialog(null);
            }
        }
        System.exit(0);
    }

    private static void runStartupScripts() {
        String[] files = new File(STARTUP_SCRIPT_DIRECTORY).list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".bsh")) continue;
                try {
                    String script = ModellingApp.loadFile(new File(STARTUP_SCRIPT_DIRECTORY, files[i]));
                    ScriptRunner.executeScript(script);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        try {
            return ModellingApp.lookupClass(name);
        }
        catch (ClassNotFoundException ex) {
            int i = name.indexOf(36);
            if (i == -1) {
                String newName = (String)classTranslations.get(name);
                if (newName == null) {
                    throw ex;
                }
                return ModellingApp.lookupClass(newName);
            }
            String newName = (String)classTranslations.get(name.substring(0, i));
            if (newName == null) {
                throw ex;
            }
            return ModellingApp.lookupClass(newName + name.substring(i));
        }
    }

    private static Class lookupClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            List pluginLoaders = PluginRegistry.getPluginClassLoaders();
            for (int i = 0; i < pluginLoaders.size(); ++i) {
                try {
                    return ((ClassLoader)pluginLoaders.get(i)).loadClass(name);
                }
                catch (ClassNotFoundException ex2) {
                    if (i != pluginLoaders.size() - 1) continue;
                    throw ex2;
                }
            }
            return null;
        }
    }

    public static void centerWindow(Window win) {
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = win.getSize();
        int x = (d1.width - d2.width) / 2;
        int y = (d1.height - d2.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        win.setLocation(x, y);
    }

    public static void centerDialog(Dialog dlg, Window parent) {
        Rectangle r = parent.getBounds();
        Dimension d = dlg.getSize();
        int x = r.x + (r.width - d.width) / 2;
        int y = r.y + 20;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        dlg.setLocation(x, y);
    }

    public static String loadFile(File f) throws IOException {
        int c;
        BufferedReader in = new BufferedReader(new FileReader(f));
        StringBuffer buf = new StringBuffer();
        while ((c = in.read()) != -1) {
            buf.append((char)c);
        }
        in.close();
        return buf.toString();
    }

    public static boolean saveScene(Scene sc, LayoutWindow fr) {
        try {
            File f = new File(sc.getDirectory(), sc.getName());
            sc.writeToFile(f);
            List plugins = PluginRegistry.getPlugins(Plugin.class);
            for (int i = 0; i < plugins.size(); ++i) {
                try {
                    ((Plugin)plugins.get(i)).processMessage(4, new Object[]{f, fr});
                    continue;
                }
                catch (Throwable tx) {
                    String name = plugins.get(i).getClass().getName();
                    name = name.substring(name.lastIndexOf(46) + 1);
                    new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginNotifyError", name)), BStandardDialog.ERROR).showMessageDialog(null);
                }
            }
            RecentFiles.addRecentFile(f);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorSavingScene"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(fr);
            return false;
        }
        return true;
    }

    public static void openScene(BFrame fr) {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("openScene"));
        if (currentDirectory != null) {
            fc.setDirectory(new File(currentDirectory));
        }
        if (!fc.showDialog(fr)) {
            return;
        }
        currentDirectory = fc.getDirectory().getAbsolutePath();
        ModellingApp.openScene(fc.getSelectedFile(), fr);
    }

    public static void openScene(File f, BFrame fr) {
        try {
            DataInputStream in = new DataInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
            Scene sc = new Scene(in, true);
            sc.setName(f.getName());
            sc.setDirectory(f.getParent());
            if (sc.errorsOccurredInLoading()) {
                new BStandardDialog("", new Object[]{UIUtilities.breakString(Translate.text("errorLoadingScenePart")), new BScrollPane(new BTextArea(sc.getLoadingErrors()))}, BStandardDialog.ERROR).showMessageDialog(fr);
            }
            ModellingApp.newWindow(sc);
            in.close();
            RecentFiles.addRecentFile(f);
        }
        catch (InvalidObjectException ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingWholeScene")), BStandardDialog.ERROR).showMessageDialog(fr);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(fr);
        }
    }

    public static void copyToClipboard(ObjectInfo[] obj, Scene scene) {
        Vector<Texture> textures = new Vector<Texture>();
        for (int i = 0; i < obj.length; ++i) {
            Texture tex = obj[i].object.getTexture();
            if (tex instanceof LayeredTexture) {
                LayeredMapping map = (LayeredMapping)obj[i].object.getTextureMapping();
                Texture[] layer = map.getLayers();
                for (int j = 0; j < layer.length; ++j) {
                    Texture dup = layer[j].duplicate();
                    dup.setID(layer[j].getID());
                    textures.addElement(dup);
                    map.setLayer(j, dup);
                    map.setLayerMapping(j, map.getLayerMapping(j).duplicate(obj[i].object, dup));
                }
                continue;
            }
            if (tex == null) continue;
            Texture dup = tex.duplicate();
            dup.setID(tex.getID());
            textures.addElement(dup);
            obj[i].object.setTexture(dup, obj[i].object.getTextureMapping().duplicate(obj[i].object, dup));
        }
        Vector<Material> materials = new Vector<Material>();
        for (int i = 0; i < obj.length; ++i) {
            Material mat = obj[i].object.getMaterial();
            if (mat == null) continue;
            Material dup = mat.duplicate();
            dup.setID(mat.getID());
            materials.addElement(dup);
            obj[i].object.setMaterial(dup, obj[i].object.getMaterialMapping().duplicate(obj[i].object, dup));
        }
        Vector<ImageMap> images = new Vector<ImageMap>();
        for (int i = 0; i < scene.getNumImages(); ++i) {
            int j;
            ImageMap map = scene.getImage(i);
            boolean used = false;
            for (j = 0; j < textures.size() && !used; ++j) {
                used = ((Texture)textures.elementAt(j)).usesImage(map);
            }
            for (j = 0; j < materials.size() && !used; ++j) {
                used = ((Material)materials.elementAt(j)).usesImage(map);
            }
            if (!used) continue;
            images.addElement(map);
        }
        clipboardObject = obj;
        clipboardTexture = new Texture[textures.size()];
        textures.copyInto(clipboardTexture);
        clipboardMaterial = new Material[materials.size()];
        materials.copyInto(clipboardMaterial);
        clipboardImage = new ImageMap[images.size()];
        images.copyInto(clipboardImage);
    }

    public static void pasteClipboard(LayoutWindow win) {
        Object current;
        int j;
        int i;
        if (clipboardObject == null) {
            return;
        }
        Scene scene = win.getScene();
        UndoRecord undo = new UndoRecord(win, false);
        win.setUndoRecord(undo);
        int[] sel = scene.getSelection();
        for (i = 0; i < clipboardImage.length; ++i) {
            int j2;
            for (j2 = 0; j2 < scene.getNumImages() && clipboardImage[i].getID() != scene.getImage(j2).getID(); ++j2) {
            }
            if (j2 != scene.getNumImages()) continue;
            scene.addImage(clipboardImage[i]);
        }
        for (i = 0; i < clipboardTexture.length; ++i) {
            Texture newtex;
            for (j = 0; j < scene.getNumTextures() && clipboardTexture[i].getID() != scene.getTexture(j).getID(); ++j) {
            }
            if (j == scene.getNumTextures()) {
                newtex = clipboardTexture[i].duplicate();
                newtex.setID(clipboardTexture[i].getID());
                scene.addTexture(newtex);
            } else {
                newtex = scene.getTexture(j);
            }
            for (j = 0; j < clipboardObject.length; ++j) {
                current = ModellingApp.clipboardObject[j].object.getTexture();
                if (current == clipboardTexture[i]) {
                    clipboardObject[j].setTexture(newtex, ModellingApp.clipboardObject[j].object.getTextureMapping().duplicate(ModellingApp.clipboardObject[j].object, newtex));
                    continue;
                }
                if (!(current instanceof LayeredTexture)) continue;
                LayeredMapping map = (LayeredMapping)ModellingApp.clipboardObject[j].object.getTextureMapping();
                map = (LayeredMapping)map.duplicate();
                clipboardObject[j].setTexture(new LayeredTexture(map), map);
                Texture[] layer = map.getLayers();
                for (int k = 0; k < layer.length; ++k) {
                    if (layer[k] != clipboardTexture[i]) continue;
                    map.setLayer(k, newtex);
                    map.setLayerMapping(k, map.getLayerMapping(k).duplicate(ModellingApp.clipboardObject[j].object, newtex));
                }
            }
        }
        for (i = 0; i < clipboardMaterial.length; ++i) {
            Material newmat;
            for (j = 0; j < scene.getNumMaterials() && clipboardMaterial[i].getID() != scene.getMaterial(j).getID(); ++j) {
            }
            if (j == scene.getNumMaterials()) {
                newmat = clipboardMaterial[i].duplicate();
                newmat.setID(clipboardMaterial[i].getID());
                scene.addMaterial(newmat);
            } else {
                newmat = scene.getMaterial(j);
            }
            for (j = 0; j < clipboardObject.length; ++j) {
                current = ModellingApp.clipboardObject[j].object.getMaterial();
                if (current != clipboardMaterial[i]) continue;
                clipboardObject[j].setMaterial(newmat, ModellingApp.clipboardObject[j].object.getMaterialMapping().duplicate(ModellingApp.clipboardObject[j].object, newmat));
            }
        }
        ObjectInfo[] obj = ObjectInfo.duplicateAll(clipboardObject);
        for (int i2 = 0; i2 < obj.length; ++i2) {
            win.addObject(obj[i2], undo);
        }
        undo.addCommand(16, new Object[]{sel});
    }

    public static int getClipboardSize() {
        if (clipboardObject == null) {
            return 0;
        }
        return clipboardObject.length;
    }

    static {
        standardDialogInsets = 0;
        windows = new Vector();
        classTranslations = new Hashtable();
        numNewWindows = 0;
        String dir2 = System.getProperty("user.dir");
        try {
            URL url = ModellingApp.class.getResource("/artofillusion/ModellingApp.class");
            if (url.toString().startsWith("jar:")) {
                String furl = url.getFile();
                dir2 = new File(new URL(furl = furl.substring(0, furl.indexOf(33))).getFile()).getParent();
                if (!new File(dir2).exists()) {
                    dir2 = System.getProperty("user.dir");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        APP_DIRECTORY = dir2;
        PLUGIN_DIRECTORY = new File(APP_DIRECTORY, "Plugins").getAbsolutePath();
        File scripts = new File(APP_DIRECTORY, "Scripts");
        TOOL_SCRIPT_DIRECTORY = new File(scripts, "Tools").getAbsolutePath();
        OBJECT_SCRIPT_DIRECTORY = new File(scripts, "Objects").getAbsolutePath();
        STARTUP_SCRIPT_DIRECTORY = new File(scripts, "Startup").getAbsolutePath();
        IconResource icon = new IconResource("artofillusion/Icons/appIcon.png");
        APP_ICON = icon.getIconWidth() == -1 ? null : icon;
        classTranslations.put("artofillusion.tools.CSGObject", "artofillusion.object.CSGObject");
        classTranslations.put("artofillusion.Cube", "artofillusion.object.Cube");
        classTranslations.put("artofillusion.Curve", "artofillusion.object.Curve");
        classTranslations.put("artofillusion.Cylinder", "artofillusion.object.Cylinder");
        classTranslations.put("artofillusion.DirectionalLight", "artofillusion.object.DirectionalLight");
        classTranslations.put("artofillusion.NullObject", "artofillusion.object.NullObject");
        classTranslations.put("artofillusion.PointLight", "artofillusion.object.PointLight");
        classTranslations.put("artofillusion.SceneCamera", "artofillusion.object.SceneCamera");
        classTranslations.put("artofillusion.Sphere", "artofillusion.object.Sphere");
        classTranslations.put("artofillusion.SplineMesh", "artofillusion.object.SplineMesh");
        classTranslations.put("artofillusion.SpotLight", "artofillusion.object.SpotLight");
        classTranslations.put("artofillusion.TriangleMesh", "artofillusion.object.TriangleMesh");
        classTranslations.put("artofillusion.Tube", "artofillusion.object.Tube");
        classTranslations.put("artofillusion.CylindricalMapping", "artofillusion.texture.CylindricalMapping");
        classTranslations.put("artofillusion.ImageMapTexture", "artofillusion.texture.ImageMapTexture");
        classTranslations.put("artofillusion.LayeredMapping", "artofillusion.texture.LayeredMapping");
        classTranslations.put("artofillusion.LayeredTexture", "artofillusion.texture.LayeredTexture");
        classTranslations.put("artofillusion.LinearMapping3D", "artofillusion.texture.LinearMapping3D");
        classTranslations.put("artofillusion.procedural.ProceduralTexture2D", "artofillusion.texture.ProceduralTexture2D");
        classTranslations.put("artofillusion.procedural.ProceduralTexture3D", "artofillusion.texture.ProceduralTexture3D");
        classTranslations.put("artofillusion.ProjectionMapping", "artofillusion.texture.ProjectionMapping");
        classTranslations.put("artofillusion.SphericalMapping", "artofillusion.texture.SphericalMapping");
        classTranslations.put("artofillusion.UniformMapping", "artofillusion.texture.UniformMapping");
        classTranslations.put("artofillusion.UniformTexture", "artofillusion.texture.UniformTexture");
        classTranslations.put("artofillusion.LinearMaterialMapping", "artofillusion.material.LinearMaterialMapping");
        classTranslations.put("artofillusion.procedural.ProceduralMaterial3D", "artofillusion.material.ProceduralMaterial3D");
        classTranslations.put("artofillusion.UniformMaterial", "artofillusion.material.UniformMaterial");
        classTranslations.put("artofillusion.UniformMaterialMapping", "artofillusion.material.UniformMaterialMapping");
        classTranslations.put("artofillusion.tools.tapDesigner.TapDesignerObjectCollection", "artofillusion.tapDesigner.TapDesignerObjectCollection");
        classTranslations.put("artofillusion.tools.tapDesigner.TapTube", "artofillusion.tapDesigner.TapTube");
        classTranslations.put("artofillusion.tools.tapDesigner.TapSplineMesh", "artofillusion.tapDesigner.TapSplineMesh");
        classTranslations.put("artofillusion.tools.tapDesigner.TapObject", "artofillusion.tapDesigner.TapObject");
        classTranslations.put("artofillusion.tools.tapDesigner.TapLeaf", "artofillusion.tapDesigner.TapLeaf");
    }
}

