/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.Plugin;
import artofillusion.UndoRecord;
import artofillusion.UndoStack;
import artofillusion.ViewerCanvas;
import artofillusion.keystroke.KeystrokeManager;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ImageFileChooser;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.KeyPressedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenuBar;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.TextWidget;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.TextComponent;
import java.util.Iterator;
import java.util.prefs.Preferences;

public abstract class ObjectEditorWindow
extends BFrame
implements EditingWindow {
    protected EditingWindow parentWindow;
    protected ObjectInfo objInfo;
    protected ViewerCanvas[] theView;
    protected BorderContainer[] viewPanel;
    protected FormContainer viewsContainer;
    protected int numViewsShown;
    protected int currentView;
    protected ToolPalette tools;
    protected EditingTool defaultTool;
    protected EditingTool currentTool;
    protected BLabel helpText;
    protected BMenuBar menubar;
    protected UndoStack undoStack;
    protected Preferences preferences;
    private boolean hasNotifiedPlugins;
    protected static boolean lastShowAxes;
    protected static boolean lastShowGrid;
    protected static boolean lastSnapToGrid;
    protected static int lastNumViews;
    protected static int lastGridSubdivisions;
    protected static double lastGridSpacing;
    static /* synthetic */ Class class$buoy$event$MousePressedEvent;

    public ObjectEditorWindow(EditingWindow parent, String title, ObjectInfo obj) {
        super(title);
        this.parentWindow = parent;
        this.objInfo = obj.duplicate(obj.object.duplicate());
        this.objInfo.coords.setOrigin(new Vec3());
        this.objInfo.coords.setOrientation(Vec3.vz(), Vec3.vy());
        this.objInfo.clearDistortion();
    }

    protected void initialize() {
        this.undoStack = new UndoStack();
        if (ModellingApp.APP_ICON != null) {
            this.setIcon(ModellingApp.APP_ICON);
        }
        this.preferences = Preferences.userNodeForPackage(this.getClass()).node("ObjectEditorWindow");
        this.loadPreferences();
        this.addEventLink(WindowClosingEvent.class, new Object(){

            void processEvent() {
                BStandardDialog dlg = new BStandardDialog("", Translate.text("saveWindowChanges"), BStandardDialog.QUESTION);
                String[] options = new String[]{Translate.text("saveChanges"), Translate.text("discardChanges"), Translate.text("button.cancel")};
                int choice = dlg.showOptionDialog(ObjectEditorWindow.this, options, options[0]);
                if (choice == 0) {
                    ObjectEditorWindow.this.doOk();
                } else if (choice == 1) {
                    ObjectEditorWindow.this.doCancel();
                }
            }
        });
        this.numViewsShown = lastNumViews;
        this.viewPanel = new BorderContainer[4];
        this.viewsContainer = new FormContainer(new double[]{1.0, this.numViewsShown == 1 ? 0.0 : 1.0}, new double[]{1.0, this.numViewsShown == 1 ? 0.0 : 1.0});
        this.viewsContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        this.theView = new ViewerCanvas[4];
        Object listen = new Object(){

            void processEvent(MousePressedEvent ev) {
                for (int i = 0; i < ObjectEditorWindow.this.theView.length; ++i) {
                    if (ObjectEditorWindow.this.currentView == i || ev.getWidget() != ObjectEditorWindow.this.theView[i]) continue;
                    ObjectEditorWindow.this.theView[ObjectEditorWindow.this.currentView].setDrawFocus(false);
                    ObjectEditorWindow.this.theView[i].setDrawFocus(true);
                    ObjectEditorWindow.this.currentView = i;
                    ObjectEditorWindow.this.updateMenus();
                    ObjectEditorWindow.this.updateImage();
                }
            }
        };
        for (int i = 0; i < this.theView.length; ++i) {
            this.viewPanel[i] = new BorderContainer(){

                public Dimension getPreferredSize() {
                    return new Dimension(0, 0);
                }

                public Dimension getMinimumSize() {
                    return new Dimension(0, 0);
                }
            };
            RowContainer controls = new RowContainer();
            this.viewPanel[i].add(controls, BorderContainer.NORTH);
            this.theView[i] = this.createViewerCanvas(i, controls);
            this.viewPanel[i].add(this.theView[i], BorderContainer.CENTER);
            this.theView[i].setShowAxes(lastShowAxes);
            this.theView[i].setGrid(lastGridSpacing, lastGridSubdivisions, lastShowGrid, lastSnapToGrid);
            this.theView[i].addEventLink(class$buoy$event$MousePressedEvent == null ? ObjectEditorWindow.class$("buoy.event.MousePressedEvent") : class$buoy$event$MousePressedEvent, listen);
        }
        this.theView[1].setOrientation(2);
        this.theView[2].setOrientation(4);
        this.theView[3].setPerspective(true);
        this.theView[this.currentView].setDrawFocus(true);
        this.viewsContainer.add(this.viewPanel[0], 0, 0);
        this.viewsContainer.add(this.viewPanel[1], 1, 0);
        this.viewsContainer.add(this.viewPanel[2], 0, 1);
        this.viewsContainer.add(this.viewPanel[3], 1, 1);
        this.menubar = new BMenuBar();
        this.setMenuBar(this.menubar);
    }

    protected abstract ViewerCanvas createViewerCanvas(int var1, RowContainer var2);

    protected void recursivelyAddListeners(Widget w) {
        if (!(w instanceof TextWidget)) {
            w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        }
        if (w instanceof WidgetContainer) {
            Iterator children = ((WidgetContainer)w).getChildren().iterator();
            while (children.hasNext()) {
                this.recursivelyAddListeners((Widget)children.next());
            }
        }
    }

    protected void loadPreferences() {
        lastShowAxes = this.preferences.getBoolean("showAxes", lastShowAxes);
        lastShowGrid = this.preferences.getBoolean("showGrid", lastShowGrid);
        lastSnapToGrid = this.preferences.getBoolean("snapToGrid", lastSnapToGrid);
        lastGridSpacing = this.preferences.getDouble("gridSpacing", lastGridSpacing);
        lastGridSubdivisions = this.preferences.getInt("gridSubdivisions", lastGridSubdivisions);
        lastNumViews = this.preferences.getInt("numViews", lastNumViews);
    }

    protected void savePreferences() {
        this.preferences.putBoolean("showAxes", lastShowAxes);
        this.preferences.putBoolean("showGrid", lastShowGrid);
        this.preferences.putBoolean("snapToGrid", lastSnapToGrid);
        this.preferences.putDouble("gridSpacing", lastGridSpacing);
        this.preferences.putInt("gridSubdivisions", lastGridSubdivisions);
        this.preferences.putInt("numViews", lastNumViews);
    }

    protected boolean[] loadBooleanArrayPreference(String key, boolean[] def) {
        byte[] bytes = this.preferences.getByteArray(key, null);
        if (bytes == null) {
            return def;
        }
        boolean[] value = new boolean[bytes.length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = bytes[i] != 0;
        }
        return value;
    }

    protected void saveBooleanArrayPreference(String key, boolean[] value) {
        byte[] bytes = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            bytes[i] = (byte)(value[i] ? 1 : 0);
        }
        this.preferences.putByteArray(key, bytes);
    }

    public void setTool(EditingTool tool) {
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setTool(tool);
        }
        this.currentTool = tool;
    }

    public boolean confirmClose() {
        return true;
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public BFrame getFrame() {
        return this;
    }

    public void updateImage() {
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].repaint();
        }
    }

    public void setUndoRecord(UndoRecord command) {
        this.undoStack.addRecord(command);
        this.updateMenus();
    }

    public void setModified() {
    }

    protected void keyPressed(KeyPressedEvent e) {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (manager.getFocusedWindow() != this.getComponent() || manager.getFocusOwner() instanceof TextComponent) {
            return;
        }
        this.tools.getSelectedTool().keyPressed(e, this.theView[this.currentView]);
        if (!e.isConsumed()) {
            KeystrokeManager.executeKeystrokes(e, this);
        }
    }

    public ViewerCanvas getView() {
        return this.theView[this.currentView];
    }

    public ToolPalette getToolPalette() {
        return this.tools;
    }

    public ViewerCanvas[] getAllViews() {
        return new ViewerCanvas[]{this.theView[0], this.theView[1], this.theView[2], this.theView[3]};
    }

    public void showAxesCommand() {
        boolean wasShown = this.theView[this.currentView].getShowAxes();
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setShowAxes(!wasShown);
        }
        lastShowAxes = !wasShown;
        this.savePreferences();
        this.updateMenus();
        this.updateImage();
    }

    public void showTemplateCommand() {
        boolean wasShown = this.theView[this.currentView].getTemplateShown();
        this.theView[this.currentView].setShowTemplate(!wasShown);
        this.updateMenus();
        this.updateImage();
    }

    public void toggleViewsCommand() {
        if (this.numViewsShown == 4) {
            this.numViewsShown = 1;
            this.viewsContainer.setColumnWeight(0, this.currentView == 0 || this.currentView == 2 ? 1.0 : 0.0);
            this.viewsContainer.setColumnWeight(1, this.currentView == 1 || this.currentView == 3 ? 1.0 : 0.0);
            this.viewsContainer.setRowWeight(0, this.currentView == 0 || this.currentView == 1 ? 1.0 : 0.0);
            this.viewsContainer.setRowWeight(1, this.currentView == 2 || this.currentView == 3 ? 1.0 : 0.0);
        } else {
            this.numViewsShown = 4;
            this.viewsContainer.setColumnWeight(0, 1.0);
            this.viewsContainer.setColumnWeight(1, 1.0);
            this.viewsContainer.setRowWeight(0, 1.0);
            this.viewsContainer.setRowWeight(1, 1.0);
        }
        this.viewsContainer.layoutChildren();
        lastNumViews = this.numViewsShown;
        this.savePreferences();
        this.updateMenus();
        this.updateImage();
        this.viewPanel[this.currentView].requestFocus();
    }

    public void setTemplateCommand() {
        ImageFileChooser fc = new ImageFileChooser(Translate.text("selectTemplateImage"));
        if (!fc.showDialog(this)) {
            return;
        }
        try {
            this.theView[this.currentView].setTemplateImage(fc.getSelectedFile());
        }
        catch (InterruptedException ex) {
            new BStandardDialog("", Translate.text("errorLoadingImage", fc.getSelectedFile().getName()), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        this.theView[this.currentView].setShowTemplate(true);
        this.updateMenus();
        this.updateImage();
    }

    public void setGridCommand() {
        ValueField spaceField = new ValueField(this.theView[this.currentView].gridSpacing, 3);
        ValueField divField = new ValueField(this.theView[this.currentView].gridSubdivisions, 7);
        BCheckBox showBox = new BCheckBox(Translate.text("showGrid"), this.theView[this.currentView].showGrid);
        BCheckBox snapBox = new BCheckBox(Translate.text("snapToGrid"), this.theView[this.currentView].snapToGrid);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("gridTitle"), new Widget[]{spaceField, divField, showBox, snapBox}, new String[]{Translate.text("gridSpacing"), Translate.text("snapToSubdivisions"), null, null});
        if (!dlg.clickedOk()) {
            return;
        }
        lastGridSpacing = spaceField.getValue();
        lastGridSubdivisions = (int)divField.getValue();
        lastShowGrid = showBox.getState();
        lastSnapToGrid = snapBox.getState();
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setGrid(lastGridSpacing, lastGridSubdivisions, lastShowGrid, lastSnapToGrid);
        }
        this.savePreferences();
        this.updateImage();
    }

    public void undoCommand() {
        this.undoStack.executeUndo();
        this.updateImage();
        this.updateMenus();
    }

    public void redoCommand() {
        this.undoStack.executeRedo();
        this.updateImage();
        this.updateMenus();
    }

    protected abstract void doOk();

    protected abstract void doCancel();

    public void setVisible(boolean visible) {
        if (visible && !this.hasNotifiedPlugins) {
            this.hasNotifiedPlugins = true;
            Plugin[] plugins = ModellingApp.getPlugins();
            for (int i = 0; i < plugins.length; ++i) {
                plugins[i].processMessage(5, new Object[]{this});
            }
        }
        super.setVisible(visible);
    }

    public void dispose() {
        super.dispose();
        Plugin[] plugins = ModellingApp.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            plugins[i].processMessage(6, new Object[]{this});
        }
    }

    static {
        lastNumViews = 4;
        lastGridSubdivisions = 10;
        lastGridSpacing = 1.0;
    }
}

