/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.MaterialsDialog;
import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.SceneChangedEvent;
import artofillusion.TexturesDialog;
import artofillusion.UndoRecord;
import artofillusion.material.Material;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.Texture;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSelector;
import buoy.event.FocusLostEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.ColumnContainer;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;

public class ObjectPropertiesPanel
extends ColumnContainer {
    private LayoutWindow window;
    private BTextField nameField;
    private ValueField xPosField;
    private ValueField yPosField;
    private ValueField zPosField;
    private ValueField xRotField;
    private ValueField yRotField;
    private ValueField zRotField;
    private BComboBox textureChoice;
    private BComboBox materialChoice;
    private Widget[] propSelector;
    private ObjectInfo[] objects;
    private Property[] properties;
    private Object3D[] previousObjects;
    private boolean ignoreNextChange;
    private Widget lastEventSource;
    private ActionProcessor paramChangeProcessor;
    static /* synthetic */ Class class$buoy$event$MouseClickedEvent;

    public ObjectPropertiesPanel(LayoutWindow window) {
        this.window = window;
        this.nameField = new BTextField();
        this.xPosField = new ValueField(0.0, 0, 1);
        this.yPosField = new ValueField(0.0, 0, 1);
        this.zPosField = new ValueField(0.0, 0, 1);
        this.xRotField = new ValueField(0.0, 0, 1);
        this.yRotField = new ValueField(0.0, 0, 1);
        this.zRotField = new ValueField(0.0, 0, 1);
        this.textureChoice = new BComboBox();
        this.materialChoice = new BComboBox();
        this.paramChangeProcessor = new ActionProcessor();
        this.rebuildContents();
        window.addEventLink(SceneChangedEvent.class, (Object)this, "rebuildContents");
        this.nameField.addEventLink(FocusLostEvent.class, (Object)this, "nameChanged");
        this.nameField.addEventLink(KeyPressedEvent.class, (Object)this, "nameChanged");
        this.xPosField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.yPosField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.zPosField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.xRotField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.yRotField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.zRotField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.textureChoice.addEventLink(ValueChangedEvent.class, (Object)this, "textureChanged");
        this.materialChoice.addEventLink(ValueChangedEvent.class, (Object)this, "materialChanged");
    }

    protected void rebuildContents() {
        int i;
        int i2;
        if (this.ignoreNextChange) {
            this.ignoreNextChange = false;
            return;
        }
        if (this.lastEventSource == this.nameField) {
            this.nameChanged(new FocusLostEvent(this.nameField, false));
        }
        Scene scene = this.window.getScene();
        int[] sel = scene.getSelection();
        this.objects = new ObjectInfo[sel.length];
        for (int i3 = 0; i3 < sel.length; ++i3) {
            this.objects[i3] = scene.getObject(sel[i3]);
        }
        boolean objectsChanged = this.previousObjects == null || this.objects.length != this.previousObjects.length;
        for (i2 = 0; i2 < this.objects.length && !objectsChanged; objectsChanged |= this.objects[i2].object != this.previousObjects[i2], ++i2) {
        }
        if (objectsChanged) {
            this.previousObjects = new Object3D[this.objects.length];
            for (i2 = 0; i2 < this.objects.length; ++i2) {
                this.previousObjects[i2] = this.objects[i2].object;
            }
        }
        if (this.objects.length == 0) {
            if (objectsChanged) {
                this.removeAll();
                this.add(Translate.label("noObjectsSelected"));
                UIUtilities.applyDefaultBackground(this);
                UIUtilities.applyDefaultFont(this);
                this.layoutChildren();
                this.repaint();
            }
            return;
        }
        if (this.objects.length == 1) {
            this.nameField.setText(this.objects[0].name);
        }
        Vec3 origin = this.objects[0].coords.getOrigin();
        this.xPosField.setValue(origin.x);
        this.yPosField.setValue(origin.y);
        this.zPosField.setValue(origin.z);
        double[] angles = this.objects[0].coords.getRotationAngles();
        this.xRotField.setValue(angles[0]);
        this.yRotField.setValue(angles[1]);
        this.zRotField.setValue(angles[2]);
        for (int i4 = 1; i4 < this.objects.length; ++i4) {
            origin = this.objects[i4].coords.getOrigin();
            this.checkFieldValue(this.xPosField, origin.x);
            this.checkFieldValue(this.yPosField, origin.y);
            this.checkFieldValue(this.zPosField, origin.z);
            angles = this.objects[i4].coords.getRotationAngles();
            this.checkFieldValue(this.xRotField, angles[0]);
            this.checkFieldValue(this.yRotField, angles[1]);
            this.checkFieldValue(this.zRotField, angles[2]);
        }
        Texture tex = this.objects[0].object.getTexture();
        boolean canSetTexture = this.objects[0].object.canSetTexture();
        boolean sameTexture = true;
        for (int i5 = 1; i5 < this.objects.length; ++i5) {
            Texture thisTex = this.objects[i5].object.getTexture();
            if (thisTex != tex) {
                sameTexture = false;
            }
            canSetTexture &= this.objects[i5].object.canSetTexture();
        }
        if (canSetTexture) {
            Vector<String> names = new Vector<String>();
            int selected = -1;
            for (int i6 = 0; i6 < scene.getNumTextures(); ++i6) {
                names.add(scene.getTexture(i6).getName());
                if (scene.getTexture(i6) != tex) continue;
                selected = i6;
            }
            if (!sameTexture) {
                selected = names.size();
                names.add("");
            } else if (tex instanceof LayeredTexture) {
                selected = names.size();
                names.add(Translate.text("layeredTexture"));
            }
            names.add(Translate.text("button.newTexture"));
            this.textureChoice.setModel(new DefaultComboBoxModel(names));
            this.textureChoice.setSelectedIndex(selected);
        }
        Material mat = this.objects[0].object.getMaterial();
        boolean canSetMaterial = this.objects[0].object.canSetMaterial();
        boolean sameMaterial = true;
        for (int i7 = 1; i7 < this.objects.length; ++i7) {
            Material thisMat = this.objects[i7].object.getMaterial();
            if (thisMat != mat) {
                sameMaterial = false;
            }
            canSetMaterial &= this.objects[i7].object.canSetMaterial();
        }
        if (canSetMaterial) {
            Vector<String> names = new Vector<String>();
            int selected = -1;
            for (i = 0; i < scene.getNumMaterials(); ++i) {
                names.add(scene.getMaterial(i).getName());
                if (scene.getMaterial(i) != mat) continue;
                selected = i;
            }
            if (!sameMaterial) {
                selected = names.size();
                names.add("");
            } else if (mat == null) {
                selected = names.size();
            }
            names.add(Translate.text("none"));
            names.add(Translate.text("button.newMaterial"));
            this.materialChoice.setModel(new DefaultComboBoxModel(names));
            this.materialChoice.setSelectedIndex(selected);
        }
        Property[] oldProperties = this.properties;
        this.findProperties();
        boolean propertiesChanged = oldProperties == null || this.properties.length != oldProperties.length;
        for (i = 0; i < this.properties.length && !propertiesChanged; ++i) {
            propertiesChanged = !this.properties[i].equals(oldProperties[i]);
        }
        if (!objectsChanged && !propertiesChanged) {
            this.showParameterValues();
            return;
        }
        this.lastEventSource = null;
        this.removeAll();
        LayoutInfo fillLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null);
        if (this.objects.length == 1) {
            this.add(Translate.label("Name"));
            this.add(this.nameField, fillLayout);
        }
        this.add(Translate.label("Position"));
        FormContainer positions = new FormContainer(new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0}, new double[1]);
        positions.add(new BLabel("X"), 0, 0);
        positions.add(this.xPosField, 1, 0, fillLayout);
        positions.add(new BLabel(" Y"), 2, 0);
        positions.add(this.yPosField, 3, 0, fillLayout);
        positions.add(new BLabel(" Z"), 4, 0);
        positions.add(this.zPosField, 5, 0, fillLayout);
        this.add(positions, fillLayout);
        this.add(Translate.label("Orientation"));
        FormContainer orientation = new FormContainer(new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0}, new double[1]);
        orientation.add(new BLabel("X"), 0, 0);
        orientation.add(this.xRotField, 1, 0, fillLayout);
        orientation.add(new BLabel(" Y"), 2, 0);
        orientation.add(this.yRotField, 3, 0, fillLayout);
        orientation.add(new BLabel(" Z"), 4, 0);
        orientation.add(this.zRotField, 5, 0, fillLayout);
        this.add(orientation, fillLayout);
        if (canSetTexture) {
            this.add(Translate.label("Texture"));
            this.add(this.textureChoice, fillLayout);
        }
        if (canSetMaterial) {
            this.add(Translate.label("Material"));
            this.add(this.materialChoice, fillLayout);
        }
        LayoutInfo centerLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
        this.propSelector = new Widget[this.properties.length];
        for (int i8 = 0; i8 < this.propSelector.length; ++i8) {
            if (this.properties[i8].getType() != Property.BOOLEAN) {
                this.add(new BLabel(this.properties[i8].getName()));
            }
            if (this.properties[i8].getType() == Property.DOUBLE) {
                this.propSelector[i8] = new ValueSelector(0.0, this.properties[i8].getMinimum(), this.properties[i8].getMaximum(), 0.005);
            } else if (this.properties[i8].getType() == Property.INTEGER) {
                this.propSelector[i8] = new ValueField(0.0, 4);
                final Property prop = this.properties[i8];
                ((ValueField)this.propSelector[i8]).setValueChecker(new ValueChecker(){

                    public boolean isValid(double val) {
                        return val >= prop.getMinimum() && val <= prop.getMaximum();
                    }
                });
            } else if (this.properties[i8].getType() == Property.BOOLEAN) {
                this.propSelector[i8] = new BCheckBox(this.properties[i8].getName(), false);
            } else if (this.properties[i8].getType() == Property.STRING) {
                this.propSelector[i8] = new BTextField(15);
            } else if (this.properties[i8].getType() == Property.COLOR) {
                this.propSelector[i8] = new ColorSelector(this.properties[i8].getName());
            } else if (this.properties[i8].getType() == Property.ENUMERATION) {
                this.propSelector[i8] = new BComboBox(this.properties[i8].getAllowedValues());
            }
            if (this.propSelector[i8] instanceof BTextField) {
                this.propSelector[i8].addEventLink(class$buoy$event$FocusLostEvent == null ? ObjectPropertiesPanel.class$("buoy.event.FocusLostEvent") : class$buoy$event$FocusLostEvent, (Object)this, "stringParameterChanged");
                this.propSelector[i8].addEventLink(class$buoy$event$KeyPressedEvent == null ? ObjectPropertiesPanel.class$("buoy.event.KeyPressedEvent") : class$buoy$event$KeyPressedEvent, (Object)this, "stringParameterChanged");
            } else {
                this.propSelector[i8].addEventLink(class$buoy$event$ValueChangedEvent == null ? ObjectPropertiesPanel.class$("buoy.event.ValueChangedEvent") : class$buoy$event$ValueChangedEvent, (Object)this, "parameterChanged");
            }
            if (this.propSelector[i8] instanceof ValueSelector || this.propSelector[i8] instanceof BCheckBox || this.propSelector[i8] instanceof ValueField) {
                this.add(this.propSelector[i8], centerLayout);
                continue;
            }
            this.add(this.propSelector[i8], fillLayout);
        }
        this.showParameterValues();
        UIUtilities.applyDefaultBackground(this);
        UIUtilities.applyDefaultFont(this);
        this.layoutChildren();
        this.repaint();
    }

    private void checkFieldValue(ValueField field, double value) {
        if (field.getValue() != value) {
            field.setValue(Double.NaN);
        }
    }

    private void findProperties() {
        this.properties = this.objects[0].object.getProperties();
        for (int i = 1; i < this.objects.length; ++i) {
            Property[] otherProperty = this.objects[i].object.getProperties();
            boolean same = this.properties.length == otherProperty.length;
            for (int j = 0; j < this.properties.length && same; ++j) {
                if (this.properties[j].equals(otherProperty[j])) continue;
                same = false;
            }
            if (same) continue;
            this.properties = new Property[0];
            return;
        }
    }

    private void showParameterValues() {
        int i;
        if (this.propSelector == null) {
            return;
        }
        Object[] values = new Object[this.propSelector.length];
        for (i = 0; i < values.length; ++i) {
            values[i] = this.objects[0].object.getPropertyValue(i);
        }
        for (i = 1; i < this.objects.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                if (values[j] == null || values[j].equals(this.objects[i].object.getPropertyValue(j))) continue;
                values[j] = null;
            }
        }
        for (i = 0; i < this.propSelector.length; ++i) {
            if (this.propSelector[i] instanceof ValueSelector) {
                ((ValueSelector)this.propSelector[i]).setValue(values[i] == null ? Double.NaN : (Double)values[i]);
                continue;
            }
            if (this.propSelector[i] instanceof ValueField) {
                ((ValueField)this.propSelector[i]).setValue(values[i] == null ? Double.NaN : (double)((Integer)values[i]).intValue());
                continue;
            }
            if (this.propSelector[i] instanceof BCheckBox) {
                ((BCheckBox)this.propSelector[i]).setState((Boolean)values[i]);
                continue;
            }
            if (this.propSelector[i] instanceof BTextField) {
                ((BTextField)this.propSelector[i]).setText((String)values[i]);
                continue;
            }
            if (this.propSelector[i] instanceof ColorSelector) {
                ((ColorSelector)this.propSelector[i]).setColor((RGBColor)values[i]);
                continue;
            }
            if (!(this.propSelector[i] instanceof BComboBox)) continue;
            ((BComboBox)this.propSelector[i]).setSelectedValue(values[i]);
        }
    }

    private void coordinatesChanged(ValueChangedEvent ev) {
        int i;
        UndoRecord undo = null;
        if (ev.getWidget() != this.lastEventSource) {
            this.ignoreNextChange = true;
            undo = new UndoRecord(this.window, false);
            for (i = 0; i < this.objects.length; ++i) {
                undo.addCommand(1, new Object[]{this.objects[i].coords, this.objects[i].coords.duplicate()});
            }
        }
        for (i = 0; i < this.objects.length; ++i) {
            CoordinateSystem coords = this.objects[i].coords;
            Vec3 origin = coords.getOrigin();
            origin.x = this.getNewValue(origin.x, this.xPosField.getValue());
            origin.y = this.getNewValue(origin.y, this.yPosField.getValue());
            origin.z = this.getNewValue(origin.z, this.zPosField.getValue());
            coords.setOrigin(origin);
            double[] angles = coords.getRotationAngles();
            angles[0] = this.getNewValue(angles[0], this.xRotField.getValue());
            angles[1] = this.getNewValue(angles[1], this.yRotField.getValue());
            angles[2] = this.getNewValue(angles[2], this.zRotField.getValue());
            coords.setOrientation(angles[0], angles[1], angles[2]);
        }
        this.lastEventSource = ev.getWidget();
        if (undo != null) {
            this.window.setUndoRecord(undo);
        } else {
            this.window.setModified();
        }
        this.window.updateImage();
    }

    private double getNewValue(double oldval, double newval) {
        return Double.isNaN(newval) ? oldval : newval;
    }

    private void nameChanged(WidgetEvent ev) {
        this.lastEventSource = ev.getWidget();
        if (ev instanceof KeyPressedEvent && ((KeyPressedEvent)ev).getKeyCode() != 10) {
            return;
        }
        if (this.objects.length == 0 || this.objects[0].name.equals(this.nameField.getText())) {
            return;
        }
        int which = this.window.getScene().indexOf(this.objects[0]);
        this.window.setUndoRecord(new UndoRecord(this.window, false, 6, new Object[]{new Integer(which), this.objects[0].name}));
        this.window.setObjectName(which, this.nameField.getText());
        if (ev instanceof KeyPressedEvent) {
            this.window.getView().requestFocus();
        }
    }

    private void textureChanged() {
        int index = this.textureChoice.getSelectedIndex();
        Scene scene = this.window.getScene();
        Texture tex = null;
        if (index < scene.getNumTextures()) {
            tex = scene.getTexture(index);
        } else if (index == this.textureChoice.getItemCount() - 1 && (tex = TexturesDialog.showNewTextureWindow(this.window, scene)) == null) {
            this.rebuildContents();
        }
        if (tex != null) {
            UndoRecord undo = new UndoRecord(this.window, false);
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i].object.getTexture() == tex) continue;
                undo.addCommand(0, new Object[]{this.objects[i].object, this.objects[i].object.duplicate()});
                this.objects[i].setTexture(tex, tex.getDefaultMapping(this.objects[i].object));
            }
            this.window.setUndoRecord(undo);
            this.window.updateImage();
            this.window.getScore().tracksModified(false);
        }
    }

    private void materialChanged() {
        boolean noMaterial;
        int index = this.materialChoice.getSelectedIndex();
        Scene scene = this.window.getScene();
        Material mat = null;
        boolean bl = noMaterial = index == this.materialChoice.getItemCount() - 2;
        if (index < scene.getNumMaterials()) {
            mat = scene.getMaterial(index);
        } else if (index == this.materialChoice.getItemCount() - 1 && (mat = MaterialsDialog.showNewMaterialWindow(this.window, scene)) == null) {
            this.rebuildContents();
        }
        if (noMaterial || mat != null) {
            UndoRecord undo = new UndoRecord(this.window, false);
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i].object.getMaterial() == mat) continue;
                undo.addCommand(0, new Object[]{this.objects[i].object, this.objects[i].object.duplicate()});
                this.objects[i].setMaterial(mat, noMaterial ? null : mat.getDefaultMapping(this.objects[i].object));
            }
            this.window.setUndoRecord(undo);
            this.window.updateImage();
            this.window.getScore().tracksModified(false);
        }
    }

    private void parameterChanged(final ValueChangedEvent ev) {
        Runnable r = new Runnable(){

            public void run() {
                ObjectPropertiesPanel.this.processParameterChange(ev);
            }
        };
        if (ev.isInProgress()) {
            this.paramChangeProcessor.addEvent(r);
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void stringParameterChanged(WidgetEvent ev) {
        if (ev instanceof FocusLostEvent || ev instanceof KeyPressedEvent && ((KeyPressedEvent)ev).getKeyCode() == 10) {
            this.parameterChanged(new ValueChangedEvent(ev.getWidget(), false));
        }
    }

    private void processParameterChange(ValueChangedEvent ev) {
        UndoRecord undo = null;
        if (ev.getWidget() != this.lastEventSource) {
            this.ignoreNextChange = true;
            undo = new UndoRecord(this.window, false);
            for (int i = 0; i < this.objects.length; ++i) {
                undo.addCommand(0, new Object[]{this.objects[i].object, this.objects[i].object.duplicate()});
            }
        }
        boolean changed = false;
        for (int i = 0; i < this.objects.length; ++i) {
            for (int j = 0; j < this.propSelector.length; ++j) {
                if (this.propSelector[j] != ev.getSource()) continue;
                Object value = null;
                if (this.propSelector[j] instanceof ValueSelector) {
                    value = new Double(((ValueSelector)this.propSelector[j]).getValue());
                } else if (this.propSelector[j] instanceof ValueField) {
                    value = new Integer((int)((ValueField)this.propSelector[j]).getValue());
                } else if (this.propSelector[j] instanceof BCheckBox) {
                    value = ((BCheckBox)this.propSelector[j]).getState();
                } else if (this.propSelector[j] instanceof BTextField) {
                    value = ((BTextField)this.propSelector[j]).getText();
                } else if (this.propSelector[j] instanceof ColorSelector) {
                    value = ((ColorSelector)this.propSelector[j]).getColor();
                } else if (this.propSelector[j] instanceof BComboBox) {
                    value = ((BComboBox)this.propSelector[j]).getSelectedValue();
                }
                if (this.objects[i].object.getPropertyValue(j).equals(value)) continue;
                this.objects[i].object.setPropertyValue(j, value);
                changed = true;
            }
            this.window.getScene().objectModified(this.objects[i].object);
        }
        this.lastEventSource = ev.getWidget();
        if (undo != null && changed) {
            this.window.setUndoRecord(undo);
        } else if (!ev.isInProgress() && changed) {
            this.window.setModified();
        }
        this.window.updateImage();
        this.window.getScore().tracksModified(false);
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        return new Dimension(Math.max(pref.width, 180), Math.max(pref.height, 200));
    }

    public Dimension getMinimumSize() {
        return new Dimension();
    }

    private class ColorSelector
    extends CustomWidget {
        private String title;
        private RGBColor color;

        ColorSelector(String title) {
            this.title = title;
            this.color = new RGBColor();
            this.setPreferredSize(new Dimension(30, 15));
            this.setMaximumSize(new Dimension(30, 15));
            this.setBackground(this.color.getColor());
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createLoweredBevelBorder());
            this.addEventLink(class$buoy$event$MouseClickedEvent == null ? (class$buoy$event$MouseClickedEvent = ObjectPropertiesPanel.class$("buoy.event.MouseClickedEvent")) : class$buoy$event$MouseClickedEvent, this);
        }

        public RGBColor getColor() {
            return this.color.duplicate();
        }

        public void setColor(RGBColor color) {
            this.color = color.duplicate();
            this.setBackground(color.getColor());
        }

        private void processEvent() {
            RGBColor oldColor = this.color.duplicate();
            new ColorChooser(ObjectPropertiesPanel.this.window, this.title, this.color);
            if (!this.color.equals(oldColor)) {
                this.setBackground(this.color.getColor());
                this.dispatchEvent(new ValueChangedEvent(this));
            }
        }
    }
}

