/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.util.SearchlistClassLoader;
import buoy.widget.BStandardDialog;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginRegistry {
    private static final ArrayList pluginLoaders = new ArrayList();
    private static final HashSet categories = new HashSet();
    private static final HashMap categoryClasses = new HashMap();
    private static final HashMap resources = new HashMap();
    private static final HashMap exports = new HashMap();
    private static final HashMap classMap = new HashMap();

    static void scanPlugins() {
        File dir2 = new File(ModellingApp.PLUGIN_DIRECTORY);
        if (!dir2.exists()) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("cannotLocatePlugins")), BStandardDialog.ERROR).showMessageDialog(null);
            return;
        }
        String[] files = dir2.list();
        HashSet<JarInfo> jars = new HashSet<JarInfo>();
        for (int i = 0; i < files.length; ++i) {
            try {
                jars.add(new JarInfo(new File(dir2, files[i])));
                continue;
            }
            catch (IOException ex) {
                continue;
            }
            catch (Exception ex) {
                System.err.println("*** Exception loading plugin file " + files[i]);
                ex.printStackTrace(System.err);
            }
        }
        HashMap nameMap = new HashMap();
        while (jars.size() > 0) {
            boolean processedAny = false;
            Iterator jarIterator = new ArrayList(jars).iterator();
            while (jarIterator.hasNext()) {
                boolean importsOk;
                JarInfo jar = (JarInfo)jarIterator.next();
                Iterator importIterator = jar.imports.iterator();
                for (importsOk = true; importsOk && importIterator.hasNext(); importsOk &= nameMap.containsKey(importIterator.next())) {
                }
                if (!importsOk) continue;
                PluginRegistry.processJar(jar, nameMap);
                processedAny = true;
                jars.remove(jar);
            }
            if (processedAny) continue;
            System.err.println("*** The following plugins were not loaded because their imports could not be resolved:");
            jarIterator = jars.iterator();
            while (jarIterator.hasNext()) {
                System.out.println(((JarInfo)jarIterator.next()).file.getName());
            }
            System.err.println();
            break;
        }
    }

    private static void processJar(JarInfo jar, Map nameMap) {
        try {
            Object info;
            int i;
            if (jar.imports.size() == 0) {
                jar.loader = new URLClassLoader(new URL[]{jar.file.toURI().toURL()});
            } else {
                SearchlistClassLoader loader = new SearchlistClassLoader(new URL[]{jar.file.toURI().toURL()});
                jar.loader = loader;
                Iterator importIterator = jar.imports.iterator();
                while (importIterator.hasNext()) {
                    loader.add(((JarInfo)nameMap.get(importIterator.next())).loader);
                }
            }
            pluginLoaders.add(jar.loader);
            HashMap classNameMap = new HashMap();
            if (jar.name != null && jar.name.length() > 0) {
                nameMap.put(jar.name, jar);
            }
            for (i = 0; i < jar.categories.size(); ++i) {
                PluginRegistry.addCategory(jar.loader.loadClass((String)jar.categories.get(i)));
            }
            for (i = 0; i < jar.plugins.size(); ++i) {
                Object plugin = jar.loader.loadClass((String)jar.plugins.get(i)).newInstance();
                PluginRegistry.registerPlugin(plugin);
                classNameMap.put(jar.plugins.get(i), plugin);
            }
            for (i = 0; i < jar.exports.size(); ++i) {
                info = (ExportInfo)jar.exports.get(i);
                ((ExportInfo)info).plugin = classNameMap.get(((ExportInfo)info).className);
                PluginRegistry.registerExportedMethod((ExportInfo)info);
            }
            for (i = 0; i < jar.resources.size(); ++i) {
                info = (ResourceInfo)jar.resources.get(i);
                PluginRegistry.registerResource(((ResourceInfo)info).type, ((ResourceInfo)info).id, jar.loader, ((ResourceInfo)info).name, ((ResourceInfo)info).locale);
            }
        }
        catch (Exception ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginLoadError", jar.file.getName())), BStandardDialog.ERROR).showMessageDialog(null);
            System.err.println("*** Exception while initializing plugin " + jar.file.getName() + ":");
            ex.printStackTrace();
        }
    }

    public static List getPluginClassLoaders() {
        return new ArrayList(pluginLoaders);
    }

    public static void addCategory(Class category) {
        categories.add(category);
    }

    public static List getCategories() {
        return new ArrayList(categories);
    }

    public static void registerPlugin(Object plugin) {
        classMap.put(plugin.getClass().getName(), plugin);
        Iterator categoryIterator = categories.iterator();
        while (categoryIterator.hasNext()) {
            Class category = (Class)categoryIterator.next();
            if (!category.isInstance(plugin)) continue;
            ArrayList<Object> instances = (ArrayList<Object>)categoryClasses.get(category);
            if (instances == null) {
                instances = new ArrayList<Object>();
                categoryClasses.put(category, instances);
            }
            instances.add(plugin);
        }
    }

    public static List getPlugins(Class category) {
        List plugins = (List)categoryClasses.get(category);
        if (plugins == null) {
            return new ArrayList();
        }
        return new ArrayList(plugins);
    }

    public static Object getPluginObject(String classname) {
        return classMap.get(classname);
    }

    public static void registerResource(String type, String id, ClassLoader loader, String name, Locale locale) throws IllegalArgumentException {
        PluginResource resource;
        HashMap<String, PluginResource> resourcesForType = (HashMap<String, PluginResource>)resources.get(type);
        if (resourcesForType == null) {
            resourcesForType = new HashMap<String, PluginResource>();
            resources.put(type, resourcesForType);
        }
        if ((resource = (PluginResource)resourcesForType.get(id)) == null) {
            resource = new PluginResource(type, id);
            resourcesForType.put(id, resource);
        }
        resource.addResource(name, loader, locale);
    }

    public static List getResourceTypes() {
        return new ArrayList(resources.keySet());
    }

    public static List getResources(String type) {
        Map resourcesForType = (Map)resources.get(type);
        if (resourcesForType == null) {
            return new ArrayList();
        }
        return new ArrayList(resourcesForType.values());
    }

    public static PluginResource getResource(String type, String id) {
        Map resourcesForType = (Map)resources.get(type);
        if (resourcesForType == null) {
            return null;
        }
        return (PluginResource)resourcesForType.get(id);
    }

    public static void registerExportedMethod(Object plugin, String method, String id) throws IllegalArgumentException {
        ExportInfo info = new ExportInfo();
        info.plugin = plugin;
        info.method = method;
        info.id = id;
        PluginRegistry.registerExportedMethod(info);
    }

    private static void registerExportedMethod(ExportInfo export) throws IllegalArgumentException {
        if (exports.containsKey(export.id)) {
            throw new IllegalArgumentException("Multiple exported methods with id=" + export.id);
        }
        exports.put(export.id, export);
    }

    public static List getExportedMethodIds() {
        return new ArrayList(exports.keySet());
    }

    public static Object invokeExportedMethod(String id, Object[] args) throws NoSuchMethodException, InvocationTargetException {
        ExportInfo info = (ExportInfo)exports.get(id);
        if (info == null) {
            throw new NoSuchMethodException("There is no exported method with id=" + id);
        }
        Method[] methods = info.plugin.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(info.method)) continue;
            try {
                return methods[i].invoke(info.plugin, args);
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            catch (IllegalAccessException ex) {
                throw new InvocationTargetException(ex);
            }
        }
        throw new NoSuchMethodException("No method found which matches the specified name and argument types.");
    }

    private static class ResourceInfo {
        String type;
        String id;
        String name;
        Locale locale;
        HashMap values = new HashMap();

        private ResourceInfo() {
        }
    }

    private static class ExportInfo {
        String method;
        String id;
        String className;
        Object plugin;

        private ExportInfo() {
        }
    }

    public static class PluginResource {
        private String type;
        private String id;
        private ArrayList names;
        private ArrayList loaders;
        private ArrayList locales;

        private PluginResource(String type, String id) {
            this.type = type;
            this.id = id;
            this.names = new ArrayList();
            this.loaders = new ArrayList();
            this.locales = new ArrayList();
        }

        private void addResource(String name, ClassLoader loader, Locale locale) throws IllegalArgumentException {
            if (this.locales.contains(locale)) {
                throw new IllegalArgumentException("Multiple resource definitions for type=" + this.type + ", name=" + this.id + ", locale=" + locale);
            }
            this.names.add(name);
            this.loaders.add(loader);
            this.locales.add(locale);
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        private int findLocalizedVersion(Locale locale) {
            int bestMatch = 0;
            int bestMatchedLevels = 0;
            for (int i = 0; i < this.locales.size(); ++i) {
                Locale loc = (Locale)this.locales.get(i);
                int matchedLevels = 0;
                if (loc != null && loc.getLanguage() == locale.getLanguage()) {
                    ++matchedLevels;
                    if (loc.getCountry() == locale.getCountry()) {
                        ++matchedLevels;
                        if (loc.getVariant() == locale.getVariant()) {
                            ++matchedLevels;
                        }
                    }
                }
                if (matchedLevels <= bestMatchedLevels) continue;
                bestMatch = i;
                bestMatchedLevels = matchedLevels;
            }
            return bestMatch;
        }

        public InputStream getInputStream() {
            int index = this.findLocalizedVersion(Translate.getLocale());
            return ((ClassLoader)this.loaders.get(index)).getResourceAsStream((String)this.names.get(index));
        }

        public URL getURL() {
            int index = this.findLocalizedVersion(Translate.getLocale());
            return ((ClassLoader)this.loaders.get(index)).getResource((String)this.names.get(index));
        }

        public String getName() {
            int index = this.findLocalizedVersion(Translate.getLocale());
            return (String)this.names.get(index);
        }

        public ClassLoader getClassLoader() {
            int index = this.findLocalizedVersion(Translate.getLocale());
            return (ClassLoader)this.loaders.get(index);
        }
    }

    private static class JarInfo {
        File file;
        String name;
        String version;
        ArrayList imports;
        ArrayList plugins;
        ArrayList categories;
        ArrayList resources;
        ArrayList exports;
        ClassLoader loader;

        JarInfo(File file) throws IOException {
            this.file = file;
            this.imports = new ArrayList();
            this.plugins = new ArrayList();
            this.categories = new ArrayList();
            this.resources = new ArrayList();
            this.exports = new ArrayList();
            ZipFile zf = new ZipFile(file);
            try {
                ZipEntry ze = zf.getEntry("extensions.xml");
                if (ze != null) {
                    BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    try {
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document doc = builder.parse(in);
                        Element extensions = doc.getDocumentElement();
                        if (!"extension".equals(extensions.getNodeName())) {
                            throw new Exception("The root element must be <extension>");
                        }
                        Node nameNode = extensions.getAttributes().getNamedItem("name");
                        if (nameNode != null) {
                            this.name = nameNode.getNodeValue();
                        }
                        NodeList categoryList = doc.getElementsByTagName("category");
                        for (int i = 0; i < categoryList.getLength(); ++i) {
                            Node category = categoryList.item(i);
                            this.categories.add(category.getAttributes().getNamedItem("class").getNodeValue());
                        }
                        NodeList pluginList = doc.getElementsByTagName("plugin");
                        for (int i = 0; i < pluginList.getLength(); ++i) {
                            Node plugin = pluginList.item(i);
                            String className = plugin.getAttributes().getNamedItem("class").getNodeValue();
                            this.plugins.add(className);
                            NodeList children = plugin.getChildNodes();
                            for (int k = 0; k < children.getLength(); ++k) {
                                Node childNode = children.item(k);
                                if (!"export".equals(childNode.getNodeName())) continue;
                                ExportInfo export = new ExportInfo();
                                export.method = childNode.getAttributes().getNamedItem("method").getNodeValue();
                                export.id = childNode.getAttributes().getNamedItem("id").getNodeValue();
                                export.className = className;
                                this.exports.add(export);
                            }
                        }
                        NodeList importList = doc.getElementsByTagName("import");
                        for (int i = 0; i < importList.getLength(); ++i) {
                            Node importNode = importList.item(i);
                            this.imports.add(importNode.getAttributes().getNamedItem("name").getNodeValue());
                        }
                        NodeList resourceList = doc.getElementsByTagName("resource");
                        for (int i = 0; i < resourceList.getLength(); ++i) {
                            Node resourceNode = resourceList.item(i);
                            ResourceInfo resource = new ResourceInfo();
                            resource.type = resourceNode.getAttributes().getNamedItem("type").getNodeValue();
                            resource.id = resourceNode.getAttributes().getNamedItem("id").getNodeValue();
                            resource.name = resourceNode.getAttributes().getNamedItem("name").getNodeValue();
                            Node localeNode = resourceNode.getAttributes().getNamedItem("locale");
                            if (localeNode != null) {
                                String[] parts = localeNode.getNodeValue().split("_");
                                if (parts.length == 1) {
                                    resource.locale = new Locale(parts[0]);
                                } else if (parts.length == 2) {
                                    resource.locale = new Locale(parts[0], parts[1]);
                                } else if (parts.length == 3) {
                                    resource.locale = new Locale(parts[0], parts[1], parts[2]);
                                }
                            }
                            this.resources.add(resource);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("*** Exception while parsing extensions.xml for plugin " + file.getName() + ":");
                        ex.printStackTrace();
                        throw new IOException();
                    }
                    return;
                }
                ze = zf.getEntry("plugins");
                if (ze != null) {
                    BufferedReader in = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                    String className = in.readLine();
                    while (className != null) {
                        this.plugins.add(className.trim());
                        className = in.readLine();
                    }
                    return;
                }
                throw new IOException();
            }
            finally {
                zf.close();
            }
        }
    }
}

