/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.EditingWindow;
import artofillusion.view.ViewerOrientationControl;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseScrolledEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;

public class SceneViewer
extends ViewerCanvas {
    Scene theScene;
    EditingWindow parentFrame;
    Vector cameras;
    boolean draggingBox;
    boolean draggingSelectionBox;
    boolean squareBox;
    boolean sentClick;
    boolean dragging;
    Point clickPoint;
    Point dragPoint;
    ObjectInfo clickedObject;
    int deselect;

    public SceneViewer(Scene s, RowContainer p, EditingWindow fr) {
        this(s, p, fr, false);
    }

    public SceneViewer(Scene s, RowContainer p, EditingWindow fr, boolean forceSoftwareRendering) {
        super(ModellingApp.getPreferences().getUseOpenGL() && SceneViewer.isOpenGLAvailable() && !forceSoftwareRendering);
        this.theScene = s;
        this.parentFrame = fr;
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        this.cameras = new Vector();
        this.buildChoices(p);
        this.rebuildCameraList();
        this.setRenderMode(ModellingApp.getPreferences().getDefaultDisplayMode());
    }

    public EditingWindow getEditingWindow() {
        return this.parentFrame;
    }

    public Scene getScene() {
        return this.theScene;
    }

    public void rebuildCameraList() {
        this.cameras.removeAllElements();
        for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo obj = this.theScene.getObject(i);
            if (!(obj.object instanceof SceneCamera)) continue;
            this.cameras.addElement(obj);
        }
        Iterator iter = this.getViewerControlWidgets().values().iterator();
        while (iter.hasNext()) {
            Widget w = (Widget)iter.next();
            if (!(w instanceof ViewerOrientationControl.OrientationChoice)) continue;
            ((ViewerOrientationControl.OrientationChoice)w).rebuildCameraList();
        }
    }

    public ObjectInfo[] getCameras() {
        return this.cameras.toArray(new ObjectInfo[this.cameras.size()]);
    }

    public void setOrientation(int which) {
        super.setOrientation(which);
        if (which > 5 && which < 6 + this.cameras.size()) {
            this.boundCamera = (ObjectInfo)this.cameras.elementAt(which - 6);
            CoordinateSystem coords = this.theCamera.getCameraCoordinates();
            coords.copyCoords(this.boundCamera.coords);
            this.theCamera.setCameraCoordinates(coords);
            this.dispatchEvent(this.viewChangedEvent);
            this.repaint();
        } else {
            this.boundCamera = null;
        }
    }

    public double[] estimateDepthRange() {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        Mat4 toView = this.theCamera.getWorldToView();
        for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo info = this.theScene.getObject(i);
            BoundingBox bounds = info.getBounds();
            double depth = toView.times((Vec3)info.coords.getOrigin()).z;
            double dx = bounds.maxx - bounds.minx;
            double dy = bounds.maxy - bounds.miny;
            double dz = bounds.maxz - bounds.minz;
            double size = 0.5 * Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (depth - size < min) {
                min = depth - size;
            }
            if (!(depth + size > max)) continue;
            max = depth + size;
        }
        return new double[]{min, max};
    }

    public void updateImage() {
        ObjectInfo obj;
        int i;
        this.adjustCamera(this.isPerspective());
        super.updateImage();
        Vec3 viewdir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            obj = this.theScene.getObject(i);
            if (obj == this.boundCamera) continue;
            this.theCamera.setObjectTransform(obj.coords.fromLocal());
            obj.object.renderObject(obj, this, viewdir);
        }
        if (this.currentTool.hilightSelection()) {
            for (i = 0; i < this.theScene.getNumObjects(); ++i) {
                Color col;
                int hsize;
                obj = this.theScene.getObject(i);
                if (obj.selected) {
                    hsize = 4;
                    col = handleColor;
                } else {
                    if (!obj.parentSelected) continue;
                    hsize = 2;
                    col = highlightColor;
                }
                this.theCamera.setObjectTransform(obj.coords.fromLocal());
                Rectangle bounds = this.theCamera.findScreenBounds(obj.getBounds());
                if (bounds == null) continue;
                this.drawBox(bounds.x, bounds.y, hsize, hsize, col);
                this.drawBox(bounds.x + bounds.width - hsize + 1, bounds.y, hsize, hsize, col);
                this.drawBox(bounds.x, bounds.y + bounds.height - hsize + 1, hsize, hsize, col);
                this.drawBox(bounds.x + bounds.width - hsize + 1, bounds.y + bounds.height - hsize + 1, hsize, hsize, col);
                this.drawBox(bounds.x + (bounds.width - hsize) / 2, bounds.y, hsize, hsize, col);
                this.drawBox(bounds.x, bounds.y + (bounds.height - hsize) / 2, hsize, hsize, col);
                this.drawBox(bounds.x + (bounds.width - hsize) / 2, bounds.y + bounds.height - hsize + 1, hsize, hsize, col);
                this.drawBox(bounds.x + bounds.width - hsize + 1, bounds.y + (bounds.height - hsize) / 2, hsize, hsize, col);
            }
        }
        this.drawBorder();
        if (this.showAxes) {
            this.drawCoordinateAxes();
        }
    }

    public void beginDraggingBox(Point p, boolean square) {
        this.draggingBox = true;
        this.clickPoint = p;
        this.squareBox = square;
        this.dragPoint = null;
    }

    protected void mousePressed(WidgetMouseEvent e) {
        ObjectInfo info;
        int i;
        Rectangle bounds = null;
        this.requestFocus();
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = true;
        this.clickPoint = e.getPoint();
        this.clickedObject = null;
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if ((this.activeTool.whichClicks() & 1) != 0) {
            this.moveToGrid(e);
            this.activeTool.mousePressed(e, this);
            return;
        }
        Point p = e.getPoint();
        int[] sel = this.theScene.getSelection();
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            this.theCamera.setObjectTransform(info.coords.fromLocal());
            bounds = this.theCamera.findScreenBounds(info.getBounds());
            if (bounds == null || !this.pointInRectangle(p, bounds)) continue;
            this.clickedObject = info;
            break;
        }
        if (i < sel.length) {
            if (e.isShiftDown()) {
                this.deselect = sel[i];
            }
            if ((this.activeTool.whichClicks() & 4) != 0) {
                int j = p.x <= bounds.x + 4 ? 0 : (p.x >= bounds.x + (bounds.width - 4) / 2 && p.x <= bounds.x + (bounds.width - 4) / 2 + 4 ? 1 : (p.x >= bounds.x + bounds.width - 4 ? 2 : -1));
                int k = p.y <= bounds.y + 4 ? 0 : (p.y >= bounds.y + (bounds.height - 4) / 2 && p.y <= bounds.y + (bounds.height - 4) / 2 + 4 ? 1 : (p.y >= bounds.y + bounds.height - 4 ? 2 : -1));
                if (k == 0) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], j);
                    return;
                }
                if (j == 0 && k == 1) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], 3);
                    return;
                }
                if (j == 2 && k == 1) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], 4);
                    return;
                }
                if (k == 2) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], j + 5);
                    return;
                }
            }
            this.moveToGrid(e);
            this.dragging = false;
            if ((this.activeTool.whichClicks() & 2) != 0) {
                this.activeTool.mousePressedOnObject(e, this, sel[i]);
            } else {
                this.sentClick = false;
            }
            return;
        }
        int j = -1;
        int minarea = Integer.MAX_VALUE;
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            info = this.theScene.getObject(i);
            if (!info.visible) continue;
            this.theCamera.setObjectTransform(info.coords.fromLocal());
            bounds = this.theCamera.findScreenBounds(info.getBounds());
            if (bounds == null || !this.pointInRectangle(p, bounds) || bounds.width * bounds.height >= minarea) continue;
            j = i;
            minarea = bounds.width * bounds.height;
        }
        if (j > -1) {
            info = this.theScene.getObject(j);
            if (!e.isShiftDown()) {
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).clearSelection();
                } else {
                    this.theScene.clearSelection();
                }
            }
            if (this.parentFrame instanceof LayoutWindow) {
                this.parentFrame.setUndoRecord(new UndoRecord(this.parentFrame, false, 16, new Object[]{sel}));
                ((LayoutWindow)this.parentFrame).addToSelection(j);
            } else {
                this.theScene.addToSelection(j);
            }
            this.parentFrame.updateMenus();
            this.parentFrame.updateImage();
            this.moveToGrid(e);
            if ((this.activeTool.whichClicks() & 2) != 0 && !e.isShiftDown()) {
                this.activeTool.mousePressedOnObject(e, this, j);
            } else {
                this.sentClick = false;
            }
            this.clickedObject = info;
            return;
        }
        this.moveToGrid(e);
        this.draggingSelectionBox = true;
        this.beginDraggingBox(p, false);
        this.sentClick = false;
    }

    private boolean pointInRectangle(Point p, Rectangle r) {
        return r.x - 1 <= p.x && r.y - 1 <= p.y && r.x + r.width + 1 >= p.x && r.y + r.height + 1 >= p.y;
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        this.moveToGrid(e);
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        if (this.draggingBox) {
            if (this.dragPoint != null) {
                this.drawDraggedShape(new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y)));
            }
            this.dragPoint = e.getPoint();
            if (this.squareBox) {
                if (Math.abs(this.dragPoint.x - this.clickPoint.x) > Math.abs(this.dragPoint.y - this.clickPoint.y)) {
                    this.dragPoint.y = this.dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(this.dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(this.dragPoint.x - this.clickPoint.x);
                } else {
                    this.dragPoint.x = this.dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(this.dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(this.dragPoint.y - this.clickPoint.y);
                }
            }
            this.drawDraggedShape(new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y)));
        }
        if (this.sentClick) {
            this.activeTool.mouseDragged(e, this);
        }
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        int[] newSelection;
        ObjectInfo info;
        int[] sel = this.theScene.getSelection();
        this.moveToGrid(e);
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        int[] oldSelection = this.theScene.getSelection();
        if (this.draggingSelectionBox) {
            this.dragPoint = e.getPoint();
            Rectangle r = new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
            if (!e.isShiftDown()) {
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).clearSelection();
                } else {
                    this.theScene.clearSelection();
                }
                this.parentFrame.updateMenus();
            }
            for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
                int j;
                info = this.theScene.getObject(i);
                if (!info.visible) continue;
                this.theCamera.setObjectTransform(info.coords.fromLocal());
                Rectangle b = this.theCamera.findScreenBounds(info.getBounds());
                if (b == null || b.x >= r.x + r.width || b.y >= r.y + r.height || r.x >= b.x + b.width || r.y >= b.y + b.height) continue;
                if (!e.isShiftDown()) {
                    if (this.parentFrame instanceof LayoutWindow) {
                        ((LayoutWindow)this.parentFrame).addToSelection(i);
                    } else {
                        this.theScene.addToSelection(i);
                    }
                    this.parentFrame.updateMenus();
                    continue;
                }
                for (j = 0; j < sel.length && sel[j] != i; ++j) {
                }
                if (j != sel.length) continue;
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).addToSelection(i);
                } else {
                    this.theScene.addToSelection(i);
                }
                this.parentFrame.updateMenus();
            }
            if (this.currentTool.hilightSelection()) {
                this.parentFrame.updateImage();
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.deselect > -1) {
            info = this.theScene.getObject(this.deselect);
            if (this.parentFrame instanceof LayoutWindow) {
                ((LayoutWindow)this.parentFrame).removeFromSelection(this.deselect);
            } else {
                this.theScene.removeFromSelection(this.deselect);
            }
            this.parentFrame.updateMenus();
            this.parentFrame.updateImage();
        }
        boolean changed = oldSelection.length != (newSelection = this.theScene.getSelection()).length;
        for (int i = 0; i < newSelection.length && !changed; changed |= oldSelection[i] != newSelection[i], ++i) {
        }
        if (changed) {
            this.parentFrame.setUndoRecord(new UndoRecord(this.parentFrame, false, 16, new Object[]{oldSelection}));
        }
    }

    public void mouseClicked(MouseClickedEvent e) {
        if (e.getClickCount() == 2 && (this.activeTool.whichClicks() & 2) != 0 && this.clickedObject != null && this.clickedObject.object.isEditable()) {
            final Object3D obj = this.clickedObject.object;
            this.parentFrame.setUndoRecord(new UndoRecord(this.parentFrame, false, 0, new Object[]{obj, obj.duplicate()}));
            obj.edit(this.parentFrame, this.clickedObject, new Runnable(){

                public void run() {
                    SceneViewer.this.theScene.objectModified(obj);
                    SceneViewer.this.parentFrame.updateImage();
                    SceneViewer.this.parentFrame.updateMenus();
                }
            });
        }
    }

    protected void processMouseScrolled(MouseScrolledEvent ev) {
        if (this.isPerspective() && this.boundCamera != null) {
            UndoRecord undo = new UndoRecord(this.getEditingWindow(), false);
            super.processMouseScrolled(ev);
            this.moveChildren(this.boundCamera, this.theCamera.getCameraCoordinates().fromLocal().times(this.boundCamera.coords.toLocal()), undo);
            this.getEditingWindow().setUndoRecord(undo);
            this.getEditingWindow().updateImage();
        } else {
            super.processMouseScrolled(ev);
        }
    }

    private void moveChildren(ObjectInfo obj, Mat4 transform, UndoRecord undo) {
        CoordinateSystem coords = obj.coords;
        CoordinateSystem oldCoords = coords.duplicate();
        coords.transformCoordinates(transform);
        undo.addCommand(1, new Object[]{coords, oldCoords});
        for (int i = 0; i < obj.children.length; ++i) {
            this.moveChildren(obj.children[i], transform, undo);
        }
    }
}

