/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.KeyPressedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BRadioButton;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RadioButtonGroup;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Insets;
import java.util.Iterator;

public class TransformDialog
extends BDialog {
    private double[] initialValues;
    private double[] finalValues;
    private ValueField[] fields;
    private BCheckBox childrenBox;
    private BRadioButton objectCenterBox;
    private BRadioButton selectionCenterBox;
    private RadioButtonGroup centerGroup;
    private boolean clicked;
    private boolean ok;
    private static boolean children = true;
    private static boolean selectionCenter = true;

    public TransformDialog(BFrame parent, String title, double[] values, boolean transformLabels, boolean extraOptions) {
        super(parent, title, true);
        this.finalValues = values;
        this.initialValues = values;
        this.fields = new ValueField[9];
        this.layoutDialog(transformLabels, extraOptions);
        this.pack();
        this.setResizable(false);
        UIUtilities.centerWindow(this);
        this.fields[0].requestFocus();
        this.setVisible(true);
    }

    public TransformDialog(BFrame parent, String title, boolean transformLabels, boolean extraOptions) {
        this(parent, title, new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN}, transformLabels, extraOptions);
    }

    public double[] getValues() {
        return this.finalValues;
    }

    public boolean clickedOk() {
        return this.ok;
    }

    public boolean applyToChildren() {
        return children;
    }

    public boolean useSelectionCenter() {
        return selectionCenter;
    }

    void layoutDialog(boolean transformLabels, boolean extraOptions) {
        BorderContainer content = new BorderContainer();
        this.setContent(BOutline.createEmptyBorder(content, ModellingApp.standardDialogInsets));
        FormContainer center = new FormContainer(4, extraOptions ? 6 : 4);
        content.add(center, BorderContainer.CENTER);
        LayoutInfo eastLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        if (transformLabels) {
            center.add(Translate.label("Move"), 0, 1, eastLayout);
            center.add(Translate.label("Rotate"), 0, 2, eastLayout);
            center.add(Translate.label("Scale"), 0, 3, eastLayout);
        } else {
            center.add(Translate.label("Position"), 0, 1, eastLayout);
            center.add(Translate.label("Orientation"), 0, 2, eastLayout);
            center.add(Translate.label("Size"), 0, 3, eastLayout);
        }
        LayoutInfo centerLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, null, null);
        center.add(new BLabel("X"), 1, 0, centerLayout);
        center.add(new BLabel("Y"), 2, 0, centerLayout);
        center.add(new BLabel("Z"), 3, 0, centerLayout);
        for (int i = 0; i < 9; ++i) {
            this.fields[i] = new ValueField(this.initialValues[i], 0);
            center.add(this.fields[i], i % 3 + 1, i / 3 + 1);
        }
        if (extraOptions) {
            this.childrenBox = new BCheckBox(Translate.text("applyToUnselectedChildren"), children);
            center.add(this.childrenBox, 0, 4, 4, 1);
            FormContainer extra = new FormContainer(2, 2);
            center.add(extra, 0, 5, 4, 1);
            extra.add(new BLabel(Translate.text("rotateScaleAround")), 0, 0, 1, 2, eastLayout);
            this.centerGroup = new RadioButtonGroup();
            LayoutInfo westLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
            this.objectCenterBox = new BRadioButton(Translate.text("individualObjectCenters"), !selectionCenter, this.centerGroup);
            extra.add(this.objectCenterBox, 1, 0, westLayout);
            this.selectionCenterBox = new BRadioButton(Translate.text("centerOfSelection"), selectionCenter, this.centerGroup);
            extra.add(this.selectionCenterBox, 1, 1, westLayout);
        }
        RowContainer buttons = new RowContainer();
        content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "dispose"));
        this.addEventLink(WindowClosingEvent.class, (Object)this, "dispose");
        this.addAsListener(this);
    }

    private void doOk() {
        this.finalValues = new double[9];
        for (int i = 0; i < this.finalValues.length; ++i) {
            this.finalValues[i] = this.fields[i].getValue();
        }
        if (this.childrenBox != null) {
            children = this.childrenBox.getState();
        }
        if (this.centerGroup != null) {
            selectionCenter = this.centerGroup.getSelection() == this.selectionCenterBox;
        }
        this.ok = true;
        this.dispose();
    }

    private void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if (code == 10) {
            this.doOk();
        }
        if (code == 27) {
            this.dispose();
        }
    }

    private void addAsListener(Widget w) {
        w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        if (w instanceof WidgetContainer) {
            Iterator iter = ((WidgetContainer)w).getChildren().iterator();
            while (iter.hasNext()) {
                this.addAsListener((Widget)iter.next());
            }
        }
    }
}

