/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.MoveViewTool;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.view.SoftwareCanvasDrawer;
import buoy.event.RepaintEvent;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BStandardDialog;
import buoy.widget.ColumnContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import javax.imageio.ImageIO;

public class AnimationPreviewer
implements Runnable {
    private LayoutWindow window;
    private double originalTime;
    private ValueField widthField;
    private ValueField heightField;
    private ValueField startField;
    private ValueField endField;
    private ValueField fpsField;
    private BLabel timeLabel;
    private BLabel frameLabel;
    private Scene theScene;
    private ObjectInfo sceneCamera;
    private BComboBox camChoice;
    private BComboBox modeChoice;
    private SceneViewer canvas;
    private Thread previewThread;
    private BDialog display;
    private byte[][] imageData;
    private NumberFormat format;
    static int currentCamera = 0;
    static int width = 320;
    static int height = 240;
    static int fps = 15;
    static double startTime = 0.0;
    static double endTime = 1.0;

    public AnimationPreviewer(LayoutWindow parent) {
        ObjectInfo obj;
        int i;
        this.window = parent;
        this.theScene = this.window.getScene();
        int count = 0;
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            obj = this.theScene.getObject(i);
            if (!(obj.object instanceof SceneCamera)) continue;
            ++count;
        }
        if (count == 0) {
            new BStandardDialog("", Translate.text("noCameraError"), BStandardDialog.INFORMATION).showMessageDialog(this.window);
            return;
        }
        if (count <= currentCamera) {
            currentCamera = 0;
        }
        ObjectInfo[] cameras = new ObjectInfo[count];
        count = 0;
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            obj = this.theScene.getObject(i);
            if (!(obj.object instanceof SceneCamera)) continue;
            cameras[count++] = obj;
        }
        this.camChoice = new BComboBox();
        for (i = 0; i < cameras.length; ++i) {
            this.camChoice.add(cameras[i].name);
        }
        this.camChoice.setSelectedIndex(currentCamera);
        this.modeChoice = new BComboBox(new Object[]{Translate.text("menu.wireframeDisplay"), Translate.text("menu.shadedDisplay"), Translate.text("menu.smoothDisplay"), Translate.text("menu.texturedDisplay"), Translate.text("menu.transparentDisplay")});
        this.modeChoice.setSelectedIndex(parent.getView().getRenderMode());
        this.widthField = new ValueField((double)width, 7);
        this.heightField = new ValueField((double)height, 7);
        this.startField = new ValueField(startTime, 0);
        this.endField = new ValueField(endTime, 0);
        this.fpsField = new ValueField(fps, 7);
        ComponentsDialog dlg = new ComponentsDialog(this.window, Translate.text("renderPreview"), new Widget[]{this.camChoice, this.modeChoice, this.startField, this.endField, this.widthField, this.heightField, this.fpsField}, new String[]{Translate.text("Camera"), Translate.text("menu.displayMode"), Translate.text("StartTime"), Translate.text("EndTime"), Translate.text("Width"), Translate.text("Height"), Translate.text("FramesPerSec")});
        if (!dlg.clickedOk()) {
            return;
        }
        currentCamera = this.camChoice.getSelectedIndex();
        this.sceneCamera = cameras[currentCamera];
        width = (int)this.widthField.getValue();
        height = (int)this.heightField.getValue();
        startTime = this.startField.getValue();
        endTime = this.endField.getValue();
        fps = (int)this.fpsField.getValue();
        this.originalTime = this.theScene.getTime();
        this.display = new BDialog(this.window, Translate.text("Preview"), true);
        this.format = NumberFormat.getNumberInstance();
        this.format.setMaximumFractionDigits(3);
        ColumnContainer content = new ColumnContainer();
        this.display.setContent(BOutline.createEmptyBorder(content, ModellingApp.standardDialogInsets));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(2, 0, 2, 0), null));
        this.timeLabel = new BLabel();
        content.add(this.timeLabel);
        this.frameLabel = new BLabel();
        content.add(this.frameLabel);
        this.setLabels(0.0, 0);
        this.canvas = new SceneViewer(this.theScene, new RowContainer(), parent, true);
        content.add(this.canvas);
        this.canvas.setPreferredSize(new Dimension(width, height));
        this.canvas.setRenderMode(this.modeChoice.getSelectedIndex());
        this.canvas.setBoundCamera(this.sceneCamera);
        this.canvas.setPerspective(true);
        this.canvas.setTool(new MoveViewTool(parent){

            public boolean hilightSelection() {
                return false;
            }
        });
        content.add(Translate.button("close", this, "doClose"), new LayoutInfo());
        this.display.pack();
        UIUtilities.centerDialog(this.display, this.window);
        this.display.setResizable(false);
        this.previewThread = new Thread(this);
        this.previewThread.setPriority(4);
        this.previewThread.start();
        this.display.setVisible(true);
    }

    public void run() {
        int totalFrames = (int)Math.ceil((endTime - startTime) * (double)fps);
        if (totalFrames <= 0) {
            totalFrames = 1;
        }
        this.imageData = new byte[totalFrames][];
        Camera cam = this.canvas.getCamera();
        long lastUpdate = 0L;
        long delay = 1000 / fps;
        try {
            long ms;
            double time;
            int i;
            for (i = 0; i < totalFrames; ++i) {
                time = startTime + (double)i / (double)fps;
                this.theScene.setTime(time);
                SceneCamera sc = (SceneCamera)this.sceneCamera.object;
                cam.setCameraCoordinates(this.sceneCamera.coords.duplicate());
                cam.setDistToScreen((double)height / 200.0 / Math.tan(sc.getFieldOfView() * Math.PI / 360.0));
                final int frame = i;
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            AnimationPreviewer.this.setLabels(time, frame);
                            SoftwareCanvasDrawer drawer = (SoftwareCanvasDrawer)AnimationPreviewer.this.canvas.getCanvasDrawer();
                            Graphics2D canvasGraphics = (Graphics2D)AnimationPreviewer.this.canvas.getComponent().getGraphics();
                            drawer.paint(new RepaintEvent(AnimationPreviewer.this.canvas, canvasGraphics));
                            canvasGraphics.dispose();
                            ((AnimationPreviewer)AnimationPreviewer.this).imageData[frame] = AnimationPreviewer.this.recordImage(drawer.getImage());
                        }
                    });
                }
                catch (Exception ex) {
                    return;
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ms = System.currentTimeMillis();
                if (ms < lastUpdate + delay) {
                    try {
                        Thread.sleep(lastUpdate + delay - ms);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
                lastUpdate = System.currentTimeMillis();
            }
            while (!Thread.currentThread().isInterrupted()) {
                for (i = 0; i < totalFrames; ++i) {
                    time = startTime + (double)i / (double)fps;
                    final int frame = i;
                    final Image image = this.retrieveImage(this.imageData[i]);
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            public void run() {
                                AnimationPreviewer.this.setLabels(time, frame);
                                Graphics2D canvasGraphics = (Graphics2D)AnimationPreviewer.this.canvas.getComponent().getGraphics();
                                canvasGraphics.drawImage(image, 0, 0, null);
                                canvasGraphics.dispose();
                            }
                        });
                    }
                    catch (Exception ex) {
                        return;
                    }
                    ms = System.currentTimeMillis();
                    if (ms < lastUpdate + delay) {
                        try {
                            Thread.sleep(lastUpdate + delay - ms);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    lastUpdate = System.currentTimeMillis();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void doClose() {
        this.previewThread.interrupt();
        try {
            this.previewThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.theScene.setTime(this.originalTime);
        this.display.dispose();
    }

    private void setLabels(double time, int frame) {
        this.timeLabel.setText(Translate.text("Time") + ": " + this.format.format(time));
        this.frameLabel.setText(Translate.text("Frame") + ": " + (frame + 1));
    }

    private byte[] recordImage(BufferedImage image) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private Image retrieveImage(byte[] bytes) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(bytes));
    }
}

