/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Joint {
    public CoordinateSystem coords;
    public String name;
    public DOF angle1;
    public DOF angle2;
    public DOF twist;
    public DOF length;
    public Joint parent;
    public Joint[] children;
    public int id;

    public Joint(CoordinateSystem coords, Joint parentJoint, String name) {
        this.parent = parentJoint;
        this.children = new Joint[0];
        this.name = name;
        this.coords = coords;
        this.angle1 = new DOF(-180.0, 180.0, 0.0);
        this.angle2 = new DOF(-180.0, 180.0, 0.0);
        this.twist = new DOF(-180.0, 180.0, 0.0);
        this.twist.fixed = true;
        if (this.parent == null) {
            this.length = new DOF(0.0, 0.0, 0.0);
        } else {
            double d = coords.getOrigin().distance(this.parent.coords.getOrigin());
            this.length = new DOF(0.0, Double.MAX_VALUE, d);
            this.calcAnglesFromCoords(false);
        }
        this.length.fixed = true;
        this.twist.loop = true;
        this.angle2.loop = true;
        this.angle1.loop = true;
        this.id = -1;
    }

    private Joint() {
    }

    public Joint duplicate() {
        Joint j = new Joint();
        j.coords = this.coords.duplicate();
        j.name = this.name;
        j.angle1 = this.angle1.duplicate();
        j.angle2 = this.angle2.duplicate();
        j.twist = this.twist.duplicate();
        j.length = this.length.duplicate();
        j.id = this.id;
        return j;
    }

    public void copy(Joint j) {
        this.coords.copyCoords(j.coords);
        this.name = j.name;
        this.angle1.copy(j.angle1);
        this.angle2.copy(j.angle2);
        this.twist.copy(j.twist);
        this.length.copy(j.length);
        this.id = j.id;
    }

    public boolean equals(Joint j) {
        if (!(this.angle1.equals(j.angle1) && this.angle2.equals(j.angle2) && this.twist.equals(j.twist) && this.length.equals(j.length))) {
            return false;
        }
        return this.name.equals(j.name);
    }

    public void recalcCoords(boolean recursive) {
        if (this.parent == null) {
            this.coords.setOrientation(this.angle1.pos, this.angle2.pos, this.twist.pos);
        } else {
            Mat4 m = this.getTransform();
            Vec3 parentPos = this.parent.coords.getOrigin();
            Vec3 zdir = this.parent.coords.fromLocal().timesDirection(m.timesDirection(Vec3.vz()));
            Vec3 updir = this.parent.coords.fromLocal().timesDirection(m.timesDirection(Vec3.vy()));
            this.coords = new CoordinateSystem(parentPos.plus(zdir.times(this.length.pos)), zdir, updir);
        }
        if (recursive) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].recalcCoords(true);
            }
        }
    }

    public Mat4 getTransform() {
        double d = Math.PI / 180;
        return Mat4.yrotation(this.angle2.pos * d).times(Mat4.xrotation(this.angle1.pos * d)).times(Mat4.zrotation(this.twist.pos * d));
    }

    public Mat4 getInverseTransform() {
        double d = Math.PI / 180;
        return Mat4.zrotation(-this.twist.pos * d).times(Mat4.xrotation(-this.angle1.pos * d)).times(Mat4.yrotation(-this.angle2.pos * d));
    }

    public void calcAnglesFromCoords(boolean recursive) {
        double[] ang;
        CoordinateSystem c;
        if (this.parent == null) {
            c = this.coords;
            ang = c.getRotationAngles();
            this.angle1.pos = ang[0];
            this.angle2.pos = ang[1];
            this.twist.pos = ang[2];
        } else {
            c = this.coords.duplicate();
            c.transformAxes(this.parent.coords.toLocal());
            ang = c.getRotationAngles();
            this.angle1.pos = -ang[0];
            this.angle2.pos = -ang[1];
            this.twist.pos = -ang[2];
        }
        if (recursive) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].calcAnglesFromCoords(true);
            }
        }
    }

    public class DOF {
        public double min;
        public double max;
        public double minComfort;
        public double maxComfort;
        public double stiffness;
        public double pos;
        public boolean fixed;
        public boolean comfort;
        public boolean loop;

        public DOF(double min, double max, double pos) {
            this.min = this.minComfort = min;
            this.max = this.maxComfort = max;
            this.pos = pos;
        }

        public DOF duplicate() {
            DOF d = new DOF(this.min, this.max, this.pos);
            d.minComfort = this.minComfort;
            d.maxComfort = this.maxComfort;
            d.stiffness = this.stiffness;
            d.fixed = this.fixed;
            d.comfort = this.comfort;
            d.loop = this.loop;
            return d;
        }

        public void copy(DOF d) {
            this.pos = d.pos;
            this.min = d.min;
            this.max = d.max;
            this.minComfort = d.minComfort;
            this.maxComfort = d.maxComfort;
            this.stiffness = d.stiffness;
            this.fixed = d.fixed;
            this.comfort = d.comfort;
            this.loop = d.loop;
        }

        public boolean equals(DOF d) {
            if (this.fixed != d.fixed || this.comfort != d.comfort || this.loop != d.loop) {
                return false;
            }
            return this.pos == d.pos && this.min == d.min && this.max == d.max && this.minComfort == d.minComfort && this.maxComfort == d.maxComfort && this.stiffness == d.stiffness;
        }

        public void set(double val) {
            this.pos = val;
            while (this.pos > this.max) {
                if (this.loop) {
                    this.pos -= this.max - this.min;
                    continue;
                }
                this.pos = this.max;
            }
            while (this.pos < this.min) {
                if (this.loop) {
                    this.pos += this.max - this.min;
                    continue;
                }
                this.pos = this.min;
            }
        }

        public double getScaledForce(double f) {
            f *= 1.0 - this.stiffness;
            if (!this.comfort) {
                return f;
            }
            if (this.pos < this.minComfort && f < 0.0 && this.minComfort > this.min) {
                f *= (this.pos - this.min) / (this.minComfort - this.min);
            } else if (this.pos > this.maxComfort && f > 0.0 && this.maxComfort < this.max) {
                f *= (this.max - this.pos) / (this.max - this.maxComfort);
            }
            return f;
        }

        public double getForceScale(double f) {
            double scale = 1.0 - this.stiffness;
            if (!this.loop && (this.pos == this.min && f < 0.0 || this.pos == this.max && f > 0.0)) {
                return 0.0;
            }
            if (!this.comfort) {
                return scale;
            }
            if (this.pos < this.minComfort && f < 0.0 && this.minComfort > this.min) {
                scale *= (this.pos - this.min) / (this.minComfort - this.min);
            } else if (this.pos > this.maxComfort && f > 0.0 && this.maxComfort < this.max) {
                scale *= (this.max - this.pos) / (this.max - this.maxComfort);
            }
            return scale;
        }

        public double getClippedForce(double f) {
            if (this.loop) {
                return f;
            }
            if (this.pos + f < this.min) {
                f = this.min - this.pos;
            } else if (this.pos + f > this.max) {
                f = this.max - this.pos;
            }
            return f;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeDouble(this.pos);
            out.writeDouble(this.min);
            out.writeDouble(this.max);
            out.writeDouble(this.minComfort);
            out.writeDouble(this.maxComfort);
            out.writeDouble(this.stiffness);
            out.writeBoolean(this.fixed);
            out.writeBoolean(this.comfort);
        }

        public DOF(DataInputStream in) throws IOException {
            this.pos = in.readDouble();
            this.min = in.readDouble();
            this.max = in.readDouble();
            this.minComfort = in.readDouble();
            this.maxComfort = in.readDouble();
            this.stiffness = in.readDouble();
            this.fixed = in.readBoolean();
            this.comfort = in.readBoolean();
            this.loop = this.max - this.min == 360.0;
        }
    }
}

