/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Joint;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.Skeleton;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import java.util.Vector;

public class ObjectRefTreeElement
extends TreeElement {
    ObjectRef ref;
    boolean disabled;

    public ObjectRefTreeElement(ObjectRef obj, TreeElement parent, TreeList tree, ObjectInfo exclude) {
        this.ref = obj;
        this.parent = parent;
        this.tree = tree;
        this.children = new Vector();
        ObjectInfo info = this.ref.getObject();
        this.setEnabled(info != exclude);
        if (this.ref.getJoint() == null) {
            Skeleton s = info.getSkeleton();
            if (s != null) {
                Joint[] j = s.getJoints();
                for (int i = 0; i < j.length; ++i) {
                    this.children.addElement(new ObjectRefTreeElement(new ObjectRef(info, j[i]), this, tree, exclude));
                }
            }
            for (int i = 0; i < info.children.length; ++i) {
                this.children.addElement(new ObjectRefTreeElement(new ObjectRef(info.children[i]), this, tree, exclude));
            }
        }
    }

    public String getLabel() {
        Joint j = this.ref.getJoint();
        if (j != null) {
            return j.name;
        }
        return this.ref.getObject().name;
    }

    public boolean canAcceptAsParent(TreeElement el) {
        return false;
    }

    public void addChild(TreeElement el, int position) {
        this.children.insertElementAt(el, position);
        ((ObjectRefTreeElement)el).parent = this;
    }

    public void removeChild(Object object) {
    }

    public Object getObject() {
        return this.ref;
    }

    public void setEnabled(boolean enable) {
        this.disabled = !enable;
        this.setSelectable(enable);
    }

    public boolean isGray() {
        return this.disabled;
    }
}

