/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationKeyframe;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Smoothness;
import artofillusion.animation.VectorKeyframe;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BOutline;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.Vector;

public class PathFromCurveDialog
extends BDialog {
    private LayoutWindow window;
    private Scene theScene;
    private BList objList;
    private BList curveList;
    private Vector objects;
    private Vector curves;
    private BCheckBox orientBox;
    private BComboBox spacingChoice;
    private ValueField startTimeField;
    private ValueField endTimeField;
    private ValueField startSpeedField;
    private ValueField endSpeedField;
    private ValueField accelField;
    private BLabel speedLabel;
    private BLabel lengthLabel;
    private BButton okButton;
    private BButton cancelButton;
    private Vec3[] subdiv;
    private double curveLength;

    public PathFromCurveDialog(LayoutWindow win, Object[] sel) {
        super(win, Translate.text("pathFromCurveTitle"), true);
        this.window = win;
        this.theScene = this.window.getScene();
        this.objects = new Vector();
        this.curves = new Vector();
        this.objList = new BList();
        this.curveList = new BList();
        for (int i = 0; i < sel.length; ++i) {
            ObjectInfo info = (ObjectInfo)sel[i];
            if (info.object instanceof Curve) {
                this.curves.addElement(info);
                this.curveList.add(info.name);
                continue;
            }
            this.objects.addElement(info);
            this.objList.add(info.name);
        }
        this.objList.setMultipleSelectionEnabled(false);
        this.curveList.setMultipleSelectionEnabled(false);
        this.objList.setSelected(0, true);
        this.curveList.setSelected(0, true);
        this.objList.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        this.curveList.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        FormContainer content = new FormContainer(4, 5);
        this.setContent(BOutline.createEmptyBorder(content, ModellingApp.standardDialogInsets));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null));
        content.add(Translate.label("setPathOf"), 0, 0);
        content.add(UIUtilities.createScrollingList(this.objList), 1, 0);
        content.add(Translate.label("fromCurve"), 2, 0);
        content.add(UIUtilities.createScrollingList(this.curveList), 3, 0);
        this.orientBox = new BCheckBox(Translate.text("orientFollowsCurve"), true);
        content.add(this.orientBox, 0, 1, 4, 1);
        this.orientBox.addEventLink(ValueChangedEvent.class, (Object)this, "selectionChanged");
        RowContainer keyRow = new RowContainer();
        content.add(keyRow, 0, 2, 4, 1);
        keyRow.add(Translate.label("keyframeSpacing"));
        this.spacingChoice = new BComboBox(new String[]{Translate.text("uniformSpacing"), Translate.text("constantSpeed"), Translate.text("constantAccel")});
        keyRow.add(this.spacingChoice);
        this.spacingChoice.setSelectedIndex(1);
        this.spacingChoice.addEventLink(ValueChangedEvent.class, (Object)this, "selectionChanged");
        FormContainer fieldPanel = new FormContainer(2, 6);
        content.add(fieldPanel, 0, 3, 4, 1);
        LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
        this.lengthLabel = Translate.label("curveLength");
        fieldPanel.add(this.lengthLabel, 0, 0, leftLayout);
        fieldPanel.add(new BLabel(Translate.text("StartTime") + ":"), 0, 1, leftLayout);
        fieldPanel.add(new BLabel(Translate.text("EndTime") + ":"), 0, 2, leftLayout);
        this.speedLabel = Translate.label("initialSpeed");
        fieldPanel.add(this.speedLabel, 0, 3, leftLayout);
        fieldPanel.add(Translate.label("finalSpeed"), 0, 4, leftLayout);
        fieldPanel.add(Translate.label("acceleration"), 0, 5, leftLayout);
        this.lengthLabel = new BLabel();
        fieldPanel.add(this.lengthLabel, 1, 0, rightLayout);
        this.startTimeField = new ValueField(0.0, 0, 5);
        fieldPanel.add(this.startTimeField, 1, 1, rightLayout);
        this.endTimeField = new ValueField(1.0, 0, 5);
        fieldPanel.add(this.endTimeField, 1, 2, rightLayout);
        this.startSpeedField = new ValueField(1.0, 0, 5);
        fieldPanel.add(this.startSpeedField, 1, 3, rightLayout);
        this.endSpeedField = new ValueField(1.0, 0, 5);
        fieldPanel.add(this.endSpeedField, 1, 4, rightLayout);
        this.accelField = new ValueField(0.0, 0, 5);
        fieldPanel.add(this.accelField, 1, 5, rightLayout);
        this.startTimeField.addEventLink(ValueChangedEvent.class, (Object)this, "adjustTextFields");
        this.endTimeField.addEventLink(ValueChangedEvent.class, (Object)this, "adjustTextFields");
        this.startSpeedField.addEventLink(ValueChangedEvent.class, (Object)this, "adjustTextFields");
        this.endSpeedField.addEventLink(ValueChangedEvent.class, (Object)this, "adjustTextFields");
        this.accelField.addEventLink(ValueChangedEvent.class, (Object)this, "adjustTextFields");
        this.endTimeField.setValue(this.curveLength);
        RowContainer buttons = new RowContainer();
        content.add(buttons, 0, 4, 4, 1);
        this.okButton = Translate.button("ok", this, "doOk");
        buttons.add(this.okButton);
        this.cancelButton = Translate.button("cancel", this, "dispose");
        buttons.add(this.cancelButton);
        this.pack();
        this.updateComponents();
        UIUtilities.centerDialog(this, win);
        this.setVisible(true);
    }

    private void selectionChanged(WidgetEvent ev) {
        if (ev.getWidget() == this.curveList || ev.getWidget() == this.spacingChoice) {
            this.adjustTextFields(new ValueChangedEvent(this.startTimeField));
        }
        this.updateComponents();
        if (ev.getWidget() == this.spacingChoice) {
            this.startTimeField.requestFocus();
        }
    }

    private void doOk() {
        this.addTracks();
        this.dispose();
    }

    private void updateComponents() {
        int spacing = this.spacingChoice.getSelectedIndex();
        this.speedLabel.setText(Translate.text(spacing == 2 ? "initialSpeed" : "speed"));
        this.startSpeedField.setEnabled(spacing != 0);
        this.endSpeedField.setEnabled(spacing == 2);
        this.accelField.setEnabled(spacing == 2);
        this.okButton.setEnabled(this.objList.getSelectedIndex() > -1 && this.curveList.getSelectedIndex() > -1 && (spacing == 0 || this.startTimeField.getValue() != this.endTimeField.getValue()));
        if (this.curveList.getSelectedIndex() > -1) {
            int i;
            ObjectInfo info = (ObjectInfo)this.curves.elementAt(this.curveList.getSelectedIndex());
            Curve cv = (Curve)info.object;
            MeshVertex[] vert = cv.getVertices();
            Vec3[] v = new Vec3[vert.length];
            Mat4 trans = info.coords.fromLocal();
            for (i = 0; i < v.length; ++i) {
                v[i] = trans.times(vert[i].r);
            }
            this.subdiv = new Curve(v, cv.getSmoothness(), cv.getSmoothingMethod(), cv.isClosed()).subdivideCurve(4).getVertexPositions();
            this.curveLength = 0.0;
            for (i = 1; i < this.subdiv.length; ++i) {
                this.curveLength += this.subdiv[i].distance(this.subdiv[i - 1]);
            }
            if (cv.isClosed()) {
                this.curveLength += this.subdiv[this.subdiv.length - 1].distance(this.subdiv[0]);
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(3);
            this.lengthLabel.setText(nf.format(this.curveLength));
            this.lengthLabel.getParent().layoutChildren();
        }
    }

    private void adjustTextFields(ValueChangedEvent ev) {
        Widget src = ev.getWidget();
        int spacing = this.spacingChoice.getSelectedIndex();
        double startTime = this.startTimeField.getValue();
        double endTime = this.endTimeField.getValue();
        double startSpeed = this.startSpeedField.getValue();
        double endSpeed = this.endSpeedField.getValue();
        double accel = this.accelField.getValue();
        double time = endTime - startTime;
        if (startTime == endTime) {
            this.okButton.setEnabled(false);
            return;
        }
        if (spacing == 0) {
            return;
        }
        if (spacing == 1) {
            if (src == this.startSpeedField) {
                this.endTimeField.setValue(startTime + this.curveLength / startSpeed);
            } else {
                this.startSpeedField.setValue(this.curveLength / (endTime - startTime));
            }
            this.okButton.setEnabled(true);
            return;
        }
        if (src == this.accelField) {
            if (accel == 0.0) {
                if (endSpeed == 0.0) {
                    endSpeed = startSpeed;
                } else {
                    startSpeed = endSpeed;
                }
                if (startSpeed == 0.0) {
                    this.okButton.setEnabled(false);
                    return;
                }
                time = this.curveLength / startSpeed;
            } else {
                time = (-startSpeed + Math.sqrt(startSpeed * startSpeed + 2.0 * accel * this.curveLength)) / accel;
                endSpeed = startSpeed + time * accel;
            }
            this.endTimeField.setValue(startTime + time);
            this.startSpeedField.setValue(startSpeed);
            this.endSpeedField.setValue(endSpeed);
            this.okButton.setEnabled(true);
            return;
        }
        if (startSpeed == 0.0 && endSpeed == 0.0) {
            this.okButton.setEnabled(false);
            return;
        }
        if (src == this.startSpeedField || src == this.endSpeedField) {
            accel = (endSpeed * endSpeed - startSpeed * startSpeed) / (2.0 * this.curveLength);
            endTime = accel == 0.0 ? startTime + this.curveLength / startSpeed : startTime + (endSpeed - startSpeed) / accel;
            this.accelField.setValue(accel);
            this.endTimeField.setValue(endTime);
        } else {
            accel = 2.0 * (this.curveLength - startSpeed * time) / (time * time);
            endSpeed = startSpeed + accel * time;
            this.accelField.setValue(accel);
            this.endSpeedField.setValue(endSpeed);
        }
        this.okButton.setEnabled(true);
    }

    private void addTracks() {
        ObjectInfo info = (ObjectInfo)this.curves.elementAt(this.curveList.getSelectedIndex());
        Mat4 trans = info.coords.fromLocal();
        Curve cv = (Curve)info.object;
        MeshVertex[] vert = cv.getVertices();
        int n = cv.isClosed() ? vert.length + 1 : vert.length;
        double[] dist = new double[n];
        double[] time = new double[n];
        String curveName = info.name;
        int k = cv.getSmoothingMethod() == 0 ? 1 : 16;
        for (int i = 1; i < vert.length; ++i) {
            dist[i] = dist[i - 1];
            for (int j = 0; j < k; ++j) {
                int n2 = i;
                dist[n2] = dist[n2] + this.subdiv[(i - 1) * k + j].distance(this.subdiv[(i - 1) * k + 1 + j]);
            }
        }
        if (cv.isClosed()) {
            dist[n - 1] = this.curveLength;
        }
        int spacing = this.spacingChoice.getSelectedIndex();
        int fps = this.theScene.getFramesPerSecond();
        double startTime = this.startTimeField.getValue();
        double endTime = this.endTimeField.getValue();
        double startSpeed = this.startSpeedField.getValue();
        double endSpeed = this.endSpeedField.getValue();
        double accel = this.accelField.getValue();
        double totalTime = endTime - startTime;
        for (int i = 0; i < n; ++i) {
            time[i] = spacing == 0 ? startTime + (double)i * totalTime / (double)(n - 1) : (spacing == 1 || accel == 0.0 ? startTime + dist[i] / startSpeed : startTime + (-startSpeed + Math.sqrt(startSpeed * startSpeed + 2.0 * accel * dist[i])) / accel);
            time[i] = (double)Math.round(time[i] * (double)fps) / (double)fps;
        }
        info = (ObjectInfo)this.objects.elementAt(this.objList.getSelectedIndex());
        this.window.setUndoRecord(new UndoRecord(this.window, false, 11, new Object[]{info, info.tracks}));
        float[] smoothness = cv.getSmoothness();
        PositionTrack tr = new PositionTrack(info);
        tr.setName(curveName + " Position");
        for (int i = 0; i < vert.length; ++i) {
            tr.setKeyframe(time[i], new VectorKeyframe(trans.times(vert[i].r)), new Smoothness(smoothness[i]));
        }
        if (n > vert.length) {
            tr.setKeyframe(time[vert.length], new VectorKeyframe(trans.times(vert[0].r)), new Smoothness(smoothness[0]));
        }
        if (cv.getSmoothingMethod() == 0) {
            tr.setSmoothingMethod(1);
        } else if (cv.getSmoothingMethod() == 2) {
            tr.setSmoothingMethod(2);
        } else {
            tr.setSmoothingMethod(3);
        }
        info.addTrack(tr, 0);
        if (this.orientBox.getState()) {
            RotationTrack tr2 = new RotationTrack(info);
            tr2.setName(curveName + " Rotation");
            Vec3 zdir = k != 1 && cv.isClosed() ? this.subdiv[1].minus(this.subdiv[this.subdiv.length - 1]) : this.subdiv[1].minus(this.subdiv[0]);
            zdir.normalize();
            Vec3 updir = Vec3.vy();
            double dot = zdir.dot(updir);
            if (Math.abs(dot) > 0.99) {
                updir = Vec3.vx();
                dot = zdir.dot(updir);
            }
            updir.subtract(zdir.times(dot));
            updir.normalize();
            CoordinateSystem coords = new CoordinateSystem(new Vec3(), zdir, updir);
            RotationKeyframe lastKey = new RotationKeyframe(coords);
            tr2.setKeyframe(time[0], lastKey, new Smoothness(smoothness[0]));
            double d = 0.0;
            int interval = cv.getSmoothingMethod() == 0 ? 1 : 8;
            for (int i = 1; i < this.subdiv.length; ++i) {
                zdir = i == this.subdiv.length - 1 ? (!cv.isClosed() ? this.subdiv[this.subdiv.length - 1].minus(this.subdiv[this.subdiv.length - 2]) : (k == 1 ? this.subdiv[0].minus(this.subdiv[this.subdiv.length - 1]) : this.subdiv[0].minus(this.subdiv[this.subdiv.length - 2]))) : (k == 1 ? this.subdiv[i + 1].minus(this.subdiv[i]) : this.subdiv[i + 1].minus(this.subdiv[i - 1]));
                zdir.normalize();
                updir = updir.minus(zdir.times(zdir.dot(updir)));
                updir.normalize();
                d += this.subdiv[i - 1].distance(this.subdiv[i]);
                if (i % interval != 0) continue;
                coords.setOrientation(zdir, updir);
                RotationKeyframe nextKey = new RotationKeyframe(coords);
                if (nextKey.x - lastKey.x > 180.0) {
                    nextKey.x -= 360.0;
                }
                if (nextKey.x - lastKey.x < -180.0) {
                    nextKey.x += 360.0;
                }
                if (nextKey.y - lastKey.y > 180.0) {
                    nextKey.y -= 360.0;
                }
                if (nextKey.y - lastKey.y < -180.0) {
                    nextKey.y += 360.0;
                }
                if (nextKey.z - lastKey.z > 180.0) {
                    nextKey.z -= 360.0;
                }
                if (nextKey.z - lastKey.z < -180.0) {
                    nextKey.z += 360.0;
                }
                double t = spacing == 0 ? startTime + (double)i * totalTime / (double)(this.subdiv.length - 1) : (spacing == 1 || accel == 0.0 ? startTime + d / startSpeed : startTime + (-startSpeed + Math.sqrt(startSpeed * startSpeed + 2.0 * accel * d)) / accel);
                t = (double)Math.round(t * (double)fps) / (double)fps;
                this.validateKeyframe(lastKey, nextKey);
                if (k == 1 || i % k == 0 && (double)smoothness[i / k] == 0.0) {
                    tr2.setKeyframe(t - 1.0 / (double)fps, new RotationKeyframe(lastKey.x, lastKey.y, lastKey.z), new Smoothness());
                }
                tr2.setKeyframe(t, nextKey, new Smoothness());
                lastKey = nextKey;
            }
            if (cv.getSmoothingMethod() == 0) {
                tr2.setSmoothingMethod(1);
            } else if (cv.getSmoothingMethod() == 2) {
                tr2.setSmoothingMethod(2);
            } else {
                tr2.setSmoothingMethod(3);
            }
            tr2.setUseQuaternion(true);
            info.addTrack(tr2, 1);
        }
        startTime = (double)Math.round(startTime * (double)fps) / (double)fps;
        this.window.getScore().rebuildList();
        this.window.setTime(startTime);
    }

    private void validateKeyframe(RotationKeyframe r1, RotationKeyframe r2) {
        CoordinateSystem coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        RotationKeyframe r3 = (RotationKeyframe)r1.blend(r2, 0.75, 0.25);
        Vec3 mid = new Vec3();
        coords.setOrientation(r1.x, r1.y, r1.z);
        Vec3 u1 = new Vec3(coords.getUpDirection());
        Vec3 z1 = new Vec3(coords.getZDirection());
        coords.setOrientation(r2.x, r2.y, r2.z);
        Vec3 u2 = new Vec3(coords.getUpDirection());
        Vec3 z2 = new Vec3(coords.getZDirection());
        coords.setOrientation(r3.x, r3.y, r3.z);
        Vec3 u3 = new Vec3(coords.getUpDirection());
        Vec3 z3 = new Vec3(coords.getZDirection());
        boolean upcheck = u1.dot(u3) < 0.0 || u2.dot(u3) < 0.0;
        boolean zcheck = z1.dot(z3) < 0.0 || z2.dot(z3) < 0.0;
        mid.set(u1.x + u2.x, u1.y + u2.y, u1.z + u2.z);
        mid.normalize();
        upcheck = mid.dot(u3) < 0.2;
        mid.set(z1.x + z2.x, z1.y + z2.y, z1.z + z2.z);
        mid.normalize();
        boolean bl = zcheck = mid.dot(z3) < 0.2;
        if (upcheck || zcheck) {
            r2.z = r2.z < r1.z ? (r2.z += 360.0) : (r2.z -= 360.0);
        }
    }
}

