/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Smoothness {
    private double s1;
    private double s2;
    private boolean same;

    public Smoothness() {
        this.s2 = 1.0;
        this.s1 = 1.0;
        this.same = true;
    }

    public Smoothness(double s) {
        this.s1 = this.s2 = s;
        this.same = true;
    }

    public Smoothness duplicate() {
        Smoothness sm = new Smoothness();
        sm.s1 = this.s1;
        sm.s2 = this.s2;
        sm.same = this.same;
        return sm;
    }

    public double getLeftSmoothness() {
        return this.s1;
    }

    public double getRightSmoothness() {
        return this.s2;
    }

    public void setSmoothness(double s) {
        this.s1 = this.s2 = s;
        this.same = true;
    }

    public void setSmoothness(double left, double right) {
        this.s1 = left;
        this.s2 = right;
        this.same = false;
    }

    public boolean isForceSame() {
        return this.same;
    }

    public Smoothness getSmoother() {
        Smoothness sm = new Smoothness();
        sm.s1 = Math.min(this.s1 * 2.0, 1.0);
        sm.s2 = this.same ? this.s1 : Math.min(this.s2 * 2.0, 1.0);
        sm.same = this.same;
        return sm;
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeDouble(this.s1);
        if (this.same) {
            out.writeDouble(Double.NaN);
        } else {
            out.writeDouble(this.s2);
        }
    }

    public Smoothness(DataInputStream in) throws IOException {
        this.s1 = in.readDouble();
        this.s2 = in.readDouble();
        this.same = Double.isNaN(this.s2);
        if (this.same) {
            this.s2 = this.s1;
        }
    }
}

