/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.VectorKeyframe;
import artofillusion.animation.WeightTrack;
import artofillusion.animation.distortion.ScaleDistortion;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ScaleTrack
extends Track {
    ObjectInfo info;
    Timecourse tc;
    int smoothingMethod;
    WeightTrack theWeight;
    boolean worldCoords;

    public ScaleTrack(ObjectInfo info) {
        super("Scale");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.theWeight = new WeightTrack(this);
        this.worldCoords = false;
    }

    public void apply(double time) {
        VectorKeyframe scale = (VectorKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (scale == null) {
            return;
        }
        double weight = this.theWeight.getWeight(time);
        double w2 = 1.0 - weight;
        if (this.worldCoords) {
            this.info.addDistortion(new ScaleDistortion(scale.x * weight + w2, scale.y * weight + w2, scale.z * weight + w2, this.info.coords.fromLocal(), this.info.coords.toLocal()));
        } else {
            this.info.addDistortion(new ScaleDistortion(scale.x * weight + w2, scale.y * weight + w2, scale.z * weight + w2, null, null));
        }
    }

    public Track duplicate(Object obj) {
        ScaleTrack t = new ScaleTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.smoothingMethod = this.smoothingMethod;
        t.worldCoords = this.worldCoords;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        ScaleTrack t = (ScaleTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.smoothingMethod = t.smoothingMethod;
        this.worldCoords = t.worldCoords;
        this.tc = t.tc.duplicate(this.info);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        Keyframe k = this.tc.evaluate(time, this.smoothingMethod);
        k = k == null ? new VectorKeyframe(1.0, 1.0, 1.0) : k.duplicate();
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        return new String[]{"X Scale", "Y Scale", "Z Scale"};
    }

    public double[] getDefaultGraphValues() {
        return new double[]{1.0, 1.0, 1.0};
    }

    public double[][] getValueRange() {
        double[][] range = new double[3][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = -1.7976931348623157E308;
            range[i][1] = Double.MAX_VALUE;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeBoolean(this.worldCoords);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            ((VectorKeyframe)v[i]).writeToFile(out);
            s[i].writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.worldCoords = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new VectorKeyframe(new Vec3(in));
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
        this.theWeight.initFromStream(in, scene);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        VectorKeyframe key = (VectorKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField xField = new ValueField(key.x, 0, 5);
        ValueField yField = new ValueField(key.y, 0, 5);
        ValueField zField = new ValueField(key.z, 0, 5);
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        String scale = Translate.text("Scale");
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), new Widget[]{xField, yField, zField, timeField, sameBox, new BLabel(Translate.text("Smoothness") + ':'), s1Slider, s2Slider}, new String[]{"X " + scale, "Y " + scale, "Z " + scale, Translate.text("Time"), null, null, "(" + Translate.text("left") + ")", "(" + Translate.text("right") + ")"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        key.x = xField.getValue();
        key.y = yField.getValue();
        key.z = zField.getValue();
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        BComboBox coordsChoice = new BComboBox(new String[]{Translate.text("Local"), Translate.text("World")});
        coordsChoice.setSelectedIndex(this.worldCoords ? 1 : 0);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("scaleTrackTitle"), new Widget[]{nameField, smoothChoice, coordsChoice}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod"), Translate.text("CoordinateSystem")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.worldCoords = coordsChoice.getSelectedIndex() == 1;
    }
}

