/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.keystroke;

import artofillusion.ApplicationPreferences;
import artofillusion.SafeFileOutputStream;
import artofillusion.keystroke.KeystrokeRecord;
import artofillusion.script.ScriptRunner;
import artofillusion.ui.EditingWindow;
import bsh.EvalError;
import bsh.Interpreter;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class KeystrokeManager {
    private static ArrayList records = new ArrayList();
    private static HashMap keyIndex = new HashMap();
    private static final String KEYSTROKE_FILENAME = "keystrokes.xml";

    public static KeystrokeRecord[] getAllRecords() {
        return records.toArray(new KeystrokeRecord[records.size()]);
    }

    public static void setAllRecords(KeystrokeRecord[] allRecords) {
        records.clear();
        for (int i = 0; i < allRecords.length; ++i) {
            records.add(allRecords[i]);
        }
        KeystrokeManager.recordModified();
    }

    public static void addRecord(KeystrokeRecord record) {
        records.add(record);
        KeystrokeManager.recordModified();
    }

    public static void removeRecord(KeystrokeRecord record) {
        records.remove(record);
        KeystrokeManager.recordModified();
    }

    public static void recordModified() {
        keyIndex = null;
    }

    public static void executeKeystrokes(KeyEvent event, EditingWindow window) {
        ArrayList list;
        if (keyIndex == null) {
            keyIndex = new HashMap(records.size());
            for (int i = 0; i < records.size(); ++i) {
                KeystrokeRecord record = (KeystrokeRecord)records.get(i);
                ArrayList<KeystrokeRecord> list2 = (ArrayList<KeystrokeRecord>)keyIndex.get(new Integer(record.getKeyCode()));
                if (list2 == null) {
                    list2 = new ArrayList<KeystrokeRecord>(1);
                    keyIndex.put(new Integer(record.getKeyCode()), list2);
                }
                list2.add(record);
            }
        }
        if ((list = (ArrayList)keyIndex.get(new Integer(event.getKeyCode()))) == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            KeystrokeRecord record = (KeystrokeRecord)list.get(i);
            if (record.getModifiers() != event.getModifiers()) continue;
            Interpreter interpreter = ScriptRunner.getInterpreter();
            try {
                interpreter.set("window", window);
                interpreter.eval(record.getScript());
            }
            catch (EvalError error) {
                error.printStackTrace();
            }
            event.consume();
        }
    }

    public static void loadRecords() {
        try {
            File dir2 = ApplicationPreferences.getPreferencesDirectory();
            File inputFile = new File(dir2, KEYSTROKE_FILENAME);
            InputStream in = inputFile.exists() ? new BufferedInputStream(new FileInputStream(inputFile)) : KeystrokeManager.class.getResourceAsStream("/keystrokes.xml");
            KeystrokeManager.addRecordsFromXML(in);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addRecordsFromXML(InputStream in) throws Exception {
        HashMap existing = new HashMap();
        for (int i = 0; i < records.size(); ++i) {
            existing.put(((KeystrokeRecord)records.get(i)).getName(), records.get(i));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        NodeList keystrokes = doc.getElementsByTagName("keystroke");
        for (int i = 0; i < keystrokes.getLength(); ++i) {
            Node keystroke = keystrokes.item(i);
            String name = keystroke.getAttributes().getNamedItem("name").getNodeValue();
            int code = Integer.parseInt(keystroke.getAttributes().getNamedItem("code").getNodeValue());
            int modifiers = Integer.parseInt(keystroke.getAttributes().getNamedItem("modifiers").getNodeValue());
            String script = keystroke.getFirstChild().getNodeValue();
            if (existing.containsKey(name)) {
                records.remove(existing.get(name));
            }
            KeystrokeManager.addRecord(new KeystrokeRecord(code, modifiers, name, script));
        }
    }

    public static void saveRecords() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("keystrokes");
        doc.appendChild(root);
        for (int i = 0; i < records.size(); ++i) {
            KeystrokeRecord record = (KeystrokeRecord)records.get(i);
            Element recordElement = doc.createElement("keystroke");
            recordElement.setAttribute("name", record.getName());
            recordElement.setAttribute("code", Integer.toString(record.getKeyCode()));
            recordElement.setAttribute("modifiers", Integer.toString(record.getModifiers()));
            Text scriptElement = doc.createTextNode(record.getScript());
            recordElement.appendChild(scriptElement);
            root.appendChild(recordElement);
        }
        File dir2 = ApplicationPreferences.getPreferencesDirectory();
        File outFile = new File(dir2, KEYSTROKE_FILENAME);
        BufferedOutputStream out = new BufferedOutputStream(new SafeFileOutputStream(outFile, 0));
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        ((OutputStream)out).close();
    }
}

