/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.object.Object3D;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public abstract class Light
extends Object3D {
    protected RGBColor color;
    protected float intensity;
    protected float decayRate;
    protected int type = 0;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_SHADOWLESS = 1;
    public static final int TYPE_AMBIENT = 2;

    public Light() {
    }

    public Light(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
    }

    public void setParameters(RGBColor color, float intensity, int type, float decayRate) {
        this.color = color;
        this.intensity = intensity;
        this.type = type;
        this.decayRate = decayRate;
    }

    public RGBColor getColor() {
        return this.color;
    }

    public void setColor(RGBColor color) {
        this.color = color.duplicate();
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    public void getLight(RGBColor light, float distance) {
        double d = distance * this.decayRate;
        light.copy(this.color);
        light.scale((double)this.intensity / (1.0 + d + d * d));
    }

    public float getDecayRate() {
        return this.decayRate;
    }

    public void setDecayRate(float rate) {
        this.decayRate = rate;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

