/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.RGBColor;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.Translate;
import java.awt.Point;

public class BlendModule
extends Module {
    RGBColor blendColor = new RGBColor(0.0f, 0.0f, 0.0f);
    boolean colorOk;
    double lastBlur;

    public BlendModule(Point position) {
        super(Translate.text("menu.blendModule"), new IOPort[]{new IOPort(1, 0, 0, new String[]{"Color 1", '(' + Translate.text("black") + ')'}), new IOPort(1, 0, 1, new String[]{"Color 2", '(' + Translate.text("white") + ')'}), new IOPort(0, 0, 2, new String[]{"Fraction", "(0)"})}, new IOPort[]{new IOPort(1, 1, 3, new String[]{"Blend"})}, position);
    }

    public void init(PointInfo p) {
        this.colorOk = false;
    }

    public void getColor(int which, RGBColor c, double blur) {
        if (this.colorOk && blur == this.lastBlur) {
            c.copy(this.blendColor);
            return;
        }
        this.colorOk = true;
        this.lastBlur = blur;
        double fract = this.linkFrom[2] == null ? 0.0 : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        double error = this.linkFrom[2] == null ? 0.0 : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        double min = fract - error;
        double max = fract + error;
        if (min < 1.0 && max > 0.0 && (min < 0.0 || max > 1.0)) {
            fract = 0.0;
            if (min < 0.0) {
                min = 0.0;
            }
            if (max > 1.0) {
                fract = max - 1.0;
                max = 1.0;
            }
            fract += 0.5 * (max + min) * (max - min);
            fract /= 2.0 * error;
        }
        if (fract < 1.0) {
            if (this.linkFrom[0] == null) {
                this.blendColor.setRGB(0.0f, 0.0f, 0.0f);
            } else {
                this.linkFrom[0].getColor(this.linkFromIndex[0], this.blendColor, blur);
            }
        }
        if (fract > 0.0) {
            if (this.linkFrom[1] == null) {
                c.setRGB(1.0f, 1.0f, 1.0f);
            } else {
                this.linkFrom[1].getColor(this.linkFromIndex[1], c, blur);
            }
        }
        if (fract <= 0.0) {
            c.copy(this.blendColor);
            return;
        }
        if (fract >= 1.0) {
            this.blendColor.copy(c);
            return;
        }
        this.blendColor.scale((float)(1.0 - fract));
        c.scale((float)fract);
        this.blendColor.add(c);
        c.copy(this.blendColor);
    }
}

