/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.Scene;
import artofillusion.animation.Track;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.script.ObjectScript;
import artofillusion.script.ScriptRunner;
import artofillusion.script.ScriptedObject;
import artofillusion.script.ScriptedObjectEnumeration;

public class ScriptedObjectController {
    private ObjectInfo info;
    private ScriptedObject object;
    private ScriptedObjectEnumeration enumeration;
    private Scene scene;
    private boolean preview;

    ScriptedObjectController(ObjectInfo obj, ScriptedObjectEnumeration objectEnum, boolean interactive, Scene sc) {
        this.info = obj;
        Object3D innerObject = obj.object;
        while (innerObject instanceof ObjectWrapper) {
            innerObject = ((ObjectWrapper)innerObject).getWrappedObject();
        }
        this.object = (ScriptedObject)innerObject;
        this.enumeration = objectEnum;
        this.preview = interactive;
        this.scene = sc;
        this.object.setUsesTime(false);
        this.object.setUsesCoords(false);
        new Thread(){

            public void run() {
                try {
                    ObjectScript script = ScriptedObjectController.this.object.getObjectScript();
                    script.execute(ScriptedObjectController.this);
                    ScriptedObjectController.this.enumeration.executionComplete();
                }
                catch (Exception ex) {
                    ScriptedObjectController.this.enumeration.executionComplete();
                    ScriptRunner.displayError(ex, 1);
                }
            }
        }.start();
    }

    public final CoordinateSystem getCoordinates() {
        this.object.setUsesCoords(true);
        return this.info.coords;
    }

    public final double getTime() {
        this.object.setUsesTime(true);
        return this.scene.getTime();
    }

    public final Scene getScene() {
        this.object.setUsesTime(true);
        return this.scene;
    }

    public final boolean isPreview() {
        return this.preview;
    }

    public final double getParameter(String name) throws IllegalArgumentException {
        for (int i = this.object.getNumParameters() - 1; i >= 0; --i) {
            if (!this.object.getParameterName(i).equals(name)) continue;
            return this.object.getParameterValue(i);
        }
        throw new IllegalArgumentException("Unknown parameter '" + name + "'");
    }

    public final void addObject(ObjectInfo info) {
        info.tracks = new Track[0];
        if (info.object.canSetTexture() && info.object.getTextureMapping() == null) {
            info.setTexture(this.object.getTexture(), this.object.getTextureMapping());
        }
        if (info.object.canSetMaterial() && info.object.getMaterialMapping() == null) {
            info.setMaterial(this.object.getMaterial(), this.object.getMaterialMapping());
        }
        this.enumeration.addObject(info);
    }

    public final void addObject(Object3D obj, CoordinateSystem coords) {
        this.addObject(new ObjectInfo(obj, coords, ""));
    }
}

