/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.texture.NonlinearMapping2D;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;

public class Nonlinear2DTriangle
extends RenderingTriangle {
    Vec3 t1;
    Vec3 t2;
    Vec3 t3;
    private NonlinearMapping2D map;

    public Nonlinear2DTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3 t1, Vec3 t2, Vec3 t3) {
        super(v1, v2, v3, n1, n2, n3);
        this.t1 = t1;
        this.t2 = t2;
        this.t3 = t3;
    }

    public void setParameters(double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        if (!this.map.coordsFromParams || p1[this.map.numTextureParams] == Double.MAX_VALUE) {
            return;
        }
        this.t1 = new Vec3(p1[this.map.numTextureParams], p1[this.map.numTextureParams + 1], p1[this.map.numTextureParams + 2]);
        this.map.getPreTransform().transform(this.t1);
        this.t2 = new Vec3(p2[this.map.numTextureParams], p2[this.map.numTextureParams + 1], p2[this.map.numTextureParams + 2]);
        this.map.getPreTransform().transform(this.t2);
        this.t3 = new Vec3(p3[this.map.numTextureParams], p3[this.map.numTextureParams + 1], p3[this.map.numTextureParams + 2]);
        this.map.getPreTransform().transform(this.t3);
    }

    public void setMesh(RenderingMesh mesh, TextureMapping map, int index) {
        super.setMesh(mesh, map, index);
        this.map = (NonlinearMapping2D)map;
    }

    public void getTextureSpec(TextureSpec spec, double angle, double u, double v, double w, double size, double t) {
        if (!this.map.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        this.map.getSpecIntermed(spec, this.t1.x * u + this.t2.x * v + this.t3.x * w, this.t1.y * u + this.t2.y * v + this.t3.y * w, this.t1.z * u + this.t2.z * v + this.t3.z * w, size, angle, t, this.getParameters(u, v, w));
    }

    public void getTransparency(RGBColor trans, double angle, double u, double v, double w, double size, double t) {
        if (!this.map.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        this.map.getTransIntermed(trans, this.t1.x * u + this.t2.x * v + this.t3.x * w, this.t1.y * u + this.t2.y * v + this.t3.y * w, this.t1.z * u + this.t2.z * v + this.t3.z * w, size, angle, t, this.getParameters(u, v, w));
    }

    public double getDisplacement(double u, double v, double w, double size, double t) {
        return this.map.getDisplaceIntermed(this.t1.x * u + this.t2.x * v + this.t3.x * w, this.t1.y * u + this.t2.y * v + this.t3.y * w, this.t1.z * u + this.t2.z * v + this.t3.z * w, size, t, this.getParameters(u, v, w));
    }
}

