/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.internal.SingleWidgetPanel;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.IndexedContainerDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BTabbedPane
extends WidgetContainer {
    private ArrayList child;
    private int suppressEvents;
    public static final TabPosition TOP = new TabPosition(1);
    public static final TabPosition LEFT = new TabPosition(2);
    public static final TabPosition BOTTOM = new TabPosition(3);
    public static final TabPosition RIGHT = new TabPosition(4);

    public BTabbedPane() {
        this(TOP);
    }

    public BTabbedPane(TabPosition pos) {
        this.component = this.createComponent(pos);
        ((JTabbedPane)this.component).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                if (BTabbedPane.this.suppressEvents == 0) {
                    BTabbedPane.this.dispatchEvent(new SelectionChangedEvent(BTabbedPane.this));
                }
            }
        });
        this.component.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ev) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$200(this.this$1).layoutChildren();
                    }
                });
            }

            static /* synthetic */ BTabbedPane access$200(2 x0) {
                return x0.BTabbedPane.this;
            }
        });
        this.child = new ArrayList();
    }

    protected JTabbedPane createComponent(TabPosition pos) {
        return new JTabbedPane(pos.value);
    }

    public int getChildCount() {
        return this.child.size();
    }

    public Widget getChild(int i) {
        return (Widget)this.child.get(i);
    }

    public Collection getChildren() {
        return new ArrayList(this.child);
    }

    public void layoutChildren() {
        this.getComponent().validate();
        for (int i = 0; i < this.child.size(); ++i) {
            Widget w = (Widget)this.child.get(i);
            if (!(w instanceof WidgetContainer)) continue;
            ((WidgetContainer)w).layoutChildren();
        }
    }

    public void add(Widget widget, String tabName) {
        this.add(widget, tabName, null, this.child.size());
    }

    public void add(Widget widget, String tabName, Icon image) {
        this.add(widget, tabName, image, this.child.size());
    }

    public void add(Widget widget, String tabName, Icon image, int index) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child.add(index, widget);
        ((JTabbedPane)this.component).insertTab(tabName, image, new SingleWidgetPanel(widget), null, index);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public void remove(Widget widget) {
        int index = this.child.indexOf(widget);
        if (index > -1) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        Widget w = (Widget)this.child.get(index);
        ((JTabbedPane)this.component).remove(index);
        this.child.remove(index);
        this.removeAsParent(w);
        this.invalidateSize();
    }

    public void removeAll() {
        ((JTabbedPane)this.component).removeAll();
        for (int i = 0; i < this.child.size(); ++i) {
            this.removeAsParent((Widget)this.child.get(i));
        }
        this.child.clear();
        this.invalidateSize();
    }

    public int getChildIndex(Widget widget) {
        return this.child.indexOf(widget);
    }

    public TabPosition getTabPosition() {
        switch (((JTabbedPane)this.component).getTabPlacement()) {
            case 1: {
                return TOP;
            }
            case 2: {
                return LEFT;
            }
            case 3: {
                return BOTTOM;
            }
        }
        return RIGHT;
    }

    public void setTabPosition(TabPosition pos) {
        ((JTabbedPane)this.component).setTabPlacement(pos.value);
    }

    public String getTabName(int index) {
        return ((JTabbedPane)this.component).getTitleAt(index);
    }

    public void setTabName(int index, String name) {
        ((JTabbedPane)this.component).setTitleAt(index, name);
    }

    public Icon getTabImage(int index) {
        return ((JTabbedPane)this.component).getIconAt(index);
    }

    public void setTabImage(int index, Icon image) {
        ((JTabbedPane)this.component).setIconAt(index, image);
    }

    public int getSelectedTab() {
        return ((JTabbedPane)this.component).getSelectedIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedTab(int index) {
        try {
            ++this.suppressEvents;
            ((JTabbedPane)this.component).setSelectedIndex(index);
        }
        finally {
            --this.suppressEvents;
        }
    }

    static {
        WidgetEncoder.setPersistenceDelegate(TabPosition.class, new StaticFieldDelegate(BTabbedPane.class));
        WidgetEncoder.setPersistenceDelegate(BTabbedPane.class, new IndexedContainerDelegate(new String[]{"getChild", "getTabName", "getTabImage"}));
    }

    public static class TabPosition {
        protected int value;

        private TabPosition(int value) {
            this.value = value;
        }
    }
}

