/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.CellValueChangedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.BTableDelegate;
import buoy.xml.delegate.BTableHeaderDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class BTable
extends Widget {
    protected DefaultTableModel defaultModel = new DefaultTableModel(){

        public boolean isCellEditable(int row, int column) {
            return (Boolean)BTable.this.columnEditable.get(column);
        }
    };
    protected BTableHeader tableHeader;
    protected ArrayList columnEditable;
    public static final SelectionMode SELECT_NONE = new SelectionMode();
    public static final SelectionMode SELECT_ROWS = new SelectionMode();
    public static final SelectionMode SELECT_COLUMNS = new SelectionMode();
    public static final SelectionMode SELECT_CELLS = new SelectionMode();

    public BTable() {
        this.component = this.createComponent();
        this.tableHeader = new BTableHeader();
        this.columnEditable = new ArrayList();
        ListSelectionListener lsl = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                BTable.this.dispatchEvent(new SelectionChangedEvent(BTable.this, ev.getValueIsAdjusting()));
            }
        };
        JTable table = (JTable)this.component;
        table.getSelectionModel().addListSelectionListener(lsl);
        table.getColumnModel().getSelectionModel().addListSelectionListener(lsl);
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public BTable(int rows, int cols) {
        this();
        this.defaultModel.setRowCount(rows);
        this.defaultModel.setColumnCount(cols);
        for (int i = 0; i < cols; ++i) {
            this.columnEditable.add(Boolean.FALSE);
        }
    }

    public BTable(Object[][] cellData, Object[] columnTitle) {
        this();
        this.defaultModel.setDataVector(cellData, columnTitle);
        for (int i = 0; i < columnTitle.length; ++i) {
            this.columnEditable.add(Boolean.FALSE);
        }
    }

    public BTable(TableModel model) {
        this();
        this.getTable().setModel(model);
    }

    protected JTable createComponent() {
        return new JTable(this.defaultModel){

            public void editingStopped(ChangeEvent ev) {
                int row = this.getEditingRow();
                int col = this.getEditingColumn();
                super.editingStopped(ev);
                BTable.this.dispatchEvent(new CellValueChangedEvent(BTable.this, row, col));
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 157 || e.getKeyCode() == 20) {
                    return false;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
    }

    public BTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public TableModel getModel() {
        return this.getTable().getModel();
    }

    public void setModel(TableModel model) {
        this.getTable().setModel(model);
        this.invalidateSize();
    }

    public void addColumn(Object columnTitle) {
        this.defaultModel.addColumn(columnTitle);
        this.columnEditable.add(Boolean.FALSE);
        this.invalidateSize();
    }

    public void addColumn(Object columnTitle, Object[] columnData) {
        this.defaultModel.addColumn(columnTitle, columnData);
        this.columnEditable.add(Boolean.FALSE);
        this.invalidateSize();
    }

    public void removeColumn(int index) {
        int columns = this.getColumnCount();
        Vector<Object> columnNames = new Vector<Object>();
        for (int i = 0; i < columns; ++i) {
            if (i == index) continue;
            columnNames.add(this.getColumnHeader(i));
        }
        Vector<Vector> data = this.defaultModel.getDataVector();
        for (int i = 0; i < data.size(); ++i) {
            data.get(i).remove(index);
        }
        this.defaultModel.setDataVector(data, columnNames);
        if (index < this.columnEditable.size()) {
            this.columnEditable.remove(index);
        }
        this.invalidateSize();
    }

    public void removeAllColumns() {
        this.defaultModel.setColumnCount(0);
        this.columnEditable.clear();
        this.invalidateSize();
    }

    public void addRow(Object[] rowData) {
        this.defaultModel.addRow(rowData);
        this.invalidateSize();
    }

    public void addRow(int index, Object[] rowData) {
        this.defaultModel.insertRow(index, rowData);
        this.invalidateSize();
    }

    public void removeRow(int index) {
        this.defaultModel.removeRow(index);
        this.invalidateSize();
    }

    public void removeAllRows() {
        this.defaultModel.setRowCount(0);
        this.invalidateSize();
    }

    public int getRowCount() {
        return this.getTable().getRowCount();
    }

    public int getColumnCount() {
        return this.getTable().getColumnCount();
    }

    public boolean isColumnEditable(int index) {
        return (Boolean)this.columnEditable.get(index);
    }

    public void setColumnEditable(int index, boolean editable) {
        this.columnEditable.set(index, new Boolean(editable));
    }

    public Object getCellValue(int row, int col) {
        return this.getTable().getModel().getValueAt(row, col);
    }

    public void setCellValue(int row, int col, Object value) {
        this.getTable().getModel().setValueAt(value, row, col);
    }

    private JTable getTable() {
        return (JTable)this.component;
    }

    private TableColumn getColumn(int col) {
        JTable table = this.getTable();
        col = table.convertColumnIndexToView(col);
        return table.getColumnModel().getColumn(col);
    }

    public Object getColumnHeader(int col) {
        return this.getColumn(col).getHeaderValue();
    }

    public void setColumnHeader(int col, Object value) {
        this.getColumn(col).setHeaderValue(value);
    }

    public int getRowHeight(int row) {
        return this.getTable().getRowHeight(row);
    }

    public void setRowHeight(int row, int height) {
        this.getTable().setRowHeight(row, height);
        this.invalidateSize();
    }

    public int getColumnWidth(int col) {
        return this.getColumn(col).getWidth();
    }

    public void setColumnWidth(int col, int width) {
        this.getColumn(col).setPreferredWidth(width);
        this.invalidateSize();
    }

    public void sizeColumnToFit(int col) {
        TableColumn tc = this.getColumn(col);
        if (tc.getHeaderRenderer() != null) {
            tc.sizeWidthToFit();
        } else {
            JTableHeader th = this.getTable().getTableHeader();
            FontMetrics fm = th.getFontMetrics(th.getFont());
            tc.setPreferredWidth(fm.stringWidth(tc.getHeaderValue().toString()) + 10);
        }
        this.invalidateSize();
    }

    public boolean getColumnsResizable() {
        return this.getTable().getTableHeader().getResizingAllowed();
    }

    public void setColumnsResizable(boolean resizable) {
        this.getTable().getTableHeader().setResizingAllowed(resizable);
    }

    public boolean getColumnsReorderable() {
        return this.getTable().getTableHeader().getReorderingAllowed();
    }

    public void setColumnsReorderable(boolean reorderable) {
        this.getTable().getTableHeader().setReorderingAllowed(reorderable);
    }

    public SelectionMode getSelectionMode() {
        JTable table = (JTable)this.component;
        if (table.getCellSelectionEnabled()) {
            return SELECT_CELLS;
        }
        if (table.getColumnSelectionAllowed()) {
            return SELECT_COLUMNS;
        }
        if (table.getRowSelectionAllowed()) {
            return SELECT_ROWS;
        }
        return SELECT_NONE;
    }

    public void setSelectionMode(SelectionMode mode) {
        JTable table = (JTable)this.component;
        table.setColumnSelectionAllowed(mode == SELECT_COLUMNS || mode == SELECT_CELLS);
        table.setRowSelectionAllowed(mode == SELECT_ROWS || mode == SELECT_CELLS);
    }

    public boolean isMultipleSelectionEnabled() {
        return this.getTable().getSelectionModel().getSelectionMode() != 0;
    }

    public void setMultipleSelectionEnabled(boolean multiple) {
        this.getTable().setSelectionMode(multiple ? 2 : 0);
    }

    public boolean isRowSelected(int row) {
        return this.getTable().isRowSelected(row);
    }

    public void setRowSelected(int row, boolean selected) {
        if (selected) {
            this.getTable().addRowSelectionInterval(row, row);
        } else {
            this.getTable().removeRowSelectionInterval(row, row);
        }
    }

    public int[] getSelectedRows() {
        return this.getTable().getSelectedRows();
    }

    public boolean isColumnSelected(int col) {
        return this.getTable().isColumnSelected(col);
    }

    public void setColumnSelected(int col, boolean selected) {
        if (selected) {
            this.getTable().addColumnSelectionInterval(col, col);
        } else {
            this.getTable().removeColumnSelectionInterval(col, col);
        }
    }

    public int[] getSelectedColumns() {
        return this.getTable().getSelectedColumns();
    }

    public boolean isCellSelected(int row, int col) {
        return this.getTable().isCellSelected(row, col);
    }

    public void setCellSelected(int row, int col, boolean selected) {
        if (selected) {
            this.getTable().addRowSelectionInterval(row, row);
            this.getTable().addColumnSelectionInterval(col, col);
        } else {
            this.getTable().removeRowSelectionInterval(row, row);
            this.getTable().removeColumnSelectionInterval(col, col);
        }
    }

    public Point[] getSelectedCells() {
        int[] cols;
        int i;
        int[] rows;
        JTable table = (JTable)this.component;
        if (table.getRowSelectionAllowed()) {
            rows = table.getSelectedRows();
        } else {
            rows = new int[this.getRowCount()];
            for (i = 0; i < rows.length; ++i) {
                rows[i] = i;
            }
        }
        if (table.getColumnSelectionAllowed()) {
            cols = table.getSelectedColumns();
        } else {
            cols = new int[this.getColumnCount()];
            for (i = 0; i < cols.length; ++i) {
                cols[i] = i;
            }
        }
        Point[] cells = new Point[rows.length * cols.length];
        for (int i2 = 0; i2 < rows.length; ++i2) {
            for (int j = 0; j < cols.length; ++j) {
                cells[i2 * cols.length + j] = new Point(cols[j], rows[i2]);
            }
        }
        return cells;
    }

    public void clearSelection() {
        this.getTable().clearSelection();
    }

    public int findRow(Point pos) {
        return this.getTable().rowAtPoint(pos);
    }

    public int findColumn(Point pos) {
        return this.getTable().columnAtPoint(pos);
    }

    public void editCellAt(int row, int col) {
        this.getTable().editCellAt(row, col);
    }

    public boolean getShowHorizontalLines() {
        return this.getTable().getShowHorizontalLines();
    }

    public void setShowHorizontalLines(boolean show) {
        this.getTable().setShowHorizontalLines(show);
    }

    public boolean getShowVerticalLines() {
        return this.getTable().getShowVerticalLines();
    }

    public void setShowVerticalLines(boolean show) {
        this.getTable().setShowVerticalLines(show);
    }

    public void scrollToCell(int row, int col) {
        JTable table = (JTable)this.component;
        Rectangle bounds = table.getCellRect(row, col, true);
        table.scrollRectToVisible(bounds);
    }

    protected void setParent(WidgetContainer container) {
        super.setParent(container);
        if (container instanceof BScrollPane) {
            BScrollPane scroll = (BScrollPane)container;
            scroll.setColHeader(this.tableHeader);
            this.getTable().setAutoResizeMode(scroll.getHorizontalScrollbarPolicy() == BScrollPane.SCROLLBAR_NEVER ? 2 : 0);
        }
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BTable.class, new BTableDelegate());
        WidgetEncoder.setPersistenceDelegate(BTableHeader.class, new BTableHeaderDelegate());
        WidgetEncoder.setPersistenceDelegate(SelectionMode.class, new StaticFieldDelegate(BTable.class));
    }

    public static class SelectionMode {
        private SelectionMode() {
        }
    }

    public class BTableHeader
    extends Widget {
        private BTableHeader() {
            this.component = ((JTable)BTable.this.component).getTableHeader();
            this.component.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ BTableHeader this$1;
                {
                    this.this$1 = this$1;
                }

                public void componentResized(ComponentEvent ev) {
                    if (((JTableHeader)this.this$1.component).getResizingColumn() != null && this.this$1.getParent() instanceof BScrollPane) {
                        this.this$1.getParent().layoutChildren();
                    }
                }
            });
        }

        public BTable getTable() {
            return BTable.this;
        }
    }
}

