/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.Widget;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public abstract class TextWidget
extends Widget {
    protected CaretListener caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            TextWidget.this.caretMoved();
        }
    };
    protected DocumentListener documentListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            TextWidget.this.textChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            TextWidget.this.textChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            TextWidget.this.textChanged();
        }
    };
    protected int suppressEvents;

    protected TextWidget() {
    }

    public String getText() {
        return ((JTextComponent)this.component).getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        try {
            ++this.suppressEvents;
            ((JTextComponent)this.component).setText(text);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public int getLength() {
        return ((JTextComponent)this.component).getDocument().getLength();
    }

    public int getCaretPosition() {
        return ((JTextComponent)this.component).getCaretPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaretPosition(int pos) {
        try {
            ++this.suppressEvents;
            ((JTextComponent)this.component).setCaretPosition(pos);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public int getSelectionStart() {
        return ((JTextComponent)this.component).getSelectionStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionStart(int pos) {
        try {
            ++this.suppressEvents;
            ((JTextComponent)this.component).setSelectionStart(pos);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public int getSelectionEnd() {
        return ((JTextComponent)this.component).getSelectionEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionEnd(int pos) {
        try {
            ++this.suppressEvents;
            ((JTextComponent)this.component).setSelectionEnd(pos);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public String getSelectedText() {
        return ((JTextComponent)this.component).getSelectedText();
    }

    public boolean isEditable() {
        return ((JTextComponent)this.component).isEditable();
    }

    public void setEditable(boolean editable) {
        ((JTextComponent)this.component).setEditable(editable);
    }

    protected void caretMoved() {
        if (this.suppressEvents == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TextWidget.this.dispatchEvent(new SelectionChangedEvent(TextWidget.this));
                }
            });
        }
    }

    protected void textChanged() {
        this.invalidateSize();
        if (this.suppressEvents == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TextWidget.this.dispatchEvent(new ValueChangedEvent(TextWidget.this));
                }
            });
        }
    }
}

