/*
 * Decompiled with CFR 0.152.
 */
package buoyx.docking;

import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoyx.docking.DragManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

public class DockableWidget
extends WidgetContainer {
    private Widget content;
    private String label;

    public DockableWidget() {
        this.component = new DockableWidgetPanel();
        DragManager manager = DragManager.getDragManager();
        this.addEventLink(MousePressedEvent.class, (Object)manager, "beginDraggingWidget");
        this.addEventLink(MouseDraggedEvent.class, (Object)manager, "mouseDragged");
        this.addEventLink(MouseReleasedEvent.class, (Object)manager, "mouseReleased");
    }

    public DockableWidget(Widget content, String label) {
        this();
        this.setContent(content);
        this.setLabel(label);
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget widget) {
        if (this.content != null) {
            this.remove(this.content);
        }
        this.content = widget;
        if (this.content != null) {
            if (this.content.getParent() != null) {
                this.content.getParent().remove(this.content);
            }
            ((Container)this.getComponent()).add(this.content.getComponent());
            this.setAsParent(this.content);
        }
        this.invalidateSize();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    protected Insets getBorderInsets() {
        FontMetrics fm = this.getComponent().getFontMetrics(this.getComponent().getFont());
        return new Insets(fm.getMaxAscent() + fm.getMaxDescent() + 4, 0, 0, 0);
    }

    protected void paintBorder(Graphics2D g) {
        Rectangle bounds = this.getBounds();
        Insets insets = this.getBorderInsets();
        g.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, insets.top, Color.LIGHT_GRAY));
        g.fillRect(0, 0, bounds.width, insets.top);
        g.setColor(Color.DARK_GRAY);
        g.drawLine(0, insets.top - 1, bounds.width, insets.top - 1);
        g.setColor(Color.BLACK);
        if (this.label != null) {
            FontMetrics fm = this.getComponent().getFontMetrics(this.getComponent().getFont());
            g.drawString(this.label, 2, fm.getMaxAscent() + 2);
        }
    }

    protected boolean isInDragRegion(Point pos) {
        return pos.y < this.getBorderInsets().top;
    }

    public Dimension getPreferredSize() {
        Dimension size = this.content == null ? new Dimension(0, 0) : new Dimension(this.content.getPreferredSize());
        Insets insets = this.getBorderInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public Dimension getMinimumSize() {
        Dimension size = this.content == null ? new Dimension(0, 0) : new Dimension(this.content.getMinimumSize());
        Insets insets = this.getBorderInsets();
        if (size.width > 0) {
            size.width += insets.left + insets.right;
        }
        if (size.height > 0) {
            size.height += insets.top + insets.bottom;
        }
        return size;
    }

    public int getChildCount() {
        return this.content == null ? 0 : 1;
    }

    public Collection getChildren() {
        ArrayList<Widget> children = new ArrayList<Widget>();
        if (this.content != null) {
            children.add(this.content);
        }
        return children;
    }

    public void remove(Widget widget) {
        if (this.content == widget) {
            ((JPanel)this.component).remove(widget.getComponent());
            this.removeAsParent(widget);
            this.invalidateSize();
        }
    }

    public void removeAll() {
        if (this.content != null) {
            this.remove(this.content);
        }
    }

    public void layoutChildren() {
        if (this.content == null) {
            return;
        }
        Insets insets = this.getBorderInsets();
        Rectangle bounds = this.getBounds();
        this.content.getComponent().setBounds(insets.left, insets.top, Math.max(0, bounds.width - insets.left - insets.right), Math.max(0, bounds.height - insets.top - insets.bottom));
        if (this.content instanceof WidgetContainer) {
            ((WidgetContainer)this.content).layoutChildren();
        }
    }

    public Rectangle getBounds() {
        Rectangle bounds = super.getBounds();
        WidgetContainer parentWidget = this.getParent();
        for (Container parent = this.getComponent().getParent(); parent != parentWidget.getComponent(); parent = parent.getParent()) {
            bounds.x += parent.getX();
            bounds.y += parent.getY();
        }
        return bounds;
    }

    private class DockableWidgetPanel
    extends JPanel {
        public DockableWidgetPanel() {
            this.setLayout(null);
        }

        public void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                Dimension size = this.getSize();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, size.width, size.height);
                g.setColor(this.getForeground());
            }
            DockableWidget.this.paintBorder((Graphics2D)g);
        }

        public boolean isOpaque() {
            return DockableWidget.this.isOpaque();
        }
    }
}

