/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BRadioButton;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RadioButtonGroup;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Insets;
import java.util.Vector;

public class ExtrudeDialog
extends BDialog {
    private LayoutWindow window;
    private BComboBox objChoice;
    private BComboBox pathChoice;
    private RadioButtonGroup pathGroup;
    private BRadioButton pathBox;
    private BRadioButton xBox;
    private BRadioButton yBox;
    private BRadioButton zBox;
    private BRadioButton vectorBox;
    private BCheckBox orientBox;
    private ValueField distField;
    private ValueField xField;
    private ValueField yField;
    private ValueField zField;
    private ValueField segField;
    private ValueField angleField;
    private ValueField tolField;
    private BButton okButton;
    private BButton cancelButton;
    private ObjectPreviewCanvas preview;
    private Vector objects;
    private Vector paths;
    private static int counter = 1;

    public ExtrudeDialog(LayoutWindow window) {
        super((WindowWidget)window, "Extrude", true);
        this.window = window;
        Scene scene = window.getScene();
        int[] selection = scene.getSelection();
        this.objects = new Vector();
        this.paths = new Vector();
        for (int i = 0; i < selection.length; ++i) {
            ObjectInfo obj = scene.getObject(selection[i]);
            if (obj.object instanceof Curve) {
                this.objects.addElement(obj);
                this.paths.addElement(obj);
                continue;
            }
            if (!(obj.object instanceof TriangleMesh) && obj.object.canConvertToTriangleMesh() == 0 || obj.object.isClosed()) continue;
            this.objects.addElement(obj);
        }
        if (this.objects.size() == 1) {
            this.paths.removeAllElements();
        }
        FormContainer content = new FormContainer(4, 10);
        this.setContent((Widget)BOutline.createEmptyBorder((Widget)content, (int)ModellingApp.standardDialogInsets));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
        content.add((Widget)new BLabel("Object to Extrude:"), 0, 0, 2, 1);
        this.objChoice = new BComboBox();
        content.add((Widget)this.objChoice, 0, 1, 2, 1);
        for (int i = 0; i < this.objects.size(); ++i) {
            this.objChoice.add((Object)((ObjectInfo)this.objects.elementAt((int)i)).name);
        }
        this.objChoice.addEventLink(ValueChangedEvent.class, (Object)this, "stateChanged");
        content.add((Widget)new BLabel("Extrude Direction:"), 0, 2, 2, 1);
        this.pathGroup = new RadioButtonGroup();
        this.xBox = new BRadioButton("X", true, this.pathGroup);
        content.add((Widget)this.xBox, 0, 3);
        this.yBox = new BRadioButton("Y", true, this.pathGroup);
        content.add((Widget)this.yBox, 0, 4);
        this.zBox = new BRadioButton("Z", true, this.pathGroup);
        content.add((Widget)this.zBox, 0, 5);
        this.pathBox = new BRadioButton("Curve", true, this.pathGroup);
        content.add((Widget)this.pathBox, 0, 6);
        this.vectorBox = new BRadioButton("Vector", true, this.pathGroup);
        content.add((Widget)this.vectorBox, 0, 7);
        this.pathBox.setEnabled(this.paths.size() > 0);
        this.pathGroup.addEventLink(SelectionChangedEvent.class, (Object)this, "stateChanged");
        this.pathGroup.setSelection((Object)this.zBox);
        RowContainer distanceRow = new RowContainer();
        content.add((Widget)distanceRow, 1, 4);
        distanceRow.add((Widget)new BLabel("Distance:"));
        this.distField = new ValueField(1.0, 3, 5);
        distanceRow.add((Widget)this.distField);
        this.distField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        this.pathChoice = new BComboBox();
        content.add((Widget)this.pathChoice, 1, 6);
        for (int i = 0; i < this.paths.size(); ++i) {
            this.pathChoice.add((Object)((ObjectInfo)this.paths.elementAt((int)i)).name);
        }
        this.pathChoice.addEventLink(ValueChangedEvent.class, (Object)this, "stateChanged");
        RowContainer vectorRow = new RowContainer();
        content.add((Widget)vectorRow, 1, 7);
        vectorRow.add((Widget)new BLabel("X"));
        this.xField = new ValueField(0.0, 0, 4);
        vectorRow.add((Widget)this.xField);
        this.xField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        vectorRow.add((Widget)new BLabel("Y"));
        this.yField = new ValueField(0.0, 0, 4);
        vectorRow.add((Widget)this.yField);
        this.yField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        vectorRow.add((Widget)new BLabel("Z"));
        this.zField = new ValueField(1.0, 0, 4);
        vectorRow.add((Widget)this.zField);
        this.zField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        this.orientBox = new BCheckBox("Orientation Follows Curve", true);
        content.add((Widget)this.orientBox, 0, 8, 2, 1);
        this.orientBox.addEventLink(ValueChangedEvent.class, (Object)this, "stateChanged");
        content.add((Widget)new BLabel("Number of Segments:"), 2, 0);
        content.add((Widget)new BLabel("Twist (degrees):"), 2, 1);
        content.add((Widget)new BLabel("Surface Accuracy:"), 2, 2);
        this.segField = new ValueField(1.0, 7, 5);
        content.add((Widget)this.segField, 3, 0);
        this.angleField = new ValueField(0.0, 0, 5);
        content.add((Widget)this.angleField, 3, 1);
        this.tolField = new ValueField(0.1, 3, 5);
        content.add((Widget)this.tolField, 3, 2);
        this.segField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        this.angleField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        this.tolField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        if (this.paths.size() > 0) {
            for (int i = 0; i < scene.getNumObjects(); ++i) {
                if (scene.getObject(i) == this.paths.elementAt(0)) continue;
                this.objChoice.setSelectedIndex(i);
                break;
            }
        }
        this.preview = new ObjectPreviewCanvas((ObjectInfo)this.objects.elementAt(0));
        content.add((Widget)this.preview, 2, 3, 2, 6, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        RowContainer buttons = new RowContainer();
        content.add((Widget)buttons, 0, 9, 4, 1, new LayoutInfo());
        this.okButton = Translate.button((String)"ok", (Object)((Object)this), (String)"doOk");
        buttons.add((Widget)this.okButton);
        this.cancelButton = Translate.button((String)"cancel", (Object)((Object)this), (String)"dispose");
        buttons.add((Widget)this.cancelButton);
        this.makeObject();
        this.pack();
        UIUtilities.centerDialog((BDialog)this, (WindowWidget)window);
        this.updateComponents();
        this.setVisible(true);
    }

    private void stateChanged() {
        this.makeObject();
        this.updateComponents();
    }

    private void updateComponents() {
        this.distField.setEnabled(this.xBox.getState() || this.yBox.getState() || this.zBox.getState());
        this.xField.setEnabled(this.vectorBox.getState());
        this.yField.setEnabled(this.vectorBox.getState());
        this.zField.setEnabled(this.vectorBox.getState());
        this.pathChoice.setEnabled(this.pathBox.getState());
        this.segField.setEnabled(!this.pathBox.getState());
        this.orientBox.setEnabled(this.pathBox.getState());
        Object3D profile = ((ObjectInfo)this.objects.elementAt((int)this.objChoice.getSelectedIndex())).object;
        this.tolField.setEnabled(!(profile instanceof Curve) && !(profile instanceof TriangleMesh));
        if (this.pathBox.getState()) {
            this.okButton.setEnabled(this.objects.elementAt(this.objChoice.getSelectedIndex()) != this.paths.elementAt(this.pathChoice.getSelectedIndex()));
        } else {
            this.okButton.setEnabled(true);
        }
    }

    private void doOk() {
        ObjectInfo profile = (ObjectInfo)this.objects.elementAt(this.objChoice.getSelectedIndex());
        CoordinateSystem coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        if (profile.object instanceof Mesh) {
            Vec3 offset = profile.coords.fromLocal().times(((Mesh)profile.object).getVertices()[0].r).minus(coords.fromLocal().times(((Mesh)this.preview.getObject().object).getVertices()[0].r));
            coords.setOrigin(coords.getOrigin().plus(offset));
        }
        this.window.addObject(this.preview.getObject().object, coords, "Extruded Object " + counter++, null);
        this.window.setSelection(this.window.getScene().getNumObjects() - 1);
        this.window.setUndoRecord(new UndoRecord((EditingWindow)this.window, false, 5, new Object[]{new Integer(this.window.getScene().getNumObjects() - 1)}));
        this.window.updateImage();
        this.dispose();
    }

    private void makeObject() {
        CoordinateSystem pathCoords;
        Curve path;
        ObjectInfo profile = (ObjectInfo)this.objects.elementAt(this.objChoice.getSelectedIndex());
        if (this.pathBox.getState()) {
            ObjectInfo info = (ObjectInfo)this.paths.elementAt(this.pathChoice.getSelectedIndex());
            path = (Curve)info.object;
            pathCoords = info.coords;
        } else {
            Vec3 dir = new Vec3();
            if (this.xBox.getState()) {
                dir.x = this.distField.getValue();
            } else if (this.yBox.getState()) {
                dir.y = this.distField.getValue();
            } else if (this.zBox.getState()) {
                dir.z = this.distField.getValue();
            } else {
                dir.set(this.xField.getValue(), this.yField.getValue(), this.zField.getValue());
            }
            Vec3[] v = new Vec3[(int)this.segField.getValue() + 1];
            float[] smooth = new float[v.length];
            for (int i = 0; i < v.length; ++i) {
                v[i] = new Vec3(dir);
                v[i].scale((double)i / this.segField.getValue());
                smooth[i] = 1.0f;
            }
            path = new Curve(v, smooth, 2, false);
            pathCoords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        }
        Object3D obj = profile.object == path ? null : (profile.object instanceof TriangleMesh ? ExtrudeDialog.extrudeMesh((TriangleMesh)profile.object, path, profile.coords, pathCoords, this.angleField.getValue() * Math.PI / 180.0, this.orientBox.getState()) : (profile.object instanceof Curve ? ExtrudeDialog.extrudeCurve((Curve)profile.object, path, profile.coords, pathCoords, this.angleField.getValue() * Math.PI / 180.0, this.orientBox.getState()) : ExtrudeDialog.extrudeMesh(profile.object.convertToTriangleMesh(this.tolField.getValue()), path, profile.coords, pathCoords, this.angleField.getValue() * Math.PI / 180.0, this.orientBox.getState())));
        Texture tex = this.window.getScene().getDefaultTexture();
        obj.setTexture(tex, tex.getDefaultMapping(obj));
        this.preview.setObject(obj);
        this.preview.repaint();
    }

    public static Object3D extrudeCurve(Curve profile, CoordinateSystem profCoords, Vec3 dir, int segments, double angle, boolean orient) {
        Vec3[] v = new Vec3[segments + 1];
        float[] smooth = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new Vec3(dir);
            v[i].scale((double)(i * segments));
            smooth[i] = 1.0f;
        }
        Curve path = new Curve(v, smooth, 2, false);
        return ExtrudeDialog.extrudeCurve(profile, path, profCoords, new CoordinateSystem(), angle, orient);
    }

    public static Object3D extrudeCurve(Curve profile, Curve path, CoordinateSystem profCoords, CoordinateSystem pathCoords, double angle, boolean orient) {
        int j;
        int i;
        MeshVertex[] profVert = profile.getVertices();
        MeshVertex[] pathVert = path.getVertices();
        Vec3[] profv = new Vec3[profVert.length];
        Vec3[] pathv = new Vec3[pathVert.length];
        Vec3 center = new Vec3();
        float[] usmooth = new float[pathVert.length];
        float[] vsmooth = new float[profVert.length];
        float[] profSmooth = profile.getSmoothness();
        float[] pathSmooth = path.getSmoothness();
        CoordinateSystem localCoords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        for (i = 0; i < profVert.length; ++i) {
            profv[i] = profCoords.fromLocal().timesDirection(profVert[i].r);
        }
        for (i = 0; i < pathVert.length; ++i) {
            pathv[i] = pathCoords.fromLocal().timesDirection(pathVert[i].r);
        }
        Vec3[] subdiv = new Curve(pathv, pathSmooth, path.getSmoothingMethod(), path.isClosed()).subdivideCurve().getVertexPositions();
        Vec3[] t = new Vec3[subdiv.length];
        Vec3[] zdir = new Vec3[subdiv.length];
        Vec3[] updir = new Vec3[subdiv.length];
        t[0] = subdiv[1].minus(subdiv[0]);
        t[0].normalize();
        zdir[0] = Vec3.vz();
        updir[0] = Vec3.vy();
        double zfrac1 = t[0].dot(zdir[0]);
        double zfrac2 = Math.sqrt(1.0 - zfrac1 * zfrac1);
        Vec3 dir1 = zdir[0].minus(t[0].times(zfrac1));
        dir1.normalize();
        double upfrac1 = t[0].dot(updir[0]);
        double upfrac2 = Math.sqrt(1.0 - upfrac1 * upfrac1);
        Vec3 dir2 = updir[0].minus(t[0].times(upfrac1));
        dir2.normalize();
        for (i = 1; i < subdiv.length; ++i) {
            t[i] = i == subdiv.length - 1 ? (path.isClosed() ? subdiv[0].minus(subdiv[subdiv.length - 2]) : subdiv[subdiv.length - 1].minus(subdiv[subdiv.length - 2])) : subdiv[i + 1].minus(subdiv[i - 1]);
            t[i].normalize();
            if (orient) {
                dir1 = dir1.minus(t[i].times(t[i].dot(dir1)));
                dir1.normalize();
                dir2 = dir2.minus(t[i].times(t[i].dot(dir2)));
                dir2.normalize();
                zdir[i] = t[i].times(zfrac1).plus(dir1.times(zfrac2));
                updir[i] = t[i].times(upfrac1).plus(dir2.times(upfrac2));
                continue;
            }
            zdir[i] = zdir[i - 1];
            updir[i] = updir[i - 1];
        }
        if (path.getSmoothingMethod() != 0) {
            for (i = 0; i < usmooth.length; ++i) {
                usmooth[i] = pathSmooth[i];
            }
        }
        if (profile.getSmoothingMethod() != 0) {
            for (i = 0; i < vsmooth.length; ++i) {
                vsmooth[i] = profSmooth[i];
            }
        }
        if (profile.getSmoothingMethod() == 3 && path.getSmoothingMethod() == 2) {
            pathv = subdiv;
            usmooth = new float[pathv.length];
            for (i = 0; i < usmooth.length; ++i) {
                usmooth[i] = i % 2 == 0 ? Math.min(pathSmooth[i / 2] * 2.0f, 1.0f) : 1.0f;
            }
        }
        if (profile.getSmoothingMethod() == 2 && path.getSmoothingMethod() == 3) {
            profv = new Curve(profv, profSmooth, profile.getSmoothingMethod(), profile.isClosed()).subdivideCurve().getVertexPositions();
            vsmooth = new float[profv.length];
            for (i = 0; i < vsmooth.length; ++i) {
                vsmooth[i] = i % 2 == 0 ? Math.min(profSmooth[i / 2] * 2.0f, 1.0f) : 1.0f;
            }
        }
        Vec3[][] v = new Vec3[pathv.length][profv.length];
        for (i = 0; i < pathv.length; ++i) {
            localCoords.setOrigin(pathv[i]);
            int k = pathv.length == subdiv.length ? i : 2 * i;
            localCoords.setOrientation(zdir[k], updir[k]);
            if (angle != 0.0) {
                Mat4 rotate = Mat4.axisRotation((Vec3)t[k], (double)((double)i * angle / (double)(pathv.length - 1)));
                localCoords.transformAxes(rotate);
            }
            for (j = 0; j < profv.length; ++j) {
                v[i][j] = localCoords.fromLocal().times(profv[j]);
                center.add(v[i][j]);
            }
        }
        center.scale(1.0 / (double)(profv.length * pathv.length));
        for (i = 0; i < pathv.length; ++i) {
            for (j = 0; j < profv.length; ++j) {
                v[i][j].subtract(center);
            }
        }
        SplineMesh mesh = new SplineMesh(v, usmooth, vsmooth, Math.max(profile.getSmoothingMethod(), path.getSmoothingMethod()), path.isClosed(), profile.isClosed());
        mesh.makeRightSideOut();
        return mesh;
    }

    public static Object3D extrudeMesh(TriangleMesh profile, CoordinateSystem profCoords, Vec3 dir, int segments, double angle, boolean orient) {
        Vec3[] v = new Vec3[segments + 1];
        float[] smooth = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new Vec3(dir);
            v[i].scale((double)(i * segments));
            smooth[i] = 1.0f;
        }
        Curve path = new Curve(v, smooth, 2, false);
        return ExtrudeDialog.extrudeMesh(profile, path, profCoords, new CoordinateSystem(), angle, orient);
    }

    public static Object3D extrudeMesh(TriangleMesh profile, Curve path, CoordinateSystem profCoords, CoordinateSystem pathCoords, double angle, boolean orient) {
        Mat4 rotate;
        int k;
        boolean angled;
        int[][] index;
        int i;
        TriangleMesh.Vertex[] profVert = (TriangleMesh.Vertex[])profile.getVertices();
        MeshVertex[] pathVert = path.getVertices();
        TriangleMesh.Edge[] profEdge = profile.getEdges();
        TriangleMesh.Face[] profFace = profile.getFaces();
        Vec3[] profv = new Vec3[profVert.length];
        Vec3[] pathv = new Vec3[pathVert.length];
        float[] pathSmooth = path.getSmoothness();
        CoordinateSystem localCoords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        int numBoundaryEdges = 0;
        int numBoundaryPoints = 0;
        for (i = 0; i < profVert.length; ++i) {
            profv[i] = profCoords.fromLocal().timesDirection(profVert[i].r);
        }
        for (i = 0; i < pathVert.length; ++i) {
            pathv[i] = pathCoords.fromLocal().timesDirection(pathVert[i].r);
        }
        if (path.getSmoothingMethod() == 0) {
            for (i = 0; i < pathSmooth.length; ++i) {
                pathSmooth[i] = 0.0f;
            }
        }
        boolean[] onBound = new boolean[profv.length];
        for (i = 0; i < profEdge.length; ++i) {
            if (profEdge[i].f2 != -1) continue;
            ++numBoundaryEdges;
            onBound[profEdge[i].v2] = true;
            onBound[profEdge[i].v1] = true;
        }
        for (i = 0; i < onBound.length; ++i) {
            if (!onBound[i]) continue;
            ++numBoundaryPoints;
        }
        int[] boundaryEdge = new int[numBoundaryEdges];
        int[] boundaryPoint = new int[numBoundaryPoints];
        int j = 0;
        for (i = 0; i < profEdge.length; ++i) {
            if (profEdge[i].f2 != -1) continue;
            boundaryEdge[j++] = i;
        }
        j = 0;
        for (i = 0; i < onBound.length; ++i) {
            if (!onBound[i]) continue;
            boundaryPoint[j++] = i;
        }
        boolean[] forward = new boolean[boundaryEdge.length];
        int[][] edgeVertIndex = new int[boundaryEdge.length][2];
        for (i = 0; i < boundaryEdge.length; ++i) {
            TriangleMesh.Edge ed = profEdge[boundaryEdge[i]];
            TriangleMesh.Face fc = profFace[ed.f1];
            forward[i] = fc.v1 == ed.v1 && fc.v2 == ed.v2 || fc.v2 == ed.v1 && fc.v3 == ed.v2 || fc.v3 == ed.v1 && fc.v1 == ed.v2;
            for (j = 0; j < boundaryPoint.length; ++j) {
                if (boundaryPoint[j] == ed.v1) {
                    edgeVertIndex[i][0] = j;
                    continue;
                }
                if (boundaryPoint[j] != ed.v2) continue;
                edgeVertIndex[i][1] = j;
            }
        }
        if (path.isClosed()) {
            index = new int[pathv.length + 1][boundaryPoint.length];
            for (i = 0; i < boundaryPoint.length; ++i) {
                for (j = 0; j < pathv.length; ++j) {
                    index[j][i] = j * boundaryPoint.length + i;
                }
                index[j][i] = i;
            }
        } else {
            index = new int[pathv.length][boundaryPoint.length];
            for (i = 0; i < boundaryPoint.length; ++i) {
                index[0][i] = boundaryPoint[i];
                index[pathv.length - 1][i] = boundaryPoint[i] + profv.length;
                for (j = 1; j < pathv.length - 1; ++j) {
                    index[j][i] = (j - 1) * boundaryPoint.length + i + 2 * profv.length;
                }
            }
        }
        Vec3[] subdiv = new Curve(pathv, pathSmooth, path.getSmoothingMethod(), path.isClosed()).subdivideCurve().getVertexPositions();
        Vec3[] t = new Vec3[subdiv.length];
        Vec3[] zdir = new Vec3[subdiv.length];
        Vec3[] updir = new Vec3[subdiv.length];
        t[0] = subdiv[1].minus(subdiv[0]);
        t[0].normalize();
        zdir[0] = Vec3.vz();
        updir[0] = Vec3.vy();
        double zfrac1 = t[0].dot(zdir[0]);
        double zfrac2 = Math.sqrt(1.0 - zfrac1 * zfrac1);
        Vec3 dir1 = zdir[0].minus(t[0].times(zfrac1));
        dir1.normalize();
        double upfrac1 = t[0].dot(updir[0]);
        double upfrac2 = Math.sqrt(1.0 - upfrac1 * upfrac1);
        Vec3 dir2 = updir[0].minus(t[0].times(upfrac1));
        dir2.normalize();
        for (i = 1; i < subdiv.length; ++i) {
            t[i] = i == subdiv.length - 1 ? (path.isClosed() ? subdiv[0].minus(subdiv[subdiv.length - 2]) : subdiv[subdiv.length - 1].minus(subdiv[subdiv.length - 2])) : subdiv[i + 1].minus(subdiv[i - 1]);
            t[i].normalize();
            if (orient) {
                dir1 = dir1.minus(t[i].times(t[i].dot(dir1)));
                dir1.normalize();
                dir2 = dir2.minus(t[i].times(t[i].dot(dir2)));
                dir2.normalize();
                zdir[i] = t[i].times(zfrac1).plus(dir1.times(zfrac2));
                updir[i] = t[i].times(upfrac1).plus(dir2.times(upfrac2));
                continue;
            }
            zdir[i] = zdir[i - 1];
            updir[i] = updir[i - 1];
        }
        Vec3[] v = path.isClosed() ? new Vec3[numBoundaryPoints * pathv.length] : new Vec3[2 * profv.length + numBoundaryPoints * (pathv.length - 2)];
        Vector<EdgeInfo> newEdge = new Vector<EdgeInfo>();
        Vector<int[]> newFace = new Vector<int[]>();
        boolean bl = angled = profile.getSmoothingMethod() == 0 && path.getSmoothingMethod() != 0;
        if (!path.isClosed()) {
            localCoords.setOrigin(pathv[0]);
            localCoords.setOrientation(zdir[0], updir[0]);
            for (i = 0; i < profv.length; ++i) {
                v[i] = localCoords.fromLocal().times(profv[i]);
            }
            k = pathv.length == subdiv.length ? pathv.length - 1 : 2 * (pathv.length - 1);
            localCoords.setOrigin(pathv[pathv.length - 1]);
            localCoords.setOrientation(zdir[k], updir[k]);
            if (angle != 0.0) {
                rotate = Mat4.axisRotation((Vec3)t[k], (double)angle);
                localCoords.transformAxes(rotate);
            }
            for (i = 0; i < profv.length; ++i) {
                v[i + profv.length] = localCoords.fromLocal().times(profv[i]);
            }
            for (i = 0; i < profEdge.length; ++i) {
                float smoothness = profEdge[i].smoothness;
                if (angled || profEdge[i].f2 == -1) {
                    smoothness = 0.0f;
                }
                newEdge.addElement(new EdgeInfo(profEdge[i].v1, profEdge[i].v2, smoothness));
                newEdge.addElement(new EdgeInfo(profEdge[i].v1 + profv.length, profEdge[i].v2 + profv.length, smoothness));
            }
            for (i = 0; i < profFace.length; ++i) {
                TriangleMesh.Face f = profFace[i];
                newFace.addElement(new int[]{f.v1, f.v2, f.v3});
                newFace.addElement(new int[]{f.v1 + profv.length, f.v3 + profv.length, f.v2 + profv.length});
            }
        }
        for (i = 0; i < pathv.length && (path.isClosed() || i != pathv.length - 1); ++i) {
            for (j = 0; j < boundaryEdge.length; ++j) {
                int v2;
                int v1;
                if (forward[j]) {
                    v1 = edgeVertIndex[j][0];
                    v2 = edgeVertIndex[j][1];
                } else {
                    v1 = edgeVertIndex[j][1];
                    v2 = edgeVertIndex[j][0];
                }
                newFace.addElement(new int[]{index[i][v1], index[i + 1][v1], index[i + 1][v2]});
                newFace.addElement(new int[]{index[i][v2], index[i][v1], index[i + 1][v2]});
                EdgeInfo ed1 = new EdgeInfo(index[i][v1], index[i + 1][v1], angled ? 0.0f : profVert[boundaryPoint[v1]].smoothness);
                newEdge.addElement(ed1);
                ed1 = new EdgeInfo(index[i][v2], index[i + 1][v2], angled ? 0.0f : profVert[boundaryPoint[v2]].smoothness);
                newEdge.addElement(ed1);
                ed1 = new EdgeInfo(index[i][v1], index[i + 1][v2], 1.0f);
                newEdge.addElement(ed1);
                if (!path.isClosed() && i <= 0) continue;
                ed1 = new EdgeInfo(index[i][v1], index[i][v2], pathSmooth[i]);
                newEdge.addElement(ed1);
            }
            localCoords.setOrigin(pathv[i]);
            k = pathv.length == subdiv.length ? i : 2 * i;
            localCoords.setOrientation(zdir[k], updir[k]);
            if (angle != 0.0) {
                rotate = Mat4.axisRotation((Vec3)t[k], (double)((double)i * angle / (double)(pathv.length - 1)));
                localCoords.transformAxes(rotate);
            }
            for (j = 0; j < boundaryPoint.length; ++j) {
                v[index[i][j]] = localCoords.fromLocal().times(profv[boundaryPoint[j]]);
            }
        }
        Vec3 center = new Vec3();
        for (i = 0; i < v.length; ++i) {
            center.add(v[i]);
        }
        center.scale(1.0 / (double)v.length);
        for (i = 0; i < v.length; ++i) {
            v[i].subtract(center);
        }
        int[][] faces = new int[newFace.size()][];
        for (i = 0; i < faces.length; ++i) {
            faces[i] = (int[])newFace.elementAt(i);
        }
        TriangleMesh mesh = new TriangleMesh(v, (int[][])faces);
        TriangleMesh.Edge[] meshEdge = mesh.getEdges();
        for (i = 0; i < newEdge.size(); ++i) {
            EdgeInfo info = (EdgeInfo)newEdge.elementAt(i);
            if (info.smoothness == 1.0f) continue;
            for (j = 0; j < meshEdge.length; ++j) {
                if ((meshEdge[j].v1 != info.v1 || meshEdge[j].v2 != info.v2) && (meshEdge[j].v1 != info.v2 || meshEdge[j].v2 != info.v1)) continue;
                meshEdge[j].smoothness = info.smoothness;
            }
        }
        mesh.setSmoothingMethod(Math.max(profile.getSmoothingMethod(), path.getSmoothingMethod()));
        mesh.makeRightSideOut();
        return mesh;
    }

    private static class EdgeInfo {
        int v1;
        int v2;
        float smoothness;

        public EdgeInfo(int vert1, int vert2, float smooth) {
            this.v1 = vert1;
            this.v2 = vert2;
            this.smoothness = smooth;
        }
    }
}

