/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.depend.bcel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class DependencyVisitor
extends EmptyVisitor {
    private Hashtable dependencies = new Hashtable();
    private ConstantPool constantPool;

    public Enumeration getDependencies() {
        return this.dependencies.keys();
    }

    public void clearDependencies() {
        this.dependencies.clear();
    }

    public void visitConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void visitConstantClass(ConstantClass constantClass) {
        String classname = constantClass.getConstantValue(this.constantPool).toString();
        this.addSlashClass(classname);
    }

    public void visitConstantNameAndType(ConstantNameAndType obj) {
        String name = obj.getName(this.constantPool);
        if (obj.getSignature(this.constantPool).equals("Ljava/lang/Class;") && name.startsWith("class$")) {
            String classname = name.substring("class$".length()).replace('$', '.');
            int index = classname.lastIndexOf(".");
            if (index > 0) {
                int index2 = classname.lastIndexOf(".", index - 1);
                char start = index2 != -1 ? classname.charAt(index2 + 1) : classname.charAt(0);
                if (start > '@' && start < '[') {
                    classname = classname.substring(0, index) + "$" + classname.substring(index + 1);
                    this.addClass(classname);
                } else {
                    this.addClass(classname);
                }
            } else {
                this.addClass(classname);
            }
        }
    }

    public void visitField(Field field) {
        this.addClasses(field.getSignature());
    }

    public void visitJavaClass(JavaClass javaClass) {
        this.addClass(javaClass.getClassName());
    }

    public void visitMethod(Method method) {
        String signature = method.getSignature();
        int pos = signature.indexOf(")");
        this.addClasses(signature.substring(1, pos));
        this.addClasses(signature.substring(pos + 1));
    }

    void addClass(String classname) {
        this.dependencies.put(classname, classname);
    }

    private void addClasses(String string) {
        StringTokenizer tokens = new StringTokenizer(string, ";");
        while (tokens.hasMoreTokens()) {
            String descriptor = tokens.nextToken();
            int pos = descriptor.indexOf(76);
            if (pos == -1) continue;
            this.addSlashClass(descriptor.substring(pos + 1));
        }
    }

    private void addSlashClass(String classname) {
        this.addClass(classname.replace('/', '.'));
    }
}

