/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting.editors;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.scripting.editors.Messages;
import com.aptana.ide.scripting.events.EventTarget;
import com.aptana.ide.scripting.parsing.LexemeList;
import com.aptana.ide.scripting.parsing.ParseResults;
import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class Editor
extends EventTarget {
    private static final long serialVersionUID = 2489151579665730844L;
    private IEditorPart _editor;
    private DocumentRewriteSession _key;

    public String getClassName() {
        return "Editor";
    }

    private IDocument getDocument() {
        ISourceViewer viewer;
        IUnifiedEditor uniEditor = this.getUnifiedEditor();
        IDocument result = null;
        if (uniEditor != null && (viewer = uniEditor.getViewer()) != null) {
            result = viewer.getDocument();
        }
        return result;
    }

    private FileService getFileService() {
        IUnifiedEditor uniEditor = this.getUnifiedEditor();
        FileService result = null;
        if (uniEditor != null) {
            EditorFileContext service = uniEditor.getFileContext();
            if (service instanceof EditorFileContext) {
                service = service.getFileContext();
            }
            if (service instanceof FileService) {
                result = (FileService)service;
            }
        }
        return result;
    }

    private IFileSourceProvider getSourceProvider() {
        FileService fileService = this.getFileService();
        IFileSourceProvider result = null;
        if (fileService != null) {
            result = fileService.getSourceProvider();
        }
        return result;
    }

    private StyledText getStyledText() {
        ISourceViewer viewer;
        IUnifiedEditor uniEditor = this.getUnifiedEditor();
        StyledText result = null;
        if (uniEditor != null && (viewer = uniEditor.getViewer()) != null) {
            result = viewer.getTextWidget();
        }
        return result;
    }

    private IUnifiedEditor getUnifiedEditor() {
        ITextEditor editor;
        IEditorPart part = this._editor;
        IUnifiedEditor result = null;
        if (part instanceof ITextEditor && (editor = (ITextEditor)part) instanceof IUnifiedEditor) {
            result = (IUnifiedEditor)editor;
        }
        return result;
    }

    public Editor(Scriptable scope, IEditorPart editor) {
        this.setParentScope(scope);
        this._editor = editor;
        String[] functions = new String[]{"applyEdit", "beginCompoundChange", "close", "endCompoundChange", "getLineAtOffset", "getOffsetAtLine", "save", "selectAndReveal", "showSelection", "toString"};
        this.defineFunctionProperties(functions, Editor.class, 5);
        this.defineProperty("file", Editor.class, 5);
        this.defineProperty("id", Editor.class, 5);
        this.defineProperty("language", Editor.class, 5);
        this.defineProperty("lexemes", Editor.class, 5);
        this.defineProperty("lineDelimiter", Editor.class, 5);
        this.defineProperty("parseResults", Editor.class, 5);
        this.defineProperty("source", Editor.class, 5);
        this.defineProperty("sourceLength", Editor.class, 5);
        this.defineProperty("selectionRange", Editor.class, 5);
        this.defineProperty("tabWidth", Editor.class, 5);
        this.defineProperty("title", Editor.class, 5);
        this.defineProperty("topIndex", Editor.class, 5);
        this.defineProperty("uri", Editor.class, 5);
        this.defineProperty("currentOffset", Editor.class, 4);
        this.defineProperty("wordWrap", Editor.class, 4);
    }

    public void save() {
        if (this._editor != null) {
            this._editor.doSave(null);
        }
    }

    public void selectAndReveal(final int offset, final int length) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                IUnifiedEditor uniEditor = Editor.this.getUnifiedEditor();
                uniEditor.selectAndReveal(offset, length);
            }
        });
    }

    public int getCurrentOffset() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        class ResultRef {
            public int result = -1;

            ResultRef() {
            }
        }
        final ResultRef result = new ResultRef();
        display.syncExec(new Runnable(){
            {
            }

            public void run() {
                StyledText textWidget = Editor.this.getStyledText();
                if (textWidget != null) {
                    result.result = textWidget.getCaretOffset();
                }
            }
        });
        return result.result;
    }

    public void setCurrentOffset(int offset) {
        StyledText textWidget = this.getStyledText();
        if (textWidget != null) {
            textWidget.setCaretOffset(offset);
        }
    }

    public Object getFile() {
        Object result;
        IFileSourceProvider sourceProvider = this.getSourceProvider();
        if (sourceProvider != null) {
            String sourcePath = sourceProvider.getSourceURI();
            Context cx = Context.getCurrentContext();
            result = cx.newObject(this.getParentScope(), "File", new Object[]{CoreUIUtils.getPathFromURI((String)sourcePath)});
        } else {
            result = Context.getUndefinedValue();
        }
        return result;
    }

    public String getUri() {
        IFileSourceProvider sourceProvider = this.getSourceProvider();
        if (sourceProvider != null) {
            String uri = sourceProvider.getSourceURI();
            return uri;
        }
        return null;
    }

    public Object getLanguage() {
        FileService fileService = this.getFileService();
        Object result = fileService != null ? fileService.getDefaultLanguage() : Context.getUndefinedValue();
        return result;
    }

    public Scriptable getLexemes() {
        FileService service = this.getFileService();
        Context cx = Context.getCurrentContext();
        Object result = service != null ? new LexemeList(this.getParentScope(), service.getLexemeList()) : cx.newArray(this.getParentScope(), 0);
        return result;
    }

    public Scriptable getParseResults() {
        FileService service = this.getFileService();
        Context cx = Context.getCurrentContext();
        Object result = service != null ? new ParseResults(this.getParentScope(), service.getParseState()) : cx.newArray(this.getParentScope(), 0);
        return result;
    }

    public String getLineDelimiter() {
        String[] delims;
        IDocument document = this.getDocument();
        String result = "\n";
        if (document != null && (delims = document.getLegalLineDelimiters()).length > 0) {
            result = delims[0];
        }
        return result;
    }

    public String getId() {
        String result = "";
        if (this._editor != null) {
            result = this._editor.getSite().getId();
        }
        return result;
    }

    public Scriptable getSelectionRange() {
        StyledText textWidget = this.getStyledText();
        Context cx = Context.getCurrentContext();
        Scriptable result = null;
        if (textWidget != null) {
            Point p = textWidget.getSelection();
            result = cx.newObject(this.getParentScope(), "Object", new Object[0]);
            result.put("startingOffset", result, (Object)new Integer(p.x));
            result.put("endingOffset", result, (Object)new Integer(p.y));
        }
        return result;
    }

    public String getSource() {
        IFileSourceProvider sourceProvider = this.getSourceProvider();
        String result = "";
        if (sourceProvider != null) {
            try {
                result = sourceProvider.getSource();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Editor_Error, (Throwable)e);
            }
        }
        return result;
    }

    public int getSourceLength() {
        IFileSourceProvider sourceProvider = this.getSourceProvider();
        int result = 0;
        if (sourceProvider != null) {
            result = sourceProvider.getSourceLength();
        }
        return result;
    }

    public int getTabWidth() {
        IUnifiedEditor uniEditor = this.getUnifiedEditor();
        int result = 4;
        if (uniEditor != null) {
            ISourceViewer viewer = uniEditor.getViewer();
            result = uniEditor.getConfiguration().getTabWidth(viewer);
        }
        return result;
    }

    public String getTitle() {
        IUnifiedEditor uniEditor = this.getUnifiedEditor();
        if (uniEditor != null) {
            return ((IEditorPart)uniEditor).getTitle();
        }
        return null;
    }

    public int getTopIndex() {
        StyledText textWidget = this.getStyledText();
        int result = -1;
        if (textWidget != null) {
            result = textWidget.getTopIndex();
        }
        return result;
    }

    public boolean getWordWrap() {
        StyledText textWidget = this.getStyledText();
        boolean result = false;
        if (textWidget != null) {
            result = textWidget.getWordWrap();
        }
        return result;
    }

    public void setWordWrap(boolean wrap) {
        StyledText textWidget = this.getStyledText();
        if (textWidget != null) {
            textWidget.setWordWrap(wrap);
        }
    }

    public void applyEdit(int offset, int deleteLength, String insertText) {
        IEditorPart part = this._editor;
        if (part instanceof AbstractTextEditor) {
            ITextEditor editor = (ITextEditor)part;
            IDocumentProvider dp = editor.getDocumentProvider();
            IDocument doc = dp.getDocument((Object)editor.getEditorInput());
            try {
                doc.replace(offset, deleteLength, insertText);
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Editor_Error, (Throwable)e);
            }
        }
    }

    public void beginCompoundChange() {
        if (this._key == null) {
            IDocument document = this.getDocument();
            if (document != null) {
                IDocumentExtension4 docExt = (IDocumentExtension4)document;
                this._key = docExt.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
            }
        } else {
            throw new IllegalStateException(Messages.Editor_Unclosed_Compound_Change);
        }
    }

    public void close(boolean save) {
        IUnifiedEditor uniEditor = this.getUnifiedEditor();
        if (uniEditor != null) {
            uniEditor.close(save);
        }
    }

    public void endCompoundChange() {
        if (this._key != null) {
            IDocument document = this.getDocument();
            if (document != null) {
                IDocumentExtension4 docExt = (IDocumentExtension4)document;
                docExt.stopRewriteSession(this._key);
            }
            this._key = null;
        }
    }

    public int getLineAtOffset(int offset) {
        StyledText textWidget = this.getStyledText();
        int result = -1;
        if (textWidget != null) {
            result = textWidget.getLineAtOffset(offset);
        }
        return result;
    }

    public int getOffsetAtLine(final int line) {
        class Result {
            public int result;

            Result() {
            }
        }
        final Result r = new Result();
        r.result = -1;
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){
            {
            }

            public void run() {
                StyledText textWidget = Editor.this.getStyledText();
                if (textWidget != null) {
                    r.result = textWidget.getOffsetAtLine(line);
                }
            }
        });
        return r.result;
    }

    public void showSelection() {
        StyledText textWidget = this.getStyledText();
        if (textWidget != null) {
            textWidget.showSelection();
        }
    }

    public String toString() {
        return "[object Editor]";
    }
}

