/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting.editors;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.editor.html.HTMLEditor;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.scripting.ScriptingEngine;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.scripting.editors.Editor;
import com.aptana.ide.scripting.editors.EditorType;
import com.aptana.ide.scripting.editors.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Editors
extends ScriptableObject {
    private static final long serialVersionUID = -1034231442157154583L;
    private Hashtable _editorsByType;
    private Callable _bracketMatcher;
    public static final int UNIFIED_EDITOR = 0;
    public static final int CSS_EDITOR = 1;
    public static final int HTML_EDITOR = 2;
    public static final int JAVASCRIPT_EDITOR = 3;
    public static final int XML_EDITOR = 4;

    public String getClassName() {
        return "Editors";
    }

    public Editors(Scriptable scope) {
        this.setParentScope(scope);
        String[] names = new String[]{"getEditorType", "open", "applyEditToActiveEditor"};
        this.defineFunctionProperties(names, Editors.class, 5);
        this.defineProperty("all", Editors.class, 5);
        this.defineProperty("activeEditor", Editors.class, 5);
        this.defineProperty("activeErrors", Editors.class, 5);
        this.defineProperty("bracketMatcher", Editors.class, 4);
        this.defineProperty("UNIFIED_EDITOR", new Integer(0), 5);
        this.defineProperty("CSS_EDITOR", new Integer(1), 5);
        this.defineProperty("HTML_EDITOR", new Integer(2), 5);
        this.defineProperty("JAVASCRIPT_EDITOR", new Integer(3), 5);
        this.defineProperty("XML_EDITOR", new Integer(4), 5);
    }

    public void setBracketMatcher(Object callback) {
        this._bracketMatcher = callback instanceof Callable ? (Callable)callback : null;
    }

    public Callable getBracketMatcher() {
        return this._bracketMatcher;
    }

    public static Scriptable getAll(ScriptableObject thisObj) {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final ArrayList editors = new ArrayList();
        Display display = workbench.getDisplay();
        final Scriptable scope = thisObj.getParentScope();
        display.syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage[] pages = window.getPages();
                int i = 0;
                while (i < pages.length) {
                    IWorkbenchPage page = pages[i];
                    IEditorReference[] editorRefs = page.getEditorReferences();
                    int j = 0;
                    while (j < editorRefs.length) {
                        IEditorPart editor = editorRefs[j].getEditor(false);
                        editors.add(new Editor(scope, editor));
                        ++j;
                    }
                    ++i;
                }
            }
        });
        Context cx = Context.getCurrentContext();
        Object[] args = editors.toArray();
        return cx.newArray(scope, args);
    }

    public static Object applyEditToActiveEditor(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        final String insertText = Context.toString((Object)args[0]);
        final IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                int offset = -1;
                IEditorPart activeEditor = null;
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null && window.getActivePage() != null && (activeEditor = window.getActivePage().getActiveEditor()) instanceof IUnifiedEditor) {
                    ITextEditor editor = (ITextEditor)activeEditor;
                    IDocumentProvider dp = editor.getDocumentProvider();
                    IDocument doc = dp.getDocument((Object)editor.getEditorInput());
                    StyledText textWidget = ((IUnifiedEditor)editor).getViewer().getTextWidget();
                    if (textWidget != null) {
                        offset = textWidget.getCaretOffset();
                        try {
                            doc.replace(offset, 0, insertText);
                        }
                        catch (BadLocationException e) {
                            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Editors_Error, (Throwable)e);
                        }
                    }
                }
            }
        });
        return null;
    }

    public static Object getActiveEditor(ScriptableObject thisObj) {
        IEditorPart editor = ScriptingEngine.getActiveEditor();
        Object result = editor != null ? new Editor(thisObj.getParentScope(), editor) : Context.getUndefinedValue();
        return result;
    }

    public static IFileError[] getActiveErrors(ScriptableObject thisObj) {
        IFileError[] result;
        IEditorPart part = ScriptingEngine.getActiveEditor();
        if (part != null && part instanceof IUnifiedEditor) {
            IUnifiedEditor editor = (IUnifiedEditor)part;
            result = editor.getFileContext().getFileErrors();
        } else {
            result = new IFileError[]{};
        }
        return result;
    }

    public EditorType[] getAllEventTargets() {
        if (this._editorsByType != null) {
            return this._editorsByType.values().toArray(new EditorType[0]);
        }
        return new EditorType[0];
    }

    public EditorType getEventTarget(String type) {
        if (this._editorsByType != null && this._editorsByType.containsKey(type)) {
            return (EditorType)this._editorsByType.get(type);
        }
        return null;
    }

    public static Scriptable getEditorType(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Editors instance = (Editors)thisObj;
        String type = Context.toString((Object)args[0]);
        if (instance._editorsByType == null) {
            instance._editorsByType = new Hashtable();
        }
        if (!instance._editorsByType.containsKey(type)) {
            EditorType editorType = new EditorType(type);
            editorType.setParentScope(instance.getParentScope());
            instance._editorsByType.put(type, editorType);
        }
        return (EditorType)instance._editorsByType.get(type);
    }

    public static Scriptable open(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String filename = Context.toString((Object)args[0]);
        File file = new File(filename);
        IEditorPart editor = WorkbenchHelper.openFile((File)file, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        if (editor == null) {
            return null;
        }
        if (editor instanceof HTMLEditor) {
            HTMLEditor html = (HTMLEditor)editor;
            editor = html.getSourceEditor();
        }
        return new Editor(thisObj.getParentScope(), editor);
    }
}

