/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting.views;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.views.actions.Action;
import com.aptana.ide.editors.views.actions.ActionSet;
import com.aptana.ide.editors.views.actions.ActionsManager;
import com.aptana.ide.editors.views.actions.ActionsViewEvent;
import com.aptana.ide.editors.views.actions.IAction;
import com.aptana.ide.editors.views.actions.IActionsViewEventListener;
import com.aptana.ide.scripting.Global;
import com.aptana.ide.scripting.ScriptInfo;
import com.aptana.ide.scripting.ScriptingEngine;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.scripting.editors.Editor;
import com.aptana.ide.scripting.events.ActionsAddEvent;
import com.aptana.ide.scripting.events.ActionsCreateSetEvent;
import com.aptana.ide.scripting.events.ActionsDeleteEvent;
import com.aptana.ide.scripting.events.ActionsDeleteSetEvent;
import com.aptana.ide.scripting.events.ActionsExecuteEvent;
import com.aptana.ide.scripting.events.Event;
import com.aptana.ide.scripting.io.File;
import com.aptana.ide.scripting.views.Messages;
import com.aptana.ide.scripting.views.View;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ActionsView
extends View
implements IActionsViewEventListener {
    private static final long serialVersionUID = -4383236968215071564L;

    public ActionsView(Scriptable scope, IWorkbenchPart view) {
        super(scope, view);
        this.defineProperty("actions", ActionsView.class, 5);
        this.defineProperty("actionSets", ActionsView.class, 5);
        String[] names = new String[]{"addAction", "createActionSet", "editAction", "expandActionSet", "expandAll", "getActionSet", "refresh", "removeActionSet", "selectAndReveal"};
        this.defineFunctionProperties(names, ActionsView.class, 5);
    }

    public Action addAction(String name, String filepath) {
        return this.getActionsManager().addAction(name, filepath);
    }

    public IAction[] getActions() {
        return this.getActionsManager().getAll();
    }

    private ActionsManager getActionsManager() {
        return UnifiedEditorsPlugin.getDefault().getActionsManager();
    }

    public void expandAll() {
        IWorkbenchPart part = this.getView();
        if (part != null) {
            com.aptana.ide.editors.views.actions.ActionsView actionsView = (com.aptana.ide.editors.views.actions.ActionsView)part;
            actionsView.expandAll();
        }
    }

    public void refresh() {
        IWorkbenchPart part = this.getView();
        if (part != null) {
            com.aptana.ide.editors.views.actions.ActionsView actionsView = (com.aptana.ide.editors.views.actions.ActionsView)part;
            actionsView.refresh();
        }
    }

    public void editAction(String path) {
        IWorkbenchPart part = this.getView();
        if (part != null) {
            com.aptana.ide.editors.views.actions.ActionsView actionsView = (com.aptana.ide.editors.views.actions.ActionsView)part;
            actionsView.editAction(path);
        }
    }

    public void selectAndReveal(String path) {
        IWorkbenchPart part = this.getView();
        if (part != null) {
            com.aptana.ide.editors.views.actions.ActionsView actionsView = (com.aptana.ide.editors.views.actions.ActionsView)part;
            actionsView.selectAndReveal(path);
        }
    }

    public void setView(IWorkbenchPart view) {
        com.aptana.ide.editors.views.actions.ActionsView actionsView;
        if (this.getView() != null) {
            actionsView = (com.aptana.ide.editors.views.actions.ActionsView)this.getView();
            actionsView.removeActionsViewEventListener((IActionsViewEventListener)this);
        }
        super.setView(view);
        if (view != null && view instanceof com.aptana.ide.editors.views.actions.ActionsView) {
            actionsView = (com.aptana.ide.editors.views.actions.ActionsView)view;
            actionsView.addActionsViewEventListener((IActionsViewEventListener)this);
        }
    }

    public void expandActionSet(String name) {
        IWorkbenchPart part = this.getView();
        if (part != null) {
            com.aptana.ide.editors.views.actions.ActionsView actionsView = (com.aptana.ide.editors.views.actions.ActionsView)part;
            actionsView.expandActionSet(name);
        }
    }

    public ActionSet createActionSet(String name) {
        return this.getActionsManager().createActionSet(name);
    }

    public void removeActionSet(String name) {
        this.getActionsManager().removeActionSet(name);
    }

    public ActionSet getActionSet(String name) {
        return this.getActionsManager().getActionSet(name);
    }

    public ActionSet[] getActionSets() {
        return this.getActionsManager().getActionSets();
    }

    public void onActionsViewEvent(ActionsViewEvent e) {
        Event event = null;
        int eventType = e.getEventType();
        switch (eventType) {
            case 7: {
                Global global = ScriptingEngine.getInstance().getGlobal();
                IAction[] actionsToReload = e.getActions();
                int i = 0;
                while (i < actionsToReload.length) {
                    IAction action = actionsToReload[i];
                    String filename = action.getScriptPath();
                    String key = global.getXrefId(filename);
                    ScriptInfo info = global.getScriptInfo(key);
                    Scriptable scope = info.getScope();
                    Object onreload = scope.get("onreload", scope);
                    if (onreload instanceof Function) {
                        Function reloadFunction = (Function)onreload;
                        Context cx = Context.enter();
                        try {
                            reloadFunction.call(cx, scope, scope, new Object[]{action.getPath()});
                        }
                        catch (Exception e1) {
                            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ActionsView_Error, (Throwable)e1);
                        }
                        Context.exit();
                    } else {
                        global.reloadLibrary(filename);
                    }
                    ++i;
                }
                break;
            }
            case 1: 
            case 2: {
                event = new ActionsAddEvent((Object)this.getView(), eventType, e.getPaths());
                break;
            }
            case 3: {
                Context.enter();
                IEditorPart part = ScriptingEngine.getActiveEditor();
                Editor editor = new Editor((Scriptable)ScriptingEngine.getInstance().getGlobal(), part);
                event = new ActionsAddEvent((Object)this.getView(), eventType, (File)((Object)editor.getFile()));
                Context.exit();
                break;
            }
            case 4: {
                event = new ActionsCreateSetEvent(this.getView(), eventType, e.getName());
                break;
            }
            case 5: {
                event = new ActionsDeleteEvent(this.getView(), eventType, e.getActions());
                break;
            }
            case 6: {
                event = new ActionsDeleteSetEvent(this.getView(), eventType, e.getName());
                break;
            }
            case 0: {
                IAction action = e.getActions()[0];
                if (action instanceof ActionSet) {
                    ActionSet actionSet = (ActionSet)action;
                    if (!actionSet.isExecutable()) break;
                    Action[] actions = actionSet.getActions();
                    Arrays.sort(actions, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            IAction action1 = (IAction)o1;
                            IAction action2 = (IAction)o2;
                            return action1.getName().compareTo(action2.getName());
                        }
                    });
                    int i = 0;
                    while (i < actions.length) {
                        ActionsExecuteEvent subEvent = new ActionsExecuteEvent(this.getView(), eventType, new IAction[]{actions[i]});
                        this.fireEventListeners(subEvent);
                        ++i;
                    }
                    break;
                }
                event = new ActionsExecuteEvent(this.getView(), eventType, e.getActions());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(Messages.ActionsView_Unrecognized_Event_Type) + eventType);
            }
        }
        if (event != null) {
            this.fireEventListeners(event);
        }
    }
}

