/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.snippets;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.editors.toolbar.IToolBarMember;
import com.aptana.ide.editors.toolbar.ToolBarContribution;
import com.aptana.ide.editors.toolbar.ToolBarContributionRegistry;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.snippets.Messages;
import com.aptana.ide.snippets.Snippet;
import com.aptana.ide.snippets.SnippetListChangeListener;
import com.aptana.ide.snippets.SnippetsPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

public final class SnippetsManager {
    private static final Snippet[] NO_SNIPPETS = null;
    private static SnippetsManager instance;
    private Map<Snippet, ToolBarContribution> _tContributions = new HashMap<Snippet, ToolBarContribution>();
    private SnippetNode _rootNode = new SnippetNode("");
    private List<SnippetListChangeListener> _snippetListChangeListeners;
    private Map<File, Snippet> _snippetsByFile = new HashMap<File, Snippet>();
    private Map<String, List<Snippet>> _snippetsByCategory = new HashMap<String, List<Snippet>>();
    private String _tempDirectory;

    private SnippetsManager() {
        Path p = new Path(FileUtils.systemTempDir);
        this._tempDirectory = p.append("aptana/snippets").toOSString();
        File f = new File(this._tempDirectory);
        f.mkdir();
    }

    public static SnippetsManager getInstance() {
        if (instance == null) {
            instance = new SnippetsManager();
        }
        return instance;
    }

    public void addChangeListener(SnippetListChangeListener listener) {
        if (listener != null) {
            if (this._snippetListChangeListeners == null) {
                this._snippetListChangeListeners = new ArrayList<SnippetListChangeListener>();
            }
            this._snippetListChangeListeners.add(listener);
        }
    }

    public void fireChangeListeners() {
        if (this._snippetListChangeListeners != null) {
            int i = 0;
            while (i < this._snippetListChangeListeners.size()) {
                this._snippetListChangeListeners.get(i).listChanged(this);
                ++i;
            }
        }
    }

    public void removeChangeListener(SnippetListChangeListener listener) {
        if (listener != null && this._snippetListChangeListeners != null) {
            this._snippetListChangeListeners.remove(listener);
        }
    }

    public void addSnippet(String category, String name, String content) {
        this.addSnippet(new Snippet(category, name, content));
    }

    public void addSnippet(final Snippet snippet) {
        if (snippet == null) {
            throw new IllegalArgumentException(Messages.SnippetsManager_Snippet_Undefined);
        }
        String category = snippet.getCategory();
        if (!this._snippetsByCategory.containsKey(category)) {
            this._snippetsByCategory.put(category, new ArrayList());
        }
        this._snippetsByCategory.get(category).add(snippet);
        String[] path = this.getCategoryPath(category);
        this._rootNode.add(path, 0, snippet);
        File file = snippet.getFile();
        if (file != null) {
            this._snippetsByFile.put(file, snippet);
        }
        if (snippet.isToolbar()) {
            String icon = snippet.getIcon();
            ImageDescriptor imageDescriptor = null;
            if (icon != null && icon.length() != 0) {
                int indexOf = icon.indexOf(47);
                String bundle = icon.substring(0, indexOf);
                String imagePath = icon.substring(indexOf);
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle, (String)imagePath);
            } else {
                imageDescriptor = SnippetsPlugin.getImageDescriptor("/icons/snippet.png");
            }
            ToolBarContribution toolBarContribution = new ToolBarContribution(snippet.getName(), snippet.getTooltip(), imageDescriptor, new IToolBarMember(){

                public void execute(IUnifiedEditor editor, String string) {
                    if (editor instanceof ITextEditor) {
                        snippet.apply((ITextEditor)editor);
                    }
                }
            });
            ToolBarContributionRegistry.getInstance().addContribution(snippet.getLanguage(), toolBarContribution);
            this._tContributions.put(snippet, toolBarContribution);
        }
        this.fireChangeListeners();
    }

    private String[] getCategoryPath(String key) {
        return key.split("->");
    }

    public Snippet[] getSnippetsByCategory(String category) {
        Snippet[] result = NO_SNIPPETS;
        if (this._snippetsByCategory.containsKey(category)) {
            List<Snippet> snippets = this._snippetsByCategory.get(category);
            result = snippets.toArray(new Snippet[snippets.size()]);
        }
        return result;
    }

    public Snippet getSnippetByFile(File file) {
        Snippet result = null;
        if (this._snippetsByFile.containsKey(file)) {
            result = this._snippetsByFile.get(file);
        }
        return result;
    }

    public void loadSnippetDirectory(File snippetsDirectory) {
        File[] files = snippetsDirectory.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            Snippet snippet;
            File file = files[i];
            if (file.isFile() && (snippet = Snippet.fromFile(file)) != null) {
                this.addSnippet(snippet);
            }
            ++i;
        }
    }

    public void removeSnippet(Snippet snippet) {
        if (snippet != null) {
            ToolBarContribution contribution;
            String category = snippet.getCategory();
            if (this._snippetsByCategory.containsKey(category)) {
                List<Snippet> snippets = this._snippetsByCategory.get(category);
                snippets.remove(snippet);
                if (snippets.size() == 0) {
                    this._snippetsByCategory.remove(category);
                }
            }
            String[] path = this.getCategoryPath(category);
            this._rootNode.remove(path, 0, snippet);
            File file = snippet.getFile();
            if (file != null) {
                this._snippetsByFile.remove(file);
            }
            if ((contribution = this._tContributions.get(snippet)) != null) {
                this._tContributions.remove(snippet);
                ToolBarContributionRegistry.getInstance().removeContribution(snippet.getLanguage(), contribution);
            }
        }
    }

    public SnippetNode getRootNode() {
        return this._rootNode;
    }

    public String getSnippetTempDirectory() {
        return this._tempDirectory;
    }

    public class SnippetNode {
        private String categoryName;
        private Map<String, SnippetNode> categoryMap = new HashMap<String, SnippetNode>();
        private List<Snippet> childNodes = new ArrayList<Snippet>();

        public SnippetNode(String name) {
            this.categoryName = name;
        }

        public String getCategoryName() {
            return this.categoryName;
        }

        public boolean hasChilds() {
            return !this.categoryMap.isEmpty() || !this.childNodes.isEmpty();
        }

        public SnippetNode[] getSubCategories() {
            Collection<SnippetNode> values = this.categoryMap.values();
            return values.toArray(new SnippetNode[values.size()]);
        }

        public Object[] getAllChildren() {
            ArrayList<SnippetNode> lst = new ArrayList<SnippetNode>(this.categoryMap.values());
            Collections.sort(lst, new Comparator<SnippetNode>(){

                @Override
                public int compare(SnippetNode n0, SnippetNode n1) {
                    return n0.getCategoryName().compareTo(n1.getCategoryName());
                }
            });
            ArrayList<Snippet> arrayList = new ArrayList<Snippet>(this.childNodes);
            Collections.sort(arrayList, new Comparator<Snippet>(){

                @Override
                public int compare(Snippet n0, Snippet n1) {
                    return n0.getName().compareTo(n1.getName());
                }
            });
            ArrayList<Object> result = new ArrayList<Object>();
            result.addAll(lst);
            result.addAll(arrayList);
            return result.toArray();
        }

        public Snippet[] getChildren() {
            Snippet[] children = new Snippet[this.childNodes.size()];
            this.childNodes.toArray(children);
            return children;
        }

        public void add(String[] path, int position, Snippet snippet) {
            if (position == path.length) {
                this.childNodes.add(snippet);
                return;
            }
            String string = path[position].trim();
            SnippetNode object = this.categoryMap.get(string);
            if (object == null) {
                object = new SnippetNode(string);
                this.categoryMap.put(string, object);
            }
            object.add(path, position + 1, snippet);
        }

        public void remove(String[] path, int position, Snippet snippet) {
            if (position == path.length) {
                if (this.childNodes.remove(snippet)) {
                    SnippetsManager.this.fireChangeListeners();
                }
            } else {
                String string = path[position].trim();
                SnippetNode object = this.categoryMap.get(string);
                if (object != null) {
                    object.remove(path, position + 1, snippet);
                    if (object.childNodes.isEmpty()) {
                        this.categoryMap.remove(string);
                        SnippetsManager.this.fireChangeListeners();
                    }
                }
            }
        }
    }
}

