/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.javacloud.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.IFileProgressMonitor;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.io.file.LocalProtocolManager;
import com.aptana.ide.server.cloud.CloudPlugin;
import com.aptana.ide.server.cloud.services.model.Event;
import com.aptana.ide.server.cloud.services.model.Site;
import com.aptana.ide.server.cloud.services.model.studio.SiteUtils;
import com.aptana.ide.server.cloud.services.model.studio.StudioSite;
import com.aptana.ide.server.cloud.syncing.ICloudDeployer;
import com.aptana.ide.server.javacloud.ui.Messages;
import com.aptana.ide.server.javacloud.util.ImageUtils;
import com.aptana.ide.server.javacloud.util.ResourceUtils;
import com.aptana.ide.server.javacloud.util.WarHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WarUploadDialog
extends TitleAreaDialog {
    private Text commentText;
    private Combo siteSelectionCombo;
    private Text warFileText;
    private File targetFile;
    private Button browseButton;
    private CLabel messageTextLabel;
    private ProgressBar progressBar;
    private Composite progressbarComposite;
    private Button createAndUploadButton;
    private Button uploadPrecreatedButton;
    private boolean createWar = true;
    private IProject project;
    private ICloudDeployer.Endpoint target;
    private StudioSite site;
    private String contextName = "public";
    private String commentHelpUrl = "http://www.aptana.com/docs/index.php/My_Cloud_-_Team#What_is_the_Cloud_Team_Comment_feature.3F";
    private boolean success = true;
    private String message;
    IVirtualFileManager vfm;
    private boolean uploadInProgress = false;
    private Link commentHelpLink;
    private boolean firstEdit = true;
    private boolean nonJavaproject = false;

    public WarUploadDialog(Shell parentShell, StudioSite site, ICloudDeployer.Endpoint target) {
        super(parentShell);
        this.project = site.getProject().getLocalProject();
        this.target = target;
        this.site = site;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public boolean close() {
        if (this.uploadInProgress) {
            String title = Messages.getString("WarUploadDialog.4");
            String message = Messages.getString("WarUploadDialog.5");
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
                return super.close();
            }
            return false;
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.getString("WarUploadDialog.6"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.verticalSpacing = 2;
        container.setLayout((Layout)gridLayout_5);
        container.setLayoutData((Object)new GridData(1808));
        this.setMessage(String.valueOf(Messages.getString("WarUploadDialog.2")) + Messages.getString("WarUploadDialog.3"));
        Group group = new Group(container, 4);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        Composite siteSelectionComposite = new Composite((Composite)group, 0);
        siteSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.verticalSpacing = 0;
        gridLayout_3.marginWidth = 0;
        gridLayout_3.numColumns = 2;
        siteSelectionComposite.setLayout((Layout)gridLayout_3);
        Label deployToLabel = new Label(siteSelectionComposite, 0);
        deployToLabel.setText(Messages.getString("WarUploadDialog.8"));
        this.siteSelectionCombo = new Combo(siteSelectionComposite, 8);
        this.siteSelectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WarUploadDialog.this.siteSelectionCombo.getSelectionIndex() == 0) {
                    WarUploadDialog.this.target = ICloudDeployer.Endpoint.PUBLIC;
                    WarUploadDialog.this.setTitle(String.valueOf(Messages.getString("WarUploadDialog.7")) + Messages.getString("WarUploadDialog.12"));
                } else {
                    WarUploadDialog.this.target = ICloudDeployer.Endpoint.STAGING;
                    WarUploadDialog.this.setTitle(String.valueOf(Messages.getString("WarUploadDialog.7")) + Messages.getString("WarUploadDialog.13"));
                }
            }
        });
        this.siteSelectionCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.siteSelectionCombo.add(Messages.getString("WarUploadDialog.18"));
        this.siteSelectionCombo.add(Messages.getString("WarUploadDialog.19"));
        String siteTypeStr = "Public";
        if (this.target == ICloudDeployer.Endpoint.PUBLIC) {
            siteTypeStr = "Public";
            this.siteSelectionCombo.select(0);
        } else if (this.target == ICloudDeployer.Endpoint.STAGING) {
            siteTypeStr = "Staging";
            this.siteSelectionCombo.select(1);
        }
        this.setTitle(String.valueOf(Messages.getString("WarUploadDialog.7")) + siteTypeStr + Messages.getString("WarUploadDialog.20"));
        this.createAndUploadButton = new Button((Composite)group, 16);
        this.createAndUploadButton.setLayoutData((Object)new GridData());
        this.createAndUploadButton.setSelection(true);
        this.createAndUploadButton.setText(Messages.getString("WarUploadDialog.9"));
        this.createAndUploadButton.setSelection(this.createWar);
        this.uploadPrecreatedButton = new Button((Composite)group, 16);
        this.uploadPrecreatedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WarUploadDialog.this.uploadPrecreatedButton.getSelection()) {
                    WarUploadDialog.this.createWar = false;
                    WarUploadDialog.this.enableUploadForm(true);
                } else {
                    WarUploadDialog.this.enableUploadForm(false);
                    WarUploadDialog.this.createWar = true;
                }
            }
        });
        this.uploadPrecreatedButton.setLayoutData((Object)new GridData());
        this.uploadPrecreatedButton.setText(Messages.getString("WarUploadDialog.10"));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.marginBottom = 5;
        gridLayout_1.horizontalSpacing = 0;
        gridLayout_1.marginHeight = 0;
        gridLayout_1.marginWidth = 0;
        gridLayout_1.marginLeft = 17;
        gridLayout_1.numColumns = 2;
        composite.setLayout((Layout)gridLayout_1);
        this.warFileText = new Text(composite, 2048);
        this.warFileText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                WarUploadDialog.this.messageTextLabel.setVisible(false);
            }
        });
        GridData gd_warFileText = new GridData(4, 0x1000000, true, false);
        this.warFileText.setLayoutData((Object)gd_warFileText);
        this.browseButton = new Button(composite, 0);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String resource = null;
                FileDialog dlg = new FileDialog(WarUploadDialog.this.getShell(), 4096);
                dlg.setFilterExtensions(new String[]{"*.war"});
                resource = dlg.open();
                if (resource != null) {
                    WarUploadDialog.this.warFileText.setText(resource);
                    WarUploadDialog.this.messageTextLabel.setVisible(false);
                }
            }
        });
        this.browseButton.setLayoutData((Object)new GridData());
        this.browseButton.setText(Messages.getString("WarUploadDialog.14"));
        this.uploadPrecreatedButton.setSelection(!this.createWar);
        this.enableUploadForm(this.uploadPrecreatedButton.getSelection());
        Composite compositeComment = new Composite((Composite)group, 0);
        compositeComment.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.marginWidth = 0;
        gridLayout_4.verticalSpacing = 0;
        gridLayout_4.marginHeight = 0;
        gridLayout_4.numColumns = 2;
        compositeComment.setLayout((Layout)gridLayout_4);
        CLabel enterDeployCommentLabel = new CLabel(compositeComment, 0);
        enterDeployCommentLabel.setText(Messages.getString("WarUploadDialog.29"));
        this.commentHelpLink = new Link(compositeComment, 0x1000008);
        this.commentHelpLink.setText(Messages.getString("WarUploadDialog.30"));
        GridData helpLinkGridData = new GridData(0x1000008, 0x1000000, true, false);
        this.commentHelpLink.setLayoutData((Object)helpLinkGridData);
        this.commentHelpLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURL((String)WarUploadDialog.this.commentHelpUrl);
            }
        });
        this.commentText = new Text(compositeComment, 2114);
        this.commentText.setText(Messages.getString("WarUploadDialog.31"));
        GridData gd_commentText = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_commentText.heightHint = 75;
        this.commentText.setLayoutData((Object)gd_commentText);
        this.commentText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (WarUploadDialog.this.firstEdit) {
                    WarUploadDialog.this.firstEdit = false;
                    WarUploadDialog.this.commentText.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.progressbarComposite = new Composite((Composite)group, 0);
        GridData gd_progressbarComposite = new GridData(4, 0x1000000, true, false);
        this.progressbarComposite.setLayoutData((Object)gd_progressbarComposite);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.marginWidth = 0;
        gridLayout_2.marginBottom = 10;
        gridLayout_2.marginHeight = 0;
        this.progressbarComposite.setLayout((Layout)gridLayout_2);
        this.messageTextLabel = new CLabel(this.progressbarComposite, 64);
        GridData gd_progressTextLabel = new GridData(16384, 0x1000000, true, false);
        gd_progressTextLabel.heightHint = 49;
        this.messageTextLabel.setLayoutData((Object)gd_progressTextLabel);
        this.messageTextLabel.setText(Messages.getString("WarUploadDialog.40"));
        this.messageTextLabel.setVisible(false);
        this.progressBar = new ProgressBar(this.progressbarComposite, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.showProgressbar(false);
        this.setTitleImage(ImageUtils.getIcon("upload_war_large.gif"));
        this.checkProjectType();
        return area;
    }

    private void checkProjectType() {
        try {
            if (!this.project.hasNature("org.eclipse.wst.common.project.facet.core.nature")) {
                this.uploadPrecreatedButton.setSelection(true);
                this.enableUploadForm(true);
                this.createAndUploadButton.setEnabled(false);
                this.createAndUploadButton.setSelection(false);
                this.createWar = false;
                this.setMessage(Messages.getString("WarUploadDialog.72"));
            }
        }
        catch (CoreException exc) {
            IdeLog.logError((Plugin)CloudPlugin.getDefault(), (String)exc.getLocalizedMessage(), (Throwable)exc);
        }
    }

    private void enableUploadForm(boolean enabled) {
        this.warFileText.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    private void enableForm(boolean enabled) {
        this.warFileText.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.uploadPrecreatedButton.setEnabled(enabled);
        this.createAndUploadButton.setEnabled(enabled);
        this.commentText.setEnabled(enabled);
        this.commentHelpLink.setEnabled(enabled);
    }

    private void showProgressbar(final boolean visible) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                WarUploadDialog.this.progressBar.setVisible(visible);
                WarUploadDialog.this.progressbarComposite.layout(true);
            }
        });
    }

    private void initializeProgressBar(final int min, final int max) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                WarUploadDialog.this.progressBar.setMinimum(min);
                WarUploadDialog.this.progressBar.setMaximum(max);
                WarUploadDialog.this.progressbarComposite.layout(true);
            }
        });
    }

    private void setProgressValue(final int value) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                WarUploadDialog.this.progressBar.setSelection(value);
                WarUploadDialog.this.progressbarComposite.layout(true);
            }
        });
    }

    private void showMessage(final String message, final int type) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                WarUploadDialog.this.messageTextLabel.setVisible(true);
                if (type == 0) {
                    WarUploadDialog.this.messageTextLabel.setForeground(ResourceUtils.getColor(60, 155, 60));
                } else if (type == 1) {
                    WarUploadDialog.this.messageTextLabel.setForeground(ResourceUtils.getColor(150, 25, 25));
                } else if (type == 2) {
                    WarUploadDialog.this.messageTextLabel.setForeground(ResourceUtils.getColor(0, 0, 0));
                }
                WarUploadDialog.this.messageTextLabel.setText(message);
                WarUploadDialog.this.progressbarComposite.layout(true);
            }
        });
    }

    private void debugMessage(String msg) {
        System.out.println(msg);
    }

    private void uploadWar() {
        this.uploadInProgress = true;
        this.debugMessage(Messages.getString("WarUploadDialog.28"));
        String warFileName = "ROOT.war";
        try {
            File tempDir = File.createTempFile("xyz", ".war").getParentFile();
            File tempFile = new File(tempDir, warFileName);
            if (tempFile.exists()) {
                tempFile.delete();
            }
            if (this.target == ICloudDeployer.Endpoint.PUBLIC) {
                this.contextName = "public";
                this.vfm = SiteUtils.findCloudVFM((Site)this.site);
            } else if (this.target == ICloudDeployer.Endpoint.STAGING) {
                this.contextName = "staging";
                this.vfm = SiteUtils.findStagingCloudVFM((Site)this.site);
            }
            if (this.createWar) {
                this.showMessage(Messages.getString("WarUploadDialog.32"), 2);
                File projectRoot = this.project.getLocation().toFile();
                String webContentPath = "WebContent";
                String classesPath = "build/classes";
                WarHelper warCreator = new WarHelper(webContentPath, classesPath, this.contextName);
                this.debugMessage(String.valueOf(Messages.getString("WarUploadDialog.38")) + tempFile.getAbsolutePath());
                warCreator.create(tempFile, projectRoot.getCanonicalFile());
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        WarUploadDialog.this.targetFile = new File(WarUploadDialog.this.warFileText.getText());
                    }
                });
                this.copyFile(this.targetFile, tempFile);
            }
            this.targetFile = tempFile;
            this.showMessage(String.valueOf(Messages.getString("WarUploadDialog.33")) + this.site.getPrimaryDomainName(), 2);
            this.vfm.connect();
            IVirtualFile remoteFile = this.vfm.createVirtualFile(String.valueOf(this.vfm.getBasePath()) + "/" + warFileName);
            LocalProtocolManager lpm = LocalProtocolManager.getInstance();
            IVirtualFileManager lvfm = lpm.createFileManager(true);
            IVirtualFile localFile = lvfm.createVirtualFile(this.targetFile.getAbsolutePath());
            final long totalSize = this.targetFile.length();
            this.initializeProgressBar(0, 100);
            this.vfm.setPoolSizes(1, 5);
            this.vfm.putFile(localFile, remoteFile, new IFileProgressMonitor(){

                public void bytesTransferred(long bytes) {
                    WarUploadDialog.this.showMessage(String.valueOf(Messages.getString("WarUploadDialog.35")) + bytes / 1024L + Messages.getString("WarUploadDialog.36") + totalSize / 1024L + Messages.getString("WarUploadDialog.37"), 2);
                    WarUploadDialog.this.setProgressValue((int)((double)((float)bytes / (float)totalSize) * 100.0));
                }

                public void done() {
                    WarUploadDialog.this.message = Messages.getString("WarUploadDialog.40");
                    WarUploadDialog.this.success = true;
                    WarUploadDialog.this.uploadComplete();
                }
            });
        }
        catch (Exception exc) {
            this.success = false;
            this.message = exc.getLocalizedMessage();
            this.debugMessage(exc.getLocalizedMessage());
            IdeLog.logError((Plugin)CloudPlugin.getDefault(), (String)exc.getLocalizedMessage(), (Throwable)exc);
            this.uploadComplete();
        }
    }

    private void uploadComplete() {
        this.uploadInProgress = false;
        this.showProgressbar(false);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (WarUploadDialog.this.success) {
                    WarUploadDialog.this.getButton(0).setVisible(true);
                    WarUploadDialog.this.getButton(0).setText(IDialogConstants.CLOSE_LABEL);
                    WarUploadDialog.this.showMessage(WarUploadDialog.this.message, 2);
                    String comment = "";
                    if (!WarUploadDialog.this.firstEdit) {
                        comment = "\n" + WarUploadDialog.this.commentText.getText();
                    }
                    WarUploadDialog.this.createCommentEvent(comment);
                } else {
                    WarUploadDialog.this.getButton(0).setText(Messages.getString("WarUploadDialog.42"));
                    WarUploadDialog.this.getButton(0).setVisible(true);
                    WarUploadDialog.this.getButton(1).setVisible(true);
                    WarUploadDialog.this.showMessage(WarUploadDialog.this.message, 1);
                }
            }
        });
    }

    private void copyFile(File from, File to) throws IOException {
        FileChannel srcChannel = new FileInputStream(from).getChannel();
        FileChannel dstChannel = new FileOutputStream(to).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getButton(0).setText(Messages.getString("WarUploadDialog.48"));
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(500, 515);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.getButton(buttonId).getText().equals(Messages.getString("WarUploadDialog.49"))) {
            if (!this.createWar) {
                if (this.warFileText.getText().trim().equals("")) {
                    this.showMessage(Messages.getString("WarUploadDialog.53"), 1);
                    return;
                }
                this.targetFile = new File(this.warFileText.getText());
                if (!this.targetFile.exists()) {
                    this.showMessage(Messages.getString("WarUploadDialog.54"), 1);
                    return;
                }
                if (!this.targetFile.getName().endsWith(".war")) {
                    this.showMessage(Messages.getString("WarUploadDialog.56"), 1);
                    return;
                }
            }
            this.enableForm(false);
            this.getButton(1).setVisible(false);
            this.getButton(0).setText(IDialogConstants.CANCEL_LABEL);
            this.showProgressbar(true);
            Job dbJob = new Job("syncJob"){

                public IStatus run(IProgressMonitor monitor) {
                    WarUploadDialog.this.uploadWar();
                    return Status.OK_STATUS;
                }
            };
            dbJob.setPriority(20);
            dbJob.setSystem(true);
            dbJob.schedule();
        } else if (buttonId == 0 && this.getButton(buttonId).getText().equals(IDialogConstants.CANCEL_LABEL)) {
            if (this.vfm != null) {
                this.uploadInProgress = false;
                this.showMessage(Messages.getString("WarUploadDialog.57"), 1);
                this.vfm.cancel();
                this.showProgressbar(false);
                this.getButton(0).setText(IDialogConstants.CLOSE_LABEL);
            }
        } else {
            this.close();
        }
    }

    public boolean isHelpAvailable() {
        return false;
    }

    private void createCommentEvent(String comment) {
        User user = AptanaUser.getSignedInUser();
        String domainName = this.site.getPrimaryDomainName();
        if (this.target == ICloudDeployer.Endpoint.STAGING) {
            domainName = this.site.getStagingDomainName();
        }
        String subject = MessageFormat.format(Messages.getString("WarUploadDialog.50"), user.getUsername(), domainName);
        StringBuilder buffer = new StringBuilder(subject);
        if (comment != null && comment.length() > 0) {
            buffer.append("\n");
            buffer.append(Messages.getString("WarUploadDialog.51"));
            buffer.append("\n");
            buffer.append(comment);
            buffer.append("\n\n");
        }
        Event event = new Event(subject, buffer.toString());
        event.setId(Integer.toString(31));
        event.setLocation(this.site.getEvents().getLocation());
        event.setRequestBuilder(this.site.getRequestBuilder());
        event.setServiceProvider(this.site.getServiceProvider());
        event.setLogger(this.site.getLogger());
        event.commit();
        this.site.updateLastSync();
        this.site.getEvents().updateMaxSizeWithSeverities();
    }
}

