/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.javacloud.util;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.cloud.CloudPlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class JarUtil {
    public static void replaceContext(File jarFile, String contextName) throws IOException {
        File tempJarFile = File.createTempFile("xyz", "war");
        JarFile jar = new JarFile(jarFile);
        boolean jarUpdated = false;
        try {
            jar.getManifest();
            JarOutputStream tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
            byte[] buffer = new byte[1024];
            try {
                try {
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        InputStream entryStream = jar.getInputStream(entry);
                        if (entry.getName().contains("web.xml")) {
                            tempJar.putNextEntry(entry);
                            Document doc = JarUtil.parseXmlFile(entryStream, contextName);
                            DOMSource source = new DOMSource(doc);
                            StreamResult result = new StreamResult(tempJar);
                            Transformer xformer = TransformerFactory.newInstance().newTransformer();
                            xformer.setOutputProperty("indent", "yes");
                            xformer.transform(source, result);
                        } else {
                            int bytesRead;
                            tempJar.putNextEntry(entry);
                            while ((bytesRead = entryStream.read(buffer)) != -1) {
                                tempJar.write(buffer, 0, bytesRead);
                            }
                        }
                        entryStream.close();
                    }
                    jarUpdated = true;
                }
                catch (Exception exc) {
                    IdeLog.logError((Plugin)CloudPlugin.getDefault(), (String)exc.getLocalizedMessage(), (Throwable)exc);
                }
            }
            finally {
                tempJar.close();
            }
        }
        finally {
            jar.close();
            if (!jarUpdated) {
                tempJarFile.delete();
            }
        }
        if (jarUpdated) {
            jarFile.delete();
            tempJarFile.renameTo(jarFile);
        }
    }

    private static Document parseXmlFile(InputStream is, String contextName) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().parse(is);
        NodeList displayNameNodes = doc.getDocumentElement().getElementsByTagName("display-name");
        int i = 0;
        while (i < displayNameNodes.getLength()) {
            Node child;
            Node node = displayNameNodes.item(i);
            if (node.getParentNode().getNodeName().equals("web-app") && node.hasChildNodes() && (child = node.getFirstChild()).getNodeType() == 3) {
                node.removeChild(child);
                Text newChild = doc.createTextNode(contextName);
                node.appendChild(newChild);
            }
            ++i;
        }
        return doc;
    }
}

