/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.javacloud.util;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.server.cloud.CloudPlugin;
import com.aptana.ide.server.javacloud.util.Messages;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.progress.UIJob;

public class JavaCloudSupport {
    public static boolean hasJavaSupport(String privateDomainName, String username, String password) {
        HttpClient client = new HttpClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        GetMethod undeployGet = null;
        try {
            String tomcatManagerUrl = "http://" + privateDomainName + "/manager/html";
            undeployGet = new GetMethod(String.valueOf(tomcatManagerUrl) + "/list");
            undeployGet.setDoAuthentication(true);
            undeployGet.getParams().setBooleanParameter("http.protocol.expect-continue", false);
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            int status = client.executeMethod((HttpMethod)undeployGet);
            return status == 200;
        }
        catch (Exception exc) {
            IdeLog.logError((Plugin)CloudPlugin.getDefault(), (String)exc.getLocalizedMessage(), (Throwable)exc);
            return false;
        }
    }

    public static void showJavaDisabledErrorMessage() {
        UIJob job = new UIJob("Syncing"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String title = Messages.getString("JavaCloudSupport.3");
                String message = String.valueOf(Messages.getString("JavaCloudSupport.4")) + Messages.getString("JavaCloudSupport.5");
                String infoButtonMessage = Messages.getString("JavaCloudSupport.6");
                MessageDialog dialog = new MessageDialog(CoreUIUtils.getActiveShell(), title, null, message, 2, new String[]{infoButtonMessage, IDialogConstants.CANCEL_LABEL}, 1);
                int retCode = dialog.open();
                if (retCode == 0) {
                    CoreUIUtils.openBrowserURL((String)"http://www.aptana.com/docs/index.php/Java_Cloud_Deployment#Enable_Java_Support");
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void showJavaEnabledErrorMessage() {
        UIJob job = new UIJob("Syncing"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String title = Messages.getString("JavaCloudSupport.7");
                String message = String.valueOf(Messages.getString("JavaCloudSupport.8")) + Messages.getString("JavaCloudSupport.9");
                String infoButtonMessage = Messages.getString("JavaCloudSupport.10");
                MessageDialog dialog = new MessageDialog(CoreUIUtils.getActiveShell(), title, null, message, 2, new String[]{infoButtonMessage, IDialogConstants.CANCEL_LABEL}, 1);
                int retCode = dialog.open();
                if (retCode == 0) {
                    CoreUIUtils.openBrowserURL((String)"http://www.aptana.com/docs/index.php/Java_Cloud_Deployment#Disable_Java_Support");
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

