/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.javacloud.util;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ResourceUtils {
    private static HashMap<RGB, Color> colorMap = new HashMap();
    private static HashMap<String, Font> fontMap = new HashMap();
    private static HashMap<Font, Font> fontToBoldFontMap = new HashMap();
    private static HashMap<Integer, Cursor> idToCursorMap = new HashMap();

    public static Color getColor(int systemColorID) {
        Display display = Display.getCurrent();
        return display.getSystemColor(systemColorID);
    }

    public static Color getColor(int r, int g, int b) {
        return ResourceUtils.getColor(new RGB(r, g, b));
    }

    public static Color getColor(RGB rgb) {
        Color color = colorMap.get(rgb);
        if (color == null) {
            Display display = Display.getCurrent();
            color = new Color((Device)display, rgb);
            colorMap.put(rgb, color);
        }
        return color;
    }

    public static void disposeColors() {
        Iterator<Color> iter = colorMap.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
        colorMap.clear();
    }

    public static Font getFont(String name, int height, int style) {
        return ResourceUtils.getFont(name, height, style, false, false);
    }

    public static Font getFont(String name, int size, int style, boolean strikeout, boolean underline) {
        String fontName = String.valueOf(name) + '|' + size + '|' + style + '|' + strikeout + '|' + underline;
        Font font = fontMap.get(fontName);
        if (font == null) {
            FontData fontData = new FontData(name, size, style);
            if (strikeout || underline) {
                try {
                    Class<?> logFontClass = Class.forName("org.eclipse.swt.internal.win32.LOGFONT");
                    Object logFont = FontData.class.getField("data").get(fontData);
                    if (logFont != null && logFontClass != null) {
                        if (strikeout) {
                            logFontClass.getField("lfStrikeOut").set(logFont, new Byte(1));
                        }
                        if (underline) {
                            logFontClass.getField("lfUnderline").set(logFont, new Byte(1));
                        }
                    }
                }
                catch (Throwable e) {
                    System.err.println("Unable to set underline or strikeout (probably on a non-Windows platform). " + e);
                }
            }
            font = new Font((Device)Display.getCurrent(), fontData);
            fontMap.put(fontName, font);
        }
        return font;
    }

    public static Font getBoldFont(Font baseFont) {
        Font font = fontToBoldFontMap.get(baseFont);
        if (font == null) {
            FontData[] fontDatas = baseFont.getFontData();
            FontData data = fontDatas[0];
            font = new Font((Device)Display.getCurrent(), data.getName(), data.getHeight(), 1);
            fontToBoldFontMap.put(baseFont, font);
        }
        return font;
    }

    public static void disposeFonts() {
        Iterator<Font> iter = fontMap.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
        fontMap.clear();
        iter = fontToBoldFontMap.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
        fontToBoldFontMap.clear();
    }

    public static Cursor getCursor(int id) {
        Integer key = new Integer(id);
        Cursor cursor = idToCursorMap.get(key);
        if (cursor == null) {
            cursor = new Cursor((Device)Display.getDefault(), id);
            idToCursorMap.put(key, cursor);
        }
        return cursor;
    }

    public static void disposeCursors() {
        Iterator<Cursor> iter = idToCursorMap.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
        idToCursorMap.clear();
    }

    public static void dispose() {
        ResourceUtils.disposeFonts();
        ResourceUtils.disposeColors();
        ResourceUtils.disposeCursors();
    }
}

