/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.intro.FeatureChange;
import com.aptana.ide.intro.IntroPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureChangeManager {
    private static FeatureChangeManager manager = null;
    public static final String FEATURE_STORE_PATH = ".features";
    private List<FeatureChange> changeList;
    private boolean changed;

    private FeatureChangeManager() {
        ArrayList<IFeatureReference> plugins = new ArrayList<IFeatureReference>();
        ArrayList<IIncludedFeatureReference> children = new ArrayList<IIncludedFeatureReference>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] sites = config.getConfiguredSites();
            int i = 0;
            while (i < sites.length) {
                IFeatureReference[] iFeatureReferenceArray = sites[i].getFeatureReferences();
                int j = 0;
                while (j < iFeatureReferenceArray.length) {
                    IFeatureReference ref = iFeatureReferenceArray[j];
                    IFeature feature = ref.getFeature(null);
                    IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
                    int x = 0;
                    while (x < included.length) {
                        children.add(included[x]);
                        ++x;
                    }
                    IConfiguredSite site = ref.getSite().getCurrentConfiguredSite();
                    if (site.isConfigured(feature)) {
                        plugins.add(ref);
                    }
                    ++j;
                }
                ++i;
            }
            for (Object e : children) {
                plugins.remove(e);
            }
        }
        catch (Exception e) {
            this.changed = false;
            this.changeList = null;
            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)e.getMessage());
        }
        try {
            List<FeatureChange> changes = this.compareToStore(plugins);
            boolean bl = this.changed = !changes.isEmpty();
            if (this.changed) {
                this.changeList = changes;
                this.updateStore(plugins);
            } else {
                this.changeList = null;
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)e.getMessage());
            this.updateStore(plugins);
            this.changed = false;
            this.changeList = null;
        }
    }

    public static synchronized FeatureChangeManager getManager() {
        if (manager == null) {
            manager = new FeatureChangeManager();
        }
        return manager;
    }

    public boolean areFeaturesChanged() {
        return this.changed;
    }

    public List<FeatureChange> getFeatureChangeList() {
        return this.changeList;
    }

    private void updateStore(List<IFeatureReference> plugins) {
        HashMap<String, String> newIdsToVersion = new HashMap<String, String>();
        int i = 0;
        while (i < plugins.size()) {
            IFeatureReference ref = plugins.get(i);
            try {
                VersionedIdentifier ident = ref.getVersionedIdentifier();
                newIdsToVersion.put(ident.getIdentifier(), ident.getVersion().toString());
                IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)("Feature ID: " + ident.getIdentifier() + " Version: " + ident.getVersion().toString()));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)e.getMessage());
            }
            ++i;
        }
        this.saveFeatureInformation(newIdsToVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<FeatureChange> compareToStore(List<IFeatureReference> plugins) throws FileNotFoundException, IOException, ClassNotFoundException {
        File bundleFile = IntroPlugin.getDefault().getStateLocation().append(FEATURE_STORE_PATH).toFile();
        ArrayList<FeatureChange> changes = new ArrayList<FeatureChange>();
        if (!bundleFile.exists()) throw new IOException("Feature store does not exist");
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(bundleFile));
        Object obj = ois.readObject();
        ois.close();
        if (!(obj instanceof HashMap)) throw new IOException("File empty or corrupted");
        HashMap idToVersions = (HashMap)obj;
        int i = 0;
        while (i < plugins.size()) {
            IFeatureReference ref = plugins.get(i);
            try {
                IFeature feature = ref.getFeature(null);
                VersionedIdentifier ident = ref.getVersionedIdentifier();
                String currentVersion = ident.getVersion().toString();
                FeatureChange change = null;
                if (idToVersions.containsKey(ident.getIdentifier())) {
                    String previous = (String)idToVersions.get(ident.getIdentifier());
                    if (!previous.equals(currentVersion)) {
                        change = new FeatureChange(ident.getIdentifier(), feature.getLabel(), previous, currentVersion, feature.getProvider());
                    }
                } else {
                    change = new FeatureChange(ident.getIdentifier(), ref.getFeature(null).getLabel(), null, currentVersion, feature.getProvider());
                }
                if (change != null) {
                    changes.add(change);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)e.getMessage());
            }
            ++i;
        }
        return changes;
    }

    private void saveFeatureInformation(HashMap idToVersions) {
        try {
            if (IntroPlugin.getDefault() != null && IntroPlugin.getDefault().getStateLocation() != null) {
                File bundleFile = IntroPlugin.getDefault().getStateLocation().append(FEATURE_STORE_PATH).toFile();
                if (!bundleFile.exists()) {
                    bundleFile.createNewFile();
                }
                IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Persisting feature list to store");
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(bundleFile));
                oos.writeObject(idToVersions);
                oos.flush();
                oos.close();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)e.getMessage());
        }
    }
}

