/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.intro.FeatureChange;
import com.aptana.ide.intro.FeatureChangeManager;
import com.aptana.ide.server.jetty.comet.CometResponderClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FeatureChangesClient
extends CometResponderClient {
    public static final String FEATURE_CHANGE_CHANNEL = "/portal/features/changes";
    public static final String FEATURE_CHANGES = "featureChanges";
    public static final String ID = "id";
    public static final String NEW_VERSION = "newVersion";
    public static final String OLD_VERSION = "oldVersion";
    public static final String PROVIDER = "provider";
    public static final String LABEL = "label";
    public static final String CHANGES = "changes";
    public static final String CHANGES_EXIST = "changesExist";

    protected Object getResponse(String toChannel, Object request) {
        if (FEATURE_CHANGE_CHANNEL.equals(toChannel)) {
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            responseData.put("response", FEATURE_CHANGES);
            boolean changed = FeatureChangeManager.getManager().areFeaturesChanged();
            List<FeatureChange> changes = FeatureChangeManager.getManager().getFeatureChangeList();
            ArrayList responseChanges = new ArrayList();
            if (changed) {
                int i = 0;
                while (i < changes.size()) {
                    FeatureChange obj = changes.get(i);
                    if (obj instanceof FeatureChange) {
                        HashMap<String, String> changeMap = new HashMap<String, String>();
                        FeatureChange change = obj;
                        changeMap.put(ID, change.getId());
                        changeMap.put(LABEL, change.getLabel());
                        changeMap.put(NEW_VERSION, change.getNewVersion());
                        changeMap.put(OLD_VERSION, change.getOldVersion());
                        changeMap.put(PROVIDER, change.getProvider());
                        responseChanges.add(changeMap);
                    }
                    ++i;
                }
            }
            responseData.put(CHANGES, responseChanges);
            responseData.put(CHANGES_EXIST, changed);
            return responseData;
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{FEATURE_CHANGE_CHANNEL};
    }
}

