/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.ui.AptanaNavigator;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.actions.CoreIntroAction;
import java.util.Properties;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class OpenWizardAction
extends CoreIntroAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runDelegate(IIntroSite site, Properties params) throws Exception {
        ISelection selection;
        String wizardType = params.getProperty("wizardType");
        String wizardId = params.getProperty("wizardId");
        if (wizardId == null) throw new Exception("Invalid wizard Id");
        IWizardDescriptor descriptor = null;
        if ("import".equals(wizardType)) {
            descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(wizardId);
        } else if ("export".equals(wizardType)) {
            descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(wizardId);
        } else if ("new".equals(wizardType)) {
            descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(wizardId);
        }
        if (descriptor == null) throw new Exception("Descriptor not found");
        IWorkbenchWizard wizard = descriptor.createWizard();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        IWorkbenchPart[] views = CoreUIUtils.getViewsInternal((String)"com.aptana.ide.core.ui.AptanaNavigator");
        if (views != null && views.length == 1 && views[0] instanceof AptanaNavigator && (selection = ((AptanaNavigator)views[0]).getTreeViewer().getSelection()) instanceof IStructuredSelection) {
            selectionToPass = (IStructuredSelection)selection;
        }
        wizard.init(IntroPlugin.getDefault().getWorkbench(), (IStructuredSelection)selectionToPass);
        if (!(wizard instanceof IWizard)) return;
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.create();
        if (wizard.getPageCount() <= 0) return;
        dialog.open();
    }
}

