/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.messaging;

import com.aptana.ide.intro.messaging.IMessageListener;
import com.aptana.ide.intro.messaging.Message;
import com.aptana.ide.intro.messaging.MessagesEditor;
import com.aptana.ide.intro.messaging.MessagingManager;
import com.aptana.ide.server.jetty.comet.CometClient;
import dojox.cometd.Channel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

public class MessagesClient
extends CometClient {
    public static final String MESSAGES_CHANNEL = "/portal/messages";
    public static final String DESCRIBE_MESSAGES = "describeMessages";
    public static final String URGENT_COUNT = "urgentCount";
    public static final String UNREAD_COUNT = "unreadCount";
    public static final String SHOW_MESSAGES = "showMessages";
    private IMessageListener messageListener = new IMessageListener(){

        public void messageChanged(Message message, int eventType) {
            Channel channel;
            Map responseData = MessagesClient.this.describeMessages();
            if (responseData != null && (channel = MessagesClient.this.bayeux.getChannel(MessagesClient.MESSAGES_CHANNEL, true)) != null) {
                channel.publish(MessagesClient.this.client, (Object)responseData, MessagesClient.this.getID(null));
            }
        }
    };

    public MessagesClient() {
        MessagingManager.addListener(this.messageListener);
    }

    public void destroy() {
        super.destroy();
        MessagingManager.removeListener(this.messageListener);
    }

    private Map describeMessages() {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put("response", DESCRIBE_MESSAGES);
        responseData.put(URGENT_COUNT, MessagingManager.getUnreadUrgentMessages());
        responseData.put(UNREAD_COUNT, MessagingManager.getUnreadMessages());
        return responseData;
    }

    protected Object getResponse(String toChannel, Object request) {
        Map requestData;
        if (MESSAGES_CHANNEL.equals(toChannel) && request instanceof Map && (requestData = (Map)request).containsKey("request")) {
            String requestType = requestData.get("request").toString();
            if (DESCRIBE_MESSAGES.equals(requestType)) {
                return this.describeMessages();
            }
            if (SHOW_MESSAGES.equals(requestType)) {
                UIJob job = new UIJob("Opening message center"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessagesEditor.openMessageCenter();
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{MESSAGES_CHANNEL};
    }

    protected String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }
}

