/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.uuid;

import java.io.IOException;

public final class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static Appendable append(Appendable a, int in) {
        return Hex.append(a, in, 8);
    }

    public static Appendable append(Appendable a, int in, int length) {
        int b = in;
        int l = length;
        char[] out = new char[l--];
        int i = l;
        while (i > -1) {
            out[i] = DIGITS[(byte)(b & 0xF)];
            b >>= 4;
            --i;
        }
        try {
            i = 0;
            while (i < out.length) {
                a.append(out[i]);
                ++i;
            }
        }
        catch (IOException iOException) {}
        return a;
    }

    public static Appendable append(Appendable a, long in) {
        return Hex.append(a, in, 16);
    }

    public static Appendable append(Appendable a, long in, int length) {
        long b = in;
        int l = length;
        char[] out = new char[l--];
        int i = l;
        while (i > -1) {
            out[i] = DIGITS[(byte)(b & 0xFL)];
            b >>= 4;
            --i;
        }
        try {
            i = 0;
            while (i < out.length) {
                a.append(out[i]);
                ++i;
            }
        }
        catch (IOException iOException) {}
        return a;
    }

    public static Appendable append(Appendable a, short in) {
        return Hex.append(a, in, 4);
    }

    public static Appendable append(Appendable a, short in, int length) {
        short b = in;
        int l = length;
        char[] out = new char[l--];
        int i = l;
        while (i > -1) {
            out[i] = DIGITS[(byte)(b & 0xF)];
            b = (short)(b >> 4);
            --i;
        }
        try {
            i = 0;
            while (i < out.length) {
                a.append(out[i]);
                ++i;
            }
        }
        catch (IOException iOException) {}
        return a;
    }

    public static Appendable append(Appendable a, byte[] b) {
        int len = b.length << 1;
        char[] out = new char[len--];
        int i = b.length - 1;
        while (i > -1) {
            out[len--] = DIGITS[(byte)(b[i] & 0xF)];
            out[len--] = DIGITS[(byte)((b[i] & 0xF0) >> 4)];
            --i;
        }
        try {
            i = 0;
            while (i < out.length) {
                a.append(out[i]);
                ++i;
            }
        }
        catch (IOException iOException) {}
        return a;
    }

    public static long parseLong(CharSequence s) {
        long out = 0L;
        int shifts = 0;
        int i = 0;
        while (i < s.length() && shifts < 16) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 48);
            } else if (c > '@' && c < 'G') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 55);
            } else if (c > '`' && c < 'g') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 87);
            }
            ++i;
        }
        return out;
    }

    public static short parseShort(String s) {
        short out = 0;
        int shifts = 0;
        int i = 0;
        while (i < s.length() && shifts < 4) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c - 48);
            } else if (c > '@' && c < 'G') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c - 55);
            } else if (c > '`' && c < 'g') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c - 87);
            }
            ++i;
        }
        return out;
    }
}

