/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty;

import com.aptana.ide.server.jetty.JettyPlugin;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferencesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private IPreferenceStore prefs;

    public PreferencesServlet() {
        this(JettyPlugin.getDefault().getPreferenceStore());
    }

    public PreferencesServlet(IPreferenceStore store) {
        this.prefs = store;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.prefs == null) {
            return;
        }
        String prefLine = request.getReader().readLine();
        while (prefLine != null) {
            int equal = prefLine.indexOf("=");
            if (equal == -1 || equal + 1 >= prefLine.length()) continue;
            String name = prefLine.substring(0, equal);
            String value = prefLine.substring(equal + 1);
            this.prefs.setValue(name, value);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.prefs == null) {
            return;
        }
        String pref = request.getParameter("p");
        if (pref != null) {
            String value = this.prefs.getString(pref);
            response.setContentLength(value.length());
            response.getWriter().print(value);
        }
    }

    public IPreferenceStore getPreferences() {
        return this.prefs;
    }

    public void setPreferences(IPreferenceStore prefs) {
        this.prefs = prefs;
    }
}

