/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.server.jetty.comet.CometClient;
import dojox.cometd.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectsClient
extends CometClient
implements IResourceChangeListener {
    public static final String AIR_TYPE = "air";
    public static final String WEB_TYPE = "web";
    public static final String RAILS_TYPE = "rails";
    public static final String UNKNOWN_TYPE = "unknown";
    public static final String PHP_TYPE = "php";
    public static final String PYTHON_TYPE = "python";
    public static final String JAVA_TYPE = "java";
    public static final String TYPE = "type";
    public static final String PYTHON_PROJECT = "org.python.pydev.pythonNature";
    public static final String RAILS_PROJECT = "org.radrails.rails.core.railsnature";
    public static final String JAXER_PROJECT = "com.aptana.ide.framework.jaxernature";
    public static final String WEB_PROJECT = "com.aptana.ide.project.nature.web";
    public static final String AIR_PROJECT = "com.aptana.ide.apollo.apollonature";
    public static final String PHP_PROJECT = "com.aptana.ide.editor.php.phpnature";
    public static final String WTP_JAVA_PROJECT = "org.eclipse.wst.common.project.facet.core.nature";
    public static final String LIST_PROJECTS = "listProjects";
    public static final String NAME = "name";
    public static final String PROJECTS_CHANNEL = "/portal/projects";
    public static final String PROJECTS = "projects";
    public static final String PROJECTS_EXIST = "projectsExist";
    public static final String PROJECTS_ARRAY = "projects";

    public ProjectsClient() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public void destroy() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.destroy();
    }

    @Override
    protected Object getResponse(String toChannel, Object request) {
        if (PROJECTS_CHANNEL.equals(toChannel)) {
            return this.listProjects();
        }
        return null;
    }

    protected void publishProjects() {
        if (this.bayeux != null) {
            Channel listChannel = this.bayeux.getChannel(this.getProjectsChannel(), true);
            listChannel.publish(this.client, this.listProjects(), Long.toString(System.currentTimeMillis()));
        }
    }

    protected Map<Object, Object> listProjects() {
        IProject[] projects = CoreUIUtils.getWorkspaceRoot().getProjects();
        HashMap<Object, Object> returnData = new HashMap<Object, Object>();
        returnData.put(PROJECTS_EXIST, projects.length > 0);
        returnData.put("response", LIST_PROJECTS);
        ArrayList names = new ArrayList();
        IProject[] iProjectArray = projects;
        int n = 0;
        int n2 = iProjectArray.length;
        while (n < n2) {
            IProject project = iProjectArray[n];
            if (project.exists() && project.isOpen()) {
                StringBuilder type = new StringBuilder();
                HashMap<String, String> projectData = new HashMap<String, String>();
                try {
                    String[] natureIds = project.getDescription().getNatureIds();
                    if (natureIds != null && natureIds.length > 0) {
                        String[] stringArray = natureIds;
                        int n3 = 0;
                        int n4 = stringArray.length;
                        while (n3 < n4) {
                            String nature = stringArray[n3];
                            type.append(nature);
                            type.append(',');
                            ++n3;
                        }
                        if (type.length() > 0) {
                            type.deleteCharAt(type.length() - 1);
                        }
                    }
                }
                catch (CoreException coreException) {}
                projectData.put(TYPE, type.toString());
                projectData.put(NAME, project.getName());
                names.add(projectData);
            }
            ++n;
        }
        returnData.put("projects", names);
        return returnData;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject project;
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] deltas = delta.getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                IProject project2 = null;
                project2 = deltas[i].getKind() == 2 && deltas[i].getMovedToPath() == null && deltas[i].getResource() instanceof IProject ? (IProject)deltas[i].getResource() : deltas[i].getResource().getProject();
                if (project2 != null) {
                    this.publishProjects();
                }
                ++i;
            }
        } else if (event.getType() == 4 && event.getResource() instanceof IProject && (project = (IProject)event.getResource()) != null) {
            this.publishProjects();
        }
    }

    protected String getProjectsChannel() {
        return PROJECTS_CHANNEL;
    }

    @Override
    protected String[] getSubscriptionIDs() {
        return new String[]{this.getProjectsChannel()};
    }

    @Override
    protected String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }
}

