/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.server.http.HttpContentTypes;
import com.aptana.jaxer.connectors.servlet.interfaces.ICallbackResponse;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatusLengthOnlyResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceBaseServlet
extends HttpServlet {
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String PRAGMA = "Pragma";
    public static final String NO_CACHE = "no-cache";
    public static final String NO_STORE = "no-store";
    private static final long serialVersionUID = 1L;
    private String resourceBase;
    private boolean noCache = false;

    public ResourceBaseServlet(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public ResourceBaseServlet() {
        this(null);
    }

    protected String getFilePath(HttpServletRequest request) {
        return request.getServletPath();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (response instanceof ICallbackResponse) {
                response.setContentLength(0);
                response.getWriter().write("");
                return;
            }
            boolean sendContent = !(response instanceof IStatusLengthOnlyResponse);
            String path = this.getFilePath(request);
            File file = new File(this.resourceBase, path);
            ResourceBaseServlet.setContentLength(file, response);
            ResourceBaseServlet.setContentType(path, response);
            this.setCacheHeaders(response);
            if (sendContent) {
                FileInputStream fis = new FileInputStream(file);
                FileUtils.pipe((InputStream)fis, (OutputStream)response.getOutputStream(), (boolean)false);
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.doGet(arg0, arg1);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public static void setContentLength(File file, HttpServletResponse response) {
        if (file != null) {
            response.setContentLength((int)file.length());
        }
    }

    public static void setContentType(String path, HttpServletResponse response) {
        String type;
        String ext = FileUtils.getExtension((String)path);
        if (ext != null && (type = HttpContentTypes.getContentType((String)("." + ext))) != null) {
            response.setContentType(type);
        }
    }

    private void setCacheHeaders(HttpServletResponse response) {
        if (this.noCache) {
            response.addHeader(CACHE_CONTROL, NO_CACHE);
            response.addHeader(CACHE_CONTROL, NO_STORE);
            response.addHeader(PRAGMA, NO_CACHE);
        }
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public boolean isNocache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }
}

